#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iomanip>

void Energy_Surface2::PHI3(Phi_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const Thread_Options& opt,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep){
//
//
// accumulate quadratic approx to part 0 onto exact evaluation of part 1
//
   TOT/=(physics_consts.CAL);
   if( SURFACE ){
      for(int iU2= 0;iU2<nU2;iU2++){
         if( U2uca(iU2)<( 1.00e-8) )continue;
         U2g(iU2)/=(physics_consts.CAL*U2uca(iU2));
      }
      for(int iU2= 0;iU2<nU2;iU2++){
         if( U2uca(iU2)<( 1.00e-8) )continue;
         for(int jU2=iU2;jU2<nU2;jU2++){
            if( U2uca(jU2)<( 1.00e-8) )continue;
            U2U2a(iU2,jU2)/=(physics_consts.CAL*U2uca(iU2)*U2uca(jU2));
         }
      }
   }
//
//
// accumulate energy, 1st, and 2nd derivative
//
   PHI3_XQ(aut,con,dep);
   PHI3_RESTCH(aut,
               physics_consts,array_consts,
               out,mol,con);
//
//
// transform units of energy and circular arc
//
   TOT*=(physics_consts.CAL);
   if( SURFACE ){
      for(int iU2= 0;iU2<nU2;iU2++){
         U2g(iU2)*=(physics_consts.CAL*U2uca(iU2));
      }
      for(int iU2= 0;iU2<nU2;iU2++){
         for(int jU2=iU2;jU2<nU2;jU2++){
            U2U2a(iU2,jU2)*=(physics_consts.CAL*U2uca(iU2)*U2uca(jU2));
         }
      }
   }
//
//
// output conformation and energy surface
//
// std::string hrule="________________________________________"
//                   "________________________________________\n";
// out.FILE3<<hrule;
// out.FILE3<< std::scientific<< std::setprecision( 8);
// out.FILE3<<"FUNC\n";
// out.FILE3<< std::setw(15)<<TOT<<'\n';
// out.FILE3<<"1st DERIV at current conf of quadratic part 0\n";
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    if( !con.Z0[iZ0].sub )continue;
//    int iU2=Z0[iZ0].U2a;
//    out.FILE3<<"iZ0="<< std::setw( 2)<<iZ0<<"  ";
//    for(int i=0;i<6;i++){
//       out.FILE3<< std::setw(15)<<vv.U2g(iU2+i);
//    }
//    out.FILE3<<'\n';
// }
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//    if( nQ2>mQ2 ){
//       out.FILE3<<"iZ0="<< std::setw( 2)<<iZ0<<'\n';
//       for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
//          out.FILE3<< std::setw(15)<<vv.U2g(Q2[iQ2].U2);
//          if( ((iQ2-mQ2)%6==0)||(iQ2==nQ2) ){
//             out.FILE3<<'\n';
//          }
//       }
//    }
// }
// out.FILE3<<"1st DERIV at current conf of cubic part 0 +exact part 1\n";
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    if( !con.Z0[iZ0].sub )continue;
//    int iU2=Z0[iZ0].U2a;
//    out.FILE3<<"iZ0="<< std::setw( 2)<<iZ0<<"  ";
//    for(int i=0;i<6;i++){
//       out.FILE3<< std::setw(15)<<U2g(iU2+i);
//    }
//    out.FILE3<<'\n';
// }
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//    if( nQ2>mQ2 ){
//       out.FILE3<<"iZ0="<< std::setw( 2)<<iZ0<<'\n';
//       for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
//          out.FILE3<< std::setw(15)<<U2g(Q2[iQ2].U2);
//          if( ((iQ2-mQ2)%6==0)||(iQ2==nQ2) ){
//             out.FILE3<<'\n';
//          }
//       }
//    }
// }
// out.FILE3<<"2nd DERIV\n";
// for(int iU2= 0;iU2<nU2;iU2++){
//    for(int jU2=iU2;jU2<nU2;jU2++){
//       out.FILE3<< std::setw(15)<<U2U2a(iU2,jU2);
//       if( ((jU2-iU2+1)%6==0)||(jU2==(nU2-1)) ){
//          out.FILE3<<'\n';
//       }
//    }
// }
   return;
}
