#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"

void Energy_Surface2::PHI2(Phi_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const DAT_REGION_MAPS& region_maps,
                           const Thread_Options& opt,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep){
//
//
// generate coordinates and multipoles for atoms and groups
//
   PHI_XQ(aut,
          array_consts,
          out,mol,con,dep);
//
//
// construct params of Fw
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else{
      PHI_WPAR(aut,
               physics_consts,
               con);
   }
//
//
// assemble peptide-peptide H-bonds, chains of H-bonds, bifurcations
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else{
      PHI_PPAR(aut,
               physics_consts,array_consts,region_maps,
               mol,con,dep);
   }
//
//
// initiate energy surface
//
   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)= (0.00);
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2= 0;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)= (0.00);
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int iQ2min=con.Z0[iZ0].Q2a;
      int iQ2max=(iQ2min-1+con.Z0[iZ0].cQ2);
      for(int iQ2=iQ2min;iQ2<=iQ2max;iQ2++){
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int jQ2min=con.Z0[jZ0].Q2a;
            int jQ2max=(jQ2min-1+con.Z0[jZ0].cQ2);
            for(int jQ2=jQ2min;jQ2<=jQ2max;jQ2++){
               Q2Q2e(iQ2,jQ2).zero();
               if( !MICRO )Q2Q2g(iQ2,jQ2).zero();
            }
         }
      }
   }
//
//
// evaluate energy, 1st, and 2nd derivative
//
   PHI_RESTCH(aut,
              physics_consts,array_consts,energy_params,
              opt,out,con,dep);
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
      Fp= (0.00);
      Fp_a= (0.00);
      Fp_b= (0.00);
      Fp_c= (0.00);
      Fp_d= (0.00);
      Fp_e= (0.00);
      Fw= (0.00);
      TOT=( Fr +Fe +Fs +Ft +Fc +Fb +Fh +Fp +Fw);
   }else{
      PHI_PWM(aut,
              physics_consts,array_consts,region_maps,
              out,mol,con,dep);
   }
   PHI_CONT(aut,
            con);
//
//
// transform units of energy and circular arc
//
   TOT*=(physics_consts.CAL);
   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)*=(physics_consts.CAL*U2uca(iU2));
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2=iU2;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)*=(physics_consts.CAL*U2uca(iU2)*U2uca(jU2));
      }
   }
   return;
}
