#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi1_Automatic.hh"
#include <cmath>

void Energy_Surface4::PHI1_R(Phi1_Automatic& aut,
                             const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ENERGY_PARAMS& energy_params,
                             const Subset_Contracted_System::tM3& con,
                             int jF2,int kQ2,int jZ0,int iE1,
                             int iF2,int i_3,int iQ2,int iZ0){

   if( con.E1[iE1].sse==1 ){
      int iS3=-1;
      int ib4=0;
      int i=( con.F2[jF2].sf&  7);
      int k=(con.F2[jF2].sf-i);
      if( iQ2==con.Z0[iZ0].Q2a ){
         int j=( con.B3[i_3].sb&  7);
         if( (con.B3[i_3].sb-j)==k ){
            iS3=energy_params.S2S2S3(i,j);
            ib4=energy_params.S2S2b4(i,j);
         }
      }else{
         int j=( con.G3[i_3].sg&  7);
         if( (con.G3[i_3].sg-j)==k ){
            iS3=energy_params.S2S2S3(i,j);
            ib4=energy_params.S2S2b4(i,j);
         }
      }
      if( iS3!=-1 )return;
      if( ib4==1 )return;
   }

   aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
   aut.RR= aut.x.rr();
   aut.R= std::sqrt( aut.RR);
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
//
//
// calc Fr
//
   int iT2=con.F2[iF2].typ;
   int jT2=con.F2[jF2].typ;

   double RHO= energy_params.T2T2r(iT2,jT2);
   if( aut.R<((1.125)*RHO) ){
   if( jF2!=con.F2[iF2].lnk ){
      double EPS= energy_params.T2T2e(iT2,jT2);
      double zZZ= (aut.R/RHO);
      double alp= energy_params.T2T2a(iT2,jT2);

      double FF=( (1.00) +alp)
               /( zZZ +alp);
      double GG= (1.12)
               /( std::pow(zZZ,7) +(.12));

      double zF= EPS*( std::pow(FF,7)*( GG -(2.00)));
      Fr+=zF;
      if( zF>Ecut )nE3++;
      PHI1_E2(aut,con,kQ2,jZ0,iF2,iQ2,iZ0);
      E2[nE2].rho= RHO;
      E2[nE2].eps= EPS;
      E2[nE2].alp= alp;
      nE2++;
   }
   }

   if( (aut.jC3<nC3)&&
       (iF2==C3[aut.jC3].N2F2[ 1])&&
       (jF2==C3[aut.jC3].N2F2[ 0]) ){
      double RHO= C3[aut.jC3].r;
      double EPS= C3[aut.jC3].a;
      double z=( aut.R -RHO);
      double zF= EPS*z*z;
      Fr+=zF;
      if( zF>((1.00)/physics_consts.CAL) )nE3++;
      PHI1_E2(aut,con,kQ2,jZ0,iF2,iQ2,iZ0);
      E2[nE2].rho= RHO;
      E2[nE2].eps= EPS;
      E2[nE2].alp= (0.00);
      nE2++;
      aut.jC3++;
   }
   return;
}
