#include "../con/Subset_Contracted_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi1_Automatic.hh"

void Energy_Surface4::PHI1_O2(const Phi1_Automatic& aut,
                              const Subset_Contracted_System::tM3& con,
                              int kQ2,int kZ0,int iF2,int iZ0){

   if( kQ2>con.Z0[kZ0].Q2a ){
      O2.push_back( tO2());
      E2[nE2].cO2++;
      O2[nO2].U2=Q2[kQ2].U2;
      Coordinates b=( aut.F2[iF2].x -aut.F2[con.Q2[kQ2].bseF2].x);
      Coordinates a=( b -aut.x);
      Coordinates c;
      c(0)= aut.sgnk*Q2[kQ2].c(0,0);
      c(1)= aut.sgnk*Q2[kQ2].c(1,0);
      c(2)= aut.sgnk*Q2[kQ2].c(2,0);
      O2[nO2].t= cross(c,b);
      O2[nO2].s= dot(aut.x,O2[nO2].t);
      O2[nO2].u= cross(c,a);
      nO2++;

   }else if( kZ0<iZ0 ){
      E2[nE2].cO2+=6;
      int kU2=Z0[kZ0].U2a;
      for(int i=0;i<6;i++){
         O2.push_back( tO2());
      }
      for(int i=0;i<3;i++){
         O2[nO2  +i].U2=(kU2+3+i);
         O2[nO2+3+i].U2=(kU2  +i);
      }
      Coordinates b;
      b(0)=( aut.F2[iF2].x(0) -U2chi(kU2  ));
      b(1)=( aut.F2[iF2].x(1) -U2chi(kU2+1));
      b(2)=( aut.F2[iF2].x(2) -U2chi(kU2+2));
      O2[nO2  ].t(0)= (0.00);
      O2[nO2  ].t(1)=-b(2);
      O2[nO2  ].t(2)= b(1);
      O2[nO2+1].t(0)= b(2);
      O2[nO2+1].t(1)= (0.00);
      O2[nO2+1].t(2)=-b(0);
      O2[nO2+2].t(0)=-b(1);
      O2[nO2+2].t(1)= b(0);
      O2[nO2+2].t(2)= (0.00);
      O2[nO2+3].t(0)=-(1.00);
      O2[nO2+3].t(1)= (0.00);
      O2[nO2+3].t(2)= (0.00);
      O2[nO2+4].t(0)= (0.00);
      O2[nO2+4].t(1)=-(1.00);
      O2[nO2+4].t(2)= (0.00);
      O2[nO2+5].t(0)= (0.00);
      O2[nO2+5].t(1)= (0.00);
      O2[nO2+5].t(2)=-(1.00);
      for(int i=0;i<6;i++){
         O2[nO2+i].s= dot(aut.x,O2[nO2+i].t);
      }
      Coordinates a=( b -aut.x);
      O2[nO2  ].u(0)= (0.00);
      O2[nO2  ].u(1)=-a(2);
      O2[nO2  ].u(2)= a(1);
      O2[nO2+1].u(0)= a(2);
      O2[nO2+1].u(1)= (0.00);
      O2[nO2+1].u(2)=-a(0);
      O2[nO2+2].u(0)=-a(1);
      O2[nO2+2].u(1)= a(0);
      O2[nO2+2].u(2)= (0.00);
      O2[nO2+3].u(0)=-(1.00);
      O2[nO2+3].u(1)= (0.00);
      O2[nO2+3].u(2)= (0.00);
      O2[nO2+4].u(0)= (0.00);
      O2[nO2+4].u(1)=-(1.00);
      O2[nO2+4].u(2)= (0.00);
      O2[nO2+5].u(0)= (0.00);
      O2[nO2+5].u(1)= (0.00);
      O2[nO2+5].u(2)=-(1.00);
      nO2+=6;

   }else if( kZ0==iZ0 ){
      E2[nE2].cO2+=6;
      int kU2=Z0[kZ0].U2a;
      for(int i=0;i<6;i++){
         O2.push_back( tO2());
      }
      for(int i=0;i<3;i++){
         O2[nO2  +i].U2=(kU2  +i);
         O2[nO2+3+i].U2=(kU2+5-i);
      }
      Coordinates b;
      b(0)=( aut.F2[iF2].x(0) -U2chi(kU2  ));
      b(1)=( aut.F2[iF2].x(1) -U2chi(kU2+1));
      b(2)=( aut.F2[iF2].x(2) -U2chi(kU2+2));
      O2[nO2  ].t(0)= (1.00);
      O2[nO2  ].t(1)= (0.00);
      O2[nO2  ].t(2)= (0.00);
      O2[nO2+1].t(0)= (0.00);
      O2[nO2+1].t(1)= (1.00);
      O2[nO2+1].t(2)= (0.00);
      O2[nO2+2].t(0)= (0.00);
      O2[nO2+2].t(1)= (0.00);
      O2[nO2+2].t(2)= (1.00);
      O2[nO2+5].t(0)= (0.00);
      O2[nO2+5].t(1)= b(2);
      O2[nO2+5].t(2)=-b(1);
      O2[nO2+4].t(0)=-b(2);
      O2[nO2+4].t(1)= (0.00);
      O2[nO2+4].t(2)= b(0);
      O2[nO2+3].t(0)= b(1);
      O2[nO2+3].t(1)=-b(0);
      O2[nO2+3].t(2)= (0.00);
      for(int i=0;i<6;i++){
        O2[nO2+i].s= dot(aut.x,O2[nO2+i].t);
      }
      Coordinates a=( b -aut.x);
      O2[nO2  ].u(0)= (1.00);
      O2[nO2  ].u(1)= (0.00);
      O2[nO2  ].u(2)= (0.00);
      O2[nO2+1].u(0)= (0.00);
      O2[nO2+1].u(1)= (1.00);
      O2[nO2+1].u(2)= (0.00);
      O2[nO2+2].u(0)= (0.00);
      O2[nO2+2].u(1)= (0.00);
      O2[nO2+2].u(2)= (1.00);
      O2[nO2+5].u(0)= (0.00);
      O2[nO2+5].u(1)= a(2);
      O2[nO2+5].u(2)=-a(1);
      O2[nO2+4].u(0)=-a(2);
      O2[nO2+4].u(1)= (0.00);
      O2[nO2+4].u(2)= a(0);
      O2[nO2+3].u(0)= a(1);
      O2[nO2+3].u(1)=-a(0);
      O2[nO2+3].u(2)= (0.00);
      nO2+=6;

   }
   return;
}
