#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include <cmath>

void Energy_Surface4::PHI1_DCHI(const DAT_PHYSICS_CONSTS& physics_consts,
                                const Mechanical_System& mol,
                                const Subset_Contracted_System::tM3& con){

   int iU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      if( !con.Z0[iZ0].sub )continue;
      double Cbet,Sbet,bet, Calp,Salp,alp, Cgam,Sgam,gam;
      U2dchi(iU2  )=( U2chi(iU2  ) -backup_U2chi(iU2  ));
      U2dchi(iU2+1)=( U2chi(iU2+1) -backup_U2chi(iU2+1));
      U2dchi(iU2+2)=( U2chi(iU2+2) -backup_U2chi(iU2+2));

      alp= U2chi(iU2+3);
      bet= U2chi(iU2+4);
      gam= U2chi(iU2+5);
      Rotation_Matrix ROT2(alp,bet,gam);
      alp= backup_U2chi(iU2+3);
      bet= backup_U2chi(iU2+4);
      gam= backup_U2chi(iU2+5);
      Rotation_Matrix ROT1(alp,bet,gam);

      Rotation_Matrix ROT;
      ROT= ROT2*transpose(ROT1);

      Sbet= ROT(2,0);
      Cbet= std::sqrt( (1.00) -Sbet*Sbet);
      bet= std::atan2(Sbet,Cbet);
      if( Cbet<(1.00e-12) ){
         gam= (0.00);
         if( Sbet>(0.00) ){
            Calp= ROT2(1,1);
            Salp= ROT2(0,1);
         }else{
            Calp= ROT2(0,2);
            Salp= ROT2(1,2);
         }
         alp= std::atan2(Salp,Calp);
      }else{
         Calp= (ROT(2,2)/Cbet);
         Salp=-(ROT(2,1)/Cbet);
         alp= std::atan2(Salp,Calp);
         Cgam= (ROT(0,0)/Cbet);
         Sgam=-(ROT(1,0)/Cbet);
         gam= std::atan2(Sgam,Cgam);
      }
      U2dchi(iU2+3)= alp;
      U2dchi(iU2+4)= bet;
      U2dchi(iU2+5)= gam;

      iU2+=6;
   }

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
         U2dchi(iU2)=( U2chi(iU2) -backup_U2chi(iU2));
         if      ( U2dchi(iU2)<-physics_consts.PI ){
            U2dchi(iU2)+=(2.00)*physics_consts.PI;
         }else if( U2dchi(iU2)> physics_consts.PI ){
            U2dchi(iU2)-=(2.00)*physics_consts.PI;
         }
         iU2++;
      }
   }

   return;
}
