#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include <vector>
#include <cmath>

class MEM_phi1 {
private:
   std::vector<double> o_U2dq;          //
public:
   MEM_phi1(int o):
      o_U2dq(o)
   {
   }
   double& U2dq(int i){
      return o_U2dq.at( i);  }
};

void Energy_Surface4::PHI1(const DAT_PHYSICS_CONSTS& physics_consts,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con){

   Fr= (0.00);
   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)= (0.00);
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2= 0;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)= (0.00);
      }
   }
   PHI1_DCHI(physics_consts,mol,con);


   MEM_phi1 vv(nU2);
   Coordinates zG;
   Coordinates zF;
   int iO2min=0;
   for(int iE2= 0;iE2<nE2;iE2++){
      int iO2max=(iO2min-1+E2[iE2].cO2);

      double q0= E2[iE2].q;
      double dq0= (0.00);
      zG.zero();
      for(int iO2=iO2min;iO2<=iO2max;iO2++){
         int iU2=O2[iO2].U2;
         double dchi= U2dchi(iU2);
         dq0+=(dchi*O2[iO2].s);
         zG+=(dchi*O2[iO2].t);
      }
      double ddq0= (0.00);
      zF.zero();
      for(int iO2=iO2min;iO2<=iO2max;iO2++){
         int iU2=O2[iO2].U2;
         double dchi= U2dchi(iU2);
         zG-=(dchi*O2[iO2].t);
         zF+=(dchi*O2[iO2].u);
         vv.U2dq(iU2)=( dot(O2[iO2].u,zG)
                        +dot(zF,O2[iO2].t));
         ddq0+=(dchi*vv.U2dq(iU2));
         vv.U2dq(iU2)+=O2[iO2].s;
      }
      double q=( q0 +dq0 +(.50)*ddq0);
      if( q<(1.00e-12) )q= (1.00e-12);

      double RR= ((2.00)*q);
      double R= std::sqrt( RR);
      double EPS= E2[iE2].eps;
      double RHO= E2[iE2].rho;
      double alp= E2[iE2].alp;
      double dedr;
      double ddedrdr;
      if( alp>(0.00) ){
         double ZZ= (R/RHO);

         double FF  =( (1.00) +alp)
                    /( ZZ +alp);
         double dFF =-FF
                    /( ZZ +alp);
         double ddFF=-(2.00)*dFF
                    /( ZZ +alp);
         double GG  = (1.12)
                    /( std::pow(ZZ,7) +(.12));
         double dGG =-GG*(7.00)*std::pow(ZZ,6)
                    /( std::pow(ZZ,7) +(.12));
         double ddGG= dGG*( (6.00)*(.12)/ZZ -(8.00)*std::pow(ZZ,6))
                    /( std::pow(ZZ,7) +(.12));

         Fr+=EPS*(
             std::pow(FF,7)*( GG -(2.00))
                  );
         dedr= (EPS/RHO)*(
             (7.00)*std::pow(FF,6)*dFF*( GG -(2.00))
            +std::pow(FF,7)*dGG
                          );
         ddedrdr= (EPS/std::pow(RHO,2))*(
             (42.00)*std::pow(FF,5)*std::pow(dFF,2)*( GG -(2.00))
            +(14.00)*std::pow(FF,6)*dFF*dGG
            +( 7.00)*std::pow(FF,6)*ddFF*( GG -(2.00))
            +std::pow(FF,7)*ddGG
                                         );
      }else{
         double ZZ=( R -RHO);
         Fr+=EPS*ZZ*ZZ;
         dedr= (2.00)*EPS*ZZ;
         ddedrdr= (2.00)*EPS;
      }
      double dedq= (dedr/R);
      double ddedqdq=( ddedrdr -dedq)/RR;

      for(int iO2=iO2min;iO2<=iO2max;iO2++){
         int iU2=O2[iO2].U2;
         U2g(iU2)+=(dedq*vv.U2dq(iU2));
         double z= ddedqdq*vv.U2dq(iU2);
         zF= dedq*O2[iO2].u;
         for(int jO2=iO2;jO2<=iO2max;jO2++){
            int jU2=O2[jO2].U2;
            U2U2a(iU2,jU2)+=( z*vv.U2dq(jU2)
                             +dot(zF,O2[jO2].t));
         }
      }

      iO2min+=E2[iE2].cO2;
   }


   int iU2max=(nU2-2);
   for(int iU2= 0;iU2<=iU2max;iU2++){
      int jU2min=(iU2+1);
      for(int jU2=jU2min;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)+=U2U2a(jU2,iU2);
         U2U2a(jU2,iU2)= (0.00);
      }
   }

   TOT= Fr;
   Fr*=physics_consts.CAL;
   return;
}
