#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Search_Subspace.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi1_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"

void Energy_Surface4::PHI0_REXP(const DAT_PHYSICS_CONSTS& physics_consts,
                                const Search_Subspace& sub,
                                const Mechanical_System& mol,
                                const Subset_Contracted_System::tM3& con,
                                Conf_Dependent_System& dep,
                                int iCYC){
   int oZ0=mol.nZ0;
   int aZ0=sub.R1[iCYC].Z0;
   Phi1_Automatic aut(con);
//
//
// generate atom coordinates
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( iZ0!=aZ0 )continue;
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         aut.TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=Z0[iZ0].U2a;
         aut.TRANS(0)= U2chi(iU2  );
         aut.TRANS(1)= U2chi(iU2+1);
         aut.TRANS(2)= U2chi(iU2+2);
         alp= U2chi(iU2+3);
         bet= U2chi(iU2+4);
         gam= U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);

      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 7)||(iT2> 17) )continue;
         aut.F2[iF2].x.generate(aut.TRANS,
                                ROT,
                                dep.F2[iF2].x);
      }

      if( nQ2>mQ2 ){
         aut.PR[ 0]= ROT;

         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              U2chi(Q2[iQ2].U2));
            Q2[iQ2].c= aut.PR[br];
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 7)||(iT2> 17) )continue;
               aut.F2[iF2].x.generate(aut.F2[con.Q2[iQ2].bseF2].x,
                                      aut.PR[br],
                                      dep.G3[iG3].b);
            }
         }
      }
   }
//
//
// evaluate macro energy and r-squared expansion
//
   Fr= (0.00);
   nE2=0;
   nO2=0;
   E2.clear();
   O2.clear();
   aut.jC3=0;

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( iZ0!=aZ0 )continue;
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      int mE1=con.Z0[iZ0].E1a;
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
         aut.br=con.Q2[iQ2].br;
         if( aut.br==0 ){
            aut.BBw=iQ2;
            aut.SCa=(nQ2+1);
         }else{
            if( con.Q2[iQ2].cbr==0 )aut.SCa=iQ2;
         }
         int nE1=(mE1-1+con.Q2[iQ2].cE1);
         if( nE1>=mE1 ){
            for(int iE1=mE1;iE1<=nE1&&(aut.jC3<nC3);iE1++){
               int iQ3=con.E1[iE1].Q3;
               int pQ1min=con.Q3[iQ3].Q1a;
               int pQ1max=(pQ1min-1+con.Q3[iQ3].cQ1);
               int jZ0=con.E1[iE1].Z0;
               int kQ2=con.E1[iE1].k;
// calc Fr
               int lam=con.E1[iE1].lam;
               if      ( lam==0 ){
               }else if( lam==1 ){
               }else if( (lam==2)||(lam==3) ){
               }else if( lam==4 ){
                  int jX2=con.E1[iE1].X2;
                  int pX1min=con.X2[jX2].X1a;
                  int pX1max=(pX1min-1+con.X2[jX2].cX1);
                  for(int pQ1=pQ1min;pQ1<=pQ1max&&(aut.jC3<nC3);pQ1++){
                     int iQ1=con.Q1[pQ1].ord;
                     int i_3min=con.Q1[iQ1].G3a;
                     int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
                     for(int pX1=pX1min;pX1<=pX1max&&(aut.jC3<nC3);pX1++){
                        int jX1=con.X1[pX1].ord;
                        int jF2min=con.X1[jX1].F2a;
                        int jF2max=(jF2min-1+con.X1[jX1].cF2);
                        for(int i_3=i_3min;i_3<=i_3max&&(aut.jC3<nC3);i_3++){
                           int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                               con.G3[i_3].F2;
                           if( iF2!=C3[aut.jC3].N2F2[ 1] )continue;
                           for(int jF2=jF2min;jF2<=jF2max&&(aut.jC3<nC3);jF2++){
                              if( jF2!=C3[aut.jC3].N2F2[ 0] )continue;
                              PHI0_R(aut,
                                     con,
                                     jF2,kQ2,jZ0,iF2,iQ2,iZ0);
                              aut.jC3++;
                           }
                        }
                     }
                  }

               }else if( (lam==6)||(lam==7) ){
                  int jQ3=con.E1[iE1].X2;
                  int qQ1min=con.Q3[jQ3].Q1a;
                  int qQ1max=(qQ1min-1+con.Q3[jQ3].cQ1);
                  for(int pQ1=pQ1min;pQ1<=pQ1max&&(aut.jC3<nC3);pQ1++){
                     int iQ1=con.Q1[pQ1].ord;
                     int i_3min=con.Q1[iQ1].G3a;
                     int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
                     for(int qQ1=qQ1min;qQ1<=qQ1max&&(aut.jC3<nC3);qQ1++){
                        int jQ1=con.Q1[qQ1].ord;
                        int j_3min=con.Q1[jQ1].G3a;
                        int j_3max=(j_3min-1+con.Q1[jQ1].cG3);
                        for(int i_3=i_3min;i_3<=i_3max&&(aut.jC3<nC3);i_3++){
                           int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                               con.G3[i_3].F2;
                           if( iF2!=C3[aut.jC3].N2F2[ 1] )continue;
                           for(int j_3=j_3min;j_3<=j_3max&&(aut.jC3<nC3);j_3++){
                              int jF2=( lam==7 )? con.B3[j_3].F2:
                                                  con.G3[j_3].F2;
                              if( jF2!=C3[aut.jC3].N2F2[ 0] )continue;
                              PHI0_R(aut,
                                     con,
                                     jF2,kQ2,jZ0,iF2,iQ2,iZ0);
                              aut.jC3++;
                           }
                        }
                     }
                  }

               }

            }
            mE1+=con.Q2[iQ2].cE1;
         }
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
      }
   }
   Fr*=physics_consts.CAL;
   TOT= Fr;

   return;
}
