#include "../con/Subset_Contracted_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi1_Automatic.hh"
#include <cmath>

void Energy_Surface4::PHI0_R(Phi1_Automatic& aut,
                             const Subset_Contracted_System::tM3& con,
                             int jF2,int kQ2,int jZ0,
                             int iF2,int iQ2,int iZ0){

   aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
   aut.RR= aut.x.rr();
   aut.R= std::sqrt( aut.RR);
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
   double RHO= C3[aut.jC3].r;
   double EPS= C3[aut.jC3].a;
   double z=( aut.R -RHO);
   Fr+=(EPS*z*z);
   PHI1_E2(aut,con,kQ2,jZ0,iF2,iQ2,iZ0);
   E2[nE2].rho= RHO;
   E2[nE2].eps= EPS;
   nE2++;

   return;
}
