#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Search_Subspace.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_phi0_hbnd {
private:
   std::vector<Energy_Surface4::tC3> o_xC3;     //
   std::vector<Energy_Surface4::tC3> o_yC3;     //
   std::vector<Coordinates> o_F2x;              //atom position
   std::vector<int> o_R0var;                    //bb variability{0,1,2}
   std::vector<int> o_R0ele;                    //bb conf {+,-}*bb variability
                                                // {0,1,2}
public:
   std::vector<int> o_C3ord;                    //
   MEM_phi0_hbnd(int oR0,int oF2):
      o_xC3(16),
      o_yC3(16),
      o_F2x(oF2),
      o_R0var(oR0),
      o_R0ele(oR0)
   {
   }
   Energy_Surface4::tC3& xC3(int i){
      return o_xC3.at( i);  }
   Energy_Surface4::tC3& yC3(int i){
      return o_yC3.at( i);  }
   Coordinates& F2x(int i){
      return o_F2x.at( i);  }
   int& R0var(int i){
      return o_R0var.at( i);  }
   int& R0ele(int i){
      return o_R0ele.at( i);  }
   int& C3ord(int i){
      return o_C3ord.at( i);  }
};

void Energy_Surface4::PHI0_HBND(const DAT_PHYSICS_CONSTS& physics_consts,
                                Output_Streams& out,
                                const Search_Subspace& sub,
                                const Mechanical_System& mol,
                                const Subset_Contracted_System::tM3& con,
                                Conf_Dependent_System& dep,
                                int iCYC,
                                int shf1,int shf2){
   int oZ0=con.oZ0;
   int oR0=con.oR0;
   int oR1=sub.nR1;
   MEM_phi0_hbnd vv(oR0,oF2);
//
//
// distance constraints between ends of deformed segment
//
   C3.clear();

   int aR1=iCYC;
   int bR1=(aR1-1+sub.R1[aR1].pt);
// int aZ0=sub.R1[aR1].Z0;
   int aR0=sub.R1[aR1].R0;
   char c1=mol.R0[aR0].c1;
   int bR0=sub.R1[bR1].R0;
// out.FILE3<< std::fixed<< std::setprecision( 3);
   if      ( c1=='a' ){
      vv.xC3( 0).N2F2[ 1]=con.R0N6F2(bR0, 0);
      vv.xC3( 1).N2F2[ 1]=con.R0N6F2(bR0, 0);
      vv.xC3( 2).N2F2[ 1]=con.R0N6F2(bR0, 0);
      vv.xC3( 3).N2F2[ 1]=con.R0N6F2(bR0, 0);
      vv.xC3( 4).N2F2[ 1]=con.R0N6F2(bR0, 1);
      vv.xC3( 5).N2F2[ 1]=con.R0N6F2(bR0, 1);
      vv.xC3( 6).N2F2[ 1]=con.R0N6F2(bR0, 1);
      vv.xC3( 7).N2F2[ 1]=con.R0N6F2(bR0, 1);
      vv.xC3( 8).N2F2[ 1]=con.R0N6F2(bR0, 4);
      vv.xC3( 9).N2F2[ 1]=con.R0N6F2(bR0, 2);
      vv.xC3(10).N2F2[ 1]=con.R0N6F2(bR0, 4);
      vv.xC3(11).N2F2[ 1]=con.R0N6F2(bR0, 2);
      vv.xC3(12).N2F2[ 1]=con.R0N6F2(bR0, 4);
      vv.xC3(13).N2F2[ 1]=con.R0N6F2(bR0, 4);
      vv.xC3(14).N2F2[ 1]=con.R0N6F2(bR0, 2);
      vv.xC3(15).N2F2[ 1]=con.R0N6F2(bR0, 2);

      vv.xC3( 0).N2F2[ 0]=con.R0N6F2(aR0, 2);
      vv.xC3( 1).N2F2[ 0]=con.R0N6F2(aR0, 1);
      vv.xC3( 2).N2F2[ 0]=con.R0N6F2(aR0, 4);
      vv.xC3( 3).N2F2[ 0]=con.R0N6F2(aR0, 0);
      vv.xC3( 4).N2F2[ 0]=con.R0N6F2(aR0, 2);
      vv.xC3( 5).N2F2[ 0]=con.R0N6F2(aR0, 1);
      vv.xC3( 6).N2F2[ 0]=con.R0N6F2(aR0, 4);
      vv.xC3( 7).N2F2[ 0]=con.R0N6F2(aR0, 0);
      vv.xC3( 8).N2F2[ 0]=con.R0N6F2(aR0, 2);
      vv.xC3( 9).N2F2[ 0]=con.R0N6F2(aR0, 2);
      vv.xC3(10).N2F2[ 0]=con.R0N6F2(aR0, 1);
      vv.xC3(11).N2F2[ 0]=con.R0N6F2(aR0, 1);
      vv.xC3(12).N2F2[ 0]=con.R0N6F2(aR0, 4);
      vv.xC3(13).N2F2[ 0]=con.R0N6F2(aR0, 0);
      vv.xC3(14).N2F2[ 0]=con.R0N6F2(aR0, 4);
      vv.xC3(15).N2F2[ 0]=con.R0N6F2(aR0, 0);

      int jR0=(aR0+shf1);
      int kR0=(bR0+shf2);
      vv.yC3( 0).N2F2[ 1]=con.R0N6F2(kR0, 0);
      vv.yC3( 1).N2F2[ 1]=con.R0N6F2(kR0, 0);
      vv.yC3( 2).N2F2[ 1]=con.R0N6F2(kR0, 0);
      vv.yC3( 3).N2F2[ 1]=con.R0N6F2(kR0, 0);
      vv.yC3( 4).N2F2[ 1]=con.R0N6F2(kR0, 1);
      vv.yC3( 5).N2F2[ 1]=con.R0N6F2(kR0, 1);
      vv.yC3( 6).N2F2[ 1]=con.R0N6F2(kR0, 1);
      vv.yC3( 7).N2F2[ 1]=con.R0N6F2(kR0, 1);
      vv.yC3( 8).N2F2[ 1]=con.R0N6F2(kR0, 4);
      vv.yC3( 9).N2F2[ 1]=con.R0N6F2(kR0, 2);
      vv.yC3(10).N2F2[ 1]=con.R0N6F2(kR0, 4);
      vv.yC3(11).N2F2[ 1]=con.R0N6F2(kR0, 2);
      vv.yC3(12).N2F2[ 1]=con.R0N6F2(kR0, 4);
      vv.yC3(13).N2F2[ 1]=con.R0N6F2(kR0, 4);
      vv.yC3(14).N2F2[ 1]=con.R0N6F2(kR0, 2);
      vv.yC3(15).N2F2[ 1]=con.R0N6F2(kR0, 2);

      vv.yC3( 0).N2F2[ 0]=con.R0N6F2(jR0, 2);
      vv.yC3( 1).N2F2[ 0]=con.R0N6F2(jR0, 1);
      vv.yC3( 2).N2F2[ 0]=con.R0N6F2(jR0, 4);
      vv.yC3( 3).N2F2[ 0]=con.R0N6F2(jR0, 0);
      vv.yC3( 4).N2F2[ 0]=con.R0N6F2(jR0, 2);
      vv.yC3( 5).N2F2[ 0]=con.R0N6F2(jR0, 1);
      vv.yC3( 6).N2F2[ 0]=con.R0N6F2(jR0, 4);
      vv.yC3( 7).N2F2[ 0]=con.R0N6F2(jR0, 0);
      vv.yC3( 8).N2F2[ 0]=con.R0N6F2(jR0, 2);
      vv.yC3( 9).N2F2[ 0]=con.R0N6F2(jR0, 2);
      vv.yC3(10).N2F2[ 0]=con.R0N6F2(jR0, 1);
      vv.yC3(11).N2F2[ 0]=con.R0N6F2(jR0, 1);
      vv.yC3(12).N2F2[ 0]=con.R0N6F2(jR0, 4);
      vv.yC3(13).N2F2[ 0]=con.R0N6F2(jR0, 0);
      vv.yC3(14).N2F2[ 0]=con.R0N6F2(jR0, 4);
      vv.yC3(15).N2F2[ 0]=con.R0N6F2(jR0, 0);

      nC3=0;
      for(int iC3= 0;iC3<16;iC3++){
         int aF2=vv.xC3(iC3).N2F2[ 0];
         int bF2=vv.xC3(iC3).N2F2[ 1];
         int jF2=vv.yC3(iC3).N2F2[ 0];
         int kF2=vv.yC3(iC3).N2F2[ 1];
         if( (bF2>-1)&&(aF2>-1)&&(kF2>-1)&&(jF2>-1) ){
            double r=( dep.F2[kF2].x -dep.F2[jF2].x).r();
            std::string atm1=con.F2[aF2].atm;
            std::string atm2=con.F2[bF2].atm;
            C3.push_back( tC3());
            C3[nC3].N2F2[ 0]= aF2;
            C3[nC3].N2F2[ 1]= bF2;
            C3[nC3].r= r;
            C3[nC3].a=( (atm1==" CB ")||
                        (atm2==" CB ") )? (1.00e+3): (1.00e+4);
            C3[nC3].a/=physics_consts.CAL;
            nC3++;
//          out.FILE3<<" jR0="<< std::setw( 4)<<aR0
//                   <<" kR0="<< std::setw( 4)<<bR0
//                   <<" atm1="<<atm1
//                   <<" atm2="<<atm2
//                   <<" r="<< std::setw( 8)<<(physics_consts.ANG*r)<<'\n';
         }
      }

   }else if( c1=='e' ){
   }else if( c1=='r' ){
   }else if( c1=='b' ){
   }else if( c1=='p' ){
      vv.xC3( 0).N2F2[ 1]=con.R0N6F2(bR0-1, 1);
      vv.xC3( 1).N2F2[ 1]=con.R0N6F2(bR0-1, 1);
      vv.xC3( 2).N2F2[ 1]=con.R0N6F2(bR0-1, 1);
      vv.xC3( 3).N2F2[ 1]=con.R0N6F2(bR0-1, 1);
      vv.xC3( 4).N2F2[ 1]=con.R0N6F2(bR0-1, 2);
      vv.xC3( 5).N2F2[ 1]=con.R0N6F2(bR0-1, 2);
      vv.xC3( 6).N2F2[ 1]=con.R0N6F2(bR0-1, 2);
      vv.xC3( 7).N2F2[ 1]=con.R0N6F2(bR0-1, 2);
      vv.xC3( 8).N2F2[ 1]=con.R0N6F2(bR0-1, 5);
      vv.xC3( 9).N2F2[ 1]=con.R0N6F2(bR0+1, 0);
      vv.xC3(10).N2F2[ 1]=con.R0N6F2(bR0-1, 5);
      vv.xC3(11).N2F2[ 1]=con.R0N6F2(bR0+1, 0);

      vv.xC3( 0).N2F2[ 0]=con.R0N6F2(aR0  , 0);
      vv.xC3( 1).N2F2[ 0]=con.R0N6F2(aR0-2, 2);
      vv.xC3( 2).N2F2[ 0]=con.R0N6F2(aR0-2, 5);
      vv.xC3( 3).N2F2[ 0]=con.R0N6F2(aR0-2, 1);
      vv.xC3( 4).N2F2[ 0]=con.R0N6F2(aR0  , 0);
      vv.xC3( 5).N2F2[ 0]=con.R0N6F2(aR0-2, 2);
      vv.xC3( 6).N2F2[ 0]=con.R0N6F2(aR0-2, 5);
      vv.xC3( 7).N2F2[ 0]=con.R0N6F2(aR0-2, 1);
      vv.xC3( 8).N2F2[ 0]=con.R0N6F2(aR0  , 0);
      vv.xC3( 9).N2F2[ 0]=con.R0N6F2(aR0  , 0);
      vv.xC3(10).N2F2[ 0]=con.R0N6F2(aR0-2, 2);
      vv.xC3(11).N2F2[ 0]=con.R0N6F2(aR0-2, 2);

      nC3=0;
      for(int iC3= 0;iC3<12;iC3++){
         int aF2=vv.xC3(iC3).N2F2[ 0];
         int bF2=vv.xC3(iC3).N2F2[ 1];
         if( (bF2>-1)&&(aF2>-1) ){
            double r=( dep.F2[bF2].x -dep.F2[aF2].x).r();
            std::string atm1=con.F2[aF2].atm;
            std::string atm2=con.F2[bF2].atm;
            C3.push_back( tC3());
            C3[nC3].N2F2[ 0]= aF2;
            C3[nC3].N2F2[ 1]= bF2;
            C3[nC3].r= r;
            C3[nC3].a=( (atm1==" C2'")||
                        (atm2==" C2'") )? (1.00e+3): (1.00e+4);
            C3[nC3].a/=physics_consts.CAL;
            nC3++;
//          out.FILE3<<" jR0="<< std::setw( 4)<<aR0
//                   <<" kR0="<< std::setw( 4)<<bR0
//                   <<" atm1="<<atm1
//                   <<" atm2="<<atm2
//                   <<" r="<< std::setw( 8)<<(physics_consts.ANG*r)<<'\n';
         }
      }

   }else if( c1=='s' ){
   }

// out.FILE3<<" distance constraints between ends of deformed segment"
//          <<" nC3="<< std::setw( 4)<<nC3<<'\n';

   if( HBC==0 )return;
//
//
// generate coords of physical atoms using imperfect deformation
//
   Coordinates TRANS;                   //rigid body translation
   Rotation_Matrix PR[3];               //generation matrix

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=Z0[iZ0].U2a;
         TRANS(0)= U2chi(iU2  );
         TRANS(1)= U2chi(iU2+1);
         TRANS(2)= U2chi(iU2+2);
         alp= U2chi(iU2+3);
         bet= U2chi(iU2+4);
         gam= U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);

      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 7)||(iT2> 17) )continue;
         vv.F2x(iF2).generate(TRANS,
                               ROT,
                               dep.F2[iF2].x);
      }

      if( nQ2>mQ2 ){
         PR[ 0]= ROT;

         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            PR[br].extend(PR[cbr],
                          dep.Q2[iQ2].tu,
                          U2chi(Q2[iQ2].U2));
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 7)||(iT2> 17) )continue;
               vv.F2x(iF2).generate(vv.F2x(con.Q2[iQ2].bseF2),
                                     PR[br],
                                     dep.G3[iG3].b);
            }
         }
      }
   }
//
// partition residues, bb conf {+=extended,-=other},
//                     bb variability {0=incomplete,1=fixed,2=variable}
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( (con.R0N6F2(iR0, 0)>=0)&&(con.R0N6F2(iR0, 1)>=0)&&
             (con.R0N6F2(iR0, 2)>=0)&&(con.R0N6F2(iR0, 3)>=0)&&
             (con.R0N6F2(iR0, 5)>=0) ){
            vv.R0var(iR0)=1;
         }else{
            vv.R0var(iR0)=0;
         }
      }
   }
   for(int iR1= 0;iR1<oR1;iR1++){
      if( sub.R1[iR1].bb>0 ){
         int iR0=sub.R1[iR1].R0;
         if( vv.R0var(iR0)==0 )continue;
         if( (iR0>=aR0)&&(iR0<=bR0) ){
            vv.R0var(iR0)=2;
         }else{
            vv.R0var(iR0)=0;
         }
      }
   }

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         vv.R0ele(iR0)=vv.R0var(iR0);
         if( vv.R0ele(iR0)>0 ){
            int jF2=con.R0N6F2(iR0,3);
            int iF2=con.R0N6F2(iR0,0);
            Coordinates zU=( vv.F2x(jF2) -vv.F2x(iF2)).normalize();
            jF2=con.R0N6F2(iR0,5);
            iF2=con.R0N6F2(iR0,2);
            Coordinates zV=( vv.F2x(jF2) -vv.F2x(iF2)).normalize();
            double Cthet= dot(zU,zV);
            double thet= (std::acos( Cthet)/physics_consts.RAD);
            if( thet>( 45.00) )vv.R0ele(iR0)=-vv.R0ele(iR0);
         }
      }
   }

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( std::abs( vv.R0ele(iR0))!=1 )continue;
// iR0 part of fixed core
         int iF2=con.R0N6F2(iR0,3);
         int kF2=con.R0N6F2(iR0,0);
         Coordinates zU=( dep.F2[iF2].y -dep.F2[kF2].y).normalize();
         bool PASS=true;
         for(int jZ0= 0;(jZ0<oZ0)&&PASS;jZ0++){
            int jR0min=mol.Z0[jZ0].R0a;
            int jR0max=(jR0min-1+mol.Z0[jZ0].cR0);
            for(int jR0=jR0min;(jR0<=jR0max)&&PASS;jR0++){
               if( jR0==iR0 )continue;
               if( std::abs( vv.R0ele(jR0))!=1 )continue;
// jR0 part of fixed core
               if( (vv.R0ele(iR0)==-1)&&(vv.R0ele(jR0)==-1) )continue;
               int jF2=con.R0N6F2(jR0,5);
               Coordinates zD=( dep.F2[jF2].y -dep.F2[iF2].y);
               double R= (physics_consts.ANG*zD.r());
               zD.normalize();
               double Cthet= dot(zU,zD);
               double thet= (std::acos( Cthet)/physics_consts.RAD);
               if( (R<(3.20))&&(thet<(50.00)) ){
                  vv.R0ele(iR0)=-1;
                  vv.R0ele(jR0)=-1;
                  PASS=false;
               }
            }
         }
      }
   }

// out.FILE3<<"bb conf {+=extended,-=other}"
//            " *bb variability {0=incomplete,1=fixed,2=variable}\n";
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    int mR0=mol.Z0[iZ0].R0a;
//    int nR0=(mR0-1+mol.Z0[iZ0].cR0);
//    for(int iR0=mR0;iR0<=nR0;iR0++){
//       out.FILE3<<" iZ0="<< std::setw( 2)<<(iZ0+1)
//                <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
//                <<" sub="<< std::setw( 2)<<vv.R0ele(iR0)<<'\n';
//    }
// }
//
//
// add H-bond crosslink distance constraints between extended confs
//
   double zR= (2.20);
   double zT= (40.0);
   for(int iTER=0;iTER<4;iTER++){
      zR+=(1.00);
      zT+=(10.0);
      for(int jZ0= 0;jZ0<oZ0;jZ0++){
         int jR0min=mol.Z0[jZ0].R0a;
         int jR0max=(jR0min-1+mol.Z0[jZ0].cR0);
         for(int jR0=jR0min;jR0<=jR0max;jR0++){
            if( vv.R0ele(jR0)<=0 )continue;
            int jF2=con.R0N6F2(jR0,3);
            int lF2=con.R0N6F2(jR0,0);
            Coordinates zU=( vv.F2x(jF2) -vv.F2x(lF2)).normalize();
            lF2=con.R0N6F2(jR0,5);
            bool PASS=true;
            for(int iZ0=jZ0;(iZ0>= 0)&&PASS;iZ0--){
               int iR0min=mol.Z0[iZ0].R0a;
               int iR0max=( iZ0==jZ0 )? (jR0-3):
                                        (iR0min-1+mol.Z0[iZ0].cR0);
               for(int iR0=iR0max;(iR0>=iR0min)&&PASS;iR0--){
                  if( vv.R0ele(iR0)<=0 )continue;
                  if( (vv.R0ele(jR0)==1)&&(vv.R0ele(iR0)==1) )continue;
                  int kF2=con.R0N6F2(iR0,5);
                  Coordinates zW=( vv.F2x(kF2) -vv.F2x(jF2));
                  double R= (physics_consts.ANG*zW.r());
                  if( R>zR )continue;
                  zW.normalize();
                  double Cthet= dot(zU,zW);
                  double thet= (std::acos( Cthet)/physics_consts.RAD);
                  if( thet>zT )continue;
                  int iF2=con.R0N6F2(iR0,3);
                  kF2=con.R0N6F2(iR0,0);
                  Coordinates zV=( vv.F2x(iF2) -vv.F2x(kF2)).normalize();
                  zW=( vv.F2x(lF2) -vv.F2x(iF2));
                  R= (physics_consts.ANG*zW.r());
                  zW.normalize();
                  Cthet= dot(zV,zW);
                  thet= (std::acos( Cthet)/physics_consts.RAD);
                  if( (R<zR)&&(thet<zT) ){
                     C3.push_back( tC3());
                     C3[nC3].N2F2[0]=con.R0N6F2(iR0,5);
                     C3[nC3].N2F2[1]=con.R0N6F2(jR0,0);
                     C3[nC3].r= ((2.95)/physics_consts.ANG);
                     C3[nC3].a= ((4.00)/physics_consts.CAL);
                     nC3++;
                     C3.push_back( tC3());
                     C3[nC3].N2F2[0]=con.R0N6F2(iR0,5);
                     C3[nC3].N2F2[1]=con.R0N6F2(jR0,3);
                     C3[nC3].r= ((1.95)/physics_consts.ANG);
                     C3[nC3].a= ((4.00)/physics_consts.CAL);
                     nC3++;
                     C3.push_back( tC3());
                     C3[nC3].N2F2[0]=con.R0N6F2(iR0,0);
                     C3[nC3].N2F2[1]=con.R0N6F2(jR0,5);
                     C3[nC3].r= ((2.95)/physics_consts.ANG);
                     C3[nC3].a= ((4.00)/physics_consts.CAL);
                     nC3++;
                     C3.push_back( tC3());
                     C3[nC3].N2F2[0]=con.R0N6F2(iR0,3);
                     C3[nC3].N2F2[1]=con.R0N6F2(jR0,5);
                     C3[nC3].r= ((1.95)/physics_consts.ANG);
                     C3[nC3].a= ((4.00)/physics_consts.CAL);
                     nC3++;
                     vv.R0ele(jR0)=0;
                     vv.R0ele(iR0)=0;
                     PASS=false;
                     continue;
                  }
                  if( (jR0-2)>=jR0min ){
                     kF2=con.R0N6F2(jR0-2,5);
                     Coordinates zW=( vv.F2x(kF2) -vv.F2x(iF2));
                     double R= (physics_consts.ANG*zW.r());
                     zW.normalize();
                     double Cthet= dot(zV,zW);
                     double thet= (std::acos( Cthet)/physics_consts.RAD);
                     if( (R<zR)&&(thet<zT) ){
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0,5);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0,0);
                        C3[nC3].r= ((2.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0,5);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0,3);
                        C3[nC3].r= ((1.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0,0);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0-2,5);
                        C3[nC3].r= ((2.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0,3);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0-2,5);
                        C3[nC3].r= ((1.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        vv.R0ele(iR0)=0;
                        PASS=false;
                     }
                  }
                  if( ((iR0+2)<=iR0max)&&(con.R0N6F2(iR0+2,3)>=0) ){
                     int iF2=con.R0N6F2(iR0+2,3);
                     int kF2=con.R0N6F2(iR0+2,0);
                     Coordinates zV=( vv.F2x(iF2) -vv.F2x(kF2)).normalize();
                     Coordinates zW=( vv.F2x(lF2) -vv.F2x(iF2));
                     double R= (physics_consts.ANG*zW.r());
                     zW.normalize();
                     double Cthet= dot(zV,zW);
                     double thet= (std::acos( Cthet)/physics_consts.RAD);
                     if( (R<zR)&&(thet<zT) ){
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0,5);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0,0);
                        C3[nC3].r= ((2.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0,5);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0,3);
                        C3[nC3].r= ((1.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0+2,0);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0,5);
                        C3[nC3].r= ((2.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        C3.push_back( tC3());
                        C3[nC3].N2F2[0]=con.R0N6F2(iR0+2,3);
                        C3[nC3].N2F2[1]=con.R0N6F2(jR0,5);
                        C3[nC3].r= ((1.95)/physics_consts.ANG);
                        C3[nC3].a= ((4.00)/physics_consts.CAL);
                        nC3++;
                        vv.R0ele(jR0)=0;
                        PASS=false;
                     }
                  }
               }
            }
         }
      }
   }

// if( out.VERBOSE ){
//    out.FILE3<<" H-bond crosslink distance constraints"
//               " between extended strands nC3="
//             << std::setw( 4)<<nC3<<'\n';
// }
//
// partition residues, bb conf {+=helical,-=other},
//                     bb variability {0=incomplete,1=fixed,2=variable}
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         vv.R0ele(iR0)=vv.R0var(iR0);
         if( vv.R0ele(iR0)>0 ){
            int jF2=con.R0N6F2(iR0,3);
            int iF2=con.R0N6F2(iR0,0);
            Coordinates zU=( vv.F2x(jF2) -vv.F2x(iF2)).normalize();
            jF2=con.R0N6F2(iR0,5);
            iF2=con.R0N6F2(iR0,2);
            Coordinates zV=( vv.F2x(jF2) -vv.F2x(iF2)).normalize();
            double Cthet= dot(zU,zV);
            double thet= (std::acos( Cthet)/physics_consts.RAD);
            if( thet<(135.00) )vv.R0ele(iR0)=-vv.R0ele(iR0);
         }
      }
   }

// out.FILE3<<"bb conf {+=helical,-=other}"
//            " *bb variability {0=incomplete,1=fixed,2=variable}\n";
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    int mR0=mol.Z0[iZ0].R0a;
//    int nR0=(mR0-1+mol.Z0[iZ0].cR0);
//    for(int iR0=mR0;iR0<=nR0;iR0++){
//       out.FILE3<<" iZ0="<< std::setw( 2)<<(iZ0+1)
//                <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
//                <<" sub="<< std::setw( 2)<<vv.R0ele(iR0)<<'\n';
//    }
// }
//
//
// add H-bond crosslink distance constraints between helical confs
//
   zR= (3.20);
   zT= (50.0);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+4);iR0<=nR0;iR0++){
         if( vv.R0ele(iR0  )<=0 )continue;
         if( vv.R0ele(iR0-1)<=0 )continue;
         if( vv.R0ele(iR0-2)<=0 )continue;
         if( vv.R0ele(iR0-3)<=0 )continue;
         if( vv.R0ele(iR0-4)<=0 )continue;
         if( (vv.R0ele(iR0  )==1)&&(vv.R0ele(iR0-4)==1) )continue;
         int jF2=con.R0N6F2(iR0  ,3);
         int lF2=con.R0N6F2(iR0  ,0);
         Coordinates zU=( vv.F2x(jF2) -vv.F2x(lF2)).normalize();
         int kF2=con.R0N6F2(iR0-4,5);
         Coordinates zW=( vv.F2x(kF2) -vv.F2x(jF2));
         double R= (physics_consts.ANG*zW.r());
         if( R>zR )continue;
         zW.normalize();
         double Cthet= dot(zU,zW);
         double thet= (std::acos( Cthet)/physics_consts.RAD);
         if( thet>zT )continue;
         C3.push_back( tC3());
         C3[nC3].N2F2[0]=con.R0N6F2(iR0-4,5);
         C3[nC3].N2F2[1]=con.R0N6F2(iR0  ,0);
         C3[nC3].r= ((2.95)/physics_consts.ANG);
         C3[nC3].a= ((4.00)/physics_consts.CAL);
         nC3++;
         C3.push_back( tC3());
         C3[nC3].N2F2[0]=con.R0N6F2(iR0-4,5);
         C3[nC3].N2F2[1]=con.R0N6F2(iR0  ,3);
         C3[nC3].r= ((1.95)/physics_consts.ANG);
         C3[nC3].a= ((4.00)/physics_consts.CAL);
         nC3++;
      }
   }

// if( out.VERBOSE ){
//    out.FILE3<<" +H-bond distance constraints"
//               " within alpha helicies nC3="
//             << std::setw( 4)<<nC3<<'\n';
// }
//
//
// order set of distance constraints
//
   vv.o_C3ord.resize(nC3);

   for(int iC3= 0;iC3<nC3;iC3++){
      vv.C3ord(iC3)=99999;
   }

   int mC3=-1;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      int mE1=con.Z0[iZ0].E1a;
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
         int nE1=(mE1-1+con.Q2[iQ2].cE1);
         if( nE1>=mE1 ){
            for(int iE1=mE1;iE1<=nE1;iE1++){
               int iQ3=con.E1[iE1].Q3;
               int pQ1min=con.Q3[iQ3].Q1a;
               int pQ1max=(pQ1min-1+con.Q3[iQ3].cQ1);
//             int jZ0=con.E1[iE1].Z0;
//             int kQ2=con.E1[iE1].k;
               int lam=con.E1[iE1].lam;
               if      ( lam==0 ){
               }else if( lam==1 ){
               }else if( (lam==2)||(lam==3) ){
               }else if( lam==4 ){
                  int jX2=con.E1[iE1].X2;
                  int pX1min=con.X2[jX2].X1a;
                  int pX1max=(pX1min-1+con.X2[jX2].cX1);
                  for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
                     int iQ1=con.Q1[pQ1].ord;
                     int i_3min=con.Q1[iQ1].G3a;
                     int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
                     for(int pX1=pX1min;pX1<=pX1max;pX1++){
                        int jX1=con.X1[pX1].ord;
                        int jF2min=con.X1[jX1].F2a;
                        int jF2max=(jF2min-1+con.X1[jX1].cF2);
                        for(int i_3=i_3min;i_3<=i_3max;i_3++){
                           int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                               con.G3[i_3].F2;
                           int iT2=con.F2[iF2].typ;
                           if( (iT2!= 2)&&(iT2!= 8)&&(iT2!= 9)&&
                               (iT2!=11)&&(iT2!=13) )continue;
                           for(int jF2=jF2min;jF2<=jF2max;jF2++){
                              int jT2=con.F2[jF2].typ;
                              if( (jT2!= 2)&&(jT2!= 8)&&(iT2!= 9)&&
                                  (jT2!=11)&&(jT2!=13) )continue;
                              for(int iC3= 0;iC3<nC3;iC3++){
                                 if( vv.C3ord(iC3)!=99999 )continue;
                                 if( (iF2==C3[iC3].N2F2[1])&&
                                     (jF2==C3[iC3].N2F2[0]) ){
                                    vv.C3ord(iC3)=++mC3;
                                    break;
                                 }
                              }
                           }
                        }
                     }
                  }

               }else if( (lam==6)||(lam==7) ){
                  int jQ3=con.E1[iE1].X2;
                  int qQ1min=con.Q3[jQ3].Q1a;
                  int qQ1max=(qQ1min-1+con.Q3[jQ3].cQ1);
                  for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
                     int iQ1=con.Q1[pQ1].ord;
                     int i_3min=con.Q1[iQ1].G3a;
                     int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
                     for(int qQ1=qQ1min;qQ1<=qQ1max;qQ1++){
                        int jQ1=con.Q1[qQ1].ord;
                        int j_3min=con.Q1[jQ1].G3a;
                        int j_3max=(j_3min-1+con.Q1[jQ1].cG3);
                        for(int i_3=i_3min;i_3<=i_3max;i_3++){
                           int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                               con.G3[i_3].F2;
                           int iT2=con.F2[iF2].typ;
                           if( (iT2!= 2)&&(iT2!= 8)&&(iT2!= 9)&&
                               (iT2!=11)&&(iT2!=13) )continue;
                           for(int j_3=j_3min;j_3<=j_3max;j_3++){
                              int jF2=( lam==7 )? con.B3[j_3].F2:
                                                  con.G3[j_3].F2;
                              int jT2=con.F2[jF2].typ;
                              if( (jT2!= 2)&&(jT2!= 8)&&(iT2!= 9)&&
                                  (jT2!=11)&&(jT2!=13) )continue;
                              for(int iC3= 0;iC3<nC3;iC3++){
                                 if( vv.C3ord(iC3)!=99999 )continue;
                                 if( (iF2==C3[iC3].N2F2[1])&&
                                     (jF2==C3[iC3].N2F2[0]) ){
                                    vv.C3ord(iC3)=++mC3;
                                    break;
                                 }
                              }
                           }
                        }
                     }
                  }

               }
            }
            mE1+=con.Q2[iQ2].cE1;
         }
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
      }
   }
   mC3++;

// if( out.VERBOSE ){
//    out.FILE3<<" ordered nC3="
//             << std::setw( 4)<<mC3<<'\n';
// }

   for(int iC3max=(nC3-1);iC3max> 0;iC3max--){
      bool ORDERED=true;
      int i1=vv.C3ord( 0);
      for(int iC3= 1;iC3<=iC3max;iC3++){
         int i2=vv.C3ord(iC3);
         if( i1>i2 ){
            int L=vv.C3ord(iC3);
            vv.C3ord(iC3)=vv.C3ord(iC3-1);
            vv.C3ord(iC3-1)=L;
            C3[iC3].swap( C3[iC3-1]);
            ORDERED=false;
         }else{
            i1=i2;
         }
      }
      if( ORDERED )break;
   }
   nC3=mC3;

   vv.o_C3ord.clear();
   return;
}
