#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include <vector>
#include <cmath>

class MEM_phi0 {
private:
   std::vector<double> o_U2dq;          //
public:
   MEM_phi0(int o):
      o_U2dq(o)
   {
   }
   double& U2dq(int i){
      return o_U2dq.at( i);  }
};

void Energy_Surface4::PHI0(const DAT_PHYSICS_CONSTS& physics_consts,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con){
//
//
// zero energy surface
//
   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)= (0.00);
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2= 0;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)= (0.00);
      }
   }
   Fr= (0.00);
   PHI1_DCHI(physics_consts,mol,con);
//
//
// evaluate energy surface
//
   MEM_phi0 vv(nU2);
   Coordinates zG;
   Coordinates zF;
   int iO2min=0;
   for(int iE2= 0;iE2<nE2;iE2++){
      int iO2max=(iO2min-1+E2[iE2].cO2);

      double q0= E2[iE2].q;
      double dq0= (0.00);
      zG.zero();
      for(int iO2=iO2min;iO2<=iO2max;iO2++){
         int iU2=O2[iO2].U2;
         double dchi= U2dchi(iU2);
         dq0+=(dchi*O2[iO2].s);
         zG+=(dchi*O2[iO2].t);
      }
      double ddq0= (0.00);
      zF.zero();
      for(int iO2=iO2min;iO2<=iO2max;iO2++){
         int iU2=O2[iO2].U2;
         double dchi= U2dchi(iU2);
         zG-=(dchi*O2[iO2].t);
         zF+=(dchi*O2[iO2].u);
         vv.U2dq(iU2)=( dot(O2[iO2].u,zG)
                        +dot(zF,O2[iO2].t));
         ddq0+=(dchi*vv.U2dq(iU2));
         vv.U2dq(iU2)+=O2[iO2].s;
      }
      double q=( q0 +dq0 +(.50)*ddq0);
      if( q<(1.00e-12) )q= (1.00e-12);

      double RR= ((2.00)*q);
      double R= std::sqrt( RR);
      double EPS= E2[iE2].eps;
      double RHO= E2[iE2].rho;
      double ZZ=( R -RHO);
      Fr+=EPS*ZZ*ZZ;
      double dedq= ((2.00)*EPS*ZZ/R);
      double ddedqdq=( (2.00)*EPS -dedq)/RR;

      for(int iO2=iO2min;iO2<=iO2max;iO2++){
         int iU2=O2[iO2].U2;
         U2g(iU2)+=(dedq*vv.U2dq(iU2));
         double z= ddedqdq*vv.U2dq(iU2);
         zF= dedq*O2[iO2].u;
         for(int jO2=iO2;jO2<=iO2max;jO2++){
            int jU2=O2[jO2].U2;
            U2U2a(iU2,jU2)+=( z*vv.U2dq(jU2)
                             +dot(zF,O2[jO2].t));
         }
      }

      iO2min+=E2[iE2].cO2;
   }
//
//
// enforce format consistent with minimizer
//
   Fr*=physics_consts.CAL;
   TOT= Fr;
   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)*=(physics_consts.CAL*U2uca(iU2));
      U2U2a(iU2,iU2)*=(physics_consts.CAL*U2uca(iU2)*U2uca(iU2));
   }
   for(int iU2= 0;iU2<(nU2-1);iU2++){
      for(int jU2=(iU2+1);jU2<nU2;jU2++){
         U2U2a(iU2,jU2)+=U2U2a(jU2,iU2);
         U2U2a(jU2,iU2)= (0.00);
         U2U2a(iU2,jU2)*=(physics_consts.CAL*U2uca(iU2)*U2uca(jU2));
      }
   }
   return;
}
