#ifndef DEF_SPHERICAL_HARMONICS
#define DEF_SPHERICAL_HARMONICS

#include "../dat/DAT_ARRAY_CONSTS.hh"

class Spherical_Harmonics {
private:
   int oL;                      //highest order
   /*spherical harmonic components*/
   double C_r[64];              //real
   double C_i[64];              //imaginary

public:
   double& r(int L,int M){
      return C_r[L*L+L+M];
   }
   double& i(int L,int M){
      return C_i[L*L+L+M];
   }
   const double& r(int L,int M) const {
      return C_r[L*L+L+M];
   }
   const double& i(int L,int M) const {
      return C_i[L*L+L+M];
   }
   double& r(int j){
      return C_r[j];
   }
   double& i(int j){
      return C_i[j];
   }
   const double& r(int j) const {
      return C_r[j];
   }
   const double& i(int j) const {
      return C_i[j];
   }

   Spherical_Harmonics();

   void populate(const DAT_ARRAY_CONSTS& array_consts,
                 int o,
                 double CT,
                 double ST,
                 double CP,
                 double SP,
                 Spherical_Harmonics& dC,
                 Spherical_Harmonics& ddC);
   void populate(const DAT_ARRAY_CONSTS& array_consts,
                 int o,
                 double CT,
                 double ST,
                 double CP,
                 double SP,
                 Spherical_Harmonics& dC);
   void populate(const DAT_ARRAY_CONSTS& array_consts,
                 int o,
                 double CT,
                 double ST,
                 double CP,
                 double SP);
   void operator=(const Spherical_Harmonics& a);
};

#endif
