#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Spherical_Harmonics.hh"
//
//
// construct
//
Spherical_Harmonics::Spherical_Harmonics():
   oL(-1)
{
}
//
// evaluate complex conjugate of spherical harmonics and 1st and 2nd derivative
// wrt thet
//
void Spherical_Harmonics::populate(const DAT_ARRAY_CONSTS& array_consts,
                                   int o,
                                   double CT,
                                   double ST,
                                   double CP,
                                   double SP,
                                   Spherical_Harmonics& dC,
                                   Spherical_Harmonics& ddC){
   double Lct[12];              //cos(the)**L
   double Lst[12];              //sin(the)**L
   double Mcp[15];              //cos(M*phi)
   double Msp[15];              //sin(M*phi)

   oL=o;

   int n=(o+5);
   Lct[ 0]= (0.00);
   Lst[ 0]= (0.00);
   Lct[ 1]= (0.00);
   Lst[ 1]= (0.00);
   Lct[ 2]= (1.00);
   Lst[ 2]= (1.00);
   for(int j=3;j<n;j++){
     Lct[j  ]= CT*Lct[j-1];
     Lst[j  ]= ST*Lst[j-1];
   }

   n=(2*o+1);
   Mcp[ o]= (1.00);
   Msp[ o]= (0.00);
   for(int j=(o+1),k=(o-1);j<n;j++,k--){
      Mcp[j  ]= CP*Mcp[j-1] -SP*Msp[j-1];
      Msp[j  ]= CP*Msp[j-1] +SP*Mcp[j-1];
      Mcp[k  ]= Mcp[j  ];
      Msp[k  ]=-Msp[j  ];
   }

   int LM=0;
   for(int L=0;L<=o;L++){
      for(int M=-L;M<=L;M++){
         int MM=( M>=0 )? M:-M;
         int Kmax=(L-MM)/2;
         double Z= (0.00);
         double dZ0= (0.00);
         double dZ1= (0.00);
         double ddZ0= (0.00);
         double ddZ1= (0.00);
         double ddZ2= (0.00);
         double ddZ3= (0.00);
         for(int K=0;K<=Kmax;K++){
            int j=(L-MM-2*K +2);
            Z+=array_consts.SH(K,LM)*Lct[j  ];
            dZ0+=array_consts.dSHt(0,K,LM)*Lct[j+1];
            dZ1+=array_consts.dSHt(1,K,LM)*Lct[j-1];
            ddZ0+=array_consts.ddSHtt(0,K,LM)*Lct[j+2];
            ddZ1+=array_consts.ddSHtt(1,K,LM)*Lct[j  ];
            ddZ2+=array_consts.ddSHtt(2,K,LM)*Lct[j  ];
            ddZ3+=array_consts.ddSHtt(3,K,LM)*Lct[j-2];
         }
         Z*=Lst[MM   +2];
         r(LM)= Z*Mcp[M +o];
         i(LM)=-Z*Msp[M +o];
         dZ0*=Lst[MM-1 +2];
         dZ1*=Lst[MM+1 +2];
         double dZ= dZ0 +dZ1;
         dC.r(LM)= dZ*Mcp[M +o];
         dC.i(LM)=-dZ*Msp[M +o];
         ddZ0*=Lst[MM-2 +2];
         ddZ1*=Lst[MM   +2];
         ddZ2*=Lst[MM   +2];
         ddZ3*=Lst[MM+2 +2];
         double ddZ= ddZ0 +ddZ1 +ddZ2 +ddZ3;
         ddC.r(LM)= ddZ*Mcp[M +o];
         ddC.i(LM)=-ddZ*Msp[M +o];
         LM++;
      }
   }
   return;
}
//
// evaluate complex conjugate of spherical harmonics and 1st derivative wrt
// thet
//
void Spherical_Harmonics::populate(const DAT_ARRAY_CONSTS& array_consts,
                                   int o,
                                   double CT,
                                   double ST,
                                   double CP,
                                   double SP,
                                   Spherical_Harmonics& dC){
   double Lct[10];              //cos(the)**L
   double Lst[10];              //sin(the)**L
   double Mcp[15];              //cos(M*phi)
   double Msp[15];              //sin(M*phi)

   oL=o;

   int n=(o+3);
   Lct[ 0]= (0.00);
   Lst[ 0]= (0.00);
   Lct[ 1]= (1.00);
   Lst[ 1]= (1.00);
   for(int j=2;j<n;j++){
     Lct[j  ]= CT*Lct[j-1];
     Lst[j  ]= ST*Lst[j-1];
   }

   n=(2*o+1);
   Mcp[ o]= (1.00);
   Msp[ o]= (0.00);
   for(int j=(o+1),k=(o-1);j<n;j++,k--){
      Mcp[j  ]= CP*Mcp[j-1] -SP*Msp[j-1];
      Msp[j  ]= CP*Msp[j-1] +SP*Mcp[j-1];
      Mcp[k  ]= Mcp[j  ];
      Msp[k  ]=-Msp[j  ];
   }

   int LM=0;
   for(int L=0;L<=o;L++){
      for(int M=-L;M<=L;M++){
         int MM=( M>=0 )? M:-M;
         int Kmax=(L-MM)/2;
         double Z= (0.00);
         double dZ0= (0.00);
         double dZ1= (0.00);
         for(int K=0;K<=Kmax;K++){
            int j=(L-MM-2*K +1);
            Z+=array_consts.SH(K,LM)*Lct[j  ];
            dZ0+=array_consts.dSHt(0,K,LM)*Lct[j+1];
            dZ1+=array_consts.dSHt(1,K,LM)*Lct[j-1];
         }
         Z*=Lst[MM   +1];
         r(LM)= Z*Mcp[M +o];
         i(LM)=-Z*Msp[M +o];
         dZ0*=Lst[MM-1 +1];
         dZ1*=Lst[MM+1 +1];
         double dZ= dZ0 +dZ1;
         dC.r(LM)= dZ*Mcp[M +o];
         dC.i(LM)=-dZ*Msp[M +o];
         LM++;
      }
   }
   return;
}
//
//
// evaluate complex conjugate of spherical harmonics
//
void Spherical_Harmonics::populate(const DAT_ARRAY_CONSTS& array_consts,
                                   int o,
                                   double CT,
                                   double ST,
                                   double CP,
                                   double SP){
   double Lct[ 8];              //cos(the)**L
   double Lst[ 8];              //sin(the)**L
   double Mcp[15];              //cos(M*phi)
   double Msp[15];              //sin(M*phi)

   oL=o;

   int n=(o+1);
   Lct[ 0]= (1.00);
   Lst[ 0]= (1.00);
   for(int j=1;j<n;j++){
     Lct[j  ]= CT*Lct[j-1];
     Lst[j  ]= ST*Lst[j-1];
   }

   n=(2*o+1);
   Mcp[ o]= (1.00);
   Msp[ o]= (0.00);
   for(int j=(o+1),k=(o-1);j<n;j++,k--){
      Mcp[j  ]= CP*Mcp[j-1] -SP*Msp[j-1];
      Msp[j  ]= CP*Msp[j-1] +SP*Mcp[j-1];
      Mcp[k  ]= Mcp[j  ];
      Msp[k  ]=-Msp[j  ];
   }

   int LM=0;
   for(int L=0;L<=o;L++){
      for(int M=-L;M<=L;M++){
         int MM=( M>=0 )? M:-M;
         int Kmax=(L-MM)/2;
         double Z= (0.00);
         for(int K=0;K<=Kmax;K++){
            int j=(L-MM-2*K);
            Z+=array_consts.SH(K,LM)*Lct[j];
         }
         Z*=Lst[MM];
         r(LM)= Z*Mcp[M +o];
         i(LM)=-Z*Msp[M +o];
         LM++;
      }
   }
   return;
}
//
//
// assign
//
void Spherical_Harmonics::operator=(const Spherical_Harmonics& a){
   for(int j= 0;j<64;j++){
      r(j)=a.r(j);
      i(j)=a.i(j);
   }
   return;
}
