#ifndef DEF_SCRATCH_MULTIPOLES
#define DEF_SCRATCH_MULTIPOLES

#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Multipoles.hh"

class Scratch_Multipoles {
private:
   int oL;                      //highest order
   /*multipole components*/
   double q_r[64];              //real
   double q_i[64];              //imaginary

public:
   int order() const {
      return oL;
   }
   double& r(int L,int M){
      return q_r[L*L+L+M];
   }
   double& i(int L,int M){
      return q_i[L*L+L+M];
   }
   const double& r(int L,int M) const {
      return q_r[L*L+L+M];
   }
   const double& i(int L,int M) const {
      return q_i[L*L+L+M];
   }
   double& r(int j){
      return q_r[j];
   }
   double& i(int j){
      return q_i[j];
   }
   const double& r(int j) const {
      return q_r[j];
   }
   const double& i(int j) const {
      return q_i[j];
   }

   Scratch_Multipoles();

   void operator*=(double a);
   void populate(int o);
   void populate(int o,
                 const Multipoles& a);

   void zero();

   void chain(const DAT_ARRAY_CONSTS& array_consts,
              Scratch_Multipoles(& dq)[3],
              Scratch_Multipoles(& ddq)[3][3]) const;
   void chain(const DAT_ARRAY_CONSTS& array_consts,
              Scratch_Multipoles(& dq)[3]) const;

   void product(const DAT_ARRAY_CONSTS& array_consts,
                const Scratch_Multipoles& q1,
                const Scratch_Multipoles& q2,
                const Scratch_Multipoles(& dq2)[3],
                const Scratch_Multipoles(& ddq2)[3][3],
                Scratch_Multipoles(& QdQ)[3],
                Scratch_Multipoles(& QddQ)[3][3]);
   void product(const DAT_ARRAY_CONSTS& array_consts,
                const Scratch_Multipoles& q1,
                const Scratch_Multipoles& q2,
                const Scratch_Multipoles(& dq2)[3],
                Scratch_Multipoles(& QdQ)[3]);
   void product(const DAT_ARRAY_CONSTS& array_consts,
                const Scratch_Multipoles& q1,
                const Scratch_Multipoles& q2);
   void zproduct(const DAT_ARRAY_CONSTS& array_consts,
                 const Scratch_Multipoles& q1,
                 const Scratch_Multipoles& q2);
};

#endif
