#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Scratch_Multipoles.hh"
//
//
// construct
//
Scratch_Multipoles::Scratch_Multipoles():
   oL(-1)
{
}
//
//
// assign
//
void Scratch_Multipoles::operator*=(double a){
   int n=(oL+1)*(oL+1);
   for(int j=0;j<n;j++){
      q_r[j]*=a;
      q_i[j]*=a;
   }
   return;
}
void Scratch_Multipoles::populate(int o){
   oL=o;
   return;
}
void Scratch_Multipoles::populate(int o,
                                  const Multipoles& a){
   oL=o;
   int n=(oL+1)*(oL+1);
   for(int j=0;j<n;j++){
      r(j)=a.r(j);
      i(j)=a.i(j);
   }
   return;
}
//
//
// initiate
//
void Scratch_Multipoles::zero(){
   int n=(oL+1)*(oL+1);
   for(int j=0;j<n;j++){
      q_r[j]= (0.00);
      q_i[j]= (0.00);
   }
   return;
}
//
//
// differentiate wrt rotation about coordinate axes
//
void Scratch_Multipoles::chain(const DAT_ARRAY_CONSTS& array_consts,
                               Scratch_Multipoles(& dq)[3],
                               Scratch_Multipoles(& ddq)[3][3]) const{
   for(int j=0;j<3;j++){
      dq[j].r(0)= (0.00);
      dq[j].i(0)= (0.00);
      for(int k=0;k<3;k++){
         ddq[j][k].r(0)= (0.00);
         ddq[j][k].i(0)= (0.00);
      }
   }
   for(int L=1;L<=oL;L++){
      int Mmax=(L-1);
      int j=(L*L);
      dq[0].r(j)= array_consts.LMu(j)*i(j+1);
      dq[0].i(j)=-array_consts.LMu(j)*r(j+1);
      dq[1].r(j)=-array_consts.LMu(j)*r(j+1);
      dq[1].i(j)=-array_consts.LMu(j)*i(j+1);
      dq[2].r(j)= (-L)*i(j);
      dq[2].i(j)=-(-L)*r(j);
      for(int M=-Mmax;M<=Mmax;M++){
         j++;
         dq[0].r(j)= array_consts.LMl(j)*i(j-1)
                    +array_consts.LMu(j)*i(j+1);
         dq[0].i(j)=-array_consts.LMl(j)*r(j-1)
                    -array_consts.LMu(j)*r(j+1);
         dq[1].r(j)= array_consts.LMl(j)*r(j-1)
                    -array_consts.LMu(j)*r(j+1);
         dq[1].i(j)= array_consts.LMl(j)*i(j-1)
                    -array_consts.LMu(j)*i(j+1);
         dq[2].r(j)= (M)*i(j);
         dq[2].i(j)=-(M)*r(j);
      }
      j++;
      dq[0].r(j)= array_consts.LMl(j)*i(j-1);
      dq[0].i(j)=-array_consts.LMl(j)*r(j-1);
      dq[1].r(j)= array_consts.LMl(j)*r(j-1);
      dq[1].i(j)= array_consts.LMl(j)*i(j-1);
      dq[2].r(j)= ( L)*i(j);
      dq[2].i(j)=-( L)*r(j);
      j=(L*L);
      ddq[0][0].r(j)= array_consts.LMu(j)*dq[0].i(j+1);
      ddq[0][0].i(j)=-array_consts.LMu(j)*dq[0].r(j+1);
      ddq[0][1].r(j)= array_consts.LMu(j)*dq[1].i(j+1);
      ddq[0][1].i(j)=-array_consts.LMu(j)*dq[1].r(j+1);
      ddq[0][2].r(j)= array_consts.LMu(j)*dq[2].i(j+1);
      ddq[0][2].i(j)=-array_consts.LMu(j)*dq[2].r(j+1);
      ddq[1][0].r(j)=-array_consts.LMu(j)*dq[0].r(j+1);
      ddq[1][0].i(j)=-array_consts.LMu(j)*dq[0].i(j+1);
      ddq[1][1].r(j)=-array_consts.LMu(j)*dq[1].r(j+1);
      ddq[1][1].i(j)=-array_consts.LMu(j)*dq[1].i(j+1);
      ddq[1][2].r(j)=-array_consts.LMu(j)*dq[2].r(j+1);
      ddq[1][2].i(j)=-array_consts.LMu(j)*dq[2].i(j+1);
      ddq[2][0].r(j)= (-L)*dq[0].i(j);
      ddq[2][0].i(j)=-(-L)*dq[0].r(j);
      ddq[2][1].r(j)= (-L)*dq[1].i(j);
      ddq[2][1].i(j)=-(-L)*dq[1].r(j);
      ddq[2][2].r(j)= (-L)*dq[2].i(j);
      ddq[2][2].i(j)=-(-L)*dq[2].r(j);
      for(int M=-Mmax;M<=Mmax;M++){
         j++;
         ddq[0][0].r(j)= array_consts.LMl(j)*dq[0].i(j-1)
                        +array_consts.LMu(j)*dq[0].i(j+1);
         ddq[0][0].i(j)=-array_consts.LMl(j)*dq[0].r(j-1)
                        -array_consts.LMu(j)*dq[0].r(j+1);
         ddq[0][1].r(j)= array_consts.LMl(j)*dq[1].i(j-1)
                        +array_consts.LMu(j)*dq[1].i(j+1);
         ddq[0][1].i(j)=-array_consts.LMl(j)*dq[1].r(j-1)
                        -array_consts.LMu(j)*dq[1].r(j+1);
         ddq[0][2].r(j)= array_consts.LMl(j)*dq[2].i(j-1)
                        +array_consts.LMu(j)*dq[2].i(j+1);
         ddq[0][2].i(j)=-array_consts.LMl(j)*dq[2].r(j-1)
                        -array_consts.LMu(j)*dq[2].r(j+1);
         ddq[1][0].r(j)= array_consts.LMl(j)*dq[0].r(j-1)
                        -array_consts.LMu(j)*dq[0].r(j+1);
         ddq[1][0].i(j)= array_consts.LMl(j)*dq[0].i(j-1)
                        -array_consts.LMu(j)*dq[0].i(j+1);
         ddq[1][1].r(j)= array_consts.LMl(j)*dq[1].r(j-1)
                        -array_consts.LMu(j)*dq[1].r(j+1);
         ddq[1][1].i(j)= array_consts.LMl(j)*dq[1].i(j-1)
                        -array_consts.LMu(j)*dq[1].i(j+1);
         ddq[1][2].r(j)= array_consts.LMl(j)*dq[2].r(j-1)
                        -array_consts.LMu(j)*dq[2].r(j+1);
         ddq[1][2].i(j)= array_consts.LMl(j)*dq[2].i(j-1)
                        -array_consts.LMu(j)*dq[2].i(j+1);
         ddq[2][0].r(j)= (M)*dq[0].i(j);
         ddq[2][0].i(j)=-(M)*dq[0].r(j);
         ddq[2][1].r(j)= (M)*dq[1].i(j);
         ddq[2][1].i(j)=-(M)*dq[1].r(j);
         ddq[2][2].r(j)= (M)*dq[2].i(j);
         ddq[2][2].i(j)=-(M)*dq[2].r(j);
      }
      j++;
      ddq[0][0].r(j)= array_consts.LMl(j)*dq[0].i(j-1);
      ddq[0][0].i(j)=-array_consts.LMl(j)*dq[0].r(j-1);
      ddq[0][1].r(j)= array_consts.LMl(j)*dq[1].i(j-1);
      ddq[0][1].i(j)=-array_consts.LMl(j)*dq[1].r(j-1);
      ddq[0][2].r(j)= array_consts.LMl(j)*dq[2].i(j-1);
      ddq[0][2].i(j)=-array_consts.LMl(j)*dq[2].r(j-1);
      ddq[1][0].r(j)= array_consts.LMl(j)*dq[0].r(j-1);
      ddq[1][0].i(j)= array_consts.LMl(j)*dq[0].i(j-1);
      ddq[1][1].r(j)= array_consts.LMl(j)*dq[1].r(j-1);
      ddq[1][1].i(j)= array_consts.LMl(j)*dq[1].i(j-1);
      ddq[1][2].r(j)= array_consts.LMl(j)*dq[2].r(j-1);
      ddq[1][2].i(j)= array_consts.LMl(j)*dq[2].i(j-1);
      ddq[2][0].r(j)= ( L)*dq[0].i(j);
      ddq[2][0].i(j)=-( L)*dq[0].r(j);
      ddq[2][1].r(j)= ( L)*dq[1].i(j);
      ddq[2][1].i(j)=-( L)*dq[1].r(j);
      ddq[2][2].r(j)= ( L)*dq[2].i(j);
      ddq[2][2].i(j)=-( L)*dq[2].r(j);
   }
   return;
}
void Scratch_Multipoles::chain(const DAT_ARRAY_CONSTS& array_consts,
                               Scratch_Multipoles(& dq)[3]) const{
   for(int j=0;j<3;j++){
      dq[j].r(0)= (0.00);
      dq[j].i(0)= (0.00);
   }
   for(int L=1;L<=oL;L++){
      int Mmax=(L-1);
      int j=(L*L);
      dq[0].r(j)= array_consts.LMu(j)*i(j+1);
      dq[0].i(j)=-array_consts.LMu(j)*r(j+1);
      dq[1].r(j)=-array_consts.LMu(j)*r(j+1);
      dq[1].i(j)=-array_consts.LMu(j)*i(j+1);
      dq[2].r(j)= (-L)*i(j);
      dq[2].i(j)=-(-L)*r(j);
      for(int M=-Mmax;M<=Mmax;M++){
         j++;
         dq[0].r(j)= array_consts.LMl(j)*i(j-1)
                    +array_consts.LMu(j)*i(j+1);
         dq[0].i(j)=-array_consts.LMl(j)*r(j-1)
                    -array_consts.LMu(j)*r(j+1);
         dq[1].r(j)= array_consts.LMl(j)*r(j-1)
                    -array_consts.LMu(j)*r(j+1);
         dq[1].i(j)= array_consts.LMl(j)*i(j-1)
                    -array_consts.LMu(j)*i(j+1);
         dq[2].r(j)= (M)*i(j);
         dq[2].i(j)=-(M)*r(j);
      }
      j++;
      dq[0].r(j)= array_consts.LMl(j)*i(j-1);
      dq[0].i(j)=-array_consts.LMl(j)*r(j-1);
      dq[1].r(j)= array_consts.LMl(j)*r(j-1);
      dq[1].i(j)= array_consts.LMl(j)*i(j-1);
      dq[2].r(j)= ( L)*i(j);
      dq[2].i(j)=-( L)*r(j);
   }
   return;
}
//
// linear combinations of multipole products transforming as multipoles
// function and derivatives wrt rotation about coordinate axes
//
void Scratch_Multipoles::product(const DAT_ARRAY_CONSTS& array_consts,
                                 const Scratch_Multipoles& q1,
                                 const Scratch_Multipoles& q2,
                                 const Scratch_Multipoles(& dq2)[3],
                                 const Scratch_Multipoles(& ddq2)[3][3],
                                 Scratch_Multipoles(& QdQ)[3],
                                 Scratch_Multipoles(& QddQ)[3][3]){
   zero();
   for(int j=0;j<3;j++){
      QdQ[j].populate(oL);
      QdQ[j].zero();
      for(int k=0;k<3;k++){
         QddQ[j][k].populate(oL);
         QddQ[j][k].zero();
      }
   }
//
// conceptually simple form
//
// for(int L1=0;L1<=q1.order();L1++){
//    for(int L2=0;L2<=q2.order();L2++){
//       int L=(L1+L2);
//       if( L>oL )continue;
//       for(int M1=-L1;M1<=L1;M1++){
//          for(int M2=-L2;M2<=L2;M2++){
//             int M=(M1+M2);
//             double z= array_consts.TR[L1][L2]
//                      *array_consts.CG(L1,L2,L,M1,M2);
//             r(L,M)+=z*( q1.r(L1,M1)*q2.r(L2,M2)
//                        -q1.i(L1,M1)*q2.i(L2,M2));
//             i(L,M)+=z*( q1.r(L1,M1)*q2.i(L2,M2)
//                        +q1.i(L1,M1)*q2.r(L2,M2));
//             for(int j=0;j<3;j++){
//                QdQ[j].r(L,M)+=z*( q1.r(L1,M1)*dq2[j].r(L2,M2)
//                                  -q1.i(L1,M1)*dq2[j].i(L2,M2));
//                QdQ[j].i(L,M)+=z*( q1.r(L1,M1)*dq2[j].i(L2,M2)
//                                  +q1.i(L1,M1)*dq2[j].r(L2,M2));
//                for(int k=0;k<3;k++){
//                   QddQ[j][k].r(L,M)+=z*( q1.r(L1,M1)*ddq2[j][k].r(L2,M2)
//                                         -q1.i(L1,M1)*ddq2[j][k].i(L2,M2));
//                   QddQ[j][k].i(L,M)+=z*( q1.r(L1,M1)*ddq2[j][k].i(L2,M2)
//                                         +q1.i(L1,M1)*ddq2[j][k].r(L2,M2));
//                }
//             }
//          }
//       }
//    }
// }
//
// computationally efficient form
//
   for(int L1=0;L1<=q1.order();L1++){
      if( L1>oL )continue;
      for(int M1=-L1,j1=(L1*L1);M1<=L1;M1++,j1++){
         double z= array_consts.C[j1][ 0];
         double q1r= q1.r(j1);
         double q1i= q1.i(j1);
         r(j1)= z*( q1r*q2.r( 0)
                   -q1i*q2.i( 0));
         i(j1)= z*( q1r*q2.i( 0)
                   +q1i*q2.r( 0));
      }
   }
   for(int L1=0;L1<=q1.order();L1++){
      for(int L2=1;L2<=q2.order();L2++){
         int L=(L1+L2);
         if( L>oL )continue;
         for(int M1=-L1,j1=(L1*L1);M1<=L1;M1++,j1++){
            double z2=(-L2-1);
            for(int M2=-L2,j2=(L2*L2);M2<=L2;M2++,j2++){
               z2++;
               double zz2= z2*z2;
               int M=(M1+M2);
               int j=(L*L+L+M);
               double z= array_consts.C[j1][j2];
               double q1r= z*q1.r(j1);
               double q1i= z*q1.i(j1);
               double H_r=( q1r*q2.r(j2)
                           -q1i*q2.i(j2));
               double H_i=( q1r*q2.i(j2)
                           +q1i*q2.r(j2));
               r(j)+=H_r;
               i(j)+=H_i;
               QdQ[2].r(j)+=z2*H_i;
               QdQ[2].i(j)-=z2*H_r;
               QddQ[2][2].r(j)-=zz2*H_r;
               QddQ[2][2].i(j)-=zz2*H_i;
               H_r=( q1r*dq2[0].r(j2)
                    -q1i*dq2[0].i(j2));
               H_i=( q1r*dq2[0].i(j2)
                    +q1i*dq2[0].r(j2));
               QdQ[0].r(j)+=H_r;
               QdQ[0].i(j)+=H_i;
               QddQ[2][0].r(j)+=z2*H_i;
               QddQ[2][0].i(j)-=z2*H_r;
               H_r=( q1r*dq2[1].r(j2)
                    -q1i*dq2[1].i(j2));
               H_i=( q1r*dq2[1].i(j2)
                    +q1i*dq2[1].r(j2));
               QdQ[1].r(j)+=H_r;
               QdQ[1].i(j)+=H_i;
               QddQ[2][1].r(j)+=z2*H_i;
               QddQ[2][1].i(j)-=z2*H_r;
               QddQ[0][0].r(j)+=( q1r*ddq2[0][0].r(j2)
                                 -q1i*ddq2[0][0].i(j2));
               QddQ[0][0].i(j)+=( q1r*ddq2[0][0].i(j2)
                                 +q1i*ddq2[0][0].r(j2));
               QddQ[1][0].r(j)+=( q1r*ddq2[1][0].r(j2)
                                 -q1i*ddq2[1][0].i(j2));
               QddQ[1][0].i(j)+=( q1r*ddq2[1][0].i(j2)
                                 +q1i*ddq2[1][0].r(j2));
               QddQ[1][1].r(j)+=( q1r*ddq2[1][1].r(j2)
                                 -q1i*ddq2[1][1].i(j2));
               QddQ[1][1].i(j)+=( q1r*ddq2[1][1].i(j2)
                                 +q1i*ddq2[1][1].r(j2));
            }
         }
      }
   }
   for(int L=0;L<=oL;L++){
      for(int M=-L,j=(L*L);M<=L;M++,j++){
         QddQ[0][1].r(j)=QddQ[1][0].r(j) -QdQ[2].r(j);
         QddQ[0][1].i(j)=QddQ[1][0].i(j) -QdQ[2].i(j);
         QddQ[0][2].r(j)=QddQ[2][0].r(j) +QdQ[1].r(j);
         QddQ[0][2].i(j)=QddQ[2][0].i(j) +QdQ[1].i(j);
         QddQ[1][2].r(j)=QddQ[2][1].r(j) -QdQ[0].r(j);
         QddQ[1][2].i(j)=QddQ[2][1].i(j) -QdQ[0].i(j);
      }
   }
   return;
}
void Scratch_Multipoles::product(const DAT_ARRAY_CONSTS& array_consts,
                                 const Scratch_Multipoles& q1,
                                 const Scratch_Multipoles& q2,
                                 const Scratch_Multipoles(& dq2)[3],
                                 Scratch_Multipoles(& QdQ)[3]){
   zero();
   for(int j=0;j<3;j++){
      QdQ[j].populate(oL);
      QdQ[j].zero();
   }
   for(int L1=0;L1<=q1.order();L1++){
      if( L1>oL )continue;
      for(int M1=-L1,j1=(L1*L1);M1<=L1;M1++,j1++){
         double z= array_consts.C[j1][ 0];
         double q1r= q1.r(j1);
         double q1i= q1.i(j1);
         r(j1)= z*( q1r*q2.r( 0)
                   -q1i*q2.i( 0));
         i(j1)= z*( q1r*q2.i( 0)
                   +q1i*q2.r( 0));
      }
   }
   for(int L1=0;L1<=q1.order();L1++){
      for(int L2=1;L2<=q2.order();L2++){
         int L=(L1+L2);
         if( L>oL )continue;
         for(int M1=-L1,j1=(L1*L1);M1<=L1;M1++,j1++){
            double z2=(-L2-1);
            for(int M2=-L2,j2=(L2*L2);M2<=L2;M2++,j2++){
               z2++;
               int M=(M1+M2);
               int j=(L*L+L+M);
               double z= array_consts.C[j1][j2];
               double q1r= z*q1.r(j1);
               double q1i= z*q1.i(j1);
               double H_r=( q1r*q2.r(j2)
                           -q1i*q2.i(j2));
               double H_i=( q1r*q2.i(j2)
                           +q1i*q2.r(j2));
               r(j)+=H_r;
               i(j)+=H_i;
               QdQ[2].r(j)+=z2*H_i;
               QdQ[2].i(j)-=z2*H_r;
               QdQ[0].r(j)+=( q1r*dq2[0].r(j2)
                             -q1i*dq2[0].i(j2));
               QdQ[0].i(j)+=( q1r*dq2[0].i(j2)
                             +q1i*dq2[0].r(j2));
               QdQ[1].r(j)+=( q1r*dq2[1].r(j2)
                             -q1i*dq2[1].i(j2));
               QdQ[1].i(j)+=( q1r*dq2[1].i(j2)
                             +q1i*dq2[1].r(j2));
            }
         }
      }
   }
   return;
}
void Scratch_Multipoles::product(const DAT_ARRAY_CONSTS& array_consts,
                                 const Scratch_Multipoles& q1,
                                 const Scratch_Multipoles& q2){
   zero();
   for(int L1=0;L1<=q1.order();L1++){
      for(int L2=0;L2<=q2.order();L2++){
         int L=(L1+L2);
         if( L>oL )continue;
         for(int M1=-L1,j1=(L1*L1);M1<=L1;M1++,j1++){
            for(int M2=-L2,j2=(L2*L2);M2<=L2;M2++,j2++){
               int M=(M1+M2);
               int j=(L*L+L+M);
               double z= array_consts.C[j1][j2];
               r(j)+=z*( q1.r(j1)*q2.r(j2)
                        -q1.i(j1)*q2.i(j2));
               i(j)+=z*( q1.r(j1)*q2.i(j2)
                        +q1.i(j1)*q2.r(j2));
            }
         }
      }
   }
   return;
}
void Scratch_Multipoles::zproduct(const DAT_ARRAY_CONSTS& array_consts,
                                  const Scratch_Multipoles& q1,
                                  const Scratch_Multipoles& q2){
   zero();
   for(int L1=0;L1<=q1.order();L1++){
      for(int L2=0;L2<=q2.order();L2++){
         int L=(L1+L2);
         if( L>oL )continue;
         int j=(L*L+L);
         int L3=( L1<L2 )? L1: L2;
         for(int M3=-L3,j1=(L1*L1+L1-L3),j2=(L2*L2+L2+L3);
             M3<=L3;
             M3++,j1++,j2--){
            double z= array_consts.C[j1][j2];
            r(j)+=z*( q1.r(j1)*q2.r(j2)
                     -q1.i(j1)*q2.i(j2));
         }
      }
   }
   return;
}
