#ifndef DEF_ROTATION_TENSOR
#define DEF_ROTATION_TENSOR

class DAT_ARRAY_CONSTS;
#include "../phi/Rotation_Matrix.hh"

class Rotation_Tensor {
/*oL=7
  n(L)=((2*oL+1)*(2*oL+2)*(2*oL+3)/6)*/
private:
   double d_r[680];             //real
   double d_i[680];             //imaginary

public:
   double& r(int M1,int M2,int L){
      return d_r[ ((2*L-1)*(2*L)*(2*L+1))/6 +(2*L+1)*(L+M1) +(L+M2)];
   }
   double& i(int M1,int M2,int L){
      return d_i[ ((2*L-1)*(2*L)*(2*L+1))/6 +(2*L+1)*(L+M1) +(L+M2)];
   }
   const double& r(int M1,int M2,int L) const {
      return d_r[ ((2*L-1)*(2*L)*(2*L+1))/6 +(2*L+1)*(L+M1) +(L+M2)];
   }
   const double& i(int M1,int M2,int L) const {
      return d_i[ ((2*L-1)*(2*L)*(2*L+1))/6 +(2*L+1)*(L+M1) +(L+M2)];
   }

   Rotation_Tensor(){
   }
   Rotation_Tensor(const DAT_ARRAY_CONSTS& array_consts,
                   int oL,
                   const Rotation_Matrix& ROT);

   void zero();
};

#endif
