#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../phi/Rotation_Tensor.hh"
#include <cmath>
//
//
// construct
//
Rotation_Tensor::Rotation_Tensor(const DAT_ARRAY_CONSTS& array_consts,
                                 int oL,
                                 const Rotation_Matrix& ROT){
//
// rotation of cartesian coordinates
// bases are coordinate axes
// ROT(alp,bet,gam)= rotation of bases by euler angles
// rotatedbasis(j)=ROT(i,j)initialbasis(i)
// initialcoords(i)=ROT(i,j)rotatedcoords(j)
//
// rotation of multipoles
// bases are spherical harmonics
// P(alp,bet,gam)= rotation of bases by euler angles
// rotatedbasis(j)=P(i,j)initialbasis(i)
// true coordinates transform as
// initialmpoles(i)=P(i,j)rotatedmpoles(j)
// multipoles, not being true coordinates, transform as
// initialmpoles(i)=P*(i,j)rotatedmpoles(j)
//
   double Cbet= ROT(2,2);
   double SS=( (1.00) -Cbet*Cbet);
   if( SS<( 1.00e-32) ){
      SS=( 1.00e-32);
   }
   double Sbet= std::sqrt( SS);
   double bet= std::atan2(Sbet,Cbet);
   double alp,gam;
   if( Sbet<(1.00e-12) ){
      gam= (0.00);
      double Calp= ROT(1,1);
      double Salp=-ROT(0,1);
      alp= std::atan2(Salp,Calp);
   }else{
      double Calp= (ROT(0,2)/Sbet);
      double Salp= (ROT(1,2)/Sbet);
      alp= std::atan2(Salp,Calp);
      double Cgam=-(ROT(2,0)/Sbet);
      double Sgam= (ROT(2,1)/Sbet);
      gam= std::atan2(Sgam,Cgam);
   }

   bet/=(2.00);
   Cbet= std::cos( bet);
   Sbet=-std::sin( bet);
   for(int L=0;L<=oL;L++){
      for(int M1=-L;M1<=L;M1++){
         for(int M2=-L;M2<=L;M2++){
            int Kmin=( (M2-M1)>0 )? (M2-M1): 0;
            int Kmax=( (L-M1)<(L+M2) )? (L-M1): (L+M2);
            double thet=( M1*alp +M2*gam);
            double CT= std::cos(-thet);
            double ST= std::sin(-thet);
            double a= array_consts.FAC[L+M1];
            a*=array_consts.FAC[L-M1];
            a*=array_consts.FAC[L+M2];
            a*=array_consts.FAC[L-M2];
            a= std::sqrt( a);
            double z= (0.00);
            for(int K=Kmin;K<=Kmax;K++){
               double b= array_consts.FAC[K];
               b*=array_consts.FAC[(L+M2)-K];
               b*=array_consts.FAC[(L-M1)-K];
               b*=array_consts.FAC[K-(M2-M1)];
               z+=(array_consts.SGN(K)/b)
                  *std::pow( Cbet, ((L-M1)+(L+M2)-2*K))
                  *std::pow( Sbet, (2*K-(M2-M1)));
            }
            r(M1,M2,L)= CT*a*z;
            i(M1,M2,L)=-ST*a*z;
         }
      }
   }
}
//
//
// initiate
//
void Rotation_Tensor::zero(){
   int n=680;
   for(int j=0;j<n;j++){
      d_r[j]= (0.00);
      d_i[j]= (0.00);
   }
   return;
}
