#ifndef DEF_ROTATION_MATRIX
#define DEF_ROTATION_MATRIX

class Coordinates;
#include <iostream>

class Rotation_Matrix {
private:
   double p[3][3];              //

public:
   double& operator()(int i,int j){
      return p[i][j];
   }
   const double& operator()(int i,int j) const {
      return p[i][j];
   }

   Rotation_Matrix(){
   }
   Rotation_Matrix(double alp,double bet,double gam);
   Rotation_Matrix(const Coordinates& a);

   Rotation_Matrix& operator=(const Rotation_Matrix& a);
   Rotation_Matrix& operator+=(const Rotation_Matrix& a);
   Rotation_Matrix& operator-=(const Rotation_Matrix& a);
   Rotation_Matrix& operator*=(const double a);
   Rotation_Matrix& operator/=(const double a);

   void identity();
   void zero();

   bool lower();

   void extend(Rotation_Matrix& pr,
               const Rotation_Matrix& tu,
               double chi);
   void extend(double chi);
   Coordinates euler();
};

Rotation_Matrix operator+(const Rotation_Matrix& a,
                          const Rotation_Matrix& b);
Rotation_Matrix operator-(const Rotation_Matrix& a,
                          const Rotation_Matrix& b);
Rotation_Matrix operator*(double a,
                          const Rotation_Matrix& b);
Rotation_Matrix operator*(const Rotation_Matrix& a,
                          const Rotation_Matrix& b);
std::ostream& operator<<(std::ostream& os,
                         const Rotation_Matrix& a);

Rotation_Matrix transpose(const Rotation_Matrix& a);
Rotation_Matrix extend(const Rotation_Matrix& a,
                       double chi);
double dot(const Rotation_Matrix& a,
           const Rotation_Matrix& b);
double eedot(const Rotation_Matrix& a,
             const Rotation_Matrix& b);

#endif
