#ifndef DEF_PHI1_AUTOMATIC
#define DEF_PHI1_AUTOMATIC

#include "../con/Subset_Contracted_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <vector>

class Phi1_Automatic {
public:
   class tF2 { /*atoms in atom-contracted chain [backward order]*/
   public:
      Coordinates x;            //atom position (bohr)
      tF2(){}
   };

public:
   Coordinates TRANS;                   //rigid body translation
   std::vector<tF2> F2;                 //backward atoms
   Rotation_Matrix PR[3];               //generation matrix resolved wrt branch
   int br;                              //branch level of current torsion
   /*path of torsions from base to current torsion*/
   int BBw;                             //last bb torsion
   int SCa;                             //first sc torsion
   double sgnk;                         //direction of torsion along path
   int jC3;                             //index
   /*relative position of atom pair*/
   Coordinates x;                       //displacement from atom j to atom i
   double RR;                           //distance squared
   double R;                            //distance

   Phi1_Automatic(const Subset_Contracted_System::tM3& con):
      F2(con.oF2)
   {
   }
};

#endif
