#ifndef DEF_MULTIPOLES
#define DEF_MULTIPOLES

#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iostream>

class Multipoles {
private:
   int oL;                      //highest order
   /*multipole components*/
   std::vector<double> q_r;     //real
   std::vector<double> q_i;     //imaginary

public:
   int order() const {
      return oL;
   }
   double& r(int L,int M){
      return q_r.at(L*L+L+M);
   }
   double& i(int L,int M){
      return q_i.at(L*L+L+M);
   }
   const double& r(int L,int M) const {
      return q_r.at(L*L+L+M);
   }
   const double& i(int L,int M) const {
      return q_i.at(L*L+L+M);
   }
   double& r(int j){
      return q_r.at(j);
   }
   double& i(int j){
      return q_i.at(j);
   }
   const double& r(int j) const {
      return q_r.at(j);
   }
   const double& i(int j) const {
      return q_i.at(j);
   }

   Multipoles();
   Multipoles(int o);

   void operator=(const Multipoles& a);
   void truncate(int o,
                 const Multipoles& a);
   void operator*=(double a);
   void operator+=(const Multipoles& a);
   void operator-=(const Multipoles& a);

   void zero();

   void rotate(const DAT_ARRAY_CONSTS& array_consts,
               const Rotation_Matrix& ROT,
               const Multipoles& a);
   void rotate(const DAT_ARRAY_CONSTS& array_consts,
               const Rotation_Matrix& ROT);
   void translate(const DAT_ARRAY_CONSTS& array_consts,
                  const Coordinates& TRANS,
                  const Multipoles& a);
};

class Surf_Match {
private:
   std::vector<double> o_XBNNLss;       //dot( o_BXNs(L), o_BXNs(L))
   std::vector<double> o_XBNLss;        //dot( o_BXNs(L), o_BXs(L))
   std::vector<double> o_XBLss;         //dot( o_BXs(L), o_BXs(L))
   std::vector<double> o_XBLn;          //numerator=( den +NLab[0])
   std::vector<double> o_XBLd;          //denominator=( NNLaa[0] +Lbb)
   std::vector<double> o_XBLf;          //zero displacement, decomp wrt X,B,L
   std::vector<double> o_XBf;           //decomp wrt X,B
   std::vector<double> o_Xf;            //decomp wrt X
   std::vector<double> o_XBLg;          //opt displacement, decomp wrt X,B,L
   std::vector<double> o_XBg;           //decomp wrt X,B
   std::vector<double> o_Xg;            //decomp wrt X
public:
   double f;                            //displacement=0, measure of match
   double x;                            //displacement (dist unit of mpoles)
   double g;                            //displacement=x, measure of match
   double eolp;                         //e penalty for overlap
   double edepth;                       //e for penetration of surfaces
   double ecleft;                       //e for cleft location
   double gfac;                         //scale factor for orientaion

   Surf_Match():
      o_XBNNLss(4*6*15*8),
      o_XBNLss(4*6*8*8),
      o_XBLss(4*6*8),
      o_XBLn(4*6*8),
      o_XBLd(4*6*8),
      o_XBLf(4*6*8),
      o_XBf(4*6),
      o_Xf(4),
      o_XBLg(4*6*8),
      o_XBg(4*6),
      o_Xg(4)
{
}

   void operator=(const Surf_Match& a);
   void fshpi(const DAT_ARRAY_CONSTS& array_consts,
              Output_Streams& out,
              const std::vector<Multipoles>& o_BXNs,
              const std::vector<Multipoles>& o_BXs,
              const std::vector<double>& o_Bu);

   double& XBNNLss(int i,int j,int k,int l){
      return o_XBNNLss.at( i*720 +j*120 +k*8 +l);  }
   double& XBNLss(int i,int j,int k,int l){
      return o_XBNLss.at( i*384 +j*64 +k*8 +l);  }
   double& XBLss(int i,int j,int k){
      return o_XBLss.at( i*48 +j*8 +k);  }
   double& XBLn(int i,int j,int k){
      return o_XBLn.at( i*48 +j*8 +k);  }
   double& XBLd(int i,int j,int k){
      return o_XBLd.at( i*48 +j*8 +k);  }
   double& XBLf(int i,int j,int k){
      return o_XBLf.at( i*48 +j*8 +k);  }
   double& XBf(int i,int j){
      return o_XBf.at( i*6 +j);  }
   double& Xf(int i){
      return o_Xf.at( i);  }
   double& XBLg(int i,int j,int k){
      return o_XBLg.at( i*48 +j*8 +k);  }
   double& XBg(int i,int j){
      return o_XBg.at( i*6 +j);  }
   double& Xg(int i){
      return o_Xg.at( i);  }

   const double& XBNNLss(int i,int j,int k,int l) const {
      return o_XBNNLss.at( i*720 +j*120 +k*8 +l);  }
   const double& XBNLss(int i,int j,int k,int l) const {
      return o_XBNLss.at( i*384 +j*64 +k*8 +l);  }
   const double& XBLss(int i,int j,int k) const {
      return o_XBLss.at( i*48 +j*8 +k);  }
   const double& XBLn(int i,int j,int k) const {
      return o_XBLn.at( i*48 +j*8 +k);  }
   const double& XBLd(int i,int j,int k) const {
      return o_XBLd.at( i*48 +j*8 +k);  }
   const double& XBLf(int i,int j,int k) const {
      return o_XBLf.at( i*48 +j*8 +k);  }
   const double& XBf(int i,int j) const {
      return o_XBf.at( i*6 +j);  }
   const double& Xf(int i) const {
      return o_Xf.at( i);  }
   const double& XBLg(int i,int j,int k) const {
      return o_XBLg.at( i*48 +j*8 +k);  }
   const double& XBg(int i,int j) const {
      return o_XBg.at( i*6 +j);  }
   const double& Xg(int i) const {
      return o_Xg.at( i);  }
};

Multipoles operator+(const Multipoles& a,
                     const Multipoles& b);
Multipoles operator-(const Multipoles& a,
                     const Multipoles& b);
double dot(const DAT_ARRAY_CONSTS& array_consts,
           const Multipoles& a,
           const Multipoles& b);
std::ostream& operator<<(std::ostream& os,
                         const Multipoles& a);
std::ostream& operator<<(std::ostream& os,
                         const Surf_Match& a);

#endif
