#ifndef DEF_GAUSSIAN_VOLUME
#define DEF_GAUSSIAN_VOLUME

#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"

class Gaussian_Volume {
public:
   double sig;                  //sqrt(kcal/bohr**3), sqrt(hart/bohr**3)
   double eta;                  //(1/bohr**2)
   Coordinates x;               //position (bohr)

   Gaussian_Volume():
      sig( 0.00),
      eta( 0.00){
   }

   Gaussian_Volume& operator=(const Gaussian_Volume& a);
};

double pairf(const DAT_PHYSICS_CONSTS& physics_consts,
             const Gaussian_Volume& a,
             const Gaussian_Volume& b,
             double r);
double pairfga(const DAT_PHYSICS_CONSTS& physics_consts,
               const Gaussian_Volume& a,
               const Gaussian_Volume& b,
               double r,
               double& dfdr,
               double& ddfdrdr);
double eef(const DAT_PHYSICS_CONSTS& physics_consts,
           const Gaussian_Volume& a,
           const Gaussian_Volume& b,
           double rr);
double eevf(const DAT_PHYSICS_CONSTS& physics_consts,
            const Gaussian_Volume& a,
            const Gaussian_Volume& b,
            const Gaussian_Volume& c,
            double RRab,
            double RRac,
            double RRbc,
            double& A_ab_ac,
            double& A_ab_bc,
            double& A_ac_bc);
double eevf(const DAT_PHYSICS_CONSTS& physics_consts,
            const Gaussian_Volume& a,
            const Gaussian_Volume& b,
            const Gaussian_Volume& c,
            double RRab,
            double RRac,
            double RRbc);
double eefga(const DAT_PHYSICS_CONSTS& physics_consts,
             const Gaussian_Volume& a,
             const Gaussian_Volume& b,
             double r,
             double& dfdr,
             double& ddfdrdr);
double eevfga(const DAT_PHYSICS_CONSTS& physics_consts,
              const Gaussian_Volume& a,
              const Gaussian_Volume& b,
              const Gaussian_Volume& c,
              double Rab,
              double Rac,
              double Rbc,
              double& dfdr,
              double& ddfdrdr);
double evefga(const DAT_PHYSICS_CONSTS& physics_consts,
              const Gaussian_Volume& a,
              const Gaussian_Volume& b,
              const Gaussian_Volume& c,
              double Rab,
              double Rac,
              double Rbc,
              double& dfdr,
              double& ddfdrdr);

#endif
