#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Gaussian_Volume.hh"
#include <cmath>
//
//
// assign
//
Gaussian_Volume& Gaussian_Volume::operator=(const Gaussian_Volume& a){
   sig= a.sig;
   eta= a.eta;
   x=a.x;
   return *this;
}
//
//
// global functions
//
double pairf(const DAT_PHYSICS_CONSTS& physics_consts,
             const Gaussian_Volume& a,
             const Gaussian_Volume& b,
             double rr){
   double z=( a.eta +b.eta);
   double eab= (a.eta*b.eta/z);
   double f= a.sig*b.sig
            *std::exp(-eab*rr)
            *std::pow( std::sqrt( physics_consts.PI/z), 3);
   return f;
}
double pairfga(const DAT_PHYSICS_CONSTS& physics_consts,
               const Gaussian_Volume& a,
               const Gaussian_Volume& b,
               double r,
               double& dfdr,
               double& ddfdrdr){
   double rr= r*r;
   double z=( a.eta +b.eta);
   double eab= (a.eta*b.eta/z);
   double f= a.sig*b.sig
            *std::exp(-eab*rr)
            *std::pow( std::sqrt( physics_consts.PI/z), 3);
   dfdr= -eab*(2.00)*r*f;
   ddfdrdr= -eab*(2.00)*f +eab*eab*(4.00)*rr*f;
   return f;
}
double eef(const DAT_PHYSICS_CONSTS& physics_consts,
           const Gaussian_Volume& a,
           const Gaussian_Volume& b,
           double rr){
   double z=( a.eta +b.eta);
   double eab= (a.eta*b.eta/z);
   double f= (4.00)*eab*a.sig*b.sig
            *std::exp( -eab*rr)
            *std::pow( std::sqrt( physics_consts.PI/z), 3)
            *( (1.50) -eab*rr);
   return f;
}
double eevf(const DAT_PHYSICS_CONSTS& physics_consts,
            const Gaussian_Volume& a,
            const Gaussian_Volume& b,
            const Gaussian_Volume& c,
            double RRab,
            double RRac,
            double RRbc,
            double& A_ab_ac,
            double& A_ab_bc,
            double& A_ac_bc){
   double z=( a.eta +b.eta +c.eta);
   double eab= (a.eta*b.eta/z);
   double eac= (a.eta*c.eta/z);
   double ebc= (b.eta*c.eta/z);
   double ecc= (c.eta*c.eta/z);
   double p0= (4.00)*eab*a.sig*b.sig*c.sig
             *std::pow( std::sqrt( physics_consts.PI/z), 3);
   double p1= std::exp( -eab*RRab -eac*RRac -ebc*RRbc);
   double p2=( (1.50) +( .50)*( RRab*( (-2.00)*eab -eac -ebc -ecc)
                               +RRac*(-eac +ebc +ecc)
                               +RRbc*( eac -ebc +ecc)));
   double f= p0*p1*p2;
   A_ab_ac=( eab*eac*f
            -p0*p1*( .50)*( eac*( (-2.00)*eab -eac -ebc -ecc)
                           +eab*(-eac +ebc +ecc)));
   A_ab_bc=( eab*ebc*f
            -p0*p1*( .50)*( ebc*( (-2.00)*eab -eac -ebc -ecc)
                           +eab*( eac -ebc +ecc)));
   A_ac_bc=( eac*ebc*f
            -p0*p1*( .50)*( ebc*(-eac +ebc +ecc)
                           +eac*( eac -ebc +ecc)));
   return f;
}
double eevf(const DAT_PHYSICS_CONSTS& physics_consts,
            const Gaussian_Volume& a,
            const Gaussian_Volume& b,
            const Gaussian_Volume& c,
            double RRab,
            double RRac,
            double RRbc){
   double z=( a.eta +b.eta +c.eta);
   double eab= (a.eta*b.eta/z);
   double eac= (a.eta*c.eta/z);
   double ebc= (b.eta*c.eta/z);
   double ecc= (c.eta*c.eta/z);
   double p0= (4.00)*eab*a.sig*b.sig*c.sig
             *std::pow( std::sqrt( physics_consts.PI/z), 3);
   double p1= std::exp( -eab*RRab -eac*RRac -ebc*RRbc);
   double p2=( (1.50) +( .50)*( RRab*( (-2.00)*eab -eac -ebc -ecc)
                               +RRac*(-eac +ebc +ecc)
                               +RRbc*( eac -ebc +ecc)));
   double f= p0*p1*p2;
   return f;
}
double eefga(const DAT_PHYSICS_CONSTS& physics_consts,
             const Gaussian_Volume& a,
             const Gaussian_Volume& b,
             double r,
             double& dfdr,
             double& ddfdrdr){
   double rr= r*r;
   double z=( a.eta +b.eta);
   double eab= (a.eta*b.eta/z);
   double p0= (4.00)*eab*a.sig*b.sig
             *std::pow( std::sqrt( physics_consts.PI/z), 3);
   double p1= std::exp( -eab*rr);
   double p2=( (1.50) -eab*rr);
   double f= p0*p1*p2;
   double dp1= -eab*(2.00)*r*p1;
   double dp2= -eab*(2.00)*r;
   dfdr= p0*( dp1*p2 +p1*dp2);
   double ddp1= -eab*(2.00)*( (1.00) -eab*(2.00)*rr)*p1;
   double ddp2= -eab*(2.00);
   ddfdrdr= p0*( ddp1*p2 +(2.00)*dp1*dp2 +p1*ddp2);
   return f;
}
double eevfga(const DAT_PHYSICS_CONSTS& physics_consts,
              const Gaussian_Volume& a,
              const Gaussian_Volume& b,
              const Gaussian_Volume& c,
              double Rab,
              double Rac,
              double Rbc,
              double& dfdr,
              double& ddfdrdr){
   double RRab= Rab*Rab;
   double RRac= Rac*Rac;
   double RRbc= Rbc*Rbc;
   double z=( a.eta +b.eta +c.eta);
   double eab= (a.eta*b.eta/z);
   double eac= (a.eta*c.eta/z);
   double ebc= (b.eta*c.eta/z);
   double ecc= (c.eta*c.eta/z);
   double p0= (4.00)*eab*a.sig*b.sig*c.sig
             *std::exp( -eac*RRac -ebc*RRbc)
             *std::pow( std::sqrt( physics_consts.PI/z), 3);
   double p1= std::exp( -eab*RRab);
   double p2=( (1.50) +( .50)*( RRab*( (-2.00)*eab -eac -ebc -ecc)
                               +RRac*(-eac +ebc +ecc)
                               +RRbc*( eac -ebc +ecc)));
   double f= p0*p1*p2;
   double dp1= -eab*(2.00)*Rab*p1;
   double dp2= Rab*( (-2.00)*eab -eac -ebc -ecc);
   dfdr= p0*( dp1*p2 +p1*dp2);
   double ddp1= -eab*(2.00)*( (1.00) -eab*(2.00)*RRab)*p1;
   double ddp2=( (-2.00)*eab -eac -ebc -ecc);
   ddfdrdr= p0*( ddp1*p2 +(2.00)*dp1*dp2 +p1*ddp2);
   return f;
}
double evefga(const DAT_PHYSICS_CONSTS& physics_consts,
              const Gaussian_Volume& a,
              const Gaussian_Volume& b,
              const Gaussian_Volume& c,
              double Rab,
              double Rac,
              double Rbc,
              double& dfdr,
              double& ddfdrdr){
   double RRab= Rab*Rab;
   double RRac= Rac*Rac;
   double RRbc= Rbc*Rbc;
   double z=( a.eta +b.eta +c.eta);
   double eab= (a.eta*b.eta/z);
   double eac= (a.eta*c.eta/z);
   double ebc= (b.eta*c.eta/z);
   double ecc= (c.eta*c.eta/z);
   double p0( 0.00),p1( 0.00),p2( 0.00);
   double dp1( 0.00),dp2( 0.00);
   double ddp1( 0.00),ddp2( 0.00);
   if( RRab<( 1.00e-8) ){
      p0= (4.00)*eab*a.sig*b.sig*c.sig
                *std::pow( std::sqrt( physics_consts.PI/z), 3);
      p1= std::exp( -( eac +ebc)*RRac);
      dp1= -( eac +ebc)*(2.00)*Rac*p1;
      ddp1= -( eac +ebc)*(2.00)*( (1.00) -( eac +ebc)*(2.00)*RRac)*p1;
      p2=( (1.50) +RRac*ecc);
      dp2= (2.00)*Rac*ecc;
      ddp2= (2.00)*ecc;
   }else{
      p0= (4.00)*eab*a.sig*b.sig*c.sig
         *std::exp( -eab*RRab -ebc*RRbc)
         *std::pow( std::sqrt( physics_consts.PI/z), 3);
      p1= std::exp( -eac*RRac);
      dp1= -eac*(2.00)*Rac*p1;
      ddp1= -eac*(2.00)*( (1.00) -eac*(2.00)*RRac)*p1;
      p2=( (1.50) +( .50)*( RRab*( (-2.00)*eab -eac -ebc -ecc)
                           +RRac*(-eac +ebc +ecc)
                           +RRbc*( eac -ebc +ecc)));
      dp2= Rac*(-eac +ebc +ecc);
      ddp2=(-eac +ebc +ecc);
   }
   double f= p0*p1*p2;
   dfdr= p0*( dp1*p2 +p1*dp2);
   ddfdrdr= p0*( ddp1*p2 +(2.00)*dp1*dp2 +p1*ddp2);
   return f;
}
