#ifndef DEF_FOURIER3D_COEFFS
#define DEF_FOURIER3D_COEFFS

#include <vector>
#include <iostream>

class Fourier3D_Coeffs {
private:
   int o;                       //
   std::vector<double> t;       //coefficients

public:
   int n() const {
      return o;
   }
   double& operator()(int i,int j,int k){
      return t.at( i*o*o +j*o +k);
   }
   const double& operator()(int i,int j,int k) const {
      return t.at( i*o*o +j*o +k);
   }
   double& operator()(int i){
      return t.at(i);
   }
   const double& operator()(int i) const {
      return t.at(i);
   }

   Fourier3D_Coeffs();
   Fourier3D_Coeffs(int b);
   void resize(int b);

   void operator=(const Fourier3D_Coeffs& a);
   void operator+=(const Fourier3D_Coeffs& a);
   void operator*=(double a);
   void operator/=(double a);

   double f(double ch1,double ch2,double ch3) const;
   double fga(double ch1,double ch2,double ch3,
              double(& g)[3],
              double(& a)[3][3]) const;
};

std::ostream& operator<<(std::ostream& os,
                         const Fourier3D_Coeffs& a);

#endif
