#include "../phi/Fourier3D_Coeffs.hh"
#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>
//
//
// construct
//
Fourier3D_Coeffs::Fourier3D_Coeffs():
   o(-1)
{
}
Fourier3D_Coeffs::Fourier3D_Coeffs(int b):
   o(b),
   t(b*b*b)
{
}
void Fourier3D_Coeffs::resize(int b){
   o=b;
   int ooo=(o*o*o);
   if( o<1 ){
      t.clear();
   }else if( ooo!=int(t.size()) ){
      t.resize(ooo);
   }
   return;
}
//
//
// assign
//
void Fourier3D_Coeffs::operator=(const Fourier3D_Coeffs& a){
   o=a.n();
   if( o<1 ){
      t.clear();
      return;
   }
   int ooo=(o*o*o);
   if( ooo!=int(t.size()) ){
      t.resize(ooo);
   }
   for(int j=0;j<ooo;j++){
      t[j]=a(j);
   }
   return;
}
void Fourier3D_Coeffs::operator+=(const Fourier3D_Coeffs& a){
   int b=( a.n()<=o )? a.n(): o;
   for(int i=0;i<b;i++){
      for(int j=0;j<b;j++){
         for(int k=0;k<b;k++){
            t[ i*o*o +j*o +k]+=a(i,j,k);
         }
      }
   }
   return;
}
void Fourier3D_Coeffs::operator*=(double a){
   int ooo=(o*o*o);
   for(int j=0;j<ooo;j++){
      t[j]*=a;
   }
   return;
}
void Fourier3D_Coeffs::operator/=(double a){
   int ooo=(o*o*o);
   for(int j=0;j<ooo;j++){
      t[j]/=a;
   }
   return;
}
//
//
// evaluate
//
double Fourier3D_Coeffs::f(double ch1,double ch2,double ch3) const{
   double C= std::cos( ch1);
   double S= std::sin( ch1);
   std::vector<double> h1(o);
   h1[ 0]= C;
   h1[ 1]= S;
   for(int i=3;i<o;i+=2){
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
   }
   C= std::cos( ch2);
   S= std::sin( ch2);
   std::vector<double> h2(o);
   h2[ 0]= C;
   h2[ 1]= S;
   for(int j=3;j<o;j+=2){
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
   }
   C= std::cos( ch3);
   S= std::sin( ch3);
   std::vector<double> h3(o);
   h3[ 0]= C;
   h3[ 1]= S;
   for(int k=3;k<o;k+=2){
      h3[k-1]= C*h3[k-3] -S*h3[k-2];
      h3[k  ]= C*h3[k-2] +S*h3[k-3];
   }
   double e= (0.00);
   for(int i=0;i<o;i++){
      double z= (0.00);
      for(int j=0;j<o;j++){
         double y= (0.00);
         for(int k=0;k<o;k++){
            y+=t[ i*o*o +j*o +k]*h3[k];
         }
         z+=y*h2[j];
      }
      e+=h1[i]*z;
   }
   return e;
}
double Fourier3D_Coeffs::fga(double ch1,double ch2,double ch3,
                             double(& g)[3],
                             double(& a)[3][3]) const{
   double C= std::cos( ch1);
   double S= std::sin( ch1);
   std::vector<double> h1(o);
   std::vector<double> dh1(o);
   std::vector<double> ddh1(o);
   h1[ 0]= C;
   h1[ 1]= S;
   dh1[ 0]=-S;
   dh1[ 1]= C;
   ddh1[ 0]=-C;
   ddh1[ 1]=-S;
   double x= (1.00);
   for(int i=3;i<o;i+=2){
      x++;
      double xx= x*x;
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
      dh1[i-1]=-x*h1[i  ];
      dh1[i  ]= x*h1[i-1];
      ddh1[i-1]=-xx*h1[i-1];
      ddh1[i  ]=-xx*h1[i  ];
   }
   C= std::cos( ch2);
   S= std::sin( ch2);
   std::vector<double> h2(o);
   std::vector<double> dh2(o);
   std::vector<double> ddh2(o);
   h2[ 0]= C;
   h2[ 1]= S;
   dh2[ 0]=-S;
   dh2[ 1]= C;
   ddh2[ 0]=-C;
   ddh2[ 1]=-S;
   x= (1.00);
   for(int j=3;j<o;j+=2){
      x++;
      double xx= x*x;
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
      dh2[j-1]=-x*h2[j  ];
      dh2[j  ]= x*h2[j-1];
      ddh2[j-1]=-xx*h2[j-1];
      ddh2[j  ]=-xx*h2[j  ];
   }
   C= std::cos( ch3);
   S= std::sin( ch3);
   std::vector<double> h3(o);
   std::vector<double> dh3(o);
   std::vector<double> ddh3(o);
   h3[ 0]= C;
   h3[ 1]= S;
   dh3[ 0]=-S;
   dh3[ 1]= C;
   ddh3[ 0]=-C;
   ddh3[ 1]=-S;
   x= (1.00);
   for(int k=3;k<o;k+=2){
      x++;
      double xx= x*x;
      h3[k-1]= C*h3[k-3] -S*h3[k-2];
      h3[k  ]= C*h3[k-2] +S*h3[k-3];
      dh3[k-1]=-x*h3[k  ];
      dh3[k  ]= x*h3[k-1];
      ddh3[k-1]=-xx*h3[k-1];
      ddh3[k  ]=-xx*h3[k  ];
   }
   double e= (0.00);
   g[0]= (0.00);
   g[1]= (0.00);
   g[2]= (0.00);
   a[0][0]= (0.00);
   a[0][1]= (0.00);
   a[0][2]= (0.00);
   a[1][1]= (0.00);
   a[1][2]= (0.00);
   a[2][2]= (0.00);
   for(int i=0;i<o;i++){
      double z= (0.00);
      double dz= (0.00);
      double ddz= (0.00);
      double ez= (0.00);
      double edz= (0.00);
      double eez= (0.00);
      for(int j=0;j<o;j++){
         double y= (0.00);
         double dy= (0.00);
         double ddy= (0.00);
         for(int k=0;k<o;k++){
            y+=t[ i*o*o +j*o +k]*h3[k];
            dy+=t[ i*o*o +j*o +k]*dh3[k];
            ddy+=t[ i*o*o +j*o +k]*ddh3[k];
         }
         z+=y*h2[j];
         dz+=dy*h2[j];
         ddz+=ddy*h2[j];
         ez+=y*dh2[j];
         edz+=dy*dh2[j];
         eez+=y*ddh2[j];
      }
      e+=h1[i]*z;
      g[0]+=dh1[i]*z;
      g[1]+=h1[i]*ez;
      g[2]+=h1[i]*dz;
      a[0][0]+=ddh1[i]*z;
      a[1][1]+=h1[i]*eez;
      a[2][2]+=h1[i]*ddz;
      a[0][1]+=dh1[i]*ez;
      a[0][2]+=dh1[i]*dz;
      a[1][2]+=h1[i]*edz;
   }
   return e;
}
//
//
// global operators
//
std::ostream& operator<<(std::ostream& os,
                         const Fourier3D_Coeffs& a){
   std::string head[12];
   head[ 0]=" [cos(1x)]";
   head[ 1]=" [sin(1x)]";
   head[ 2]=" [cos(2x)]";
   head[ 3]=" [sin(2x)]";
   head[ 4]=" [cos(3x)]";
   head[ 5]=" [sin(3x)]";
   head[ 6]=" [cos(4x)]";
   head[ 7]=" [sin(4x)]";
   head[ 8]=" [cos(5x)]";
   head[ 9]=" [sin(5x)]";
   head[10]=" [cos(6x)]";
   head[11]=" [sin(6x)]";
   int n=a.n();
   os<< std::fixed<< std::setprecision(4);
   for(int i=0;i<n;i++){
      for(int kmin=0;kmin<n;kmin+=6){
         int kmax=( (kmin+6)<n )? (kmin+6): n;
         os<<head[i]<<"          ";
         for(int k=kmin;k<kmax;k++){
            os<<head[k];
         }
         os<<'\n';
         for(int j=0;j<n;j++){
            os<<"          "<<head[j];
            for(int k=kmin;k<kmax;k++){
               os<< std::setw(10)<<a(i,j,k);
            }
            os<<'\n';
         }
      }
   }
   return os;
}
