#ifndef DEF_FOURIER2D_COEFFS
#define DEF_FOURIER2D_COEFFS

#include "../phi/Fourier3D_Coeffs.hh"
#include <vector>
#include <iostream>

class Fourier2D_Coeffs {
private:
   int o;                       //
   std::vector<double> t;       //coefficients

public:
   int n() const {
      return o;
   }
   double& operator()(int i,int j){
      return t.at( i*o +j);
   }
   const double& operator()(int i,int j) const {
      return t.at( i*o +j);
   }
   double& operator()(int i){
      return t.at(i);
   }
   const double& operator()(int i) const {
      return t.at(i);
   }

   Fourier2D_Coeffs();
   Fourier2D_Coeffs(int b);
   void resize(int b);

   void operator=(const Fourier2D_Coeffs& a);
   void operator+=(const Fourier2D_Coeffs& a);
   void operator*=(double a);
   void operator/=(double a);
   void fix3(const Fourier3D_Coeffs& a,double th3);
   void fix2(const Fourier3D_Coeffs& a,double th2);
   void fix1(const Fourier3D_Coeffs& a,double th1);

   double f(double ch1,double ch2) const;
   double fga(double ch1,double ch2,
              double(& g)[2],
              double(& a)[2][2]) const;
};

std::ostream& operator<<(std::ostream& os,
                         const Fourier2D_Coeffs& a);

#endif
