#include "../phi/Fourier2D_Coeffs.hh"
#include "../phi/Fourier3D_Coeffs.hh"
#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>
//
//
// construct
//
Fourier2D_Coeffs::Fourier2D_Coeffs():
   o(-1)
{
}
Fourier2D_Coeffs::Fourier2D_Coeffs(int b):
   o(b),
   t(b*b)
{
}
void Fourier2D_Coeffs::resize(int b){
   o=b;
   int oo=(o*o);
   if( o<1 ){
      t.clear();
   }else if( oo!=int(t.size()) ){
      t.resize(oo);
   }
   return;
}
//
//
// assign
//
void Fourier2D_Coeffs::operator=(const Fourier2D_Coeffs& a){
   o=a.n();
   if( o<1 ){
      t.clear();
      return;
   }
   int oo=(o*o);
   if( oo!=int(t.size()) ){
      t.resize(oo);
   }
   for(int j=0;j<oo;j++){
      t[j]=a(j);
   }
   return;
}
void Fourier2D_Coeffs::operator+=(const Fourier2D_Coeffs& a){
   int b=( a.n()<=o )? a.n(): o;
   for(int i=0;i<b;i++){
      for(int j=0;j<b;j++){
         t[ i*o +j]+=a(i,j);
      }
   }
   return;
}
void Fourier2D_Coeffs::operator*=(double a){
   int oo=(o*o);
   for(int j=0;j<oo;j++){
      t[j]*=a;
   }
   return;
}
void Fourier2D_Coeffs::operator/=(double a){
   int oo=(o*o);
   for(int j=0;j<oo;j++){
      t[j]/=a;
   }
   return;
}
void Fourier2D_Coeffs::fix3(const Fourier3D_Coeffs& a,double th3){
   double C= std::cos( th3);
   double S= std::sin( th3);
   int n=a.n();
   std::vector<double> h3(n);
   h3[ 0]= C;
   h3[ 1]= S;
   for(int k=3;k<n;k+=2){
      h3[k-1]= C*h3[k-3] -S*h3[k-2];
      h3[k  ]= C*h3[k-2] +S*h3[k-3];
   }
   for(int i=0;i<n;i++){
      for(int j=0;j<n;j++){
         for(int k=0;k<n;k++){
            t[ i*o +j]+=a(i,j,k)*h3[k];
         }
      }
   }
   return;
}
void Fourier2D_Coeffs::fix2(const Fourier3D_Coeffs& a,double th2){
   double C= std::cos( th2);
   double S= std::sin( th2);
   int n=a.n();
   std::vector<double> h2(n);
   h2[ 0]= C;
   h2[ 1]= S;
   for(int j=3;j<n;j+=2){
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
   }
   for(int i=0;i<n;i++){
      for(int k=0;k<n;k++){
         for(int j=0;j<n;j++){
            t[ i*o +k]+=a(i,j,k)*h2[j];
         }
      }
   }
   return;
}
void Fourier2D_Coeffs::fix1(const Fourier3D_Coeffs& a,double th1){
   double C= std::cos( th1);
   double S= std::sin( th1);
   int n=a.n();
   std::vector<double> h1(n);
   h1[ 0]= C;
   h1[ 1]= S;
   for(int i=3;i<n;i+=2){
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
   }
   for(int j=0;j<n;j++){
      for(int k=0;k<n;k++){
         for(int i=0;i<n;i++){
            t[ j*o +k]+=a(i,j,k)*h1[i];
         }
      }
   }
   return;
}
//
//
// evaluate
//
double Fourier2D_Coeffs::f(double ch1,double ch2) const{
   double C= std::cos( ch1);
   double S= std::sin( ch1);
   std::vector<double> h1(o);
   h1[ 0]= C;
   h1[ 1]= S;
   for(int i=3;i<o;i+=2){
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
   }
   C= std::cos( ch2);
   S= std::sin( ch2);
   std::vector<double> h2(o);
   h2[ 0]= C;
   h2[ 1]= S;
   for(int j=3;j<o;j+=2){
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
   }
   double e= (0.00);
   for(int i=0;i<o;i++){
      double z= (0.00);
      for(int j=0;j<o;j++){
         z+=t[ i*o +j]*h2[j];
      }
      e+=h1[i]*z;
   }
   return e;
}
double Fourier2D_Coeffs::fga(double ch1,double ch2,
                             double(& g)[2],
                             double(& a)[2][2]) const{
   double C= std::cos( ch1);
   double S= std::sin( ch1);
   std::vector<double> h1(o);
   std::vector<double> dh1(o);
   std::vector<double> ddh1(o);
   h1[ 0]= C;
   h1[ 1]= S;
   dh1[ 0]=-S;
   dh1[ 1]= C;
   ddh1[ 0]=-C;
   ddh1[ 1]=-S;
   double x= (1.00);
   for(int i=3;i<o;i+=2){
      x++;
      double xx= x*x;
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
      dh1[i-1]=-x*h1[i  ];
      dh1[i  ]= x*h1[i-1];
      ddh1[i-1]=-xx*h1[i-1];
      ddh1[i  ]=-xx*h1[i  ];
   }
   C= std::cos( ch2);
   S= std::sin( ch2);
   std::vector<double> h2(o);
   std::vector<double> dh2(o);
   std::vector<double> ddh2(o);
   h2[ 0]= C;
   h2[ 1]= S;
   dh2[ 0]=-S;
   dh2[ 1]= C;
   ddh2[ 0]=-C;
   ddh2[ 1]=-S;
   x= (1.00);
   for(int j=3;j<o;j+=2){
      x++;
      double xx= x*x;
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
      dh2[j-1]=-x*h2[j  ];
      dh2[j  ]= x*h2[j-1];
      ddh2[j-1]=-xx*h2[j-1];
      ddh2[j  ]=-xx*h2[j  ];
   }
   double e= (0.00);
   g[0]= (0.00);
   g[1]= (0.00);
   a[0][0]= (0.00);
   a[0][1]= (0.00);
   a[1][1]= (0.00);
   for(int i=0;i<o;i++){
      double z= (0.00);
      double dz= (0.00);
      double ddz= (0.00);
      for(int j=0;j<o;j++){
         z+=t[ i*o +j]*h2[j];
         dz+=t[ i*o +j]*dh2[j];
         ddz+=t[ i*o +j]*ddh2[j];
      }
      e+=h1[i]*z;
      g[0]+=dh1[i]*z;
      g[1]+=h1[i]*dz;
      a[0][0]+=ddh1[i]*z;
      a[1][1]+=h1[i]*ddz;
      a[0][1]+=dh1[i]*dz;
   }
   return e;
}
//
//
// global operators
//
std::ostream& operator<<(std::ostream& os,
                         const Fourier2D_Coeffs& a){
   std::string head[18];
   head[ 0]=" [cos(1x)]";
   head[ 1]=" [sin(1x)]";
   head[ 2]=" [cos(2x)]";
   head[ 3]=" [sin(2x)]";
   head[ 4]=" [cos(3x)]";
   head[ 5]=" [sin(3x)]";
   head[ 6]=" [cos(4x)]";
   head[ 7]=" [sin(4x)]";
   head[ 8]=" [cos(5x)]";
   head[ 9]=" [sin(5x)]";
   head[10]=" [cos(6x)]";
   head[11]=" [sin(6x)]";
   head[12]=" [cos(7x)]";
   head[13]=" [sin(7x)]";
   head[14]=" [cos(8x)]";
   head[15]=" [sin(8x)]";
   head[16]=" [cos(9x)]";
   head[17]=" [sin(9x)]";
   int n=a.n();
   os<< std::fixed<< std::setprecision(4);
   for(int jmin=0;jmin<n;jmin+=6){
      int jmax=( (jmin+6)<n )? (jmin+6): n;
      os<<"          ";
      for(int j=jmin;j<jmax;j++){
         os<<head[j];
      }
      os<<'\n';
      for(int i=0;i<n;i++){
         os<<head[i];
         for(int j=jmin;j<jmax;j++){
            os<< std::setw(10)<<a(i,j);
         }
         os<<'\n';
      }
   }
   return os;
}
