#ifndef DEF_FOURIER1D_COEFFS
#define DEF_FOURIER1D_COEFFS

#include "../phi/Fourier2D_Coeffs.hh"
#include "../phi/Fourier3D_Coeffs.hh"
#include <vector>
#include <iostream>

class Fourier1D_Coeffs {
private:
   int o;                       //
   std::vector<double> t;       //coefficients

public:
   bool BOUND;                  //
   double ch0;                  //lower bound of range (radians)
   double ch1;                  //upper bound of range (radians)

   int n() const {
      return o;
   }
   double& operator()(int i){
      return t.at(i);
   }
   const double& operator()(int i) const {
      return t.at(i);
   }

   Fourier1D_Coeffs();
   Fourier1D_Coeffs(int b);
   void resize(int b);

   void operator=(const Fourier1D_Coeffs& a);
   void operator+=(const Fourier1D_Coeffs& a);
   void operator*=(double a);
   void operator/=(double a);
   void fix2(const Fourier2D_Coeffs& a,double th2);
   void fix1(const Fourier2D_Coeffs& a,double th1);
   void fix23(const Fourier3D_Coeffs& a,double th2,double th3);
   void fix13(const Fourier3D_Coeffs& a,double th1,double th3);
   void fix12(const Fourier3D_Coeffs& a,double th1,double th2);

   double f(double chi) const;
   double fga(double chi,
              double& g,
              double& a) const;
};

std::ostream& operator<<(std::ostream& os,
                         const Fourier1D_Coeffs& a);

#endif
