#include "../phi/Fourier1D_Coeffs.hh"
#include "../phi/Fourier2D_Coeffs.hh"
#include "../phi/Fourier3D_Coeffs.hh"
#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>
//
//
// construct
//
Fourier1D_Coeffs::Fourier1D_Coeffs():
   o(-1),
   BOUND(false)
{
}
Fourier1D_Coeffs::Fourier1D_Coeffs(int b):
   o(b),
   t(b),
   BOUND(false)
{
}
void Fourier1D_Coeffs::resize(int b){
   o=b;
   if( o<1 ){
      t.clear();
   }else if( o!=int(t.size()) ){
      t.resize(o);
   }
   return;
}
//
//
// assign
//
void Fourier1D_Coeffs::operator=(const Fourier1D_Coeffs& a){
   o=a.n();
   if( o<1 ){
      t.clear();
      return;
   }
   if( o!=int(t.size()) ){
      t.resize(o);
   }
   for(int j=0;j<o;j++){
      t[j]=a(j);
   }
   BOUND=a.BOUND;
   ch0= a.ch0;
   ch1= a.ch1;
   return;
}
void Fourier1D_Coeffs::operator+=(const Fourier1D_Coeffs& a){
   int b=( a.n()<=o )? a.n(): o;
   for(int j=0;j<b;j++){
      t[j]+=a(j);
   }
   return;
}
void Fourier1D_Coeffs::operator*=(double a){
   for(int j=0;j<o;j++){
      t[j]*=a;
   }
   return;
}
void Fourier1D_Coeffs::operator/=(double a){
   for(int j=0;j<o;j++){
      t[j]/=a;
   }
   return;
}
void Fourier1D_Coeffs::fix2(const Fourier2D_Coeffs& a,double th2){
   double C= std::cos( th2);
   double S= std::sin( th2);
   int n=a.n();
   std::vector<double> h2(n);
   h2[ 0]= C;
   h2[ 1]= S;
   for(int j=3;j<n;j+=2){
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
   }
   for(int i=0;i<n;i++){
      for(int j=0;j<n;j++){
         t[i+1]+=a(i,j)*h2[j];
      }
   }
   return;
}
void Fourier1D_Coeffs::fix1(const Fourier2D_Coeffs& a,double th1){
   double C= std::cos( th1);
   double S= std::sin( th1);
   int n=a.n();
   std::vector<double> h1(n);
   h1[ 0]= C;
   h1[ 1]= S;
   for(int i=3;i<n;i+=2){
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
   }
   for(int j=0;j<n;j++){
      for(int i=0;i<n;i++){
         t[j+1]+=a(i,j)*h1[i];
      }
   }
   return;
}
void Fourier1D_Coeffs::fix23(const Fourier3D_Coeffs& a,double th2,double th3){
   int n=a.n();
   double C= std::cos( th2);
   double S= std::sin( th2);
   std::vector<double> h2(n);
   h2[ 0]= C;
   h2[ 1]= S;
   for(int j=3;j<n;j+=2){
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
   }
   C= std::cos( th3);
   S= std::sin( th3);
   std::vector<double> h3(n);
   h3[ 0]= C;
   h3[ 1]= S;
   for(int k=3;k<n;k+=2){
      h3[k-1]= C*h3[k-3] -S*h3[k-2];
      h3[k  ]= C*h3[k-2] +S*h3[k-3];
   }
   for(int i=0;i<n;i++){
      for(int j=0;j<n;j++){
         double z= (0.00);
         for(int k=0;k<n;k++){
            z+=a(i,j,k)*h3[k];
         }
         t[i+1]+=z*h2[j];
      }
   }
   return;
}
void Fourier1D_Coeffs::fix13(const Fourier3D_Coeffs& a,double th1,double th3){
   int n=a.n();
   double C= std::cos( th1);
   double S= std::sin( th1);
   std::vector<double> h1(n);
   h1[ 0]= C;
   h1[ 1]= S;
   for(int i=3;i<n;i+=2){
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
   }
   C= std::cos( th3);
   S= std::sin( th3);
   std::vector<double> h3(n);
   h3[ 0]= C;
   h3[ 1]= S;
   for(int k=3;k<n;k+=2){
      h3[k-1]= C*h3[k-3] -S*h3[k-2];
      h3[k  ]= C*h3[k-2] +S*h3[k-3];
   }
   for(int j=0;j<n;j++){
      for(int i=0;i<n;i++){
         double z= (0.00);
         for(int k=0;k<n;k++){
            z+=a(i,j,k)*h3[k];
         }
         t[j+1]+=z*h1[i];
      }
   }
   return;
}
void Fourier1D_Coeffs::fix12(const Fourier3D_Coeffs& a,double th1,double th2){
   int n=a.n();
   double C= std::cos( th1);
   double S= std::sin( th1);
   std::vector<double> h1(n);
   h1[ 0]= C;
   h1[ 1]= S;
   for(int i=3;i<n;i+=2){
      h1[i-1]= C*h1[i-3] -S*h1[i-2];
      h1[i  ]= C*h1[i-2] +S*h1[i-3];
   }
   C= std::cos( th2);
   S= std::sin( th2);
   std::vector<double> h2(n);
   h2[ 0]= C;
   h2[ 1]= S;
   for(int j=3;j<n;j+=2){
      h2[j-1]= C*h2[j-3] -S*h2[j-2];
      h2[j  ]= C*h2[j-2] +S*h2[j-3];
   }
   for(int k=0;k<n;k++){
      for(int i=0;i<n;i++){
         double z= (0.00);
         for(int j=0;j<n;j++){
            z+=a(i,j,k)*h2[j];
         }
         t[k+1]+=z*h1[i];
      }
   }
   return;
}
//
//
// evaluate
//
double Fourier1D_Coeffs::f(double chi) const{
   double C= std::cos( chi);
   double S= std::sin( chi);
   std::vector<double> h(o);
   h[ 0]= (1.00);
   h[ 1]= C;
   h[ 2]= S;
   for(int i=4;i<o;i+=2){
      h[i-1]= C*h[i-3] -S*h[i-2];
      h[i  ]= C*h[i-2] +S*h[i-3];
   }
   double e= (0.00);
   for(int i=0;i<o;i++){
      e+=t[i]*h[i];
   }
// factor (16.00) chosen st d of 1 degree contributes e of approx 4 kcal
   if( BOUND ){
      if      ( ch0<ch1 ){
         if      ( chi<ch0 ){
            double d0=( chi -ch0)*(16.00);
            e+=(d0*d0*d0*d0);
         }else if( chi>ch1 ){
            double d1=( chi -ch1)*(16.00);
            e+=(d1*d1*d1*d1);
         }
      }else if( ch1<ch0 ){
         double ch2=( ch1 +ch0)/(2.00);
         if      ( (chi<ch0)&&(chi>ch2) ){
            double d0=( chi -ch0)*(16.00);
            e+=(d0*d0*d0*d0);
         }else if( (chi>ch1)&&(chi<ch2) ){
            double d1=( chi -ch1)*(16.00);
            e+=(d1*d1*d1*d1);
         }
      }
   }
   return e;
}
double Fourier1D_Coeffs::fga(double chi,
                             double& g,
                             double& a) const{
   double C= std::cos( chi);
   double S= std::sin( chi);
   std::vector<double> h(o);
   std::vector<double> dh(o);
   std::vector<double> ddh(o);
   h[ 0]= (1.00);
   dh[ 0]= (0.00);
   ddh[ 0]= (0.00);
   h[ 1]= C;
   h[ 2]= S;
   dh[ 1]=-S;
   dh[ 2]= C;
   ddh[ 1]=-C;
   ddh[ 2]=-S;
   double x= (1.00);
   for(int i=4;i<o;i+=2){
      x++;
      double xx= x*x;
      h[i-1]= C*h[i-3] -S*h[i-2];
      h[i  ]= C*h[i-2] +S*h[i-3];
      dh[i-1]=-x*h[i  ];
      dh[i  ]= x*h[i-1];
      ddh[i-1]=-xx*h[i-1];
      ddh[i  ]=-xx*h[i  ];
   }
   double e= (0.00);
   g= (0.00);
   a= (0.00);
   for(int i=0;i<o;i++){
      e+=t[i]*h[i];
      g+=t[i]*dh[i];
      a+=t[i]*ddh[i];
   }
   if( BOUND ){
      if      ( ch0<ch1 ){
         if      ( chi<ch0 ){
            double d0=( chi -ch0)*(16.00);
            e+=(d0*d0*d0*d0);
            g+=((  4.00)*( 16.00)*d0*d0*d0);
            a+=(( 12.00)*( 16.00)*( 16.00)*d0*d0);
         }else if( chi>ch1 ){
            double d1=( chi -ch1)*(16.00);
            e+=(d1*d1*d1*d1);
            g+=((  4.00)*( 16.00)*d1*d1*d1);
            a+=(( 12.00)*( 16.00)*( 16.00)*d1*d1);
         }
      }else if( ch1<ch0 ){
         double ch2=( ch1 +ch0)/(2.00);
         if      ( (chi<ch0)&&(chi>ch2) ){
            double d0=( chi -ch0)*(16.00);
            e+=(d0*d0*d0*d0);
            g+=((  4.00)*( 16.00)*d0*d0*d0);
            a+=(( 12.00)*( 16.00)*( 16.00)*d0*d0);
         }else if( (chi>ch1)&&(chi<ch2) ){
            double d1=( chi -ch1)*(16.00);
            e+=(d1*d1*d1*d1);
            g+=((  4.00)*( 16.00)*d1*d1*d1);
            a+=(( 12.00)*( 16.00)*( 16.00)*d1*d1);
         }
      }
   }
   return e;
}
//
//
// global operators
//
std::ostream& operator<<(std::ostream& os,
                         const Fourier1D_Coeffs& a){
   std::string head[25];
   head[ 0]=" 1        ";
   head[ 1]=" [cos(1x)]";
   head[ 2]=" [sin(1x)]";
   head[ 3]=" [cos(2x)]";
   head[ 4]=" [sin(2x)]";
   head[ 5]=" [cos(3x)]";
   head[ 6]=" [sin(3x)]";
   head[ 7]=" [cos(4x)]";
   head[ 8]=" [sin(4x)]";
   head[ 9]=" [cos(5x)]";
   head[10]=" [sin(5x)]";
   head[11]=" [cos(6x)]";
   head[12]=" [sin(6x)]";
   head[13]=" [cos(7x)]";
   head[14]=" [sin(7x)]";
   head[15]=" [cos(8x)]";
   head[16]=" [sin(8x)]";
   head[17]=" [cos(9x)]";
   head[18]=" [sin(9x)]";
   head[19]=" [cos(10)]";
   head[20]=" [sin(10)]";
   head[21]=" [cos(11)]";
   head[22]=" [sin(11)]";
   head[23]=" [cos(12)]";
   head[24]=" [sin(12)]";
   int n=a.n();
   os<< std::fixed<< std::setprecision(4);
   if( n>0 ){
      os<<head[ 0]<<'\n';
      os<< std::setw(10)<<a( 0)<<'\n';
   }
   for(int imin=1;imin<n;imin+=6){
      int imax=( (imin+6)<n )? (imin+6): n;
      for(int i=imin;i<imax;i++){
         os<<head[i];
      }
      os<<'\n';
      for(int i=imin;i<imax;i++){
         os<< std::setw(10)<<a(i);
      }
      os<<'\n';
   }
   return os;
}
