#ifndef DEF_COORDINATES
#define DEF_COORDINATES

#include "../phi/Rotation_Matrix.hh"
#include <iostream>

class Coordinates {
private:
   double x[3];                 //cartesian coords

public:
   double& operator()(int i){
      return x[i];
   }
   const double& operator()(int i) const {
      return x[i];
   }

   Coordinates(){
   }

   Coordinates& operator=(const Coordinates& a);
   Coordinates& operator+=(const Coordinates& a);
   Coordinates& operator-=(const Coordinates& a);
   Coordinates& operator*=(const double a);
   Coordinates& operator/=(const double a);

   void zero();

   double rr() const;
   double r() const;
   Coordinates& normalize();

   void generate(const Coordinates& TRANS,
                 const Rotation_Matrix& ROT,
                 const Coordinates& b);
   void rotate(const Rotation_Matrix& ROT,
               const Coordinates& b);

   void chain(Coordinates(& dx)[3],
              Coordinates(& ddx)[3][3]) const;
   void chain(Coordinates(& dx)[3]) const;
};

Coordinates operator+(const Coordinates& a,
                      const Coordinates& b);
Coordinates operator-(const Coordinates& a,
                      const Coordinates& b);
Coordinates operator-(const Coordinates& a);
Coordinates operator*(double a,
                      const Coordinates& b);
Coordinates operator*(const Rotation_Matrix& ROT,
                      const Coordinates& b);
Coordinates operator*(const Coordinates& b,
                      const Rotation_Matrix& ROT);
bool operator==(const Coordinates& a,
                const Coordinates& b);
bool operator!=(const Coordinates& a,
                const Coordinates& b);
std::ostream& operator<<(std::ostream& os,
                         const Coordinates& a);

double dot(const Coordinates& a,
           const Coordinates& b);
Coordinates cross(const Coordinates& a,
                  const Coordinates& b);

#endif
