#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <iostream>
#include <iomanip>
#include <cmath>
//
//
// assign
//
Coordinates& Coordinates::operator=(const Coordinates& a){
   for(int i=0;i<3;i++){
      x[i]=a(i);
   }
   return *this;
}
Coordinates& Coordinates::operator+=(const Coordinates& a){
   for(int i=0;i<3;i++){
      x[i]+=a(i);
   }
   return *this;
}
Coordinates& Coordinates::operator-=(const Coordinates& a){
   for(int i=0;i<3;i++){
      x[i]-=a(i);
   }
   return *this;
}
Coordinates& Coordinates::operator*=(const double a){
   for(int i=0;i<3;i++){
      x[i]*=a;
   }
   return *this;
}
Coordinates& Coordinates::operator/=(const double a){
   for(int i=0;i<3;i++){
      x[i]/=a;
   }
   return *this;
}
//
//
// initiate
//
void Coordinates::zero(){
   for(int i=0;i<3;i++){
      x[i]= (0.00);
   }
   return;
}
//
//
// normalize
//
double Coordinates::rr() const{
   return ( x[0]*x[0] +x[1]*x[1] +x[2]*x[2]);
}
double Coordinates::r() const{
   return std::sqrt( x[0]*x[0] +x[1]*x[1] +x[2]*x[2]);
}
Coordinates& Coordinates::normalize(){
   double z= (0.00);
   for(int i=0;i<3;i++){
      z+=x[i]*x[i];
   }
   z=std::sqrt( z);
   for(int i=0;i<3;i++){
      x[i]/=z;
   }
   return *this;
}
//
// x= TRANS +ROT*b
// x= ROT*b
//
void Coordinates::generate(const Coordinates& TRANS,
                           const Rotation_Matrix& ROT,
                           const Coordinates& b){
   for(int i=0;i<3;i++){
      x[i]=( TRANS(i) +ROT(i,0)*b(0)
                      +ROT(i,1)*b(1)
                      +ROT(i,2)*b(2));
   }
   return;
}
void Coordinates::rotate(const Rotation_Matrix& ROT,
                         const Coordinates& b){
   for(int i=0;i<3;i++){
      x[i]=( ROT(i,0)*b(0)
            +ROT(i,1)*b(1)
            +ROT(i,2)*b(2));
   }
   return;
}
//
//
// differentiate wrt rotation about coordinate axes
//
void Coordinates::chain(Coordinates(& dx)[3],
                        Coordinates(& ddx)[3][3]) const{
   dx[0](0)= (0.00);
   dx[0](1)= x[2];
   dx[0](2)=-x[1];
   dx[1](0)=-x[2];
   dx[1](1)= (0.00);
   dx[1](2)= x[0];
   dx[2](0)= x[1];
   dx[2](1)=-x[0];
   dx[2](2)= (0.00);

   ddx[0][0](0)= (0.00);
   ddx[0][0](1)=-x[1];
   ddx[0][0](2)=-x[2];
   ddx[1][0](0)= x[1];
   ddx[1][0](1)= (0.00);
   ddx[1][0](2)= (0.00);
   ddx[2][0](0)= x[2];
   ddx[2][0](1)= (0.00);
   ddx[2][0](2)= (0.00);

   ddx[0][1](0)= (0.00);
   ddx[0][1](1)= x[0];
   ddx[0][1](2)= (0.00);
   ddx[1][1](0)=-x[0];
   ddx[1][1](1)= (0.00);
   ddx[1][1](2)=-x[2];
   ddx[2][1](0)= (0.00);
   ddx[2][1](1)= x[2];
   ddx[2][1](2)= (0.00);

   ddx[0][2](0)= (0.00);
   ddx[0][2](1)= (0.00);
   ddx[0][2](2)= x[0];
   ddx[1][2](0)= (0.00);
   ddx[1][2](1)= (0.00);
   ddx[1][2](2)= x[1];
   ddx[2][2](0)=-x[0];
   ddx[2][2](1)=-x[1];
   ddx[2][2](2)= (0.00);
   return;
}
void Coordinates::chain(Coordinates(& dx)[3]) const{
   dx[0](0)= (0.00);
   dx[0](1)= x[2];
   dx[0](2)=-x[1];
   dx[1](0)=-x[2];
   dx[1](1)= (0.00);
   dx[1](2)= x[0];
   dx[2](0)= x[1];
   dx[2](1)=-x[0];
   dx[2](2)= (0.00);
   return;
}
//
//
// global operators
//
Coordinates operator+(const Coordinates& a,
                      const Coordinates& b){
   Coordinates t=a;
   t+=b;
   return t;
}
Coordinates operator-(const Coordinates& a,
                      const Coordinates& b){
   Coordinates t=a;
   t-=b;
   return t;
}
Coordinates operator-(const Coordinates& a){
   Coordinates t;
   t(0)=-a(0);
   t(1)=-a(1);
   t(2)=-a(2);
   return t;
}
Coordinates operator*(double a,
                      const Coordinates& b){
   Coordinates t=b;
   t*=a;
   return t;
}
Coordinates operator*(const Rotation_Matrix& ROT,
                      const Coordinates& b){
   Coordinates t;
   for(int i=0;i<3;i++){
      t(i)=( ROT(i,0)*b(0)
            +ROT(i,1)*b(1)
            +ROT(i,2)*b(2));
   }
   return t;
}
Coordinates operator*(const Coordinates& b,
                      const Rotation_Matrix& ROT){
   Coordinates t;
   for(int i=0;i<3;i++){
      t(i)=( b(0)*ROT(0,i)
            +b(1)*ROT(1,i)
            +b(2)*ROT(2,i));
   }
   return t;
}
bool operator==(const Coordinates& a,
                const Coordinates& b){
   Coordinates t=b;
   t-=a;
   return (t.rr()<(1.00e-10));
}
bool operator!=(const Coordinates& a,
                const Coordinates& b){
   Coordinates t=b;
   t-=a;
   return (t.rr()>(1.00e-10));
}
std::ostream& operator<<(std::ostream& os,
                         const Coordinates& a){
   os<< std::fixed<< std::setprecision(3);
   for(int i=0;i<3;i++){
      os<< std::setw( 8)<<a(i);
   }
   return os;
}
//
//
// global functions
//
double dot(const Coordinates& a,
           const Coordinates& b){
   return ( a(0)*b(0) +a(1)*b(1) +a(2)*b(2));
}
Coordinates cross(const Coordinates& a,
                  const Coordinates& b){
   Coordinates t;
   t(0)= a(1)*b(2) -a(2)*b(1);
   t(1)= a(2)*b(0) -a(0)*b(2);
   t(2)= a(0)*b(1) -a(1)*b(0);
   return t;
}
