#ifndef DEF_CONF_DEPENDENT_SYSTEM
#define DEF_CONF_DEPENDENT_SYSTEM

#include "../phi/Coordinates.hh"
#include "../phi/Fourier1D_Coeffs.hh"
#include "../phi/Fourier2D_Coeffs.hh"
#include "../phi/Fourier3D_Coeffs.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include <vector>

class Conf_Dependent_System {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      Coordinates trans;        //translation (bohr)
      Coordinates rot;          //rotation euler angles (radian)
      tZ0(){}
   };
   class tQ1 { /*torsions in chains [forward order]*/
   public:
      double chi;               //torsion angle (radian)
      tQ1(){}
   };
   class tQ2 { /*torsions in torsion-contracted chains [forward order]*/
   public:
      double chi;               //torsion angle (radian)
      Rotation_Matrix tu;       //t(chi about x-axis)u(lam about z-axis)
      Fourier1D_Coeffs tau;     //fourier coeffs (hartree)
      tQ2(){}
   };
   class tG2 { /*atoms in torsion-contracted chain forward groups [forward
                 order]*/
   public:
      Coordinates b;            //local unrotated coords (bohr)
      tG2(){}
   };
   class tJ2 { /*pairs of adjacent torsion angles in torsion-contracted chains*/
   public:
      Fourier2D_Coeffs tau;     //fourier coeffs (hartree)
      tJ2(){}
   };
   class tY2 { /*triples of adjacent torsion angles in torsion-contracted
                 chains*/
   public:
      Fourier3D_Coeffs tau;     //fourier coeffs (hartree)
      tY2(){}
   };
   class tF2 { /*atoms in atom-contracted chains [backward order]*/
   public:
      Coordinates x;            //coords (bohr), no translation +rotation
      Multipoles q;             //atomic multipoles
      Multipoles p;             //H-bond octopole
      bool bur;                 //buried relative to molecular surface
      Coordinates y;            //coords (bohr)
      tF2(){}
   };
   class tG3 { /*atoms in atom-contracted chain forward groups [forward order]*/
   public:
      Coordinates b;            //local unrotated coords (bohr)
      tG3(){}
   };

private:
   std::vector<int> o_J2N2Q2;           //pair of torsions
   std::vector<int> o_Y2N3Q2;           //triple of torsions

public:
   /*uncontracted sets*/
   std::vector<tZ0> Z0;         //chains
   std::vector<tQ1> Q1;         //torsions [forward order]
   /*torsion-contracted sets*/
   std::vector<tQ2> Q2;         //torsions [forward order]
   std::vector<tG2> G2;         //atoms in forward groups [forward order]
   std::vector<tJ2> J2;         //pairs of adjacent torsion angles
   std::vector<tY2> Y2;         //triples of adjacent torsion angles
   /*atom-contracted sets*/
   std::vector<tF2> F2;         //atoms [backward order]
   std::vector<tG3> G3;         //atoms in forward groups [forward order]

   int& J2N2Q2(int i,int j){
      return o_J2N2Q2.at( i*2 +j);
   }
   int& Y2N3Q2(int i,int j){
      return o_Y2N3Q2.at( i*3 +j);
   }
   const int& J2N2Q2(int i,int j) const {
      return o_J2N2Q2.at( i*2 +j);
   }
   const int& Y2N3Q2(int i,int j) const {
      return o_Y2N3Q2.at( i*3 +j);
   }

   Conf_Dependent_System(int oZ0,int oQ1,int oF1,int oG1,int oJ1,int oY1):
      o_J2N2Q2(oJ1*2),
      o_Y2N3Q2(oY1*3),
      Z0(oZ0),
      Q1(oQ1+1),
      Q2(oQ1+1),
      G2(oG1),
      J2(oJ1),
      Y2(oY1),
      F2(oF1),
      G3(oG1)
   {
   }
};

#endif
