#ifndef DEF_BLOCK_PAIR
#define DEF_BLOCK_PAIR

#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"

class Block_Pair {
private:
   /*for block pair (a,b),
     derivatives wrt rigid body translation and rotation
     of block a or b,
     rotation is about the origin of the molecule containing the block*/
   double e;                    //interaction energy
   double de[6];                //1st derivatives
   double dde[6][6];            //2nd derivatives

public:
   double& operator()(){
      return e;
   }
   double& operator()(int i){
      return de[i];
   }
   double& operator()(int i,int j){
      return dde[i][j];
   }
   const double& operator()() const {
      return e;
   }
   const double& operator()(int i) const {
      return de[i];
   }
   const double& operator()(int i,int j) const {
      return dde[i][j];
   }

   Block_Pair(){
   }

   void operator=(const Block_Pair& a);
   void operator+=(const Block_Pair& a);
   void operator-=(const Block_Pair& a);

   void zero();

   void transform(const Rotation_Matrix& hc,
                  const Coordinates& hx,
                  const Rotation_Matrix& hc0,
                  const Coordinates& hx0,
                  const Rotation_Matrix& jc,
                  const Coordinates& jx,
                  const Rotation_Matrix& jc0,
                  const Coordinates& jx0);
   void translate(const Coordinates& b);
   void bound(int jQ2,int iQ2,
              double u,
              Coordinates t,
              Coordinates a);
};

class Block_Pair_G {
private:
   /*for block pair (a,b),
     derivatives wrt rigid body translation and rotation
     of block a or b,
     rotation is about the origin of the molecule containing the block*/
   double e;                    //interaction energy
   double de[6];                //1st derivatives

public:
   double& operator()(){
      return e;
   }
   double& operator()(int i){
      return de[i];
   }
   const double& operator()() const {
      return e;
   }
   const double& operator()(int i) const {
      return de[i];
   }

   Block_Pair_G(){
   }

   void operator=(const Block_Pair_G& a);
   void operator+=(const Block_Pair_G& a);
   void operator-=(const Block_Pair_G& a);

   void zero();
};

#endif
