#include "../mov/Lagrange_Multiplier.hh"
#include "../phi/Block_Pair.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>
//
//
// assign
//
void Block_Pair::operator=(const Block_Pair& a){
   for(int i=0;i<6;i++){
      de[i]=a(i);
      for(int j=0;j<6;j++){
         dde[i][j]=a(i,j);
      }
   }
   return;
}
void Block_Pair::operator+=(const Block_Pair& a){
   for(int i=0;i<6;i++){
      de[i]+=a(i);
      for(int j=0;j<6;j++){
         dde[i][j]+=a(i,j);
      }
   }
   return;
}
void Block_Pair::operator-=(const Block_Pair& a){
   for(int i=0;i<6;i++){
      de[i]-=a(i);
      for(int j=0;j<6;j++){
         dde[i][j]+=a(j,i);
      }
   }
   return;
}
void Block_Pair_G::operator=(const Block_Pair_G& a){
   for(int i=0;i<6;i++){
      de[i]=a(i);
   }
   return;
}
void Block_Pair_G::operator+=(const Block_Pair_G& a){
   for(int i=0;i<6;i++){
      de[i]+=a(i);
   }
   return;
}
void Block_Pair_G::operator-=(const Block_Pair_G& a){
   for(int i=0;i<6;i++){
      de[i]-=a(i);
   }
   return;
}
//
//
// initiate
//
void Block_Pair::zero(){
   for(int i=0;i<6;i++){
      de[i]= (0.00);
      for(int j=0;j<6;j++){
         dde[i][j]= (0.00);
      }
   }
   return;
}
void Block_Pair_G::zero(){
   for(int i=0;i<6;i++){
      de[i]= (0.00);
   }
   return;
}
//
//
// rotate block pair to enable accumulation
//
void Block_Pair::transform(const Rotation_Matrix& hc,
                           const Coordinates& hx,
                           const Rotation_Matrix& hc0,
                           const Coordinates& hx0,
                           const Rotation_Matrix& jc,
                           const Coordinates& jx,
                           const Rotation_Matrix& jc0,
                           const Coordinates& jx0){
//
//
// backup
//
   double df[6];
   double ddf[6][6];
   for(int i=0;i<6;i++){
      df[i]= de[i];
      for(int j=0;j<6;j++){
         ddf[i][j]= dde[i][j];
      }
   }
//
//
// transformation (TRANS,ROT) to normalize hQ2 backward group
//
   Rotation_Matrix ROT= hc0*transpose(hc);
   Coordinates TRANS=( hx0 -ROT*hx);
//
//
// normalize jQ2 backward group
//
   Rotation_Matrix c= ROT*jc;
   Coordinates x=( TRANS +ROT*jx);
//
//
// transformation (b,P) of jQ2 backward group, old to new
//
   Rotation_Matrix P= c*transpose(jc0);
   Coordinates b=( x -P*jx0);
   Rotation_Matrix Q;
   for(int i=0;i<3;i++){
      Q(0,i)=( P(1,i)*b(2) -P(2,i)*b(1));
      Q(1,i)=( P(2,i)*b(0) -P(0,i)*b(2));
      Q(2,i)=( P(0,i)*b(1) -P(1,i)*b(0));
   }
//
//
// rotate
//
   for(int i=0;i<3;i++){
      de[3+i]= (0.00);
      de[  i]= (0.00);
      for(int x=0;x<3;x++){
         de[3+i]+=( df[3+x]*P(x,i)
                   +df[  x]*Q(x,i));
         de[  i]+=( df[  x]*P(x,i));
      }
      for(int j=0;j<3;j++){
         dde[3+i][3+j]= (0.00);
         dde[  i][3+j]= (0.00);
         dde[3+i][  j]= (0.00);
         dde[  i][  j]= (0.00);
         for(int x=0;x<3;x++){
            for(int y=0;y<3;y++){
               dde[3+i][3+j]+=( ddf[3+x][3+y]*P(x,i)*P(y,j)
                               +ddf[  x][3+y]*Q(x,i)*P(y,j)
                               +ddf[3+x][  y]*P(x,i)*Q(y,j)
                               +ddf[  x][  y]*Q(x,i)*Q(y,j));
               dde[  i][3+j]+=( ddf[  x][3+y]*P(x,i)*P(y,j)
                               +ddf[  x][  y]*P(x,i)*Q(y,j));
               dde[3+i][  j]+=( ddf[3+x][  y]*P(x,i)*P(y,j)
                               +ddf[  x][  y]*Q(x,i)*P(y,j));
               dde[  i][  j]+=( ddf[  x][  y]*P(x,i)*P(y,j));
            }
         }
      }
   }
   return;
}
//
//
// translate origin to base atom of rotatable bond
//
void Block_Pair::translate(const Coordinates& b){
   Rotation_Matrix ddf;
   for(int j=0;j<3;j++){
      ddf(0,j)=( dde[1][j]*b(2) -dde[2][j]*b(1));
      ddf(1,j)=( dde[2][j]*b(0) -dde[0][j]*b(2));
      ddf(2,j)=( dde[0][j]*b(1) -dde[1][j]*b(0));
   }
   de[3]-=( de[1]*b(2) -de[2]*b(1));
   de[4]-=( de[2]*b(0) -de[0]*b(2));
   de[5]-=( de[0]*b(1) -de[1]*b(0));
   for(int i=0;i<3;i++){
      dde[3+i][3]+=( ddf(i,1)*b(2) -ddf(i,2)*b(1));
      dde[3+i][4]+=( ddf(i,2)*b(0) -ddf(i,0)*b(2));
      dde[3+i][5]+=( ddf(i,0)*b(1) -ddf(i,1)*b(0));
   }
   for(int j=0;j<3;j++){
      dde[3][3+j]-=( dde[1][3+j]*b(2) -dde[2][3+j]*b(1));
      dde[4][3+j]-=( dde[2][3+j]*b(0) -dde[0][3+j]*b(2));
      dde[5][3+j]-=( dde[0][3+j]*b(1) -dde[1][3+j]*b(0));
   }
   for(int i=0;i<3;i++){
      dde[3+i][3]-=( dde[3+i][1]*b(2) -dde[3+i][2]*b(1));
      dde[3+i][4]-=( dde[3+i][2]*b(0) -dde[3+i][0]*b(2));
      dde[3+i][5]-=( dde[3+i][0]*b(1) -dde[3+i][1]*b(0));
   }
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         dde[i][3+j]-=ddf(j,i);
         dde[3+i][j]-=ddf(i,j);
      }
   }
   return;
}
//
//
// bound block pair energy surface
//
void Block_Pair::bound(int jQ2,int iQ2,
                       double u,
                       Coordinates t,
                       Coordinates a){
   int ck1,ck2,ck3,ck4,ck5;             //loop counters
//
//
// accept surface
//
   Lagrange_Multiplier lag( 6);
   for(int i=0;i<3;i++){
      lag.U2g(  i)= de[  i]*(2.000);
      lag.U2g(3+i)= de[3+i]*(0.125);
      lag.U2h(  i)= dde[  i][  i]*(2.000)*(2.000);
      lag.U2h(3+i)= dde[3+i][3+i]*(0.125)*(0.125);
   }
   for(int i=0;i<3;i++){
      for(int j=i;j<3;j++){
         lag.U2U2a(  i,  j)= dde[  j][  i]*(2.000)*(2.000);
         lag.U2U2a(3+i,3+j)= dde[3+j][3+i]*(0.125)*(0.125);
      }
   }
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         lag.U2U2a(  i,3+j)= dde[  i][3+j]*(2.000)*(0.125);
      }
   }
//
//
// evaluate ae
//
   lag.U2x( 0)= t(0);
   lag.U2x( 1)= t(1);
   lag.U2x( 2)= t(2);
   lag.U2x( 3)= a(0);
   lag.U2x( 4)= a(1);
   lag.U2x( 5)= a(2);
   double g= (0.00);
   double h= (0.00);
   for(int iU2=0;iU2<6;iU2++){
      g+=lag.U2g(iU2)*lag.U2x(iU2);
      h+=lag.U2h(iU2)*lag.U2x(iU2)*lag.U2x(iU2);
   }
   h/=(2.00);
   for(int iU2=0;iU2<5;iU2++){
      double z= (0.00);
      for(int jU2=(iU2+1);jU2<6;jU2++){
         z+=lag.U2U2a(iU2,jU2)*lag.U2x(jU2);
      }
      h+=z*lag.U2x(iU2);
   }
   double ae=( g +h);
   if( (ae/u)>(-1.00e-2) )return;
//
//
// find initial lamda
//
   double zz= lag.gradient();
   for(ck1=3;ck1>0;ck1--){
      if      ( ck1==3 ){
         lag.lamda= (0.00);
      }else if( ck1==2 ){
         lag.lamda=( lag.hmean+lag.hsigma);
      }else if( ck1==1 ){
         lag.lamda=-lag.hbound;
      }
      lag.diagonal();
      bool pd=lag.lower();
      if( pd )break;
   }
   if( ck1==0 ){
      std::cerr<<"ERROR: k1."<< std::endl;
      std::exit( 2);
   }
   lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
   double dxx;
   double xx=lag.length(dxx);
   double f= (0.00);
   for(int iU2=0;iU2<6;iU2++){
      f+=lag.U2g(iU2)*lag.U2x(iU2);
   }
   f*=(.50);
   if( (lag.lamda<=( 1.00e-8))&&
       (f>((-7.92)*u)) ){
      return;
   }
////  std::cout<< std::fixed;
////  std::cout<<" jQ2="<< std::setw( 3)<<jQ2
////           <<" iQ2="<< std::setw( 3)<<iQ2
////           <<" k1="<< std::setw( 2)<<(3-ck1)
////           <<"      "
////           << std::setprecision( 8)
////           <<" lam="<< std::setw(11)<<lag.lamda
////           << std::setprecision( 2)
////           <<" x="<< std::setw(11)<< std::sqrt(xx)
////           << std::setprecision(10)
////           <<" f="<< std::setw(15)<<f
////           << std::setprecision( 8)
////           <<" f/u="<< std::setw(12)<<(f/u)<< std::endl;
//
//
// reduce lamda
//
   for(ck2=4;ck2>0;ck2--){
      if( f<((-7.92)*u) )break;
      if( lag.lamda<=( 1.00e-8) )return;

      for(ck4=20;ck4> 0;ck4--){
         for(int ii=0;ii<5;ii++){
            lag.step(lag.o_U2x,lag.lamda,lag.o_U2x);
         }
         lag.normalize();
      }
      double s0= (1.00);
      lag.step(lag.o_U2x,(1.00),lag.o_U2x);
      double s1=lag.normalize();
      double h0=(s0/s1);
      double g0= (0.00);
      for(int iU2=0;iU2<6;iU2++){
         g0+=lag.U2x(iU2)*lag.U2g(iU2);
      }
      double dlamda=( (g0*g0/((16.00)*u)) -h0);
      lag.lamda+=dlamda;
      if( lag.lamda<(0.00) )lag.lamda= (0.00);
      dlamda/=(-64.00);

      for(ck5=8;ck5>0;ck5--){
         lag.diagonal();
         bool pd=lag.lower();
         if( pd )break;
         lag.lamda+=dlamda;
         dlamda*=(2.00);
      }
      if( ck5==0 ){
         std::cerr<<"ERROR: k5."<< std::endl;
         std::exit( 2);
      }
      lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
      xx= lag.length(dxx);
      f= (0.00);
      for(int iU2=0;iU2<6;iU2++){
         f+=lag.U2g(iU2)*lag.U2x(iU2);
      }
      f*=(.50);
////  std::cout<< std::fixed;
////  std::cout<<" jQ2="<< std::setw( 3)<<jQ2
////           <<" iQ2="<< std::setw( 3)<<iQ2
////           <<" k2="<< std::setw( 2)<<(4-ck2)
////           <<" k5="<< std::setw( 2)<<(8-ck5)
////           << std::setprecision( 8)
////           <<" lam="<< std::setw(11)<<lag.lamda
////           << std::setprecision( 2)
////           <<" x="<< std::setw(11)<< std::sqrt(xx)
////           << std::setprecision(10)
////           <<" f="<< std::setw(15)<<f
////           << std::setprecision( 8)
////           <<" f/u="<< std::setw(12)<<(f/u)<< std::endl;
   }
//
//
// increase lamda
//
   for(ck3=8;ck3>0;ck3--){
      if( f>((-8.08)*u) )break;

      double dlamda= (2.00)*( ((-8.00)*u) -f)/xx;
      lag.lamda+=dlamda;
      if( lag.lamda<(0.00) )lag.lamda= (0.00);

      lag.diagonal();
      bool pd=lag.lower();
      if( !pd ){
         std::cerr<<"ERROR: k3."<< std::endl;
         std::exit( 2);
      }
      lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
      xx=lag.length(dxx);
      f= (0.00);
      for(int iU2=0;iU2<6;iU2++){
         f+=lag.U2g(iU2)*lag.U2x(iU2);
      }
      f*=(.50);
////  std::cout<< std::fixed;
////  std::cout<<" jQ2="<< std::setw( 3)<<jQ2
////           <<" iQ2="<< std::setw( 3)<<iQ2
////           <<" k3="<< std::setw( 2)<<(8-ck3)
////           <<"      "
////           << std::setprecision( 8)
////           <<" lam="<< std::setw(11)<<lag.lamda
////           << std::setprecision( 2)
////           <<" x="<< std::setw(11)<< std::sqrt(xx)
////           << std::setprecision(10)
////           <<" f="<< std::setw(15)<<f
////           << std::setprecision( 8)
////           <<" f/u="<< std::setw(12)<<(f/u)<< std::endl;
   }
//
//
// evaluate penalty
//
//// double ss=( dot(t,t) +dot(a,a));
//// double pf= lag.lamda*ss;
////  std::cout<<" jQ2="<< std::setw( 3)<<jQ2
////           <<" iQ2="<< std::setw( 3)<<iQ2
////           <<"      "
////           << std::setprecision(10)
////           <<" p="<< std::setw(15)<<pf
////           <<"    "
////           << std::setprecision( 2)
////           <<" s="<< std::setw(11)<< std::sqrt(ss)
////           << std::setprecision(10)
////           <<" e="<< std::setw(15)<<ae
////           << std::setprecision( 8)
////           <<" e/u="<< std::setw(12)<<(ae/u)<< std::endl;
//
//
// modify block pair
//
   if( lag.lamda<=(1.00e-8) ){
   }else{
      for(int i=0;i<3;i++){
         dde[  i][  i]+=lag.lamda/((2.000)*(2.000));
         dde[3+i][3+i]+=lag.lamda/((0.125)*(0.125));
      }
////  std::cout<< std::fixed;
////  std::cout<<" jQ2="<< std::setw( 3)<<jQ2
////           <<" iQ2="<< std::setw( 3)<<iQ2
////           <<" k1="<< std::setw( 2)<<(3-ck1)
////           <<" k2="<< std::setw( 2)<<(4-ck2)
////           <<" k3="<< std::setw( 2)<<(32-ck3)
////           << std::setprecision( 8)
////           <<" lam="<< std::setw(11)<<lag.lamda
////           << std::setprecision( 2)
////           <<" x="<< std::setw(11)<< std::sqrt(xx)
////           << std::setprecision(10)
////           <<" f="<< std::setw(15)<<f
////           << std::setprecision( 8)
////           <<" f/u="<< std::setw(12)<<(f/u)<< std::endl;
   }

   return;
}
