#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <fstream>
#include <iomanip>
#include <cmath>

class MEM_pck_vis {
public:
   class tX { /*dot of patch st angle DOT wrt n is low*/
   public:
      double rst;               //angle of DOT wrt n (radians)
      int DOT;                  //index of DOT
      double ghp;               //fraction hydrophob of surf area
      tX(){}
   };
private:
   std::vector<bool> o_DOTsub;  //subset of dots cavity or cleft
public:
   std::vector<tX> o_X;         //subset of DOT
   MEM_pck_vis(int o):
      o_DOTsub(o, true)
   {
   }
   void DOTsub(int i,bool a){
      o_DOTsub[ i]=a;  }
   bool DOTsub(int i){
      return o_DOTsub[ i];  }
   tX& X(int i){
      return o_X.at( i);  }
};

void Packing_Search::PCK_VIS(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const DAT_ARRAY_CONSTS& array_consts,
         const DAT_DISULFIDE_LINKS& disulfide_links,
         const DAT_ENERGY_PARAMS& energy_params,
         const DAT_REGION_MAPS& region_maps,
         const DAT_RESIDUE_MAPPINGS& residue_mappings,
         const Thread_Options& opt,
         Output_Streams& out,
         std::string& CNF,
         double ztrans){

   double ANG= physics_consts.ANG;
   double ANGANG= ANG*ANG;
//
   std::string MOL=G9[ 0].bod.substr( 0, 4)+CNF;
   std::string filename1="../../dock/car/x"+MOL+".pdb";
   std::ofstream ofile1(filename1.c_str());
   ofile1<< std::fixed<< std::setprecision( 3);
   std::string filename2="../../dock/car/d"+MOL+".pdb";
   std::ofstream ofile2(filename2.c_str());
   ofile2<< std::fixed<< std::setprecision( 3);
   int ii=0;
   for(int iG9= 0;iG9<oG9;iG9++){
      const Structure& str=G9[iG9].bac;
      Coordinates G9FTns;
      G9FTns.zero();
      if( iG9==0 ){
         G9FTns( 2)= ( 1.00);
      }else{
         G9FTns( 2)= (-1.00);
      }
      Coordinates G9FTx;
      G9FTx.zero();
      if( iG9==0 ){
      }else{
         G9FTx( 2)= ztrans;
      }
//
//
// construct mechanical system
//
      Search_Subspace sub;
      Distance_Constraints dst(physics_consts,residue_mappings,
                               opt,out,str,sub);

      int oZ0=str.nZ0;
      int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
      int oQ1=oZ0;
      int oU1=0;
      int oF1=0;
      int oB1=0;
      int oG1=0;
      int oH1=0;
      int oJ1=0;
      int oY1=0;
      for(int iR0= 0;iR0<oR0;iR0++){
         int iL0=str.R0[iR0].L0;
         oQ1+=residue_mappings.L0[iL0].cQ0;
         oU1+=residue_mappings.L0[iL0].cU0;
         oF1+=residue_mappings.L0[iL0].cF0;
         oB1+=residue_mappings.L0[iL0].cB0;
         oG1+=residue_mappings.L0[iL0].cG0;
         oH1+=residue_mappings.L0[iL0].cH0;
         oJ1+=residue_mappings.L0[iL0].cJ0;
         oY1+=residue_mappings.L0[iL0].cY0;
      }
      Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
      Subset_Contracted_System col(disulfide_links,residue_mappings,
                                   opt,str,sub);
      Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
      mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
              opt,str,out,dst,col,dep);
      mol.CON(physics_consts,array_consts,energy_params,
              region_maps,
              opt,out,col,dep);
      Subset_Contracted_System::tM3& con=col.M3[ 0];
      int oQ2=con.oQ2;
      int oF2=con.oF2;
      int oA5=con.oA5;
//
//
// resize molecule specific vectors
//
      F2.resize(oF2);
      Q2.resize(oQ2);
      A5.resize(oA5);
//
//
// calc F2[].x and F2[].q
//
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

         Coordinates TRANS=dep.Z0[iZ0].trans;
         double alp= dep.Z0[iZ0].rot(0);
         double bet= dep.Z0[iZ0].rot(1);
         double gam= dep.Z0[iZ0].rot(2);
         Rotation_Matrix ROT(alp,bet,gam);
         Q2[mQ2].c=ROT;
         int mB3=con.Z0[iZ0].B3a;
         int nB3=(mB3-1+con.Z0[iZ0].cB3);
         for(int iB3=mB3;iB3<=nB3;iB3++){
            int iF2=con.B3[iB3].F2;
            F2[iF2].x.generate(TRANS,
                               ROT,
                               dep.F2[iF2].x);
            F2[iF2].q.rotate(array_consts,
                             ROT,
                             dep.F2[iF2].q);
            if( con.F2[iF2].ion ){
               F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
            }
         }

         if( nQ2>mQ2 ){
            Rotation_Matrix PR[3];
            PR[ 0]=ROT;
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
               int br=con.Q2[iQ2].br;
               int cbr=con.Q2[iQ2].cbr;
               PR[br].extend(PR[cbr],
                             dep.Q2[iQ2].tu,
                             dep.Q2[iQ2].chi);
               Q2[iQ2].c=PR[br];
               int mG3=con.Q2[iQ2].G3a;
               int nG3=(mG3-1+con.Q2[iQ2].cG3);
               for(int iG3=mG3;iG3<=nG3;iG3++){
                  int iF2=con.G3[iG3].F2;
                  F2[iF2].x.generate(F2[con.Q2[iQ2].bseF2].x,
                                     PR[br],
                                     dep.G3[iG3].b);
                  F2[iF2].q.rotate(array_consts,
                                   PR[br],
                                   dep.F2[iF2].q);
                  if( con.F2[iF2].ion ){
                     F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
                  }
               }
            }
         }
      }
//
//
// calc boundary surf
//
      Dielec_Continu mlg(oQ2,oF2,oA5,oR0);
      Dielec_Continu med(oQ2,oF2,oA5,oR0);
      for(int iQ2= 0;iQ2<oQ2;iQ2++){
         mlg.Q2[iQ2].c=Q2[iQ2].c;
         med.Q2[iQ2].c=Q2[iQ2].c;
      }
      bool VERBOSE_hold=out.VERBOSE;
//
//
// large probe radius dots
//
      mlg.probe= ((2.80)/ANG);
      mlg.MED_SPHERE(physics_consts,out);
      mlg.MED_TORUS(physics_consts,out);
      PCK_MOL(physics_consts,energy_params,
              mlg,mol,con,dep);
      out.VERBOSE=false;
      mlg.bse_nA5=0;
      mlg.bse_nB5=0;
      mlg.bse_nC5=0;
      mlg.bse_nF5=0;
      mlg.bse_nE5=0;
      mlg.bse_nV5=0;
      mlg.bse_nH5=0;
      mlg.ENDSTATE=0;
      mlg.MED_SURF(physics_consts,out);
      if( mlg.ENDSTATE>0 ){
         out.FILE3<<"ENDSTATE="<< std::setw( 2)<<mlg.ENDSTATE<< std::endl;
         std::exit( 2);
         return;
      }
      mlg.bse_nD5=0;
      mlg.MED_DOT(physics_consts,array_consts,out);
      out.VERBOSE=VERBOSE_hold;
      PCK_SURF(physics_consts,
               str,out,mlg);
//
//
// small probe radius dots
//
      med.probe= ((1.40)/ANG);
      med.MED_SPHERE(physics_consts,out);
      med.MED_TORUS(physics_consts,out);
      PCK_MOL(physics_consts,energy_params,
              med,mol,con,dep);
      out.VERBOSE=false;
      med.bse_nA5=0;
      med.bse_nB5=0;
      med.bse_nC5=0;
      med.bse_nF5=0;
      med.bse_nE5=0;
      med.bse_nV5=0;
      med.bse_nH5=0;
      med.ENDSTATE=0;
      med.MED_SURF(physics_consts,out);
      if( med.ENDSTATE>0 ){
         out.FILE3<<"ENDSTATE="<< std::setw( 2)<<med.ENDSTATE<< std::endl;
         std::exit( 2);
         return;
      }
      med.bse_nD5=0;
      med.MED_DOT(physics_consts,array_consts,out);
      med.MED_SIG(physics_consts,array_consts,out);
      out.VERBOSE=VERBOSE_hold;
      PCK_SURF(physics_consts,
               str,out,med);
      PCK_EHP(physics_consts,
              str,out,med);
//
//
// subset of cavity and cleft dots
//
      int oDOT=med.nDOT;
      MEM_pck_vis vv(oDOT);
      double rrcut= ((3.20)/ANGANG);
      for(int i0G5=-16;i0G5<=16;i0G5++){
         int iG5min=(i0G5-3);
         if( iG5min<-16 )iG5min=-16;
         int iG5max=(i0G5+3);
         if( iG5max> 16 )iG5max= 16;
         for(int j0G5=-16;j0G5<=16;j0G5++){
            int jG5min=(j0G5-3);
            if( jG5min<-16 )jG5min=-16;
            int jG5max=(j0G5+3);
            if( jG5max> 16 )jG5max= 16;
            for(int k0G5=-16;k0G5<=16;k0G5++){
               int kG5min=(k0G5-3);
               if( kG5min<-16 )kG5min=-16;
               int kG5max=(k0G5+3);
               if( kG5max> 16 )kG5max= 16;
               if( med.G5G5G5(i0G5,j0G5,k0G5).n==0 )continue;
               int iD5min=med.G5G5G5(i0G5,j0G5,k0G5).i;
               int iD5max=(iD5min-1+med.G5G5G5(i0G5,j0G5,k0G5).n);
               for(int iD5=iD5min;iD5<=iD5max;iD5++){
                  int aDOT=med.D5[iD5].DOTa;
                  int bDOT=(aDOT-1+med.D5[iD5].cDOT);
                  for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                     bool HIT=(false);
                     for(int iG5=iG5min;iG5<=iG5max&&(!HIT);iG5++){
                        for(int jG5=jG5min;jG5<=jG5max&&(!HIT);jG5++){
                           for(int kG5=kG5min;kG5<=kG5max&&(!HIT);kG5++){
                              if( mlg.G5G5G5(iG5,jG5,kG5).n==0 )continue;
                              int jD5min=mlg.G5G5G5(iG5,jG5,kG5).i;
                              int jD5max=(jD5min-1+mlg.G5G5G5(iG5,jG5,kG5).n);
                              for(int jD5=jD5min;jD5<=jD5max&&(!HIT);jD5++){
//                               if( mlg.D5[jD5].Q5> 0 )continue;
                                 int pDOT=mlg.D5[jD5].DOTa;
                                 int qDOT=(pDOT-1+mlg.D5[jD5].cDOT);
                                 for(int jDOT=pDOT;jDOT<=qDOT&&(!HIT);jDOT++){
                                    double rr=( mlg.DOT[jDOT].x
                                               -med.DOT[iDOT].x).rr();
                                    if( rr<rrcut ){
                                       vv.DOTsub(iDOT,false);
                                       HIT=true;
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
//
//
// moments for surface matching of interface
//
      {
         {
            {
//
//
// patch of dot surf
//
               vv.o_X.clear();
               int oX=-1;
               for(int iD5= 0;iD5<med.nD5;iD5++){
                  int iQ5=med.D5[iD5].Q5;
                  if( iQ5> 0 )continue;
                  int aDOT=med.D5[iD5].DOTa;
                  int bDOT=(aDOT-1+med.D5[iD5].cDOT);
                  for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                     Coordinates d=( med.DOT[iDOT].x -G9FTx);
                     double dn= dot( d, G9FTns);
                     double cn= dot( med.DOT[iDOT].c, G9FTns);
                     if( cn<( -.15) )continue;
                     double r= d.r();
                     double Cthe= (dn/r);
                     if( Cthe<(  .32) )continue;
                     double zz=( (1.00) -Cthe*Cthe);
                     if( zz<( 1.00e-25) )zz=( 1.00e-25);
                     double Sthe= std::sqrt( zz);
                     double rst= (r*Sthe);
                     if( oX<6143 ){
                        vv.o_X.push_back( MEM_pck_vis::tX());
                        oX++;
                     }else{
                        if( rst>=vv.X(oX).rst )continue;
                     }
                     vv.X(oX).rst= rst;
                     vv.X(oX).DOT=iDOT;
                     for(int jX=oX;jX> 0;jX--){
                        if( vv.X(jX   ).rst>=
                            vv.X(jX- 1).rst )break;
                        double z= vv.X(jX- 1).rst;
                        vv.X(jX- 1).rst= vv.X(jX   ).rst;
                        vv.X(jX   ).rst= z;
                        int j=vv.X(jX- 1).DOT;
                        vv.X(jX- 1).DOT=vv.X(jX   ).DOT;
                        vv.X(jX   ).DOT=j;
                     }
                  }
               }
               oX++;
//
//
// dot surface
//
               for(int iZ0=0;iZ0<str.nZ0;iZ0++){
                  int mR0=str.Z0[iZ0].R0a;
                  int nR0=(mR0-1+str.Z0[iZ0].cR0);
                  for(int iR0=mR0;iR0<=nR0;iR0++){
                     char c1=str.R0[iR0].c1;
                     std::string aa=str.R0[iR0].aa;
                     if( c1=='a' ){
                        if( (aa[0]=='e')||
                            (aa[0]=='z') )aa=aa.substr(1,3)+' ';
                        if( (aa[3]=='e')||
                            (aa[3]=='z') )aa=aa.substr(0,3)+' ';
                     }
                     char cha=str.R0[iR0].cha;
                     int res=str.R0[iR0].res;
                     char ins=str.R0[iR0].ins;
                     int mP1=str.R0[iR0].P1a;
                     int nP1=(mP1-1+str.R0[iR0].cP1);
                     for(int iP1=mP1;iP1<=nP1;iP1++){
                        if( str.P1[iP1].sub==0 )continue;
                        std::string atm=str.P1[iP1].atm;
                        int iT2=str.P1[iP1].typ;
                        if( (aa=="CYH ")&&(atm==" HG ") )iT2=5;
                        if( (iT2== 0)||(iT2== 3) )continue;
                        ii++;
                        ofile1<<"ATOM  "
                             << std::setw( 5)<<ii<<' '
                             <<atm<<' '
                             <<aa.substr(0,3)<<' '
                             <<cha
                             << std::setw( 4)<<res
                             <<ins<<"   ";
                        for(int j=0;j<3;j++){
                           ofile1<< std::setw( 8)<<str.P1[iP1].x(j);
                        }
                        ofile1<<'\n';
                     }
                  }
               }
               ofile1<<"TER"<<'\n';
               for(int iX= 0;iX<oX;iX++){
                  int iDOT=vv.X(iX).DOT;
                  ii++;
                  std::string atm=( iG9==0 )? " T00": " T02";
                  char cha=' ';
                  int res=0;
                  char ins=' ';
                  ofile2<<"ATOM  "
                       << std::setw( 5)<<ii<<' '
                       <<atm<<' '
                       <<"DOT"<<' '
                       <<cha
                       << std::setw( 4)<<res
                       <<ins<<"   ";
                  for(int j=0;j<3;j++){
                     ofile2<< std::setw( 8)<<(ANG*med.DOT[iDOT].x(j));
                  }
                  ofile2<<'\n';
               }
               ofile2<<"TER"<<'\n';
            }
         }
      }
//
//
// clear molecule specific vectors
//
      F2.clear();
      Q2.clear();
      A5.clear();
   }
   ofile1.close();
   ofile2.close();
   return;
}
