#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_pck_sphere {
private:
   std::vector<Coordinates> o_Vn;       //vertices on unit sphere
   std::vector<int> o_FNV;              //triple of vertices
   std::vector<int> o_TNz;              //triple of coeffs for dot
public:
   MEM_pck_sphere():
      o_Vn(12),
      o_FNV(20*3),
      o_TNz(64*3)
   {
   }
   Coordinates& Vn(int i){
      return o_Vn.at( i);  }
   int& FNV(int i,int j){
      return o_FNV.at( i*3 +j);  }
   int& TNz(int i,int j){
      return o_TNz.at( i*3 +j);  }
};

void Packing_Search::PCK_SPHERE(const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_ARRAY_CONSTS& array_consts,
                                Output_Streams& out){
   double PI= physics_consts.PI;
   double RAD= physics_consts.RAD;
   MEM_pck_sphere vv;
//
//
// vertices on a unit sphere
//
   double Sz= std::sqrt( (2.00)/( (5.00) +std::sqrt( 5.00)));
   double the= (2.00)*std::asin( Sz);
   double Cthe= std::cos( the);
   double Sthe= std::sin( the);
   double dphi= (2.00)*PI/(5.00);
   vv.Vn( 0)(0)=( 0.00);
   vv.Vn( 0)(1)=( 0.00);
   vv.Vn( 0)(2)=( 1.00);
   double phi= (0.00);
   for(int iV= 1;iV< 6;iV++){
      double Cphi= std::cos( phi);
      double Sphi= std::sin( phi);
      vv.Vn(iV)(0)= Sthe*Cphi;
      vv.Vn(iV)(1)= Sthe*Sphi;
      vv.Vn(iV)(2)= Cthe;
      phi+=dphi;
   }
   phi= (dphi/(2.00));
   for(int iV= 6;iV<11;iV++){
      double Cphi= std::cos( phi);
      double Sphi= std::sin( phi);
      vv.Vn(iV)(0)= Sthe*Cphi;
      vv.Vn(iV)(1)= Sthe*Sphi;
      vv.Vn(iV)(2)=-Cthe;
      phi+=dphi;
   }
   vv.Vn(11)(0)=( 0.00);
   vv.Vn(11)(1)=( 0.00);
   vv.Vn(11)(2)=(-1.00);
//
//
// faces of an icosohedren
//
   vv.FNV( 0,0)= 0;
   vv.FNV( 0,1)= 1;
   vv.FNV( 0,2)= 2;
   vv.FNV( 1,0)= 1;
   vv.FNV( 1,1)= 6;
   vv.FNV( 1,2)= 2;
   vv.FNV( 2,0)= 0;
   vv.FNV( 2,1)= 2;
   vv.FNV( 2,2)= 3;
   vv.FNV( 3,0)= 2;
   vv.FNV( 3,1)= 7;
   vv.FNV( 3,2)= 3;
   vv.FNV( 4,0)= 0;
   vv.FNV( 4,1)= 3;
   vv.FNV( 4,2)= 4;
   vv.FNV( 5,0)= 3;
   vv.FNV( 5,1)= 8;
   vv.FNV( 5,2)= 4;
   vv.FNV( 6,0)= 0;
   vv.FNV( 6,1)= 4;
   vv.FNV( 6,2)= 5;
   vv.FNV( 7,0)= 4;
   vv.FNV( 7,1)= 9;
   vv.FNV( 7,2)= 5;
   vv.FNV( 8,0)= 0;
   vv.FNV( 8,1)= 5;
   vv.FNV( 8,2)= 1;
   vv.FNV( 9,0)= 5;
   vv.FNV( 9,1)=10;
   vv.FNV( 9,2)= 1;
   vv.FNV(10,0)= 2;
   vv.FNV(10,1)= 6;
   vv.FNV(10,2)= 7;
   vv.FNV(11,0)= 7;
   vv.FNV(11,1)= 6;
   vv.FNV(11,2)=11;
   vv.FNV(12,0)= 3;
   vv.FNV(12,1)= 7;
   vv.FNV(12,2)= 8;
   vv.FNV(13,0)= 8;
   vv.FNV(13,1)= 7;
   vv.FNV(13,2)=11;
   vv.FNV(14,0)= 4;
   vv.FNV(14,1)= 8;
   vv.FNV(14,2)= 9;
   vv.FNV(15,0)= 9;
   vv.FNV(15,1)= 8;
   vv.FNV(15,2)=11;
   vv.FNV(16,0)= 5;
   vv.FNV(16,1)= 9;
   vv.FNV(16,2)=10;
   vv.FNV(17,0)=10;
   vv.FNV(17,1)= 9;
   vv.FNV(17,2)=11;
   vv.FNV(18,0)= 1;
   vv.FNV(18,1)=10;
   vv.FNV(18,2)= 6;
   vv.FNV(19,0)= 6;
   vv.FNV(19,1)=10;
   vv.FNV(19,2)=11;
//
//
// surface elements on a face
//
   vv.TNz( 0,0)=22;
   vv.TNz( 0,1)= 1;
   vv.TNz( 0,2)= 1;
   vv.TNz( 1,0)=20;
   vv.TNz( 1,1)= 2;
   vv.TNz( 1,2)= 2;
   vv.TNz( 2,0)=19;
   vv.TNz( 2,1)= 4;
   vv.TNz( 2,2)= 1;
   vv.TNz( 3,0)=19;
   vv.TNz( 3,1)= 1;
   vv.TNz( 3,2)= 4;
//
   vv.TNz( 4,0)=18;
   vv.TNz( 4,1)= 3;
   vv.TNz( 4,2)= 3;
   vv.TNz( 5,0)=16;
   vv.TNz( 5,1)= 4;
   vv.TNz( 5,2)= 4;
   vv.TNz( 6,0)=15;
   vv.TNz( 6,1)= 6;
   vv.TNz( 6,2)= 3;
   vv.TNz( 7,0)=15;
   vv.TNz( 7,1)= 3;
   vv.TNz( 7,2)= 6;
//
   vv.TNz( 8,0)=16;
   vv.TNz( 8,1)= 7;
   vv.TNz( 8,2)= 1;
   vv.TNz( 9,0)=14;
   vv.TNz( 9,1)= 8;
   vv.TNz( 9,2)= 2;
   vv.TNz(10,0)=13;
   vv.TNz(10,1)=10;
   vv.TNz(10,2)= 1;
   vv.TNz(11,0)=13;
   vv.TNz(11,1)= 7;
   vv.TNz(11,2)= 4;
//
   vv.TNz(12,0)=16;
   vv.TNz(12,1)= 1;
   vv.TNz(12,2)= 7;
   vv.TNz(13,0)=14;
   vv.TNz(13,1)= 2;
   vv.TNz(13,2)= 8;
   vv.TNz(14,0)=13;
   vv.TNz(14,1)= 4;
   vv.TNz(14,2)= 7;
   vv.TNz(15,0)=13;
   vv.TNz(15,1)= 1;
   vv.TNz(15,2)=10;
//
   vv.TNz(16,0)=10;
   vv.TNz(16,1)=13;
   vv.TNz(16,2)= 1;
   vv.TNz(17,0)= 8;
   vv.TNz(17,1)=14;
   vv.TNz(17,2)= 2;
   vv.TNz(18,0)= 7;
   vv.TNz(18,1)=16;
   vv.TNz(18,2)= 1;
   vv.TNz(19,0)= 7;
   vv.TNz(19,1)=13;
   vv.TNz(19,2)= 4;
//
   vv.TNz(20,0)= 6;
   vv.TNz(20,1)=15;
   vv.TNz(20,2)= 3;
   vv.TNz(21,0)= 4;
   vv.TNz(21,1)=16;
   vv.TNz(21,2)= 4;
   vv.TNz(22,0)= 3;
   vv.TNz(22,1)=18;
   vv.TNz(22,2)= 3;
   vv.TNz(23,0)= 3;
   vv.TNz(23,1)=15;
   vv.TNz(23,2)= 6;
//
   vv.TNz(24,0)= 4;
   vv.TNz(24,1)=19;
   vv.TNz(24,2)= 1;
   vv.TNz(25,0)= 2;
   vv.TNz(25,1)=20;
   vv.TNz(25,2)= 2;
   vv.TNz(26,0)= 1;
   vv.TNz(26,1)=22;
   vv.TNz(26,2)= 1;
   vv.TNz(27,0)= 1;
   vv.TNz(27,1)=19;
   vv.TNz(27,2)= 4;
//
   vv.TNz(28,0)= 4;
   vv.TNz(28,1)=13;
   vv.TNz(28,2)= 7;
   vv.TNz(29,0)= 2;
   vv.TNz(29,1)=14;
   vv.TNz(28,2)= 8;
   vv.TNz(30,0)= 1;
   vv.TNz(30,1)=16;
   vv.TNz(30,2)= 7;
   vv.TNz(31,0)= 1;
   vv.TNz(31,1)=13;
   vv.TNz(31,2)=10;
//
   vv.TNz(32,0)=12;
   vv.TNz(32,1)= 3;
   vv.TNz(32,2)= 9;
   vv.TNz(33,0)=10;
   vv.TNz(33,1)= 4;
   vv.TNz(33,2)=10;
   vv.TNz(34,0)= 9;
   vv.TNz(34,1)= 6;
   vv.TNz(34,2)= 9;
   vv.TNz(35,0)= 9;
   vv.TNz(35,1)= 3;
   vv.TNz(35,2)=12;
//
   vv.TNz(36,0)=10;
   vv.TNz(36,1)= 7;
   vv.TNz(36,2)= 7;
   vv.TNz(37,0)= 8;
   vv.TNz(37,1)= 8;
   vv.TNz(37,2)= 8;
   vv.TNz(38,0)= 7;
   vv.TNz(38,1)=10;
   vv.TNz(38,2)= 7;
   vv.TNz(39,0)= 7;
   vv.TNz(39,1)= 7;
   vv.TNz(39,2)=10;
//
   vv.TNz(40,0)= 6;
   vv.TNz(40,1)= 9;
   vv.TNz(40,2)= 9;
   vv.TNz(41,0)= 4;
   vv.TNz(41,1)=10;
   vv.TNz(41,2)=10;
   vv.TNz(42,0)= 3;
   vv.TNz(42,1)=12;
   vv.TNz(42,2)= 9;
   vv.TNz(43,0)= 3;
   vv.TNz(43,1)= 9;
   vv.TNz(43,2)=12;
//
   vv.TNz(44,0)=12;
   vv.TNz(44,1)= 9;
   vv.TNz(44,2)= 3;
   vv.TNz(45,0)=10;
   vv.TNz(45,1)=10;
   vv.TNz(45,2)= 4;
   vv.TNz(46,0)= 9;
   vv.TNz(46,1)=12;
   vv.TNz(46,2)= 3;
   vv.TNz(47,0)= 9;
   vv.TNz(47,1)= 9;
   vv.TNz(47,2)= 6;
//
   vv.TNz(48,0)=10;
   vv.TNz(48,1)= 1;
   vv.TNz(48,2)=13;
   vv.TNz(49,0)= 8;
   vv.TNz(49,1)= 2;
   vv.TNz(49,2)=14;
   vv.TNz(50,0)= 7;
   vv.TNz(50,1)= 4;
   vv.TNz(50,2)=13;
   vv.TNz(51,0)= 7;
   vv.TNz(51,1)= 1;
   vv.TNz(51,2)=16;
//
   vv.TNz(52,0)= 6;
   vv.TNz(52,1)= 3;
   vv.TNz(52,2)=15;
   vv.TNz(53,0)= 4;
   vv.TNz(53,1)= 4;
   vv.TNz(53,2)=16;
   vv.TNz(54,0)= 3;
   vv.TNz(54,1)= 6;
   vv.TNz(54,2)=15;
   vv.TNz(55,0)= 3;
   vv.TNz(55,1)= 3;
   vv.TNz(55,2)=18;
//
   vv.TNz(56,0)= 4;
   vv.TNz(56,1)= 7;
   vv.TNz(56,2)=13;
   vv.TNz(57,0)= 2;
   vv.TNz(57,1)= 8;
   vv.TNz(57,2)=14;
   vv.TNz(58,0)= 1;
   vv.TNz(58,1)=10;
   vv.TNz(58,2)=13;
   vv.TNz(59,0)= 1;
   vv.TNz(59,1)= 7;
   vv.TNz(59,2)=16;
//
   vv.TNz(60,0)= 4;
   vv.TNz(60,1)= 1;
   vv.TNz(60,2)=19;
   vv.TNz(61,0)= 2;
   vv.TNz(61,1)= 2;
   vv.TNz(61,2)=20;
   vv.TNz(62,0)= 1;
   vv.TNz(62,1)= 4;
   vv.TNz(62,2)=19;
   vv.TNz(63,0)= 1;
   vv.TNz(63,1)= 1;
   vv.TNz(63,2)=22;
//
//
// points on a unit sphere
//
   Coordinates n;
   double alp,bet,gam;
   for(int jF= 0;jF<20;jF++){
      for(int jT= 0;jT<64;jT++){
         n.zero();
         for(int iN=0;iN<3;iN++){
            n+=double( vv.TNz(jT,iN))*vv.Vn( vv.FNV(jF,iN));
         }
         n.normalize();
         FT(jF,jT).n=n;
         CT= n(2);
         ST= std::sqrt( (1.00) -CT*CT);
         if( ST>( 1.00e-12) ){
            CP= n(0)/ST;
            SP= n(1)/ST;
         }else{
            CP= (1.00);
            SP= (0.00);
         }
         alp= std::atan2(SP,CP);
         bet= std::atan2(ST,CT);
         FT(jF,jT).alp= alp;
         FT(jF,jT).bet= bet;
         FT(jF,jT).H.populate(array_consts, 7,CT,ST,CP,SP);
         gam= (0.00);
         FT(jF,jT).ROT=Rotation_Matrix(alp,bet,gam);
         alp=( alp +PI);
         bet=( PI -bet);
         double dgam= (PI/(32.00));
         gam= (-0.50)*dgam;
         for(int iJ= 0;iJ<64;iJ++){
            gam+=dgam;
            FT(jF,jT).JROT.push_back( Rotation_Matrix(alp,bet,gam));
         }
      }
   }
//
//
// grid points of [-180,180)x[  0,180]
//
   for(double a=(-179.50);a<( 180.00);a++){
      alp= (a*RAD);
      double Calp= std::cos( alp);
      double Salp= std::sin( alp);
      for(double b=(   0.50);b<( 180.00);b++){
         bet= (b*RAD);
         double Cbet= std::cos( bet);
         double Sbet= std::sin( bet);
         n(0)= Calp*Sbet;
         n(1)= Salp*Sbet;
         n(2)= Cbet;
         int pF=-1;
         int pT=-1;
         double z=(-1.00);
         for(int jF= 0;jF<20;jF++){
            for(int jT= 0;jT<64;jT++){
               double C= dot( n, FT(jF,jT).n);
               if( C> z ){
                  z= C;
                  pF=jF;
                  pT=jT;
               }
            }
         }
         tAB& ab=AB(a,b);
         ab.pF=pF;
         ab.pT=pT;
      }
   }
//
//
// diagnostic output
//
// out.FILE3<< std::fixed<< std::setprecision(3);
// out.FILE3<<" iF"" iT""            x         ""    alp  ""   bet  "<<'\n';
// for(int jF= 0;jF<20;jF++){
//    for(int jT= 0;jT<64;jT++){
//       out.FILE3<< std::setw( 3)<<jF
//                << std::setw( 3)<<jT<<' ';
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw( 7)<<FT(jF,jT).n(i);
//       }
//       out.FILE3<<' '<< std::setw( 8)<<(FT(jF,jT).alp/RAD)
//                     << std::setw( 8)<<(FT(jF,jT).bet/RAD)<<'\n';
//    }
// }
// out.FILE3<< std::fixed<< std::setprecision(1);
// out.FILE3<<"    a ""    b "" iF"" iT"<<'\n';
// for(double a=(-179.50);a<( 180.00);a++){
//    for(double b=(   0.50);b<( 180.00);b++){
//       tAB& ab=AB(a,b);
//       int pF=ab.pF;
//       int pT=ab.pT;
//       out.FILE3<< std::setw( 6)<<a
//                << std::setw( 6)<<b
//                << std::setw( 3)<<pF
//                << std::setw( 3)<<pT<<'\n';
//    }
// }
   return;
}
