#include "../pck/Packing_Search.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
//
//
// merge 2 (oU-1)-bod subsystems
//
bool Packing_Search::PCK_NDOC(Output_Streams& out,
                              int iY9,
                              int aY9,int aD9,int bY9,int bD9,
                              int pZ9,int lZ9,
                              int aX,int bX,
                              std::vector<int>& o_XZ9,
                              Coordinates& t,Coordinates& u,
                              Rotation_Matrix& r){
   Rotation_Matrix J;
   J(0,0)= ( 1.00);
   J(1,0)= ( 0.00);
   J(2,0)= ( 0.00);
   J(0,1)= ( 0.00);
   J(1,1)= (-1.00);
   J(2,1)= ( 0.00);
   J(0,2)= ( 0.00);
   J(1,2)= ( 0.00);
   J(2,2)= (-1.00);
//
//
// shared bod
//
   int gG9=U9[pU9].Y9[iY9].Z9[o_XZ9[ 1]].G9;
   int aQo(-1),bQo(-1);         //index of shared bod
   if      ( (aX== 0)&&(bX== 0) ){
      aQo=1;
      bQo=3;
   }else if( (aX== 0)&&(bX==(pU9- 2)) ){
      aQo=1;
      bQo=0;
   }else if( (aX==(pU9- 2))&&(bX== 0) ){
      aQo=0;
      bQo=1;
   }else if( (aX==(pU9- 2))&&(bX==(pU9- 2)) ){
      aQo=2;
      bQo=0;
   }
//
// t= pos of local axes for shared bod of (pU-1)-bod config a
// u=                   for                          config b
// P= local axes for shared bod of (pU-1)-bod config a
// Q=            for                          config b
// r= P=r*Q 
//
   t=Y9[aY9].D9[aD9].Q[aQo].t;
   u=Y9[bY9].D9[bD9].Q[bQo].t;
   Rotation_Matrix P=Y9[aY9].D9[aD9].Q[aQo].r;
   Rotation_Matrix Q=Y9[bY9].D9[bD9].Q[bQo].r;
   if( pU9== 3 ){
      Rotation_Matrix B;
      if      ( (aX== 0)&&(bX== 0) ){
         B=          J*Y9[aY9].D9[aD9].Z9[ 1].c
          *transpose(J*Y9[bY9].D9[bD9].Z9[ 1].c);
      }else if( (aX== 0)&&(bX==(pU9- 2)) ){
         B=          J*Y9[aY9].D9[aD9].Z9[ 1].c
          *transpose(  Y9[bY9].D9[bD9].Z9[ 0].c);
      }else if( (aX==(pU9- 2))&&(bX== 0) ){
         B=            Y9[aY9].D9[aD9].Z9[ 0].c
          *transpose(J*Y9[bY9].D9[bD9].Z9[ 1].c);
      }else if( (aX==(pU9- 2))&&(bX==(pU9- 2)) ){
         B=            Y9[aY9].D9[aD9].Z9[ 0].c
          *transpose(  Y9[bY9].D9[bD9].Z9[ 0].c);
      }
      P=B*P;
   }else{
   }
   r=P*transpose(Q);
//
//
// transform element endpoints for 2nd (pU- 1)-bod
//
   int iZ9=-1;
   int jZ9=-1;
   for(int gZ9= 0;gZ9<pU9;gZ9++){
      gG9=U9[pU9].Y9[iY9].Z9[gZ9].G9;
      if      ( gZ9==(pZ9  ) ){
         iZ9++;
         Z9[gZ9].c=Y9[aY9].D9[aD9].Z9[iZ9].c;
         Z9[gZ9].t=Y9[aY9].D9[aD9].Z9[iZ9].t;
      }else if( gZ9==(lZ9  ) ){
         jZ9++;
         Z9[gZ9].c=r*Y9[bY9].D9[bD9].Z9[jZ9].c;
         Z9[gZ9].t=( t +r*( Y9[bY9].D9[bD9].Z9[jZ9].t -u));
      }else{
         iZ9++;
         jZ9++;
         Rotation_Matrix T=( .50)*( Y9[aY9].D9[aD9].Z9[iZ9].c
                                   +(r*Y9[bY9].D9[bD9].Z9[jZ9].c));
         Coordinates c=T.euler();
         Z9[gZ9].c=Rotation_Matrix( c);
         Z9[gZ9].t=( .50)*( Y9[aY9].D9[aD9].Z9[iZ9].t
                           +( t +r*( Y9[bY9].D9[bD9].Z9[jZ9].t -u)));
      }
   }
   return false;
}
