#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_pck_nbod {
public:
   std::vector<char> o_Z9X;     //x position in config
   std::vector<Packing_Search::ePack> o_Z9e;    //e resolved wrt bod
   std::vector<int> o_Z9A;     //geom of dock to previous x
   std::vector<int> o_Z9B;     //geom of dock to following x
   std::vector<int> o_XZ9;      //inverse map of Z9X
   std::vector<int> o_Z9Z9;     //map of subset of bods to current set
   std::vector<int> o_Z9G9;     //map of subset to full set
   std::vector<int> o_Z9sub;    //map of current -subset to full set
public:
   Packing_Search::ePack e;      //energy of config
   MEM_pck_nbod(int o):
      o_Z9X(o),
      o_Z9e(o),
      o_Z9A(o),
      o_Z9B(o),
      o_XZ9(o),
      o_Z9Z9(o),
      o_Z9G9(o),
      o_Z9sub(o)
   {
   }
   char& Z9X(int i){
      return o_Z9X.at( i);  }
   Packing_Search::ePack& Z9e(int i){
      return o_Z9e.at( i);  }
   int& Z9A(int i){
      return o_Z9A.at( i);  }
   int& Z9B(int i){
      return o_Z9B.at( i);  }
   int& XZ9(int i){
      return o_XZ9.at( i);  }
   int& Z9Z9(int i){
      return o_Z9Z9.at( i);  }
   int& Z9G9(int i){
      return o_Z9G9.at( i);  }
   int& Z9sub(int i){
      return o_Z9sub.at( i);  }
};

bool Packing_Search::PCK_NBOD(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const DAT_ARRAY_CONSTS& array_consts,
         Output_Streams& out){
   double RAD= physics_consts.RAD;
   double PI= physics_consts.PI;
   double alp= ( -2.528);
//
//
// mean e of 2-bod contacts
//
   ePack e2;
   {
      int o=U9[ 2].oY9;
      for(int iY9=0;iY9<o;iY9++){
         e2+=U9[ 2].Y9[iY9].e;
      }
      e2/=double(o);
   }
//
//
// for each oZ-bod subsystem
//
   MEM_pck_nbod vv(pU9);
   oI9=U9[pU9].oY9;
   I9.clear();
   I9.resize(oI9);
   int jI9=-1;
   int qU9=(pU9- 1);
   int xD9=2048;
   bool EMPTY=true;
   oY9=U9[qU9].oY9;
   for(int iY9= 0;iY9<(oY9- 1);iY9++){
      for(int jY9=(iY9+ 1);jY9<oY9;jY9++){
         {
            int n=0;
            for(int iZ9= 0;iZ9<qU9;iZ9++){
               for(int jZ9= 0;jZ9<qU9;jZ9++){
                  if( U9[qU9].Y9[jY9].Z9[jZ9].G9==
                      U9[qU9].Y9[iY9].Z9[iZ9].G9 )n++;
               }
            }
            if( n<(qU9- 1) )continue;
         }
         {
            int pZ9=-1;
            for(int iZ9= 0;iZ9<qU9;iZ9++){
               bool MATCH=false;
               for(int jZ9= 0;jZ9<qU9&&(!MATCH);jZ9++){
                  if( U9[qU9].Y9[jY9].Z9[jZ9].G9==
                      U9[qU9].Y9[iY9].Z9[iZ9].G9 )MATCH=true;
               }
               if( !MATCH ){
                  pZ9=iZ9;
                  break;
               }
            }
            if( pZ9<(qU9- 1) )continue;
         }
         jI9++;
         I9[jI9].oZ9=pU9;
//
//       out.FILE3<<"GROUP OF "
//                <<std::setw( 2)<<qU9
//                <<"-BOD SUBSYSTEMS=(";
//       for(int jZ9= 0;jZ9<pU9;jZ9++){
//          out.FILE3<<std::setw( 4)<<U9[pU9].Y9[jI9].Z9[jZ9].Y9
//                   <<(( jZ9<qU9 )? ',': ')');
//          }
//       }
//       out.FILE3<<'\n';
//
//
// for each pair from group of contained (pU- 1)-bod subsystems
//
         int oD9=-1;
         for(int aZ9= 0;aZ9<(pU9- 1);aZ9++){
            int aY9=U9[pU9].Y9[jI9].Z9[aZ9].Y9;
            int oaD9=Y9[aY9].oD9;
            if( oaD9== 0 )continue;
            for(int bZ9=(aZ9+ 1);bZ9<pU9;bZ9++){
               int bY9=U9[pU9].Y9[jI9].Z9[bZ9].Y9;
               int obD9=Y9[bY9].oD9;
               if( obD9== 0 )continue;
//
               int pZ9=(pU9- 1-bZ9);
               int lZ9=(pU9- 1-aZ9);
               int pG9=U9[pU9].Y9[jI9].Z9[pZ9].G9;
               int lG9=U9[pU9].Y9[jI9].Z9[lZ9].G9;
//
//
// merge configs, disallow inconsistency
//
               int nD9=0;
               for(int aD9= 0;aD9<oaD9;aD9++){
                  int aX=Y9[aY9].D9[aD9].Z9[pZ9   ].X;
                  if( (aX!= 0)&&(aX!=(qU9- 1)) )continue;
                  for(int bD9= 0;bD9<obD9;bD9++){
                     int bX=Y9[bY9].D9[bD9].Z9[lZ9- 1].X;
                     if( (bX!= 0)&&(bX!=(qU9- 1)) )continue;
//
                     if( (aD9+bD9)>xD9 )continue;
                     bool CONSISTENT=true;
                     vv.e.zero();
                     int iZ9=-1;
                     int jZ9=-1;
                     for(int gZ9= 0;gZ9<pU9;gZ9++){
                        int gG9=U9[pU9].Y9[jI9].Z9[gZ9].G9;
                        if      ( gZ9==(pZ9  ) ){
                           iZ9++;
                           if      ( (aX== 0)&&(bX== 0) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                           }else if( (aX== 0)&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX== 0) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                           }
                           vv.Z9e(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].e;
//
                        }else if( gZ9==(lZ9  ) ){
                           jZ9++;
                           if      ( (aX== 0)&&(bX== 0) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                           }else if( (aX== 0)&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX== 0) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                           }
                           vv.Z9e(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].e;
//
                        }else{
                           iZ9++;
                           jZ9++;
                           if      ( (aX== 0)&&(bX== 0) ){
                              int iX=Y9[aY9].D9[aD9].Z9[iZ9].X;
                              int jX=(qU9-Y9[bY9].D9[bD9].Z9[jZ9].X);
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( iX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( jX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=iX;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }else if( iX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }
                           }else if( (aX== 0)&&(bX==(qU9- 1)) ){
                              int iX=Y9[aY9].D9[aD9].Z9[iZ9].X;
                              int jX=Y9[bY9].D9[bD9].Z9[jZ9].X+ 1;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( iX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( jX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=iX;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                              vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }else if( iX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }
                           }else if( (aX==(qU9- 1))&&(bX== 0) ){
                              int iX=Y9[aY9].D9[aD9].Z9[iZ9].X+ 1;
                              int jX=Y9[bY9].D9[bD9].Z9[jZ9].X;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( jX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( iX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=jX;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                              vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[aY9].D9[aD9].Z9[iZ9].e;
                              }else if( jX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              }
                           }else if( (aX==(qU9- 1))&&(bX==(qU9- 1)) ){
                              int iX=((qU9- 1)-Y9[aY9].D9[aD9].Z9[iZ9].X);
                              int jX=Y9[bY9].D9[bD9].Z9[jZ9].X+ 1;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( iX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( jX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=iX;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                              vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }else if( iX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }
                           }
                        }
                        vv.e+=vv.Z9e(gZ9);
                     }
                     if( !CONSISTENT )continue;
//
                     for(int gZ9= 0;gZ9<pU9;gZ9++){
                        vv.XZ9(vv.Z9X(gZ9))=gZ9;
                     }
//
//
// merge 2 (oU-1)-bod subsystems
//
                     Coordinates t,u;
                     Rotation_Matrix r;
//
// t= pos of local axes for shared bod of (pU-1)-bod config a
// u=                   for                          config b
// P= local axes for shared bod of (pU-1)-bod config a
// Q=            for                          config b
// r= P=r*Q 
//
                     if( PCK_NDOC(out,
                                  jI9,
                                  aY9,aD9,bY9,bD9,
                                  pZ9,lZ9,
                                  aX,bX,
                                  vv.o_XZ9,
                                  t,u,r)
                         )continue;
//
//
// params for surf match
//
                     int pC9=G9[pG9].oC9;
                     int pV9=G9[pG9].oV9;
                     for(int iC9= 0;iC9<pC9;iC9++){
                        G9[pG9].C9[iC9].x=G9[pG9].C9[iC9].b;
                     }
                     for(int iV9= 0;iV9<pV9;iV9++){
                        G9[pG9].V9[iV9].x=G9[pG9].V9[iV9].b;
                     }
                     Rotation_Matrix ROT=transpose(Z9[pZ9].c)*Z9[lZ9].c;
                     x=transpose(Z9[pZ9].c)*( Z9[lZ9].t -Z9[pZ9].t);
                     R=x.r();
                     int pF(-1),pT(-1);
                     {
                        Coordinates n=((1.00)/R)*x;
                        CT= n(2);
                        double STST=( (1.00) -CT*CT);
                        if( STST<( 1.00e-25) )STST=( 1.00e-25);
                        ST= std::sqrt( STST);
                        if( ST>(1.00e-12) ){
                           CP= n(0)/ST;
                           SP= n(1)/ST;
                        }else{
                           CP= (1.00);
                           SP= (0.00);
                        }
                        double alp= std::atan2(SP,CP)/RAD;
                        double bet= std::atan2(ST,CT)/RAD;
                        tAB& pab=AB( alp, bet);
                        int pF=pab.pF;
                        int pT=pab.pT;
                     }
                     Coordinates TRANS1=( G9[pG9].FT(pF,pT).x -G9[pG9].x);
                     int pFs=G9[pG9].FT(pF,pT).kF;
                     int pTs=G9[pG9].FT(pF,pT).kT;
                     int lF(-1),lT(-1),iJ(-1);
                     {
                        Rotation_Matrix ROT1=FT(pF,pT).ROT;
                        Rotation_Matrix ROT2=ROT1*ROT;
                        Coordinates k=ROT2.euler();
                        double alp=( k(0)<( 0.00) )?( k(0) +PI):( k(0) -PI);
                        double bet=( PI -k(1));
                        double gam=( k(2)<( 0.00) )?( k(2) +(2.00)*PI): k(2);
                        tAB& lab=AB( alp/RAD, bet/RAD);
                        int lF=lab.pF;
                        int lT=lab.pT;
                        double dgam= (PI/(32.00));
                        int iJ=int( std::floor( gam/dgam));
                        if( iJ==64 )iJ=63;
                     }
                     Coordinates TRANS2=( G9[lG9].FT(lF,lT).x -G9[lG9].x);
                     int lFs=G9[lG9].FT(lF,lT).kF;
                     int lTs=G9[lG9].FT(lF,lT).kT;
                     for(int iC=0;iC<3;iC++){
                        Cq1[iC].populate( 7,G9[pG9].FT(pF,pT).C(iC).q);
                     }
                     for(int iC9= 0;iC9<pC9;iC9++){
                        Coordinates b=G9[pG9].C9[iC9].b;
                        b-=TRANS1;
                        double r= b.r();
                        double C= dot(b,FT(pFs,pTs).n)/r;
                        double the= std::acos( C);
                        G9[pG9].C9[iC9].f= std::exp( alp*the*the);
                        G9[pG9].C9[iC9].PASS=( the>(( .50)*PI) );
                     }
                     for(int iC=0;iC<3;iC++){
                        Cq2[iC].populate( 7,G9[lG9].FT(lF,lT).C(iC).Jq(iJ));
                     }
                     int lC9=G9[lG9].oC9;
                     for(int iC9= 0;iC9<lC9;iC9++){
                        Coordinates b=G9[lG9].C9[iC9].b;
                        G9[lG9].C9[iC9].x.generate(x,ROT,b);
                        b-=TRANS2;
                        double r= b.r();
                        double C= dot(b,FT(lFs,lTs).n)/r;
                        double the= std::acos( C);
                        G9[lG9].C9[iC9].f= std::exp( alp*the*the);
                        G9[lG9].C9[iC9].PASS=( the>(( .50)*PI) );
                     }
                     for(int iB=0;iB<6;iB++){
                        for(int iX=0;iX<4;iX++){
                           for(int N=0;N<8;N++){
                              BXNs(iB,iX,N)=G9[pG9].FT(pF,pT).B(iB).XNs(iX,N);
                           }
                        }
                     }
                     for(int iB=0;iB<6;iB++){
                        for(int iX=0;iX<4;iX++){
                           BXs(iB,iX)=G9[lG9].FT(lF,lT).B(iB).JXs(iJ,iX);
                        }
                     }
//
//
// lattice energy of reduced model
//
                     bool OVERLAP=PCK_F(physics_consts,array_consts,out,
                                        pG9,lG9,pF,pT,lF,lT,ROT,
                                        pU9,e2);
                     if( OVERLAP )continue;
                     ePack de(Fe,Fm,Fs,Fh,Fp,Fi,Fd);
                     vv.e+=de;
                     de/=double(pU9);
                     for(int gZ9= 0;gZ9<pU9;gZ9++){
                        vv.Z9e(gZ9)+=de;
                     }
                     Ftot= vv.e.Ftot;
//
//
// characterization of packed config
//
                     if( Ftot>( 0.00) )continue;
                     nD9++;
                     if( oD9<8191 ){
                        I9[jI9].D9.push_back( tY9::tY9D9());
                        oD9++;
                        I9[jI9].D9[oD9].Z9.resize(pU9);
                     }else{
                        if( Ftot>=I9[jI9].D9[oD9].e.Ftot )continue;
                     }
                     I9[jI9].D9[oD9].e=vv.e;
                     for(int gZ9= 0;gZ9<pU9;gZ9++){
                        I9[jI9].D9[oD9].Z9[gZ9].X=vv.Z9X(gZ9);
                        I9[jI9].D9[oD9].Z9[gZ9].e=vv.Z9e(gZ9);
                        I9[jI9].D9[oD9].Z9[gZ9].A=vv.Z9A(gZ9);
                        I9[jI9].D9[oD9].Z9[gZ9].B=vv.Z9B(gZ9);
                        I9[jI9].D9[oD9].Z9[gZ9].c=Z9[gZ9].c;
                        I9[jI9].D9[oD9].Z9[gZ9].t=Z9[gZ9].t;
                     }
                     Coordinates& ta0=Y9[aY9].D9[aD9].Q[ 0].t;
                     Coordinates& ta1=Y9[aY9].D9[aD9].Q[ 1].t;
                     Coordinates& ta2=Y9[aY9].D9[aD9].Q[ 2].t;
                     Coordinates& ta3=Y9[aY9].D9[aD9].Q[ 3].t;
                     Rotation_Matrix& ra0=Y9[aY9].D9[aD9].Q[ 0].r;
                     Rotation_Matrix& ra1=Y9[aY9].D9[aD9].Q[ 1].r;
                     Rotation_Matrix& ra2=Y9[aY9].D9[aD9].Q[ 2].r;
                     Rotation_Matrix& ra3=Y9[aY9].D9[aD9].Q[ 3].r;
                     Coordinates tb0=( t +r*( Y9[bY9].D9[bD9].Q[ 0].t -u));
                     Coordinates tb1=( t +r*( Y9[bY9].D9[bD9].Q[ 1].t -u));
                     Coordinates tb2=( t +r*( Y9[bY9].D9[bD9].Q[ 2].t -u));
                     Coordinates tb3=( t +r*( Y9[bY9].D9[bD9].Q[ 3].t -u));
                     Rotation_Matrix rb0=(r*Y9[bY9].D9[bD9].Q[ 0].r);
                     Rotation_Matrix rb1=(r*Y9[bY9].D9[bD9].Q[ 1].r);
                     Rotation_Matrix rb2=(r*Y9[bY9].D9[bD9].Q[ 2].r);
                     Rotation_Matrix rb3=(r*Y9[bY9].D9[bD9].Q[ 3].r);
                     if( pU9== 3 ){
                        if      ( (aX== 0)&&(bX== 0) ){
                           I9[jI9].D9[oD9].Q[ 0].r=ra0;
                           I9[jI9].D9[oD9].Q[ 1].r=rb1;
                           I9[jI9].D9[oD9].Q[ 2].r=ra1;
                           I9[jI9].D9[oD9].Q[ 3].r=rb0;
                           I9[jI9].D9[oD9].Q[ 0].t=ta0;
                           I9[jI9].D9[oD9].Q[ 1].t=tb1;
                           I9[jI9].D9[oD9].Q[ 2].t=ta1;
                           I9[jI9].D9[oD9].Q[ 3].t=tb0;
                        }else if( (aX== 0)&&(bX==(pU9- 2)) ){
                           I9[jI9].D9[oD9].Q[ 0].r=ra0;
                           I9[jI9].D9[oD9].Q[ 1].r=rb0;
                           I9[jI9].D9[oD9].Q[ 2].r=ra1;
                           I9[jI9].D9[oD9].Q[ 3].r=rb1;
                           I9[jI9].D9[oD9].Q[ 0].t=ta0;
                           I9[jI9].D9[oD9].Q[ 1].t=tb0;
                           I9[jI9].D9[oD9].Q[ 2].t=ta1;
                           I9[jI9].D9[oD9].Q[ 3].t=tb1;
                        }else if( (aX==(pU9- 2))&&(bX== 0) ){
                           I9[jI9].D9[oD9].Q[ 0].r=rb0;
                           I9[jI9].D9[oD9].Q[ 1].r=ra0;
                           I9[jI9].D9[oD9].Q[ 2].r=rb1;
                           I9[jI9].D9[oD9].Q[ 3].r=ra1;
                           I9[jI9].D9[oD9].Q[ 0].t=tb0;
                           I9[jI9].D9[oD9].Q[ 1].t=ta0;
                           I9[jI9].D9[oD9].Q[ 2].t=tb1;
                           I9[jI9].D9[oD9].Q[ 3].t=ta1;
                        }else if( (aX==(pU9- 2))&&(bX==(pU9- 2)) ){
                           I9[jI9].D9[oD9].Q[ 0].r=ra1;
                           I9[jI9].D9[oD9].Q[ 1].r=rb0;
                           I9[jI9].D9[oD9].Q[ 2].r=ra0;
                           I9[jI9].D9[oD9].Q[ 3].r=rb1;
                           I9[jI9].D9[oD9].Q[ 0].t=ta1;
                           I9[jI9].D9[oD9].Q[ 1].t=tb0;
                           I9[jI9].D9[oD9].Q[ 2].t=ta0;
                           I9[jI9].D9[oD9].Q[ 3].t=tb1;
                        }
                     }else{
                        if      ( (aX== 0)&&(bX== 0) ){
                           I9[jI9].D9[oD9].Q[ 0].r=ra0;
                           I9[jI9].D9[oD9].Q[ 1].r=ra1;
                           I9[jI9].D9[oD9].Q[ 2].r=rb1;
                           I9[jI9].D9[oD9].Q[ 3].r=rb0;
                           I9[jI9].D9[oD9].Q[ 0].t=ta0;
                           I9[jI9].D9[oD9].Q[ 1].t=ta1;
                           I9[jI9].D9[oD9].Q[ 2].t=tb1;
                           I9[jI9].D9[oD9].Q[ 3].t=tb0;
                        }else if( (aX== 0)&&(bX==(pU9- 2)) ){
                           I9[jI9].D9[oD9].Q[ 0].r=ra0;
                           I9[jI9].D9[oD9].Q[ 1].r=ra1;
                           I9[jI9].D9[oD9].Q[ 2].r=rb2;
                           I9[jI9].D9[oD9].Q[ 3].r=rb3;
                           I9[jI9].D9[oD9].Q[ 0].t=ta0;
                           I9[jI9].D9[oD9].Q[ 1].t=ta1;
                           I9[jI9].D9[oD9].Q[ 2].t=tb2;
                           I9[jI9].D9[oD9].Q[ 3].t=tb3;
                        }else if( (aX==(pU9- 2))&&(bX== 0) ){
                           I9[jI9].D9[oD9].Q[ 0].r=rb0;
                           I9[jI9].D9[oD9].Q[ 1].r=rb1;
                           I9[jI9].D9[oD9].Q[ 2].r=ra2;
                           I9[jI9].D9[oD9].Q[ 3].r=ra3;
                           I9[jI9].D9[oD9].Q[ 0].t=tb0;
                           I9[jI9].D9[oD9].Q[ 1].t=tb1;
                           I9[jI9].D9[oD9].Q[ 2].t=ta2;
                           I9[jI9].D9[oD9].Q[ 3].t=ta3;
                        }else if( (aX==(pU9- 2))&&(bX==(pU9- 2)) ){
                           I9[jI9].D9[oD9].Q[ 0].r=ra3;
                           I9[jI9].D9[oD9].Q[ 1].r=ra2;
                           I9[jI9].D9[oD9].Q[ 2].r=rb2;
                           I9[jI9].D9[oD9].Q[ 3].r=rb3;
                           I9[jI9].D9[oD9].Q[ 0].t=ta3;
                           I9[jI9].D9[oD9].Q[ 1].t=ta2;
                           I9[jI9].D9[oD9].Q[ 2].t=tb2;
                           I9[jI9].D9[oD9].Q[ 3].t=tb3;
                        }
                     }
//
//
// maintain order
//
                     for(int jD9=oD9;jD9> 0;jD9--){
                        if( I9[jI9].D9[jD9   ].e.Ftot>=
                            I9[jI9].D9[jD9- 1].e.Ftot )break;
                        I9[jI9].D9[jD9   ].swap(
                        I9[jI9].D9[jD9- 1]);
                     }
//
                  }
               }
//
//
//
//
            }
         }
         oD9++;
         I9[jI9].oD9=oD9;
         if( oD9> 0 ){
            EMPTY=false;
         }else{
            continue;
         }
      }
   }
//
//
// transfer I9 from Y9 to enable recursion
//
   Y9.clear();
   Y9.resize(oI9);
   for(int jI9= 0;jI9<oI9;jI9++){
      Y9[jI9]=I9[jI9];
   }
   oY9=oI9;
//
//
// partial config backup
//
   for(int iY9= 0;iY9<oY9;iY9++){
      if( Y9[iY9].oD9>0 ){
         U9[pU9].Y9[iY9]=Y9[iY9].D9[ 0];
      }else{
      }
   }
//
//
// factorization
//
   for(int pY9= 0;pY9<oY9;pY9++){
      if( !U9[pU9].Y9[pY9].STABLE )continue;
      ePack e=U9[pU9].Y9[pY9].e;
      double zde( 0.00);
      int aU9(-1),aY9(-1),bU9(-1),bY9(-1);
      for(int iU9= 2;iU9<=(pU9/2);iU9++){
         int jU9=(pU9-iU9);
         int iZ9= 0;
         vv.Z9Z9(iZ9)=-1;
         while( true ){
            vv.Z9Z9(iZ9)++;
            if( vv.Z9Z9(iZ9)>(jU9+iZ9) ){
               if( iZ9== 0 ){
                  break;
               }else{
                  iZ9--;
                  continue;
               }
//
            }else{
               vv.Z9G9(iZ9)=U9[pU9].Y9[pY9].Z9[vv.Z9Z9(iZ9)].G9;
               if( iZ9==(iU9- 1) ){
//
//
// indexes of iU and jU-bod subsystems
//
                  int iY9=(U9[iU9].oY9- 1);
                  int jY9=(U9[jU9].oY9- 1);
                  for(int jZ9= 0;jZ9<pU9;jZ9++){
                     vv.Z9sub(jZ9)=U9[pU9].Y9[pY9].Z9[jZ9].G9;
                  }
                  for(int jZ9= 0;jZ9<iU9;jZ9++){
                     vv.Z9sub(vv.Z9Z9(jZ9))=-1;
                     int n=(oG9- 1-vv.Z9G9(jZ9));
                     int i=(iU9-jZ9);
                     if( i>n )continue;
                     iY9-=( array_consts.FAC[n  ]/
                           (array_consts.FAC[n-i]*array_consts.FAC[i  ])
                            );
                  }
                  if( !U9[iU9].Y9[iY9].STABLE )continue;
                  int jZ9=-1;
                  for(int kZ9= 0;kZ9<pU9;kZ9++){
                     if( vv.Z9sub(kZ9)==-1 )continue;
                     jZ9++;
                     int n=(oG9- 1-vv.Z9sub(kZ9));
                     int i=(jU9-jZ9);
                     if( i>n )continue;
                     jY9-=( array_consts.FAC[n  ]/
                           (array_consts.FAC[n-i]*array_consts.FAC[i  ])
                            );
                  }
                  if( !U9[jU9].Y9[jY9].STABLE )continue;
//
//
// maintain optimal partition
//
                  double de=( ( .40)*U9[iU9].Y9[iY9].e.Ftot
                             +( .40)*U9[jU9].Y9[jY9].e.Ftot
                             -e.Ftot);
                  if( de>zde ){
                     zde= de;
                     aU9=iU9;
                     aY9=iY9;
                     bU9=jU9;
                     bY9=jY9;
                  }
               }else{
                  iZ9++;
                  vv.Z9Z9(iZ9   )=vv.Z9Z9(iZ9- 1);
               }
//
            }
         }
      }
//
//
// diagnostic output
//
      if( aU9>-1 ){
         U9[pU9].Y9[pY9].STABLE=false;
         Y9[pY9].oD9=0;
         U9[aU9].Y9[aY9].FACTOR=true;
         U9[bU9].Y9[bY9].FACTOR=true;
      }
   }
   return EMPTY;
}
