#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include <string>
#include <iostream>
#include <cstdlib>

void Packing_Search::PCK_MOL(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const DAT_ENERGY_PARAMS& energy_params,
         Dielec_Continu& med,
         const Mechanical_System& mol,
         const Subset_Contracted_System::tM3& con,
         const Conf_Dependent_System& dep){
   double ANG= physics_consts.ANG;
   med.nA5=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int lte=con.F2[iF2].lte;
         int iT2=con.F2[iF2].typ;
         if( (lte<0)||(iT2>17) ){
         }else{
            med.A5[med.nA5].atm=con.F2[iF2].atm;
            med.A5[med.nA5].lte=lte;
            med.A5[med.nA5].typ=iT2;
            med.A5[med.nA5].x=F2[iF2].x;
            med.A5[med.nA5].q=F2[iF2].q;
            if( con.F2[iF2].ion ){
               med.A5[med.nA5].q.r(0,0)-=(1.375)*con.F2[iF2].off;
            }
            med.A5[med.nA5].r= energy_params.T2[iT2].Rsph;
            med.A5[med.nA5].r-=( .25)/ANG;
            int iR0=con.F2[iF2].R0;
            char c1=mol.R0[iR0].c1;
            std::string aa=mol.R0[iR0].aa;
            std::string ab=mol.R0[iR0].aa;
            if( c1=='a' ){
               if( (ab[0]=='e')||
                   (ab[0]=='z') )ab=ab.substr(1,3)+' ';
               if( (ab[3]=='e')||
                   (ab[3]=='z') )ab=ab.substr(0,3)+' ';
            }
            std::string atm=con.F2[iF2].atm;
//          if      ( c1=='a' ){
//             if      ( ab=="LYS " ){
//                if( (atm==" NZ ")||
//                    (atm=="1HZ ")||
//                    (atm=="2HZ ")||
//                    (atm=="3HZ ") ){
//                   med.A5[med.nA5].r+=( .25)/ANG;
//                }
//             }else if( ab=="ARG " ){
//                if( (atm==" NE ")||
//                    (atm==" HE ")||
//                    (atm==" NH1")||
//                    (atm=="1HH1")||
//                    (atm=="2HH1")||
//                    (atm==" NH2")||
//                    (atm=="1HH2")||
//                    (atm=="2HH2") ){
//                   med.A5[med.nA5].r+=( .25)/ANG;
//                }
//             }else if( ab=="ORN " ){
//                if( (atm==" NE ")||
//                    (atm=="1HE ")||
//                    (atm=="2HE ")||
//                    (atm=="3HE ") ){
//                   med.A5[med.nA5].r+=( .25)/ANG;
//                }
//             }else if( aa[0]=='e' ){
//                if( (atm==" N  ")||
//                    (atm=="1H  ")||
//                    (atm=="2H  ")||
//                    (atm=="3H  ") ){
//                   med.A5[med.nA5].r+=( .20)/ANG;
//                }
//             }else if( (ab=="SEP ")||(ab=="THP ")||(ab=="TYP ") ){
//                if( (atm==" P  ")||
//                    (atm==" O1P")||
//                    (atm==" O2P")||
//                    (atm==" O3P") ){
//                   med.A5[med.nA5].r+=( .40)/ANG;
//                }
//             }
//          }else if( c1=='e' ){
//          }else if( c1=='r' ){
//          }else if( c1=='b' ){
//          }else if( c1=='p' ){
//             if      ( aa=="PO  " ){
//                if( (atm==" O3'")||
//                    (atm==" P  ")||
//                    (atm==" O1P")||
//                    (atm==" O2P") ){
//                   med.A5[med.nA5].r+=( .20)/ANG;
//                }
//             }else if( aa=="PSR " ){
//                if( (atm==" O3'")||
//                    (atm==" P  ")||
//                    (atm==" O1P")||
//                    (atm==" S2P") ){
//                   med.A5[med.nA5].r+=( .10)/ANG;
//                }
//             }else if( aa=="PSS " ){
//                if( (atm==" O3'")||
//                    (atm==" P  ")||
//                    (atm==" S1P")||
//                    (atm==" O2P") ){
//                   med.A5[med.nA5].r+=( .10)/ANG;
//                }
//             }else if( (aa=="5PO ")||(aa=="3PO ") ){
//                if( (atm==" P  ")||
//                    (atm==" O1P")||
//                    (atm==" O2P")||
//                    (atm==" O3P") ){
//                   med.A5[med.nA5].r+=( .40)/ANG;
//                }
//             }
//          }else if( c1=='s' ){
//          }
            med.A5[med.nA5].bur=dep.F2[iF2].bur;
            if( iT2== 7 ){
               bool MATCHED=false;
               for(int jB3=mB3;jB3<iB3;jB3++){
                  int jF2=con.B3[jB3].F2;
                  double zz=( F2[jF2].x -F2[iF2].x).rr();
                  if( zz<( 1.00e-8) ){
                     int jA5=med.F2[jF2].A5;
                     med.A5[med.nA5].F2=jF2;
                     med.A5[med.nA5].A5=jA5;
                     med.F2[iF2].A5=jA5;
                     med.A5[jA5].F2=iF2;
                     med.A5[jA5].A5=med.nA5;
                     med.F2[jF2].A5=med.nA5;
                     MATCHED=true;
                     break;
                  }
               }
               if( !MATCHED ){
                  std::cerr<<"ERROR: No match for satellite "
                             "interaction site to physical atom.\n";
                  std::exit( 2);
               }
            }else{
               med.A5[med.nA5].F2=iF2;
               med.A5[med.nA5].A5=med.nA5;
               med.F2[iF2].A5=med.nA5;
            }
            med.A5[med.nA5].Q2=mQ2;
            A5[med.nA5].Z0=iZ0;
            A5[med.nA5].R0=con.F2[iF2].R0;
            med.nA5++;
         }
      }
      if( nQ2>mQ2 ){
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int pF2=con.Q2[iQ2].bseF2;
            int pA5=med.F2[pF2].A5;
            std::string sat='+'+con.F2[pF2].atm.substr(1,3);
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int lte=con.F2[iF2].lte;
               int iT2=con.F2[iF2].typ;
               if( (lte<0)||(iT2>17) ){
               }else{
                  med.A5[med.nA5].atm=con.F2[iF2].atm;
                  med.A5[med.nA5].lte=lte;
                  med.A5[med.nA5].typ=iT2;
                  med.A5[med.nA5].x=F2[iF2].x;
                  med.A5[med.nA5].q=F2[iF2].q;
                  if( con.F2[iF2].ion ){
                     med.A5[med.nA5].q.r(0,0)-=(1.375)*con.F2[iF2].off;
                  }
                  med.A5[med.nA5].r= energy_params.T2[iT2].Rsph;
                  med.A5[med.nA5].r-=( .25)/ANG;
                  int iR0=con.F2[iF2].R0;
                  char c1=mol.R0[iR0].c1;
                  std::string aa=mol.R0[iR0].aa;
                  std::string ab=mol.R0[iR0].aa;
//                if( c1=='a' ){
//                   if( (ab[0]=='e')||
//                       (ab[0]=='z') )ab=ab.substr(1,3)+' ';
//                   if( (ab[3]=='e')||
//                       (ab[3]=='z') )ab=ab.substr(0,3)+' ';
//                }
//                std::string atm=con.F2[iF2].atm;
//                if      ( c1=='a' ){
//                   if      ( ab=="LYS " ){
//                      if( (atm==" NZ ")||
//                          (atm=="1HZ ")||
//                          (atm=="2HZ ")||
//                          (atm=="3HZ ") ){
//                         med.A5[med.nA5].r+=( .25)/ANG;
//                      }
//                   }else if( ab=="ARG " ){
//                      if( (atm==" NE ")||
//                          (atm==" HE ")||
//                          (atm==" NH1")||
//                          (atm=="1HH1")||
//                          (atm=="2HH1")||
//                          (atm==" NH2")||
//                          (atm=="1HH2")||
//                          (atm=="2HH2") ){
//                         med.A5[med.nA5].r+=( .25)/ANG;
//                      }
//                   }else if( ab=="ORN " ){
//                      if( (atm==" NE ")||
//                          (atm=="1HE ")||
//                          (atm=="2HE ")||
//                          (atm=="3HE ") ){
//                         med.A5[med.nA5].r+=( .25)/ANG;
//                      }
//                   }else if( aa[0]=='e' ){
//                      if( (atm==" N  ")||
//                          (atm=="1H  ")||
//                          (atm=="2H  ")||
//                          (atm=="3H  ") ){
//                         med.A5[med.nA5].r+=( .20)/ANG;
//                      }
//                   }else if( (ab=="SEP ")||(ab=="THP ")||(ab=="TYP ") ){
//                      if( (atm==" P  ")||
//                          (atm==" O1P")||
//                          (atm==" O2P")||
//                          (atm==" O3P") ){
//                         med.A5[med.nA5].r+=( .40)/ANG;
//                      }
//                   }
//                }else if( c1=='e' ){
//                }else if( c1=='r' ){
//                }else if( c1=='b' ){
//                }else if( c1=='p' ){
//                   if      ( aa=="PO  " ){
//                      if( (atm==" O3'")||
//                          (atm==" P  ")||
//                          (atm==" O1P")||
//                          (atm==" O2P") ){
//                         med.A5[med.nA5].r+=( .20)/ANG;
//                      }
//                   }else if( aa=="PSR " ){
//                      if( (atm==" O3'")||
//                          (atm==" P  ")||
//                          (atm==" O1P")||
//                          (atm==" S2P") ){
//                         med.A5[med.nA5].r+=( .10)/ANG;
//                      }
//                   }else if( aa=="PSS " ){
//                      if( (atm==" O3'")||
//                          (atm==" P  ")||
//                          (atm==" S1P")||
//                          (atm==" O2P") ){
//                         med.A5[med.nA5].r+=( .10)/ANG;
//                      }
//                   }else if( (aa=="5PO ")||(aa=="3PO ") ){
//                      if( (atm==" P  ")||
//                          (atm==" O1P")||
//                          (atm==" O2P")||
//                          (atm==" O3P") ){
//                         med.A5[med.nA5].r+=( .40)/ANG;
//                      }
//                   }
//                }else if( c1=='s' ){
//                }
                  med.A5[med.nA5].bur=dep.F2[iF2].bur;
                  if( iT2== 7 ){
                     if( con.F2[iF2].atm==sat ){
                        med.A5[med.nA5].F2=pF2;
                        med.A5[med.nA5].A5=pA5;
                        med.F2[iF2].A5=pA5;
                        med.A5[med.nA5].Q2=med.A5[pA5].Q2;
                        med.A5[pA5].F2=iF2;
                        med.A5[pA5].A5=med.nA5;
                        med.F2[pF2].A5=med.nA5;
                        med.A5[pA5].Q2=iQ2;
                        sat="    ";
                     }else{
                        bool MATCHED=false;
                        for(int jG3=mG3;jG3<iG3;jG3++){
                           int jF2=con.G3[jG3].F2;
                           double zz=( F2[jF2].x -F2[iF2].x).rr();
                           if( zz<( 1.00e-8) ){
                              int jA5=med.F2[jF2].A5;
                              med.A5[med.nA5].F2=jF2;
                              med.A5[med.nA5].A5=jA5;
                              med.F2[iF2].A5=jA5;
                              med.A5[jA5].F2=iF2;
                              med.A5[jA5].A5=med.nA5;
                              med.F2[jF2].A5=med.nA5;
                              med.A5[med.nA5].Q2=iQ2;
                              MATCHED=true;
                              break;
                           }
                        }
                        if( !MATCHED ){
                           std::cerr<<"ERROR: No match for satellite "
                                      "interaction site to physical atom.\n";
                           std::exit( 2);
                        }
                     }
                  }else{
                     med.A5[med.nA5].F2=iF2;
                     med.A5[med.nA5].A5=med.nA5;
                     med.A5[med.nA5].Q2=iQ2;
                     med.F2[iF2].A5=med.nA5;
                  }
                  A5[med.nA5].Z0=iZ0;
                  A5[med.nA5].R0=con.F2[iF2].R0;
                  med.nA5++;
               }
            }
         }
      }
   }
   return;
}
