#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <vector>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_pck_ico {
private:
   std::vector<bool> o_DOTsub;          //subset of dots cavity or cleft
   std::vector<Coordinates> o_R0x;      //center of nonpolar atoms (bohr)
   std::vector<int> o_R0n;              //number
   std::vector<int> o_R0m;              //number on surf
   int oR0;                             //
   std::vector<bool> o_R0R0sub;         //contact is possible for sc pair
   std::vector<bool> o_R0sub;           //sc is contained in packing unit
   std::vector<int> o_R0I3a;            //start index of sc contacts
   std::vector<int> o_R0cI3;            //number of sc contacts
   std::vector<int> o_R0I3b;            //start of higher index sc contacts
   std::vector<int> o_R0dI3;            //number of lower index sc contacts
   std::vector<int> o_XiR0;             //packing unit of size oX
public:
   std::vector<int> o_I3R0;             //mapping to index of sc
   MEM_pck_ico(int o,int r):
      o_DOTsub(o, true),
      o_R0x(r),
      o_R0n(r),
      o_R0m(r),
      oR0(r),
      o_R0R0sub(r*r,false),
      o_R0sub(r),
      o_R0I3a(r),
      o_R0cI3(r, 0),
      o_R0I3b(r),
      o_R0dI3(r, 0),
      o_XiR0(12)
   {
   }
   void DOTsub(int i,bool a){
      o_DOTsub[ i]=a;  }
   bool DOTsub(int i){
      return o_DOTsub[ i];  }
   Coordinates& R0x(int i){
      return o_R0x.at( i);  }
   int& R0n(int i){
      return o_R0n.at( i);  }
   int& R0m(int i){
      return o_R0m.at( i);  }
   void R0R0sub(int i,int j,bool a){
      o_R0R0sub[ i*oR0 +j]=a;  }
   bool R0R0sub(int i,int j){
      return o_R0R0sub[ i*oR0 +j];  }
   void R0sub(int i,bool a){
      o_R0sub[ i]=a;  }
   bool R0sub(int i){
      return o_R0sub[ i];  }
   int& R0I3a(int i){
      return o_R0I3a.at( i);  }
   int& R0cI3(int i){
      return o_R0cI3.at( i);  }
   int& R0I3b(int i){
      return o_R0I3b.at( i);  }
   int& R0dI3(int i){
      return o_R0dI3.at( i);  }
   int& XiR0(int i){
      return o_XiR0.at( i);  }
   int& I3R0(int i){
      return o_I3R0.at( i);  }
};

void Packing_Search::PCK_ICO(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const DAT_ARRAY_CONSTS& array_consts,
         const DAT_DISULFIDE_LINKS& disulfide_links,
         const DAT_ENERGY_PARAMS& energy_params,
         const DAT_REGION_MAPS& region_maps,
         const DAT_RESIDUE_MAPPINGS& residue_mappings,
         const Thread_Options& opt,
         Output_Streams& out){

   double ANG= physics_consts.ANG;
   double ANGANG= ANG*ANG;
   double RAD= physics_consts.RAD;
//
// std::string MOL=G9[ 0].bod.substr( 0, 4);
// std::string filename1="../../dock/car/x"+MOL+".pdb";
// std::ofstream ofile1(filename1.c_str());
// ofile1<< std::fixed<< std::setprecision( 3);
// std::string filename2="../../dock/car/d"+MOL+".pdb";
// std::ofstream ofile2(filename2.c_str());
// ofile2<< std::fixed<< std::setprecision( 3);
// int ii=0;
   for(int iG9= 0;iG9<oG9;iG9++){
      const Structure& str=G9[iG9].str;
//
//
// construct mechanical system
//
      Search_Subspace sub;
      Distance_Constraints dst(physics_consts,residue_mappings,
                               opt,out,str,sub);

      int oZ0=str.nZ0;
      int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
      int oQ1=oZ0;
      int oU1=0;
      int oF1=0;
      int oB1=0;
      int oG1=0;
      int oH1=0;
      int oJ1=0;
      int oY1=0;
      for(int iR0= 0;iR0<oR0;iR0++){
         int iL0=str.R0[iR0].L0;
         oQ1+=residue_mappings.L0[iL0].cQ0;
         oU1+=residue_mappings.L0[iL0].cU0;
         oF1+=residue_mappings.L0[iL0].cF0;
         oB1+=residue_mappings.L0[iL0].cB0;
         oG1+=residue_mappings.L0[iL0].cG0;
         oH1+=residue_mappings.L0[iL0].cH0;
         oJ1+=residue_mappings.L0[iL0].cJ0;
         oY1+=residue_mappings.L0[iL0].cY0;
      }
      Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
      Subset_Contracted_System col(disulfide_links,residue_mappings,
                                   opt,str,sub);
      Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
      mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
              opt,str,out,dst,col,dep);
      mol.CON(physics_consts,array_consts,energy_params,
              region_maps,
              opt,out,col,dep);
      Subset_Contracted_System::tM3& con=col.M3[ 0];
      int oQ2=con.oQ2;
      int oF2=con.oF2;
      int oA5=con.oA5;
//
//
// resize molecule specific vectors
//
      F2.resize(oF2);
      Q2.resize(oQ2);
      A5.resize(oA5);
//
//
// calc F2[].x and F2[].q
//
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

         Coordinates TRANS=dep.Z0[iZ0].trans;
         double alp= dep.Z0[iZ0].rot(0);
         double bet= dep.Z0[iZ0].rot(1);
         double gam= dep.Z0[iZ0].rot(2);
         Rotation_Matrix ROT(alp,bet,gam);
         Q2[mQ2].c=ROT;
         int mB3=con.Z0[iZ0].B3a;
         int nB3=(mB3-1+con.Z0[iZ0].cB3);
         for(int iB3=mB3;iB3<=nB3;iB3++){
            int iF2=con.B3[iB3].F2;
            F2[iF2].x.generate(TRANS,
                               ROT,
                               dep.F2[iF2].x);
            F2[iF2].q.rotate(array_consts,
                             ROT,
                             dep.F2[iF2].q);
            if( con.F2[iF2].ion ){
               F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
            }
         }

         if( nQ2>mQ2 ){
            Rotation_Matrix PR[3];
            PR[ 0]=ROT;
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
               int br=con.Q2[iQ2].br;
               int cbr=con.Q2[iQ2].cbr;
               PR[br].extend(PR[cbr],
                             dep.Q2[iQ2].tu,
                             dep.Q2[iQ2].chi);
               Q2[iQ2].c=PR[br];
               int mG3=con.Q2[iQ2].G3a;
               int nG3=(mG3-1+con.Q2[iQ2].cG3);
               for(int iG3=mG3;iG3<=nG3;iG3++){
                  int iF2=con.G3[iG3].F2;
                  F2[iF2].x.generate(F2[con.Q2[iQ2].bseF2].x,
                                     PR[br],
                                     dep.G3[iG3].b);
                  F2[iF2].q.rotate(array_consts,
                                   PR[br],
                                   dep.F2[iF2].q);
                  if( con.F2[iF2].ion ){
                     F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
                  }
               }
            }
         }
      }
//
//
// calc mean atom pos x
//
      {
         x.zero();
         double z= (0.00);
         for(int iF2= 0;iF2<oF2;iF2++){
            if( con.F2[iF2].lte<0 )continue;
            x+=F2[iF2].x;
            z++;
         }
         x/=z;
         G9[iG9].x=x;
         for(int jF= 0;jF<20;jF++){
            for(int jT= 0;jT<64;jT++){
               Coordinates n=FT(jF,jT).n;
               double zdn( 0.00);
               for(int iF2= 0;iF2<oF2;iF2++){
                  if( con.F2[iF2].lte<0 )continue;
                  Coordinates d=( F2[iF2].x -x);
                  double dn= dot(d,n);
                  if( dn>zdn ){
                     zdn= dn;
                  }
               }
               G9[iG9].FT(jF,jT).dncut=( zdn +( 1.60)/ANG -(15.00)/ANG);
            }
         }
      }
//
//
// calc boundary surf
//
      Dielec_Continu mlg(oQ2,oF2,oA5,oR0);
      Dielec_Continu& med=G9[iG9].med;
      med.Q2.resize(oQ2);
      med.F2.resize(oF2);
      med.A5.resize(oA5);
      for(int iQ2= 0;iQ2<oQ2;iQ2++){
         mlg.Q2[iQ2].c=Q2[iQ2].c;
         med.Q2[iQ2].c=Q2[iQ2].c;
      }
      bool VERBOSE_hold=out.VERBOSE;
//
//
// large probe radius dots
//
      mlg.probe= ((2.80)/ANG);
      mlg.MED_SPHERE(physics_consts,out);
      mlg.MED_TORUS(physics_consts,out);
      PCK_MOL(physics_consts,energy_params,
              mlg,mol,con,dep);
      out.VERBOSE=false;
      mlg.bse_nA5=0;
      mlg.bse_nB5=0;
      mlg.bse_nC5=0;
      mlg.bse_nF5=0;
      mlg.bse_nE5=0;
      mlg.bse_nV5=0;
      mlg.bse_nH5=0;
      mlg.ENDSTATE=0;
      mlg.MED_SURF(physics_consts,out);
      if( mlg.ENDSTATE>0 ){
         out.FILE3<<"ENDSTATE="<< std::setw( 2)<<mlg.ENDSTATE<< std::endl;
         std::exit( 2);
         return;
      }
      mlg.bse_nD5=0;
      mlg.MED_DOT(physics_consts,array_consts,out);
      out.VERBOSE=VERBOSE_hold;
      PCK_SURF(physics_consts,
               str,out,mlg);
//
//
// small probe radius dots
//
      med.probe= ((1.40)/ANG);
      med.MED_SPHERE(physics_consts,out);
      med.MED_TORUS(physics_consts,out);
      PCK_MOL(physics_consts,energy_params,
              med,mol,con,dep);
      out.VERBOSE=false;
      med.bse_nA5=0;
      med.bse_nB5=0;
      med.bse_nC5=0;
      med.bse_nF5=0;
      med.bse_nE5=0;
      med.bse_nV5=0;
      med.bse_nH5=0;
      med.ENDSTATE=0;
      med.MED_SURF(physics_consts,out);
      if( med.ENDSTATE>0 ){
         out.FILE3<<"ENDSTATE="<< std::setw( 2)<<med.ENDSTATE<< std::endl;
         std::exit( 2);
         return;
      }
      med.bse_nD5=0;
      med.MED_DOT(physics_consts,array_consts,out);
      med.MED_SIG(physics_consts,array_consts,out);
      out.VERBOSE=VERBOSE_hold;
      PCK_SURF(physics_consts,
               str,out,med);
      PCK_EHP(physics_consts,
              str,out,med);
//
//
// subset of cavity and cleft dots
//
      int oDOT=med.nDOT;
      MEM_pck_ico vv(oDOT,oR0);
      double rrcut= ((3.20)/ANGANG);
      for(int i0G5=-16;i0G5<=16;i0G5++){
         int iG5min=(i0G5-3);
         if( iG5min<-16 )iG5min=-16;
         int iG5max=(i0G5+3);
         if( iG5max> 16 )iG5max= 16;
         for(int j0G5=-16;j0G5<=16;j0G5++){
            int jG5min=(j0G5-3);
            if( jG5min<-16 )jG5min=-16;
            int jG5max=(j0G5+3);
            if( jG5max> 16 )jG5max= 16;
            for(int k0G5=-16;k0G5<=16;k0G5++){
               int kG5min=(k0G5-3);
               if( kG5min<-16 )kG5min=-16;
               int kG5max=(k0G5+3);
               if( kG5max> 16 )kG5max= 16;
               if( med.G5G5G5(i0G5,j0G5,k0G5).n==0 )continue;
               int iD5min=med.G5G5G5(i0G5,j0G5,k0G5).i;
               int iD5max=(iD5min-1+med.G5G5G5(i0G5,j0G5,k0G5).n);
               for(int iD5=iD5min;iD5<=iD5max;iD5++){
                  int aDOT=med.D5[iD5].DOTa;
                  int bDOT=(aDOT-1+med.D5[iD5].cDOT);
                  for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                     bool HIT=(false);
                     for(int iG5=iG5min;iG5<=iG5max&&(!HIT);iG5++){
                        for(int jG5=jG5min;jG5<=jG5max&&(!HIT);jG5++){
                           for(int kG5=kG5min;kG5<=kG5max&&(!HIT);kG5++){
                              if( mlg.G5G5G5(iG5,jG5,kG5).n==0 )continue;
                              int jD5min=mlg.G5G5G5(iG5,jG5,kG5).i;
                              int jD5max=(jD5min-1+mlg.G5G5G5(iG5,jG5,kG5).n);
                              for(int jD5=jD5min;jD5<=jD5max&&(!HIT);jD5++){
//                               if( mlg.D5[jD5].Q5> 0 )continue;
                                 int pDOT=mlg.D5[jD5].DOTa;
                                 int qDOT=(pDOT-1+mlg.D5[jD5].cDOT);
                                 for(int jDOT=pDOT;jDOT<=qDOT&&(!HIT);jDOT++){
                                    double rr=( mlg.DOT[jDOT].x
                                               -med.DOT[iDOT].x).rr();
                                    if( rr<rrcut ){
                                       vv.DOTsub(iDOT,false);
                                       HIT=true;
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
//
//
// moments for surface matching of interface
//
      {
//       out.FILE3<<" jF jT     rs    omg        as     zs        ah"
//                  "    nc        ac     ec     m \n";
//       out.FILE3<<std::fixed<<std::setprecision( 2);
         for(int jF= 0;jF<20;jF++){
            for(int jT= 0;jT<64;jT++){
               tG9::uFT& G9FT=G9[iG9].FT(jF,jT);
               G9FT.o_D.resize(6144);
//
//
// patch of dot surf
//
               G9FT.oD=-1;
               for(int iD5= 0;iD5<mlg.nD5;iD5++){
                  int iQ5=mlg.D5[iD5].Q5;
                  if( iQ5> 0 )continue;
                  int aDOT=mlg.D5[iD5].DOTa;
                  int bDOT=(aDOT-1+mlg.D5[iD5].cDOT);
                  for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                     if( vv.DOTsub(iDOT) )continue;
                     Coordinates d=( mlg.DOT[iDOT].x -x);
                     double dn= dot( d, FT(jF,jT).n);
                     if( dn<G9FT.dncut )continue;
                     double cn= dot( mlg.DOT[iDOT].c, FT(jF,jT).n);
                     if( cn<( -.00) )continue;
                     double r= d.r();
                     double Cthe= (dn/r);
                     if( Cthe<(  .32) )continue;
                     double zz=( (1.00) -Cthe*Cthe);
                     if( zz<( 1.00e-25) )zz=( 1.00e-25);
                     double Sthe= std::sqrt( zz);
                     double rst= (r*Sthe);
                     if( G9FT.oD<5119 ){
                        G9FT.oD++;
                     }else{
                        if( rst>=G9FT.D(G9FT.oD).rst )continue;
                     }
                     G9FT.D(G9FT.oD).rst= rst;
                     G9FT.D(G9FT.oD).DOT=iDOT;
                     for(int jD=G9FT.oD;jD> 0;jD--){
                        if( G9FT.D(jD   ).rst>=
                            G9FT.D(jD- 1).rst )break;
                        double z= G9FT.D(jD- 1).rst;
                        G9FT.D(jD- 1).rst= G9FT.D(jD   ).rst;
                        G9FT.D(jD   ).rst= z;
                        int j=G9FT.D(jD- 1).DOT;
                        G9FT.D(jD- 1).DOT=G9FT.D(jD   ).DOT;
                        G9FT.D(jD   ).DOT=j;
                     }
                  }
               }
               G9FT.oD++;
//
//
// patch position +normal +config
//
               Coordinates xs;          //mean position
               Coordinates ns;          //mean normal to surf
               xs.zero();
               ns.zero();
               double as= (0.00);       //area of surf
               for(int iD= 0;iD<G9FT.oD;iD++){
                  int iDOT=G9FT.D(iD).DOT;
                  xs+=(mlg.DOT[iDOT].a*mlg.DOT[iDOT].x);
                  ns+=(mlg.DOT[iDOT].a*mlg.DOT[iDOT].c);
                  as+=(mlg.DOT[iDOT].a);
               }
               xs/=as;
               ns.normalize();
               double Comg= dot( ns, FT(jF,jT).n);
               G9FT.omg= std::acos( Comg)/RAD;
               int pF(-1),pT(-1);
               {
                  double Cthe= ns(2);
                  double zz=( (1.00) -Cthe*Cthe);
                  if( zz<( 1.00e-25) )zz=( 1.00e-25);
                  double Sthe= std::sqrt( zz);
                  double the= std::atan2(Sthe,Cthe)/RAD;
                  double Cphi( 1.00),Sphi( 0.00),phi(   0.00);
                  if( Sthe>( 1.00e-12) ){
                     Cphi= (ns(0)/Sthe);
                     Sphi= (ns(1)/Sthe);
                     phi= std::atan2(Sphi,Cphi)/RAD;
                  }
                  tAB& pab=AB(phi,the);
                  pF=pab.pF;
                  pT=pab.pT;
               }
               G9FT.kF=pF;
               G9FT.kT=pT;
               ns=FT(pF,pT).n;
               G9FT.ns=ns;
               G9FT.x=( xs -(( 10.00)/ANG)*ns);
               double zdn( 0.00);
               for(int iF2= 0;iF2<oF2;iF2++){
                  if( con.F2[iF2].lte<0 )continue;
                  Coordinates d=( F2[iF2].x -G9FT.x);
                  double dn= dot(d,ns);
                  if( dn>zdn ){
                     zdn= dn;
                  }
               }
               G9FT.rs=( zdn +(1.60)/ANG);
//
//
// replace patch of dot surf
//
               G9FT.oD=-1;
               for(int iD5= 0;iD5<med.nD5;iD5++){
                  int iQ5=med.D5[iD5].Q5;
                  if( iQ5> 0 )continue;
                  int aDOT=med.D5[iD5].DOTa;
                  int bDOT=(aDOT-1+med.D5[iD5].cDOT);
                  for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                     Coordinates d=( med.DOT[iDOT].x -G9FT.x);
                     double dn= dot( d, G9FT.ns);
                     double cn= dot( med.DOT[iDOT].c, G9FT.ns);
                     if( cn<( -.15) )continue;
                     double r= d.r();
                     double Cthe= (dn/r);
                     if( Cthe<(  .32) )continue;
                     double zz=( (1.00) -Cthe*Cthe);
                     if( zz<( 1.00e-25) )zz=( 1.00e-25);
                     double Sthe= std::sqrt( zz);
                     double rst= (r*Sthe);
                     if( G9FT.oD<6143 ){
                        G9FT.oD++;
                     }else{
                        if( rst>=G9FT.D(G9FT.oD).rst )continue;
                     }
                     G9FT.D(G9FT.oD).rst= rst;
                     G9FT.D(G9FT.oD).DOT=iDOT;
                     for(int jD=G9FT.oD;jD> 0;jD--){
                        if( G9FT.D(jD   ).rst>=
                            G9FT.D(jD- 1).rst )break;
                        double z= G9FT.D(jD- 1).rst;
                        G9FT.D(jD- 1).rst= G9FT.D(jD   ).rst;
                        G9FT.D(jD   ).rst= z;
                        int j=G9FT.D(jD- 1).DOT;
                        G9FT.D(jD- 1).DOT=G9FT.D(jD   ).DOT;
                        G9FT.D(jD   ).DOT=j;
                     }
                  }
               }
               G9FT.oD++;
//________
//
//
// nearest grid indexes for native dock config
//
// int pFn( -1),pTn( -1),lFn( -1),lTn( -1);
// if      ( MOL=="1brs" ){
//    pFn=19;
//    pTn=29;
//    lFn= 5;
//    lTn= 3;
// }else if( MOL=="1emv" ){
//    pFn=11;
//    pTn=39;
//    lFn= 6;
//    lTn=36;
// }else if( MOL=="2ptc" ){
//    pFn=10;
//    pTn=56;
//    lFn= 7;
//    lTn=50;
// }else if( MOL=="2vir" ){
//    pFn=13;
//    pTn=30;
//    lFn= 8;
//    lTn=18;
// }else if( MOL=="1p2c" ){
//    pFn= 8;
//    pTn=39;
//    lFn=13;
//    lTn=36;
// }else if( MOL=="1efn" ){
//    pFn= 1;
//    pTn=48;
//    lFn=14;
//    lTn=58;
// }else if( MOL=="3bzd" ){
//    pFn=13;
//    pTn=19;
//    lFn= 8;
//    lTn=28;
// }else if( MOL=="1ay7" ){
//    pFn=11;
//    pTn=43;
//    lFn= 6;
//    lTn=44;
// }else if( MOL=="2wpt" ){
//    pFn=15;
//    pTn=27;
//    lFn= 0;
//    lTn=24;
// }else if( MOL=="1cbw" ){
//    pFn= 3;
//    pTn=63;
//    lFn=16;
//    lTn=63;
// }else if( MOL=="2tgp" ){
//    pFn=10;
//    pTn=56;
//    lFn= 7;
//    lTn=50;
// }else if( MOL=="2pcb" ){
//    pFn= 2;
//    pTn=31;
//    lFn=17;
//    lTn=16;
// }else if( MOL=="2vis" ){
//    pFn=13;
//    pTn=30;
//    lFn= 8;
//    lTn=18;
// }else if( MOL=="1mlc" ){
//    pFn= 7;
//    pTn= 3;
//    lFn=10;
//    lTn=27;
// }else if( MOL=="2aq3" ){
//    pFn=13;
//    pTn=34;
//    lFn= 8;
//    lTn=34;
// }
// if( ((iG9==0)&&(jF==pFn)&&(jT==pTn))||
//     ((iG9==1)&&(jF==lFn)&&(jT==lTn)) ){
//
//
// dot surface
//
//    for(int iZ0=0;iZ0<str.nZ0;iZ0++){
//       int mR0=str.Z0[iZ0].R0a;
//       int nR0=(mR0-1+str.Z0[iZ0].cR0);
//       for(int iR0=mR0;iR0<=nR0;iR0++){
//          char c1=str.R0[iR0].c1;
//          std::string aa=str.R0[iR0].aa;
//          if( c1=='a' ){
//             if( (aa[0]=='e')||
//                 (aa[0]=='z') )aa=aa.substr(1,3)+' ';
//             if( (aa[3]=='e')||
//                 (aa[3]=='z') )aa=aa.substr(0,3)+' ';
//          }
//          char cha=str.R0[iR0].cha;
//          int res=str.R0[iR0].res;
//          char ins=str.R0[iR0].ins;
//          int mP1=str.R0[iR0].P1a;
//          int nP1=(mP1-1+str.R0[iR0].cP1);
//          for(int iP1=mP1;iP1<=nP1;iP1++){
//             if( str.P1[iP1].sub==0 )continue;
//             std::string atm=str.P1[iP1].atm;
//             int iT2=str.P1[iP1].typ;
//             if( (aa=="CYH ")&&(atm==" HG ") )iT2=5;
//             if( (iT2== 0)||(iT2== 3) )continue;
//             ii++;
//             ofile1<<"ATOM  "
//                  << std::setw( 5)<<ii<<' '
//                  <<atm<<' '
//                  <<aa.substr(0,3)<<' '
//                  <<cha
//                  << std::setw( 4)<<res
//                  <<ins<<"   ";
//             for(int j=0;j<3;j++){
//                ofile1<< std::setw( 8)<<str.P1[iP1].x(j);
//             }
//             ofile1<<'\n';
//          }
//       }
//    }
//    ofile1<<"TER"<<'\n';
//    for(int iD= 0;iD<G9FT.oD;iD++){
//       int iDOT=G9FT.D(iD).DOT;
//        ii++;
//        std::string atm=( iG9==0 )? " T00": " T02";
//       char cha=' ';
//       int res=0;
//       char ins=' ';
//       ofile2<<"ATOM  "
//            << std::setw( 5)<<ii<<' '
//            <<atm<<' '
//            <<"DOT"<<' '
//            <<cha
//            << std::setw( 4)<<res
//            <<ins<<"   ";
//       for(int j=0;j<3;j++){
//          ofile2<< std::setw( 8)<<(ANG*med.DOT[iDOT].x(j));
//       }
//       ofile2<<'\n';
//    }
//    ofile2<<"TER"<<'\n';
// }
//________
//
//
// center of surface area for patch
//
               as= (0.00);              //area of surf
               double zs= (0.00);       //mean z component of surf area
               double ah= (0.00);       //area of hydrophobic surf
               Coordinates c;           //sum over cleft dots of normal
               c.zero();
               double ac= (0.00);       //area of cleft surf
               int nc=0;                //n of cleft dots
               for(int iD= 0;iD<G9FT.oD;iD++){
                  int iDOT=G9FT.D(iD).DOT;
                  Coordinates d=( med.DOT[iDOT].x -G9FT.x);
                  double dn= dot( d, G9FT.ns);
                  double ghp= (0.00);
                  if      ( med.DOT[iDOT].typ==-1 ){
                     int iC5=med.DOT[iDOT].elm;
                     for(int iN3=0;iN3<3;iN3++){
                        int iA5=med.C5[iC5].N3A5[iN3];
                        int iT2=med.A5[iA5].typ;
                        if( (iT2== 0)||(iT2== 3)||(iT2== 8)||
                            (iT2==10)||(iT2==15) )ghp++;
                     }
                     ghp/=(3.00);
                  }else if( med.DOT[iDOT].typ== 0 ){
                     int elm=med.DOT[iDOT].elm;
                     int iB5;
                     if( elm< 0 ){
                        iB5=(-1-elm);
                     }else{
                        int jE6=med.F6[elm].N2E6[0];
                        int iE6=med.F6[elm].N2E6[1];
                        int jH5=med.E6[jE6].H5;
                        int iH5=med.E6[iE6].H5;
                        iB5=med.H5[iH5].B5;
                     }
                     for(int iN2=0;iN2<2;iN2++){
                        int iA5=med.B5[iB5].N2A5[iN2];
                        int iT2=med.A5[iA5].typ;
                        if( (iT2== 0)||(iT2== 3)||(iT2== 8)||
                            (iT2==10)||(iT2==15) )ghp++;
                     }
                     ghp/=(2.00);
                  }else if( med.DOT[iDOT].typ== 1 ){
                     int elm=med.DOT[iDOT].elm;
                     int iA5;
                     if( elm< 0 ){
                        iA5=(-1-elm);
                     }else{
                        iA5=med.F7[elm].A5;
                     }
                     int iT2=med.A5[iA5].typ;
                     if( (iT2== 0)||(iT2== 3)||(iT2== 8)||
                         (iT2==10)||(iT2==15) )ghp++;
                  }
                  G9FT.D(iD).ghp= ghp;
                  int iB=(iD/1024);
                  double Bw=( (1.125) -double(iB)*( .125));
                  as+=(Bw*med.DOT[iDOT].a);
                  zs+=(Bw*med.DOT[iDOT].a*dn);
                  if( ghp>( 1.00e-6) ){
                     ah+=(ghp*Bw*med.DOT[iDOT].a);
                  }
                  if( vv.DOTsub(iDOT) ){
                     c+=(Bw*med.DOT[iDOT].a*med.DOT[iDOT].c);
                     ac+=(Bw*med.DOT[iDOT].a);
                     nc++;
                  }
               }
               G9FT.as= as;
               zs/=as;
               zs+=( .375)/ANG;
               G9FT.zs= zs;
               G9FT.ah= ah;
               double ec= ( 0.00);
               if( nc> 7 ){
                  c.normalize();
                  double Cphi= dot( c, G9FT.ns);
                  double phi= std::acos( Cphi)/RAD;
                  double z=( phi -(  75.00))/(  30.00);
                  z*=(( 30.00)*(ac/as));
                  if( z<( 0.00) ){
                     ec= ( 3.25)*std::tanh( z);
                  }else{
                     ec= ( 9.75)*std::tanh( z);
                  }
               }
               G9FT.ec= ec;
               G9FT.nc= nc;
               xs=(zs*G9FT.ns);
//
//
// iterate over shells
//
               int iDmin=0;
               int iDmax=1024;
               for(int jB=0;jB<6;jB++){
//
//
// radius of sphere bounding patch subset
//
                  double U= ( 0.00);    //max dist from xs
                  for(int iD=iDmin;iD<iDmax&&(iD<G9FT.oD);iD++){
                     int iDOT=G9FT.D(iD).DOT;
                     Coordinates d=( med.DOT[iDOT].x -G9FT.x);
                     double dn= dot( d, G9FT.ns);
                     d-=xs;
// expand surf along n
                     d+=((  .20)*( dn -zs)*G9FT.ns);
                     double r= d.r();
                     if( r>U ){
                        U= r;
                     }
                  }
                  U*=( .65);
                  G9FT.B(jB).U= U;
//
//
// mean z component of patch subset
//
                  double Bas= (0.00);   //area of surf
                  double Bzs= (0.00);   //mean z component of surf area
                  for(int iD=iDmin;iD<iDmax&&(iD<G9FT.oD);iD++){
                     int iDOT=G9FT.D(iD).DOT;
                     Coordinates d=( med.DOT[iDOT].x -G9FT.x);
                     double dn= dot( d, G9FT.ns);
                     Bas+=(med.DOT[iDOT].a);
                     Bzs+=(med.DOT[iDOT].a*dn);
                  }
                  Bzs/=Bas;
                  G9FT.B(jB).zs= Bzs;
//
//
// moments of exposed surface area (total and hydrophobic), and chg density
//
                  Multipoles a(0);
                  a.i(0,0)= (0.00);
                  for(int iX=0;iX<4;iX++){
                     BXs(jB,iX).zero();
                  }
                  for(int iD=iDmin;iD<iDmax&&(iD<G9FT.oD);iD++){
                     int iDOT=G9FT.D(iD).DOT;
                     Coordinates d=( med.DOT[iDOT].x -G9FT.x);
                     double dn= dot( d, G9FT.ns);
                     d-=xs;
// expand surf along n
                     d+=((  .20)*( dn -zs)*G9FT.ns);
// scale surf to unit sphere
                     d/=U;
                     d=-d;
                     double ghp= G9FT.D(iD).ghp;
// assign chg analog as distance along n
                     double z= (1.20)*( dn -zs)/U;
                     a.r(0,0)= (med.DOT[iDOT].a);
                     BXs(jB, 0).translate(array_consts,d,a);
                     if( ghp>( 1.00e-6) ){
                        a.r(0,0)= (ghp*med.DOT[iDOT].a);
                        BXs(jB, 1).translate(array_consts,d,a);
                     }
                     a.r(0,0)= (z*med.DOT[iDOT].a);
                     BXs(jB, 2).translate(array_consts,d,a);
                     a.r(0,0)= med.DOT[iDOT].chg;
                     BXs(jB, 3).translate(array_consts,d,a);
                  }
                  BXs(jB, 0)*=(ANGANG*( .032));
                  BXs(jB, 1)*=(ANGANG*( .032));
                  BXs(jB, 2)*=(ANGANG*( .032));
//
//
// rotation st normal to interface is z-axis
//
                  for(int iX=0;iX<4;iX++){
                     for(int iN=0;iN<8;iN++){
                        G9FT.B(jB).XNs(iX,iN).zero();
                     }
                  }
                  Multipoles t(7);
                  for(int iX=0;iX<4;iX++){
                     t.rotate(array_consts,
                              FT(pF,pT).ROT,BXs(jB,iX));
                     for(int L=0;L<8;L++){
                        for(int L1=0,L2=L;L1<=L;L1++,L2--){
                           int j2=(L2*L2+L2);
                           int j=(L*L+L-L1);
                           for(int M1=-L1,j1=(L1*L1);M1<=L1;M1++,j1++){
                              double z= array_consts.C[j1][j2];
                              G9FT.B(jB).XNs(iX,L2).r(j)+=
                                  t.r(j1)*z;
                              G9FT.B(jB).XNs(iX,L2).i(j)+=
                                  t.i(j1)*z;
                              j++;
                           }
                        }
                     }
                  }
                  for(int iJ= 0;iJ<64;iJ++){
                     for(int iX=0;iX<4;iX++){
                        G9FT.B(jB).JXs(iJ,iX).rotate(
                            array_consts,
                            FT(pF,pT).JROT[iJ],BXs(jB,iX));
                     }
                  }
                  iDmax+=1024;
               }
//
//
// concave-convex measure of surf patch
//
               double alp( -.13);
               double zx( 0.00),zy( 0.00);
               double p( 1.00),z( 0.00);
               for(int jB=0;jB<6;jB++){
                  p= std::exp( alp*double( jB*jB));
                  zx+=p*double( jB);
                  zy+=p*G9FT.B(jB).zs;
                  z+=p;
               }
               zx/=z;
               zy/=z;
               double zxx( 0.00),zxy( 0.00);
               for(int jB=0;jB<6;jB++){
                  p= std::exp( alp*double( jB*jB));
                  zxx+=p*( double(jB) -zx)*( double(jB) -zx);
                  zxy+=p*( double(jB) -zx)*( G9FT.B(jB).zs -zy);
               }
               G9FT.ms= (zxy/zxx);
//
//
// concave-convex measure of surf patch
//
//             out.FILE3<< std::setw( 3)<<jF
//                      << std::setw( 3)<<jT
//                      << std::setw( 7)<<(ANG*G9FT.rs)
//                      << std::setw( 7)<<G9FT.omg
//                      << std::setw(10)<<(ANGANG*G9FT.as)
//                      << std::setw( 7)<<(ANG*G9FT.zs)
//                      << std::setw(10)<<(ANGANG*G9FT.ah)
//                      << std::setw( 6)<<nc
//                      << std::setw(10)<<ac
//                      << std::setw( 7)<<G9FT.ec
//                      << std::setw( 7)<<G9FT.ms
//                      <<'\n';
//
//
// electrostatic mpoles
//
               R=( G9FT.rs -(1.60)/ANG);
               double R1= ( .50)*R;
               double R2= ( .25)*R;
//             ns=G9FT.ns;
               Coordinates x=G9FT.x;
               Coordinates x1=( x +( .50)*R*ns);
               Coordinates x2=( x +( .75)*R*ns);
               Multipoles a(7),a1(7),a2(7);
               a.zero();
               a1.zero();
               a2.zero();
               for(int iF2= 0;iF2<oF2;iF2++){
                  if( con.F2[iF2].lte<0 )continue;
                  Coordinates d=( x2 -F2[iF2].x);
                  if( d.r()<R2 ){
                     a2.translate(array_consts,d,F2[iF2].q);
                  }else{
                     d=( x1 -F2[iF2].x);
                     if( d.r()<R1 ){
                        a1.translate(array_consts,d,F2[iF2].q);
                     }else{
                        d=( x -F2[iF2].x);
                        double r= d.r();
                        if( r>R ){
                           d*=(R/r);
                        }
                        a.translate(array_consts,d,F2[iF2].q);
                     }
                  }
               }
               G9FT.C( 2).q.rotate(array_consts,
                                             FT(pF,pT).ROT,a2);
               G9FT.C( 1).q.rotate(array_consts,
                                             FT(pF,pT).ROT,a1);
               G9FT.C( 0).q.rotate(array_consts,
                                             FT(pF,pT).ROT,a);
               for(int jJ= 0;jJ<64;jJ++){
                  G9FT.C( 2).Jq(jJ).rotate(array_consts,
                                                     FT(pF,pT).JROT[jJ],a2);
                  G9FT.C( 1).Jq(jJ).rotate(array_consts,
                                                     FT(pF,pT).JROT[jJ],a1);
                  G9FT.C( 0).Jq(jJ).rotate(array_consts,
                                                     FT(pF,pT).JROT[jJ],a);
               }
//
               G9FT.o_D.clear();
            }
         }
      }
      {
//
//
// set of full charges
//
         int oC9=0;
         for(int iF2= 0;iF2<oF2;iF2++){
            if( con.F2[iF2].zet==0 )continue;
            G9[iG9].C9.push_back( tG9::tC9());
            Coordinates d=( F2[iF2].x -G9[iG9].x);
            G9[iG9].C9[oC9].b=d;
            for(int i=0;i<4;i++){
               G9[iG9].C9[oC9].ef[i]=con.F2[iF2].ef[i];
               G9[iG9].C9[oC9].ef[i].sig*=(.934017);
            }
            int iR0=con.F2[iF2].R0;
            G9[iG9].C9[oC9].R0=iR0;
            G9[iG9].C9[oC9].aa=mol.R0[iR0].aa;
            G9[iG9].C9[oC9].atm=con.F2[iF2].atm;
            G9[iG9].C9[oC9].q= (G9[iG9].C9[oC9].ef[0].sig/(   0.0364569));
            oC9++;
         }
         G9[iG9].oC9=oC9;
//
//
// nonpolar sites, sc center of nonpolar atoms
//
         for(int iR0= 0;iR0<oR0;iR0++){
            vv.R0x(iR0).zero();
            vv.R0n(iR0)=0;
            vv.R0m(iR0)=0;
         }
         for(int iF2= 0;iF2<oF2;iF2++){
            if( con.F2[iF2].lte<0 )continue;
            std::string atm=con.F2[iF2].atm;
            int iR0=con.F2[iF2].R0;
            char c1=mol.R0[iR0].c1;
            std::string aa=mol.R0[iR0].aa;
            if      ( c1=='a' ){
               if( (aa[0]=='e')||
                   (aa[0]=='z') )aa=aa.substr(1,3)+' ';
               if( (aa[3]=='e')||
                   (aa[3]=='z') )aa=aa.substr(0,3)+' ';
               if      ( aa=="ALA " ){
                  if( (atm!=" CB ") )continue;
               }else if( aa=="CYS " ){
                  if( (atm!=" CB ")&&(atm!=" SG ") )continue;
               }else if( aa=="GLU " ){
                  if( (atm!=" CB ") )continue;
               }else if( aa=="PHE " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD1")&&
                      (atm!=" CD2")&&(atm!=" CE1")&&(atm!=" CE2")&&
                      (atm!=" CZ ") )continue;
               }else if( aa=="HIS " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD2")&&
                      (atm!=" CE1")&&(atm!=" NE2") )continue;
               }else if( aa=="ILE " ){
                  if( (atm!=" CB ")&&(atm!=" CG1")&&(atm!=" CG2")&&
                      (atm!=" CD1") )continue;
               }else if( aa=="LYS " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD ") )continue;
               }else if( aa=="LEU " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD1")&&
                      (atm!=" CD2") )continue;
               }else if( aa=="MET " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" SD ")&&
                      (atm!=" CE ") )continue;
               }else if( aa=="ASN " ){
                  if( (atm!=" CB ") )continue;
               }else if( aa=="PRO " ){
                  if( (atm!=" CB ")&&(atm!=" CG ") )continue;
               }else if( aa=="GLN " ){
                  if( (atm!=" CB ")&&(atm!=" CG ") )continue;
               }else if( aa=="ARG " ){
                  if( (atm!=" CB ")&&(atm!=" CG ") )continue;
               }else if( aa=="THR " ){
                  if( (atm!=" CG2") )continue;
               }else if( aa=="VAL " ){
                  if( (atm!=" CB ")&&(atm!=" CG1")&&(atm!=" CG2") )continue;
               }else if( aa=="TRP " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD1")&&
                      (atm!=" CD2")&&(atm!=" CE2")&&(atm!=" CE3")&&
                      (atm!=" CZ2")&&(atm!=" CZ3")&&(atm!=" CH2") )continue;
               }else if( aa=="TYR " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD1")&&
                      (atm!=" CD2")&&(atm!=" CE1")&&(atm!=" CE2") )continue;
               }else if( aa=="AIB " ){
                  if( (atm!=" CB2")&&(atm!=" CB1") )continue;
               }else if( aa=="ABU " ){
                  if( (atm!=" CB ")&&(atm!=" CG ") )continue;
               }else if( aa=="NLE " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD ")&&
                      (atm!=" CE ") )continue;
               }else if( aa=="ORN " ){
                  if( (atm!=" CB ")&&(atm!=" CG ") )continue;
               }else if( aa=="CYH " ){
                  if( (atm!=" CB ")&&(atm!=" SG ") )continue;
               }else if( aa=="HIE " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" ND1")&&
                      (atm!=" CD2")&&(atm!=" CE1") )continue;
               }else if( aa=="ASZ " ){
                  if( (atm!=" CB ") )continue;
               }else if( aa=="GLZ " ){
                  if( (atm!=" CB ")&&(atm!=" CG ") )continue;
               }else if( aa=="LYZ " ){
                  if( (atm!=" CB ")&&(atm!=" CG ")&&(atm!=" CD ") )continue;
               }else if( aa=="TYZ " ){
                  if( (atm!=" CB ") )continue;
               }else{
                  continue;
               }
            }else if( c1=='e' ){
               continue;
            }else if( c1=='r' ){
               if( aa=="D   " ){
                  if( (atm!=" C2'") )continue;
               }else if( aa=="RF  " ){
                  if( (atm!=" C2'")&&(atm!=" F2'") )continue;
               }else if( aa=="CET " ){
                  if( (atm!=" C7'") )continue;
               }else{
                  continue;
               }
            }else if( c1=='b' ){
               if      ( aa=="A   " ){
                  if( (atm!=" N9 ")&&(atm!=" C4 ")&&(atm!=" C8 ")&&
                      (atm!=" N3 ")&&(atm!=" C5 ")&&(atm!=" N7 ")&&
                      (atm!=" C2 ")&&(atm!=" C6 ")&&(atm!=" N1 ") )continue;
               }else if( aa=="G   " ){
                  if( (atm!=" N9 ")&&(atm!=" C4 ")&&(atm!=" C8 ")&&
                      (atm!=" N3 ")&&(atm!=" C5 ")&&(atm!=" N7 ")&&
                      (atm!=" C2 ")&&(atm!=" N1 ") )continue;
               }else if( aa=="T   " ){
                  if( (atm!=" N1 ")&&(atm!=" C6 ")&&(atm!=" N3 ")&&
                      (atm!=" C5 ")&&(atm!=" C5A") )continue;
               }else if( aa=="C   " ){
                  if( (atm!=" N1 ")&&(atm!=" C6 ")&&(atm!=" N3 ")&&
                      (atm!=" C5 ")&&(atm!=" C4 ") )continue;
               }else if( aa=="U   " ){
                  if( (atm!=" N1 ")&&(atm!=" C6 ")&&(atm!=" N3 ")&&
                      (atm!=" C5 ") )continue;
               }else{
                  continue;
               }
            }else if( c1=='s' ){
               continue;
            }
            vv.R0x(iR0)+=( F2[iF2].x -G9[iG9].x);
            vv.R0n(iR0)++;
            int iA5=med.F2[iF2].A5;
            if( A5[iA5].exsa>( 2.00) )vv.R0m(iR0)++;
         }
//
//
// nonpolar sites, sc contacts
//
         for(int iR0= 0;iR0<(oR0-1);iR0++){
            if( vv.R0n(iR0)==0 )continue;
            if( vv.R0m(iR0)> 0 )continue;
            double zi= ((1.00)/double( vv.R0n(iR0)));
            for(int jR0=(iR0+1);jR0<oR0;jR0++){
               if( vv.R0n(jR0)==0 )continue;
               if( vv.R0m(jR0)> 0 )continue;
               double zj= ((1.00)/double( vv.R0n(jR0)));
               double r=( zj*vv.R0x(jR0) -zi*vv.R0x(iR0)).r();
               if( r<(( 6.75)/ANG) ){
                  vv.R0R0sub(iR0,jR0, true);
               }
            }
         }
         int mI3=0;
         for(int iR0= 0;iR0<oR0;iR0++){
            vv.R0I3a(iR0)=mI3;
            int n=vv.R0cI3(iR0);
            for(int i=0;i<n;i++){
               vv.o_I3R0.push_back(-1);
               mI3++;
            }
            vv.R0I3b(iR0)=mI3;
            for(int jR0=(iR0+1);jR0<oR0;jR0++){
               if( vv.R0R0sub(iR0,jR0) ){
                  vv.o_I3R0.push_back(jR0);
                  vv.R0cI3(iR0)++;
                  vv.R0cI3(jR0)++;
                  mI3++;
               }
            }
         }
         for(int iR0= 0;iR0<(oR0-1);iR0++){
            int iI3min=vv.R0I3b(iR0);
            int iI3max=(vv.R0I3a(iR0)+vv.R0cI3(iR0));
            for(int iI3=iI3min;iI3<iI3max;iI3++){
               int jR0=vv.I3R0(iI3);
               vv.I3R0(vv.R0I3a(jR0)+vv.R0dI3(jR0))=iR0;
               vv.R0dI3(jR0)++;
            }
         }
         for(int iR0= 0;iR0<oR0;iR0++){
            int iI3min=vv.R0I3a(iR0);
            int iI3max=(iI3min+vv.R0cI3(iR0));
            for(int iI3=iI3min;iI3<iI3max;iI3++){
               int jR0=vv.I3R0(iI3);
               int jI3min=vv.R0I3a(jR0);
               int jI3max=(jI3min+vv.R0cI3(jR0));
               for(int jI3=jI3min;jI3<jI3max;jI3++){
                  int kR0=vv.I3R0(jI3);
                  if( kR0>iR0 ){
                     vv.R0R0sub(iR0,kR0, true);
                  }
                  int kI3min=vv.R0I3a(kR0);
                  int kI3max=(kI3min+vv.R0cI3(kR0));
                  for(int kI3=kI3min;kI3<kI3max;kI3++){
                     int lR0=vv.I3R0(kI3);
                     if( lR0>iR0 ){
                        vv.R0R0sub(iR0,lR0, true);
                     }
                  }
               }
            }
         }
//
//
// nonpolar sites, partition side chains into clusters
//
         for(int iR0= 0;iR0<oR0;iR0++){
            vv.R0sub(iR0,( vv.R0n(iR0)==0 ));
         }
         int oV9=0;
         for(int oX=( oR0<12 )? oR0: 12;oX> 0;oX--){
            int iX= 0;
            vv.XiR0( 0)=-1;
            bool GROUP=true;
            for(;;){
               vv.XiR0(iX)++;
               if( (oX-iX)>(oR0-vv.XiR0(iX))||(!GROUP) ){
                  if( iX== 0 ){
                     break;
                  }else{
                     iX--;
                     if( iX== 0 )GROUP=true;
                     continue;
                  }

               }else{
                  if( vv.R0sub(vv.XiR0(iX)) )continue;
                  bool PASS=false;
                  for(int jX= 0;jX<iX;jX++){
                     if( !vv.R0R0sub(vv.XiR0(jX),vv.XiR0(iX)) )PASS=true;
                  }
                  if( PASS )continue;
                  if( iX==(oX-1) ){
                     x.zero();
                     int n=0;
                     for(int jX= 0;jX<oX;jX++){
                        int jR0=vv.XiR0(jX);
                        vv.R0sub(jR0, true);
                        x+=vv.R0x(jR0);
                        n+=vv.R0n(jR0);
                     }
                     x/=double( n);
                     double r= ((3.20)/ANG)
                              *std::exp( std::log( double( n))/(3.00));
                     G9[iG9].V9.push_back( tG9::tV9());
                     G9[iG9].V9[oV9].b=x;
                     G9[iG9].V9[oV9].vf.sig=(  2.5191)
                                           *std::sqrt( std::pow(ANG,3));
                     G9[iG9].V9[oV9].vf.eta= std::pow((1.49609)/r,2);
                     G9[iG9].V9[oV9].oX=oX;
                     for(int jX= 0;jX<oX;jX++){
                        G9[iG9].V9[oV9].XR0.push_back( vv.XiR0(jX));
                     }
                     oV9++;
                     if( iX== 0 ){
                     }else{
                        GROUP=false;
                     }
                  }else{
                     iX++;
                     vv.XiR0(iX)=vv.XiR0(iX-1);
                  }

               }
            }
         }
         G9[iG9].oV9=oV9;
//
//
// nonpolar sites, diagnostic output
//
//       out.FILE3<<" iG9"" oC9"" oV9"
//                << '\n';
//       out.FILE3<< std::setw( 4)<<iG9
//                << std::setw( 4)<<G9[iG9].oC9
//                << std::setw( 4)<<G9[iG9].oV9
//                << '\n';
//       out.FILE3<<" iV9"" oX""  eta ""   r  "" XR0"
//                << '\n';
//       for(int iV9= 0;iV9<oV9;iV9++){
//          int oX=G9[iG9].V9[iV9].oX;
//          double eta= G9[iG9].V9[iV9].vf.eta;
//          double r= ANG*(1.49609)/std::sqrt( eta);
//          out.FILE3<< std::setw( 4)<<iV9
//                   << std::setw( 3)<<oX
//                   << std::setprecision(3)
//                   << std::setw( 6)<<eta
//                   << std::setprecision(2)
//                   << std::setw( 6)<<r;
//          for(int iX= 0;iX<oX;iX++){
//             int iR0=G9[iG9].V9[iV9].XR0[iX];
//             std::string aa=mol.R0[iR0].aa;
//             out.FILE3<<'['<< std::setw( 3)<<iR0
//                      <<' '<<aa<<']';
//             if( (iX==6)||(iX==(oX-1)) ){
//                out.FILE3<<'\n';
//             }
//          }
//       }
      }
//
//
// clear molecule specific vectors
//
      F2.clear();
      Q2.clear();
      A5.clear();
   }
// ofile1.close();
// ofile2.close();
   return;
}
