#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
/**/#include <iomanip>
#include <cmath>

bool Packing_Search::PCK_F(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const DAT_ARRAY_CONSTS& array_consts,
         Output_Streams& out,
         int pG9,int lG9,
         int pF,int pT,int lF,int lT,
         const Rotation_Matrix& ROT,
         int oZ9,
         Packing_Search::ePack e){
   double ANG= physics_consts.ANG;
   double CAL= physics_consts.CAL;
   int pC9=G9[pG9].oC9;
   int pV9=G9[pG9].oV9;
   int lC9=G9[lG9].oC9;
   int lV9=G9[lG9].oV9;
/**/ out.FILE3<< std::fixed<< std::setprecision( 2);
//
//
// radii of spherical regions
//
   double Cr1[3];
   Cr1[ 0]=( G9[pG9].FT(pF,pT).rs -(1.60)/ANG);
   Cr1[ 1]= ( .50)*Cr1[ 0];
   Cr1[ 2]= ( .50)*Cr1[ 1];
   double Cr2[3];
   Cr2[ 0]=( G9[lG9].FT(lF,lT).rs -(1.60)/ANG);
   Cr2[ 1]= ( .50)*Cr2[ 0];
   Cr2[ 2]= ( .50)*Cr2[ 1];
   double r0=( R -Cr1[ 0] -Cr2[ 0]);
//
//
// truncated multipole expansion of Fe
//
   double ee_a( 0.00),DIVERGENCE( 0.00);
   for(int iC=0;iC<3;iC++){
      for(int jC=0;jC<3;jC++){
//       out.FILE3<<std::setw( 2)<<iC
//                <<std::setw( 2)<<jC;
         R=( Cr1[iC] +Cr2[jC] +r0);
         ZZ= (1.00)/R;
         if( ZZ>(1.00) )ZZ= (1.00);
         Lr[ 0]= (1.00);
         Lr[ 1]= ZZ;
         for(int L=2;L<9;L++){
            Lr[L  ]= ZZ*Lr[L-1];
         }
         QQ.zproduct(array_consts,Cq1[iC],Cq2[jC]);
         for(int L=0;L<8;L++){
            ee_a+=Lr[L+1]*QQ.r(L,0);
//          out.FILE3<<std::setw( 8)<<(CAL*Lr[L+1]*QQ.r(L,0));
         }
//       out.FILE3<<'\n';
         DIVERGENCE+=std::abs( Lr[ 8]*QQ.r(7,0));
      }
   }
   ee_a+=(( .80)*DIVERGENCE);
// out.FILE3<<" DIVERGENCE="
//          <<std::setw( 8)<<(CAL*DIVERGENCE)
//          <<'\n';
//
//
// direct evaluation of Fe limited to full chgs
//
   double ee_b( 0.00);
   for(int iC9= 0;iC9<pC9;iC9++){
      for(int jC9= 0;jC9<lC9;jC9++){
         double Rij=( G9[pG9].C9[iC9].x
                     -G9[lG9].C9[jC9].x).r();
         double z=( G9[pG9].C9[iC9].f
                   *G9[lG9].C9[jC9].f);
         ee_b+=(( .032)*z*G9[pG9].C9[iC9].q
                         *G9[lG9].C9[jC9].q/Rij);
      }
   }
   Fe=( ( 0.75)*ee_a +( 0.00)*ee_b);
   Fe*=CAL;
//
//
// surface match for Fs, Fh, Fp, and Fi
//
   double as=( G9[pG9].FT(pF,pT).as
              +G9[lG9].FT(lF,lT).as);
   double ah=( G9[pG9].FT(pF,pT).ah
              +G9[lG9].FT(lF,lT).ah);
   double hfrac= (ah/as);
   double pfrac=( (1.00) -hfrac);
   doc.fshpi(array_consts,out,o_BXNs,o_BXs,o_Bu);
   Fs= doc.Xg( 0)*( 1.00);
   Fh= doc.Xg( 1)*( 1.25)*hfrac;
   Fp= doc.Xg( 2)*( 1.00);
   Fi= doc.Xg( 3)*( 0.75);
   Fd= doc.eolp;
//
//
// geometry params
//
   double Rdoc=( G9[pG9].FT(pF,pT).zs
                +G9[lG9].FT(lF,lT).zs
                +doc.x*G9[pG9].FT(pF,pT).B( 1).U
                +( 1.00)/ANG);
   double Rbox=( G9[pG9].FT(pF,pT).rs
                +G9[lG9].FT(lF,lT).rs);
   double Rcor=( G9[pG9].FT(pF,pT).B( 0).zs
                +G9[lG9].FT(lF,lT).B( 0).zs
                +doc.x*G9[pG9].FT(pF,pT).B( 1).U);
//
//
// pack depth
//
   {
      if( Fs<( -0.75) ){
         double z=( Rdoc -Rbox)*(  .0625);
         doc.edepth= ( 6.00)*std::tanh( z);
      }else{
         doc.edepth= ( 6.00);
      }
      Fd+= doc.edepth;
   }
//
//
// pack to cleft
//
   {
      double pe= G9[pG9].FT(pF,pT).ec;
      double pm= G9[pG9].FT(pF,pT).ms;
      if( (pe<( 0.00))&&(pm<( -.75)) ){
         pe*=(  .00);
      }
      double le= G9[lG9].FT(lF,lT).ec;
      double lm= G9[lG9].FT(lF,lT).ms;
      if( (le<( 0.00))&&(lm<( -.75)) ){
         le*=(  .00);
      }
      if( (pm<( -.25))&&(lm<( -.25)) ){
         if( pe<( 0.00) ){
            pe*=(  .50);
         }
         if( le<( 0.00) ){
            le*=(  .50);
         }
      }
      if( (pe<( 0.00))&&(le<( 0.00)) ){
         if( pe<le ){
            pe*=(  .00);
         }else{
            le*=(  .00);
         }
      }
      doc.ecleft=( le +pe);
      Fd+=doc.ecleft;
   }
//
//
// distance dependence of surface match
//
   if( oZ9>2 ){
      double z=( R -Rcor);
      double tanhz=( ( .50) -( .50)*std::tanh( ( .20)*z));
      doc.gfac= tanhz;
      Fs*=tanhz;
      Fh*=tanhz;
      Fp*=tanhz;
      Fi*=tanhz;
   }
//
//
// reject config with overlap
//
   if( oZ9>2 ){
      if( R<( Rcor +(6.40)/ANG) ){
         if( Fs>( .50)*e.Fs )return true;
      }
   }else{
      double Ft=( Fe +Fs +Fh +Fp +Fi +Fd);
      if( Ft>( Fcut +( 32.00)) ){
//       out.FILE3<<"THRESH: (Ftot-Fm)="<<std::setw( 7)<<Ft
//                <<" Fcut="<<std::setw( 7)<<( Fcut +( 32.00))<<'\n';
//
         return true;
      }
   }
//
//
// adjust x=( TRANS1 +R*n -ROT2*TRANS2), shorten R
//
   if( oZ9==2 ){
      Coordinates& n=G9[pG9].FT(pF,pT).ns;
      R=( G9[lG9].FT(lF,lT).rs +G9[pG9].FT(pF,pT).rs);
      x+=( Rdoc -R)*n;
   }
   for(int iC9= 0;iC9<lC9;iC9++){
      Coordinates& b=G9[lG9].C9[iC9].b;
      G9[lG9].C9[iC9].x.generate(x,ROT,b);
   }
   for(int iV9= 0;iV9<lV9;iV9++){
      Coordinates& b=G9[lG9].V9[iV9].b;
      G9[lG9].V9[iV9].x.generate(x,ROT,b);
   }
//
//
// screen for overlaps
//
   {
      double zcc( (2.60)/ANG),zcv( (2.70)/ANG),zvv( (2.50)/ANG);
      bool OVERLAP=false;
      double z( 0.00);
      for(int iC9= 0;iC9<pC9&&(!OVERLAP);iC9++){
         Coordinates& a=G9[pG9].C9[iC9].x;
         for(int jC9= 0;jC9<lC9&&(!OVERLAP);jC9++){
            z= (G9[lG9].C9[jC9].x-a).r();
            if( z<zcc ){
//             out.FILE3<<"OLP cc";
               OVERLAP=true;
            }
         }
         for(int jV9= 0;jV9<lV9&&(!OVERLAP);jV9++){
            z= (G9[lG9].V9[jV9].x-a).r();
            if( z<zcv ){
//             out.FILE3<<"OLP cv";
               OVERLAP=true;
            }
         }
      }
      for(int iV9= 0;iV9<pV9&&(!OVERLAP);iV9++){
         Coordinates& a=G9[pG9].V9[iV9].x;
         for(int jC9= 0;jC9<lC9&&(!OVERLAP);jC9++){
            z= (G9[lG9].C9[jC9].x-a).r();
            if( z<zcv ){
//             out.FILE3<<"OLP cv";
               OVERLAP=true;
            }
         }
         for(int jV9= 0;jV9<lV9&&(!OVERLAP);jV9++){
            z= (G9[lG9].V9[jV9].x-a).r();
            if( z<zvv ){
//             out.FILE3<<"OLP vv";
               OVERLAP=true;
            }
         }
      }
      if( OVERLAP ){
//       out.FILE3<<" r="<<std::setw( 6)<<(ANG*z)<<'\n';
//       out.FILE3<<"#e"
//                << std::setw( 7)<<Fe
//                << std::setw( 7)<<(CAL*ee_a)
//                << std::setw( 7)<<(CAL*ee_b)<<'\n';
//       out.FILE3<<"#d"
//                << std::setw( 7)<<Fd
//                << std::setw( 7)<<doc.eolp
//                << std::setw( 7)<<doc.edepth
//                << std::setw( 7)<<doc.ecleft<<'\n';
         return true;
      }
   }
//
//
// gaussian approx of Fm
//
   double eev_ppl( 0.00);
   for(int iC9= 0;iC9<pC9;iC9++){
      if( G9[pG9].C9[iC9].PASS )continue;
      for(int jC9=iC9;jC9<pC9;jC9++){
         if( G9[pG9].C9[iC9].PASS )continue;
         double z=( jC9==iC9 )? (1.00): (2.00);
         z*=( G9[pG9].C9[iC9].f
             *G9[pG9].C9[jC9].f);
         double RRij=( G9[pG9].C9[iC9].x
                      -G9[pG9].C9[jC9].x).rr();
         double eev= (0.00);
         for(int kV9= 0;kV9<lV9;kV9++){
            double RRik=( G9[pG9].C9[iC9].x
                         -G9[lG9].V9[kV9].x).rr();
            double RRjk=( G9[pG9].C9[jC9].x
                         -G9[lG9].V9[kV9].x).rr();
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            G9[pG9].C9[iC9].ef[i],
                            G9[pG9].C9[jC9].ef[j],
                            G9[lG9].V9[kV9].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
         }
         eev_ppl+=(( .50)*z*eev);
      }
   }
   double eev_llp( 0.00);
   for(int iC9= 0;iC9<lC9;iC9++){
      if( G9[lG9].C9[iC9].PASS )continue;
      for(int jC9=iC9;jC9<lC9;jC9++){
         if( G9[lG9].C9[iC9].PASS )continue;
         double z=( jC9==iC9 )? (1.00): (2.00);
         z*=( G9[lG9].C9[iC9].f
             *G9[lG9].C9[jC9].f);
         double RRij=( G9[lG9].C9[iC9].x
                      -G9[lG9].C9[jC9].x).rr();
         double eev= (0.00);
         for(int kV9= 0;kV9<pV9;kV9++){
            double RRik=( G9[lG9].C9[iC9].x
                         -G9[pG9].V9[kV9].x).rr();
            double RRjk=( G9[lG9].C9[jC9].x
                         -G9[pG9].V9[kV9].x).rr();
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            G9[lG9].C9[iC9].ef[i],
                            G9[lG9].C9[jC9].ef[j],
                            G9[pG9].V9[kV9].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
         }
         eev_llp+=(( .50)*z*eev);
      }
   }
   double ee_pl( 0.00);
   double eev_plp( 0.00),eev_pll( 0.00);
   for(int iC9= 0;iC9<pC9;iC9++){
      if( G9[pG9].C9[iC9].PASS )continue;
      for(int jC9= 0;jC9<lC9;jC9++){
         if( G9[lG9].C9[iC9].PASS )continue;
         double z= (2.00);
         z*=( G9[pG9].C9[iC9].f
             *G9[lG9].C9[jC9].f);
         double RRij=( G9[pG9].C9[iC9].x
                      -G9[lG9].C9[jC9].x).rr();
         double ee= (0.00);
         for(int i=0;i<4;i++){
            for(int j=0;j<4;j++){
               ee+=eef(physics_consts,
                       G9[pG9].C9[iC9].ef[i],
                       G9[lG9].C9[jC9].ef[j],
                       RRij);
            }
         }
         ee_pl+=(( .10)*z*ee);
         double eev= (0.00);
         for(int kV9= 0;kV9<pV9;kV9++){
            double RRik=( G9[pG9].C9[iC9].x
                         -G9[pG9].V9[kV9].x).rr();
            double RRjk=( G9[lG9].C9[jC9].x
                         -G9[pG9].V9[kV9].x).rr();
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            G9[pG9].C9[iC9].ef[i],
                            G9[lG9].C9[jC9].ef[j],
                            G9[pG9].V9[kV9].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
         }
         eev_plp+=(( .50)*z*eev);
         eev= (0.00);
         for(int kV9= 0;kV9<lV9;kV9++){
            double RRik=( G9[pG9].C9[iC9].x
                         -G9[lG9].V9[kV9].x).rr();
            double RRjk=( G9[lG9].C9[jC9].x
                         -G9[lG9].V9[kV9].x).rr();
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            G9[pG9].C9[iC9].ef[i],
                            G9[lG9].C9[jC9].ef[j],
                            G9[lG9].V9[kV9].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
         }
         eev_pll+=(( .50)*z*eev);
      }
   }
   double eev_ppp( 0.00);
   for(int iC9= 0;iC9<pC9;iC9++){
      if( G9[pG9].C9[iC9].PASS )continue;
      for(int jC9=iC9;jC9<pC9;jC9++){
         if( G9[pG9].C9[iC9].PASS )continue;
         double z=( jC9==iC9 )? (1.00): (2.00);
         z*=( G9[pG9].C9[iC9].f
             *G9[pG9].C9[jC9].f);
         double RRij=( G9[pG9].C9[iC9].x
                      -G9[pG9].C9[jC9].x).rr();
         double eev= (0.00);
         for(int kV9= 0;kV9<pV9;kV9++){
            double RRik=( G9[pG9].C9[iC9].x
                         -G9[pG9].V9[kV9].x).rr();
            double RRjk=( G9[pG9].C9[jC9].x
                         -G9[pG9].V9[kV9].x).rr();
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            G9[pG9].C9[iC9].ef[i],
                            G9[pG9].C9[jC9].ef[j],
                            G9[pG9].V9[kV9].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
         }
         eev_ppp+=(( .50)*z*eev);
      }
   }
   double eev_lll( 0.00);
   for(int iC9= 0;iC9<lC9;iC9++){
      if( G9[lG9].C9[iC9].PASS )continue;
      for(int jC9=iC9;jC9<lC9;jC9++){
         if( G9[lG9].C9[iC9].PASS )continue;
         double z=( jC9==iC9 )? (1.00): (2.00);
         z*=( G9[lG9].C9[iC9].f
             *G9[lG9].C9[jC9].f);
         double RRij=( G9[lG9].C9[iC9].x
                      -G9[lG9].C9[jC9].x).rr();
         double eev= (0.00);
         for(int kV9= 0;kV9<lV9;kV9++){
            double RRik=( G9[lG9].C9[iC9].x
                         -G9[lG9].V9[kV9].x).rr();
            double RRjk=( G9[lG9].C9[jC9].x
                         -G9[lG9].V9[kV9].x).rr();
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            G9[lG9].C9[iC9].ef[i],
                            G9[lG9].C9[jC9].ef[j],
                            G9[lG9].V9[kV9].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
         }
         eev_lll+=(( .50)*z*eev);
      }
   }
   Fm= ( .32)*( ee_pl +( eev_ppl +eev_llp
                        +eev_pll +eev_plp
                        +eev_ppp +eev_lll));
   Fm*=CAL;
// out.FILE3<<"#e"
//          << std::setw( 7)<<Fe
//          << std::setw( 7)<<(CAL*ee_a)
//          << std::setw( 7)<<(CAL*ee_b)<<'\n';
// out.FILE3<<"#m"
//          << std::setw( 7)<<Fm
//          << std::setw( 7)<<(CAL*ee_pl)
//          << std::setw( 7)<<(CAL*eev_ppl)
//          << std::setw( 7)<<(CAL*eev_llp)
//          << std::setw( 7)<<(CAL*eev_pll)
//          << std::setw( 7)<<(CAL*eev_plp)
//          << std::setw( 7)<<(CAL*eev_ppp)
//          << std::setw( 7)<<(CAL*eev_lll)<<'\n';
// out.FILE3<<"#d"
//          << std::setw( 7)<<Fd
//          << std::setw( 7)<<doc.eolp
//          << std::setw( 7)<<doc.edepth
//          << std::setw( 7)<<doc.ecleft<<'\n';

   return false;
}
