#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../pck/Packing_Search.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iomanip>

void Packing_Search::PCK_EHP(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const Structure& str,
         Output_Streams& out,
         const Dielec_Continu& med){
//
//
// exposed surface area resolved wrt atoms
//
   double ANG= physics_consts.ANG;
   double ANGANG= ANG*ANG;
   for(int iA5= 0;iA5<med.nA5;iA5++){
      A5[iA5].exsa= (0.00);
   }
   for(int iF5= 0;iF5<med.nF5;iF5++){
      int iC5=iF5;
      if( !med.C5[iC5].sub )continue;
      double z= (ANGANG*med.F5[iF5].sa/(3.00));
      for(int iN3=0;iN3<3;iN3++){
         int iA5=med.C5[iC5].N3A5[iN3];
         A5[iA5].exsa+=z;
      }
   }
   for(int iF6= 0;iF6<med.nF6;iF6++){
      double z= (ANGANG*med.F6[iF6].sa/(2.00));
      for(int iN2=0;iN2<2;iN2++){
         int iA5=med.H5[med.E6[med.F6[iF6].N2E6[iN2]].H5].A5;
         A5[iA5].exsa+=z;
      }
   }
   for(int iF7= 0;iF7<med.nF7;iF7++){
      double z= (ANGANG*med.F7[iF7].sa);
      int iA5=med.F7[iF7].A5;
      A5[iA5].exsa+=z;
   }
   for(int iA5= 0;iA5<med.nA5;iA5++){
      if( !med.A5[iA5].free )continue;
      double z= (ANGANG*med.A5[iA5].sa);
      A5[iA5].exsa+=z;
   }
   for(int ijB5= 0;ijB5<med.nB5;ijB5++){
      if( !med.B5[ijB5].free )continue;
      double z= (ANGANG*med.B5[ijB5].sa/(2.00));
      for(int iN2=0;iN2<2;iN2++){
         int iA5=med.B5[ijB5].N2A5[iN2];
         A5[iA5].exsa+=z;
      }
   }
//
//
// exposed hydrophobic surface area of full element
//
   double ahp= (0.00);
   for(int iA5= 0;iA5<med.nA5;iA5++){
      int iT2=med.A5[iA5].typ;
      if( (iT2!= 8)&&(iT2!=10) )continue;
      ahp+=A5[iA5].exsa;
   }
//
//
// diagnostic output
//
// out.FILE3<< std::fixed<< std::setprecision( 3);
// out.FILE3<<"iZ0"" iR0""   aa""  atm""    exsa\n";
// for(int iA5= 0;iA5<med.nA5;iA5++){
//    int iZ0=A5[iA5].Z0;
//    int iR0=A5[iA5].R0;
//    std::string aa=str.R0[iR0].aa;
//    std::string atm=med.A5[iA5].atm;
//    out.FILE3<< std::setw( 3)<<iZ0
//             << std::setw( 4)<<iR0
//             <<' '<<aa
//             <<' '<<atm
//             << std::setw( 8)<<A5[iA5].exsa<<'\n';
// }
// if( out.VERBOSE ){
//    out.FILE3<<"Exposed Hydrophobic Surface Area="
//             << std::setprecision( 2)<< std::setw( 9)<<ahp<<'\n';
// }
//
//
// exposed hydrophobic surface area of full element (alternative)
//
// {
//    out.FILE3<< std::fixed<< std::setprecision( 2);
//    out.FILE3<<"   nhp     ahp  \n";
//    ahp= (0.00);
//    int nhp=0;
//    for(int iD5= 0;iD5<med.nD5;iD5++){
//       int iQ5=med.D5[iD5].Q5;
//       if( iQ5> 0 )continue;
//       int aDOT=med.D5[iD5].DOTa;
//       int bDOT=(aDOT-1+med.D5[iD5].cDOT);
//       for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
//          double gcleft=( vv.DOTsub(iDOT) )? (2.00): (1.00);
//          double ghp= (0.00);
//          if      ( med.DOT[iDOT].typ==-1 ){
//             int iC5=med.DOT[iDOT].elm;
//             for(int iN3=0;iN3<3;iN3++){
//                int iA5=med.C5[iC5].N3A5[iN3];
//                int iT2=med.A5[iA5].typ;
//                if( (iT2== 8)||(iT2==10)||(iT2==15) )ghp++;
//             }
//             ghp/=(3.00);
//          }else if( med.DOT[iDOT].typ== 0 ){
//             int elm=med.DOT[iDOT].elm;
//             int iB5;
//             if( elm< 0 ){
//                iB5=(-1-elm);
//             }else{
//                int jE6=med.F6[elm].N2E6[0];
//                int iE6=med.F6[elm].N2E6[1];
//                int jH5=med.E6[jE6].H5;
//                int iH5=med.E6[iE6].H5;
//                iB5=med.H5[iH5].B5;
//             }
//             for(int iN2=0;iN2<2;iN2++){
//                int iA5=med.B5[iB5].N2A5[iN2];
//                int iT2=med.A5[iA5].typ;
//                if( (iT2== 8)||(iT2==10)||(iT2==15) )ghp++;
//             }
//             ghp/=(2.00);
//          }else if( med.DOT[iDOT].typ== 1 ){
//             int elm=med.DOT[iDOT].elm;
//             int iA5;
//             if( elm< 0 ){
//                iA5=(-1-elm);
//             }else{
//                iA5=med.F7[elm].A5;
//             }
//             int iT2=med.A5[iA5].typ;
//             if( (iT2== 8)||(iT2==10)||(iT2==15) )ghp++;
//          }
//          if( ghp<( 1.00e-6) )continue;
//          ahp+=(gcleft*ghp*med.DOT[iDOT].a);
//          nhp++;
//       }
//    }
//    ahp*=ANGANG;
//    out.FILE3<< std::setw( 6)<<nhp
//             << std::setw(10)<<ahp
//             <<'\n';
// }

   return;
}
