#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

bool Packing_Search::PCK_2BOD(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const DAT_ARRAY_CONSTS& array_consts,
         const DAT_DISULFIDE_LINKS& disulfide_links,
         const DAT_ENERGY_PARAMS& energy_params,
         const DAT_REGION_MAPS& region_maps,
         const DAT_RESIDUE_MAPPINGS& residue_mappings,
         const Thread_Options& opt,
         Output_Streams& out){
   double ANG= physics_consts.ANG;
   double RAD= physics_consts.RAD;
   double PI= physics_consts.PI;
   Rotation_Matrix J;
   J(0,0)= ( 1.00);
   J(1,0)= ( 0.00);
   J(2,0)= ( 0.00);
   J(0,1)= ( 0.00);
   J(1,1)= (-1.00);
   J(2,1)= ( 0.00);
   J(0,2)= ( 0.00);
   J(1,2)= ( 0.00);
   J(2,2)= (-1.00);
   QQ.populate( 7);
   double alp= ( -2.528);
//
//
// 2-bod dock energies
//
   out.FILE3<<"2-BODY ENERGIES\n";
   oY9=U9[ 2].oY9;
   Y9.clear();
   Y9.resize(oY9);
   int oZ9=2;
   for(int iY9= 0;iY9<oY9;iY9++){
      Y9[iY9].oZ9=2;
      int pG9=U9[ 2].Y9[iY9].Z9[ 0].G9;
      int lG9=U9[ 2].Y9[iY9].Z9[ 1].G9;
      int pC9=G9[pG9].oC9;
      int pV9=G9[pG9].oV9;
      for(int iC9= 0;iC9<pC9;iC9++){
         G9[pG9].C9[iC9].x=G9[pG9].C9[iC9].b;
      }
      for(int iV9= 0;iV9<pV9;iV9++){
         G9[pG9].V9[iV9].x=G9[pG9].V9[iV9].b;
      }
      int lC9=G9[lG9].oC9;
      int lV9=G9[lG9].oV9;
//
//
// config of native
//
      int pFn(-1),pTn(-1),lFn(-1),lTn(-1),iJn( 0);
      {
         int oDOTp=G9[pG9].med.nDOT;
         int oDOTl=G9[lG9].med.nDOT;
         for(int iDOT= 0;iDOT<oDOTp;iDOT++){
            G9[pG9].med.DOT[iDOT].HIT=false;
         }
         for(int jDOT= 0;jDOT<oDOTl;jDOT++){
            G9[lG9].med.DOT[jDOT].HIT=false;
         }
         double rrcut= std::pow( (3.20)/ANG, 2);
         for(int iDOT= 0;iDOT<oDOTp;iDOT++){
            for(int jDOT= 0;jDOT<oDOTl;jDOT++){
               double rr=( G9[lG9].med.DOT[jDOT].x
                          -G9[pG9].med.DOT[iDOT].x).rr();
               if( rr<rrcut ){
                  G9[lG9].med.DOT[jDOT].HIT=true;
                  G9[pG9].med.DOT[iDOT].HIT=true;
               }
            }
         }
         Coordinates xp,np;
         xp.zero();
         double ap= (0.00);
         for(int iDOT= 0;iDOT<oDOTp;iDOT++){
            if( !G9[pG9].med.DOT[iDOT].HIT )continue;
            xp+=(G9[pG9].med.DOT[iDOT].a*G9[pG9].med.DOT[iDOT].x);
            ap+=(G9[pG9].med.DOT[iDOT].a);
         }
         xp/=ap;
         np=( xp -G9[pG9].x).normalize();
         Coordinates xl,nl;
         xl.zero();
         double al= (0.00);
         for(int jDOT= 0;jDOT<oDOTl;jDOT++){
            if( !G9[lG9].med.DOT[jDOT].HIT )continue;
            xl+=(G9[lG9].med.DOT[jDOT].a*G9[lG9].med.DOT[jDOT].x);
            al+=(G9[lG9].med.DOT[jDOT].a);
         }
         xl/=al;
         nl=( xl -G9[lG9].x).normalize();
         double Cthe= np(2);
         double zz=( (1.00) -Cthe*Cthe);
         if( zz<( 1.00e-25) )zz=( 1.00e-25);
         double Sthe= std::sqrt( zz);
         double the= std::atan2(Sthe,Cthe)/RAD;
         double Cphi( 1.00),Sphi( 0.00),phi(   0.00);
         if( Sthe>( 1.00e-12) ){
            Cphi= (np(0)/Sthe);
            Sphi= (np(1)/Sthe);
            phi= std::atan2(Sphi,Cphi)/RAD;
         }
         tAB& pab=AB(phi,the);
         pFn=pab.pF;
         pTn=pab.pT;
         Cthe= nl(2);
         zz=( (1.00) -Cthe*Cthe);
         if( zz<( 1.00e-25) )zz=( 1.00e-25);
         Sthe= std::sqrt( zz);
         the= std::atan2(Sthe,Cthe)/RAD;
         phi=(   0.00);
         if( Sthe>( 1.00e-12) ){
            Cphi= (nl(0)/Sthe);
            Sphi= (nl(1)/Sthe);
            phi= std::atan2(Sphi,Cphi)/RAD;
         }
         tAB& lab=AB(phi,the);
         lFn=lab.pF;
         lTn=lab.pT;
      }
//    out.FILE3<<" NATIVE\n";
//    out.FILE3<<" pF pT lF lT iJ\n";
//    out.FILE3<<std::setw( 3)<<pFn
//             <<std::setw( 3)<<pTn
//             <<std::setw( 3)<<lFn
//             <<std::setw( 3)<<lTn
//             <<std::setw( 3)<<iJn
//             <<'\n';
//    out.FILE3<<std::fixed<<std::setprecision( 2);
//    out.FILE3<<" jF jT    omg      as    zs     ahp"
//               "    rs    ec    m[   Bzs]\n";
//    out.FILE3<< std::setw( 3)<<pFn
//             << std::setw( 3)<<pTn
//             << std::setw( 7)<<G9[pG9].FT(pFn,pTn).omg
//             << std::setw( 8)<<(G9[pG9].FT(pFn,pTn).as*ANG*ANG)
//             << std::setw( 6)<<(G9[pG9].FT(pFn,pTn).zs*ANG)
//             << std::setw( 8)<<(G9[pG9].FT(pFn,pTn).ah*ANG*ANG)
//             << std::setw( 6)<<(G9[pG9].FT(pFn,pTn).rs*ANG)
//             << std::setw( 6)<<G9[pG9].FT(pFn,pTn).ec
//             << std::setw( 6)<<G9[pG9].FT(pFn,pTn).ms<<'[';
//    for(int iB=0;iB<6;iB++){
//       out.FILE3<< std::setw( 6)<<(G9[pG9].FT(pFn,pTn).B(iB).zs*ANG);
//    }
//    out.FILE3<<"]\n";
//    out.FILE3<< std::setw( 3)<<lFn
//             << std::setw( 3)<<lTn
//             << std::setw( 7)<<G9[lG9].FT(lFn,lTn).omg
//             << std::setw( 8)<<(G9[lG9].FT(lFn,lTn).as*ANG*ANG)
//             << std::setw( 6)<<(G9[lG9].FT(lFn,lTn).zs*ANG)
//             << std::setw( 8)<<(G9[lG9].FT(lFn,lTn).ah*ANG*ANG)
//             << std::setw( 6)<<(G9[lG9].FT(lFn,lTn).rs*ANG)
//             << std::setw( 6)<<G9[lG9].FT(lFn,lTn).ec
//             << std::setw( 6)<<G9[lG9].FT(lFn,lTn).ms<<'[';
//    for(int iB=0;iB<6;iB++){
//       out.FILE3<< std::setw( 6)<<(G9[lG9].FT(lFn,lTn).B(iB).zs*ANG);
//    }
//    out.FILE3<<"]\n";
//
//
// energy of native
//
      Coordinates TRANSn=G9[pG9].FT(pFn,pTn).ns;
      Rotation_Matrix ROTn;
      double dTRANS( 0.00),dROT( 0.00);
      {
         Coordinates TRANS1=( G9[pG9].FT(pFn,pTn).x -G9[pG9].x);
         int pFs=G9[pG9].FT(pFn,pTn).kF;
         int pTs=G9[pG9].FT(pFn,pTn).kT;
         Coordinates& n=FT(pFs,pTs).n;
         Rotation_Matrix& ROT1=FT(pFs,pTs).ROT;
         for(int iC=0;iC<3;iC++){
            Cq1[iC].populate( 7,G9[pG9].FT(pFn,pTn).C(iC).q);
         }
         for(int iB=0;iB<6;iB++){
            for(int iX=0;iX<4;iX++){
               for(int iN=0;iN<8;iN++){
                  BXNs(iB,iX,iN)=G9[pG9].FT(pFn,pTn).B(iB).XNs(iX,iN);
               }
            }
            Bu(iB)= G9[pG9].FT(pFn,pTn).B( 1).U
                   /G9[pG9].FT(pFn,pTn).B(iB).U;
         }
         for(int iC9= 0;iC9<pC9;iC9++){
            Coordinates b=G9[pG9].C9[iC9].b;
            b-=TRANS1;
            double r= b.r();
            double C= dot(b,n)/r;
            double the= std::acos( C);
            G9[pG9].C9[iC9].f= std::exp( alp*the*the);
            G9[pG9].C9[iC9].PASS=( the>(( .50)*PI) );
         }
         Z9[ 0].c=ROT1;
         Z9[ 0].t=ROT1*((-1.00)*TRANS1);
//
         Coordinates TRANS2=( G9[lG9].FT(lFn,lTn).x -G9[lG9].x);
         int lFs=G9[lG9].FT(lFn,lTn).kF;
         int lTs=G9[lG9].FT(lFn,lTn).kT;
         Rotation_Matrix& ROT2=FT(lFs,lTs).JROT[iJn];
         for(int iC=0;iC<3;iC++){
            Cq2[iC].populate( 7,G9[lG9].FT(lFn,lTn).C(iC).Jq(iJn));
         }
         Rotation_Matrix ROT=transpose(ROT1)*ROT2;
         R=( G9[lG9].FT(lFn,lTn).rs +G9[pG9].FT(pFn,pTn).rs);
         x=( TRANS1 +R*n -ROT*TRANS2);
         ROTn=ROT;
         for(int iB=0;iB<6;iB++){
            for(int iX=0;iX<4;iX++){
               BXs(iB,iX)=G9[lG9].FT(lFn,lTn).B(iB).JXs(iJn,iX);
            }
//          out.FILE3<<BXNs(iB, 0, 0);
//          out.FILE3<<BXs(iB, 0);
         }
         for(int iC9= 0;iC9<lC9;iC9++){
            Coordinates b=G9[lG9].C9[iC9].b;
            G9[lG9].C9[iC9].x.generate(x,ROT,b);
            b-=TRANS2;
            double r= b.r();
            double C= dot(b,FT(lFn,lTn).n)/r;
            double the= std::acos( C);
            G9[lG9].C9[iC9].f= std::exp( alp*the*the);
            G9[lG9].C9[iC9].PASS=( the>(( .50)*PI) );
         }
//
         ePack e2;
         bool OVERLAP=PCK_F(physics_consts,array_consts,out,
                            pG9,lG9,pFn,pTn,lFn,lTn,ROT,
                            oZ9,e2);
         Z9[ 1].c=ROT2;
         Z9[ 1].t=ROT2*((-1.00)*TRANS2);
         Z9[ 1].t(2)+=( G9[pG9].FT(pFn,pTn).zs
                       +G9[lG9].FT(lFn,lTn).zs
                       +doc.x*G9[pG9].FT(pFn,pTn).B( 1).U);
         Ftot=( Fe +Fm +Fs +Fh +Fp +Fi +Fd);
         dTRANS= dot(n,TRANSn);
         dROT= dot(ROT,ROTn);
      }
//    out.FILE3<<std::setprecision(2);
//    out.FILE3<<"  tot     e      m   "
//               "   s      h      p      i      d   \n";
//    out.FILE3<<std::setw( 7)<<Ftot
//             <<std::setw( 7)<<Fe
//             <<std::setw( 7)<<Fm
//             <<std::setw( 7)<<Fs
//             <<std::setw( 7)<<Fh
//             <<std::setw( 7)<<Fp
//             <<std::setw( 7)<<Fi
//             <<std::setw( 7)<<Fd
//             <<'\n';
//    out.FILE3<<"  dexp    dn     dr  \n";
//    out.FILE3<<std::setw( 7)<<( (1.60)*dTRANS +( .80)*dROT)
//             <<std::setw( 7)<<dTRANS
//             <<std::setw( 7)<<dROT
//             <<'\n';
//    out.FILE3<<doc;
//
//
// structure of native
//
      if( false ){
         Structure str;
         G9[pG9].bac.generate((ANG*Z9[ 0].t),
                              Z9[ 0].c,
                              G9[pG9].str);
         G9[pG9].bac.TOR(physics_consts,residue_mappings);
         str=G9[pG9].bac;
         G9[lG9].bac.generate((ANG*Z9[ 1].t),
                              Z9[ 1].c,
                              G9[lG9].str);
         G9[lG9].bac.TOR(physics_consts,residue_mappings);
         str+=G9[lG9].bac;
         str.mol=G9[pG9].str.mol+'_'
                +G9[lG9].str.mol;
         str.cnf="nat";
         str.TOR(physics_consts,residue_mappings);
         str.CAR2FIL();
//       std::string CNF="n";
//       double ztrans=( G9[pG9].FT(pFn,pTn).zs
//                      +G9[lG9].FT(lFn,lTn).zs
//                      +doc.x*G9[pG9].FT(pFn,pTn).B( 1).U);
//       PCK_VIS(physics_consts,array_consts,disulfide_links,energy_params,
//               region_maps,residue_mappings,
//               opt,out,
//               CNF,ztrans);
      }
//
//
// lattice 2-bod energies
//
      out.FILE3<<"PAIR OF BODS=("<< std::setw( 2)<<pG9
                            <<','<< std::setw( 2)<<lG9
                            <<')'<< std::endl;
//
//
// sparse search over lattice
//
      Fcut= ( 1.00e+4);
      int oD9=-1;
      for(int pF= 0;pF<20;pF++){
         for(int pT= 5;pT<64;pT+=16){
            Coordinates TRANS1=( G9[pG9].FT(pF,pT).x -G9[pG9].x);
            int pFs=G9[pG9].FT(pF,pT).kF;
            int pTs=G9[pG9].FT(pF,pT).kT;
            Coordinates& n=FT(pFs,pTs).n;
            Rotation_Matrix& ROT1=FT(pFs,pTs).ROT;
            for(int iC=0;iC<3;iC++){
               Cq1[iC].populate( 7,G9[pG9].FT(pF,pT).C(iC).q);
            }
            for(int iB=0;iB<6;iB++){
               for(int iX=0;iX<4;iX++){
                  for(int iN=0;iN<8;iN++){
                     BXNs(iB,iX,iN)=G9[pG9].FT(pF,pT).B(iB).XNs(iX,iN);
                  }
               }
               Bu(iB)= G9[pG9].FT(pF,pT).B( 1).U
                      /G9[pG9].FT(pF,pT).B(iB).U;
            }
            for(int iC9= 0;iC9<pC9;iC9++){
               Coordinates b=G9[pG9].C9[iC9].b;
               b-=TRANS1;
               double r= b.r();
               double C= dot(b,n)/r;
               double the= std::acos( C);
               G9[pG9].C9[iC9].f= std::exp( alp*the*the);
               G9[pG9].C9[iC9].PASS=( the>(( .50)*PI) );
            }
            Z9[ 0].c=ROT1;
            Z9[ 0].t=ROT1*((-1.00)*TRANS1);
            for(int lF= 0;lF<20;lF++){
               for(int lT= 5;lT<64;lT+=16){
                  Coordinates TRANS2=( G9[lG9].FT(lF,lT).x -G9[lG9].x);
                  int lFs=G9[lG9].FT(lF,lT).kF;
                  int lTs=G9[lG9].FT(lF,lT).kT;
                  for(int iJ= 0;iJ<64;iJ+=4){
                     Rotation_Matrix& ROT2=FT(lFs,lTs).JROT[iJ];
                     for(int iC=0;iC<3;iC++){
                        Cq2[iC].populate( 7,G9[lG9].FT(lF,lT).C(iC).Jq(iJ));
                     }
                     Rotation_Matrix ROT=transpose(ROT1)*ROT2;
                     R=( G9[lG9].FT(lF,lT).rs +G9[pG9].FT(pF,pT).rs);
                     x=( TRANS1 +R*n -ROT*TRANS2);
                     for(int iB=0;iB<6;iB++){
                        for(int iX=0;iX<4;iX++){
                           BXs(iB,iX)=G9[lG9].FT(lF,lT).B(iB).JXs(iJ,iX);
                        }
                     }
                     for(int iC9= 0;iC9<lC9;iC9++){
                        Coordinates b=G9[lG9].C9[iC9].b;
                        G9[lG9].C9[iC9].x.generate(x,ROT,b);
                        b-=TRANS2;
                        double r= b.r();
                        double C= dot(b,FT(lFs,lTs).n)/r;
                        double the= std::acos( C);
                        G9[lG9].C9[iC9].f= std::exp( alp*the*the);
                        G9[lG9].C9[iC9].PASS=( the>(( .50)*PI) );
                     }
//
//
// lattice energy of reduced model
//
                     ePack e2;
                     bool OVERLAP=PCK_F(physics_consts,array_consts,out,
                                        pG9,lG9,pF,pT,lF,lT,ROT,
                                        oZ9,e2);
                     if( OVERLAP )continue;
                     Z9[ 1].c=ROT2;
                     Z9[ 1].t=ROT2*((-1.00)*TRANS2);
                     Z9[ 1].t(2)+=( G9[pG9].FT(pF,pT).zs
                                   +G9[lG9].FT(lF,lT).zs
                                   +doc.x*G9[pG9].FT(pF,pT).B( 1).U);
                     Ftot=( Fe +Fm +Fs +Fh +Fp +Fi +Fd);
                     Fb=( pF*5242880 +pT*81920 +lF*4096 +lT*64 +iJ);
//
//
// measure of distance from native conf
//
                     double d=( (1.60)*dot(n,TRANSn)
                               +( .80)*dot(ROT,ROTn));
//                   if( d>( 3.50) ){
//                      out.FILE3<<std::setprecision(2);
//                      out.FILE3<<" pF pT lF lT iJ  dexp "
//                                 "  tot     e      m   "
//                                 "   s      h      p      i      d   \n";
//                      out.FILE3<<std::setw( 3)<<pF
//                               <<std::setw( 3)<<pT
//                               <<std::setw( 3)<<lF
//                               <<std::setw( 3)<<lT
//                               <<std::setw( 3)<<iJ
//                               <<std::setw( 7)<<d
//                               <<std::setw( 7)<<Ftot
//                               <<std::setw( 7)<<Fe
//                               <<std::setw( 7)<<Fm
//                               <<std::setw( 7)<<Fs
//                               <<std::setw( 7)<<Fh
//                               <<std::setw( 7)<<Fp
//                               <<std::setw( 7)<<Fi
//                               <<std::setw( 7)<<Fd
//                               <<'\n';
//                      out.FILE3<<doc;
//                   }
//
//
// characterization of docked config
//
                     if( oD9<4095 ){
                        Y9[iY9].D9.push_back( tY9::tY9D9());
                        oD9++;
                        Y9[iY9].D9[oD9].Z9.resize( 2);
                     }else{
                        if( Ftot>=Y9[iY9].D9[oD9].e.Ftot )continue;
                     }
                     Y9[iY9].D9[oD9].e=ePack(Fe,Fm,Fs,Fh,Fp,Fi,Fd);
                     Y9[iY9].D9[oD9].dexp= d;
                     Y9[iY9].D9[oD9].Z9[ 0].X=0;
                     Y9[iY9].D9[oD9].Z9[ 1].X=1;
                     Y9[iY9].D9[oD9].Z9[ 0].e= ( .50)*Y9[iY9].D9[oD9].e;
                     Y9[iY9].D9[oD9].Z9[ 1].e= ( .50)*Y9[iY9].D9[oD9].e;
                     Y9[iY9].D9[oD9].Z9[ 0].A=-1;
                     Y9[iY9].D9[oD9].Z9[ 1].A=Fb;
                     Y9[iY9].D9[oD9].Z9[ 0].B=Fb;
                     Y9[iY9].D9[oD9].Z9[ 1].B=-1;
                     for(int iZ9=0;iZ9<2;iZ9++){
                        Y9[iY9].D9[oD9].Z9[iZ9].c=Z9[iZ9].c;
                        Y9[iY9].D9[oD9].Z9[iZ9].t=Z9[iZ9].t;
                     }
                     Y9[iY9].D9[oD9].Q[ 0].t=Z9[ 0].t;
                     Y9[iY9].D9[oD9].Q[ 1].t=Z9[ 1].t;
                     Y9[iY9].D9[oD9].Q[ 0].r.identity();
                     Y9[iY9].D9[oD9].Q[ 1].r=J;
                     Y9[iY9].D9[oD9].Q[ 2].t=Y9[iY9].D9[oD9].Q[ 0].t;
                     Y9[iY9].D9[oD9].Q[ 3].t=Y9[iY9].D9[oD9].Q[ 1].t;
                     Y9[iY9].D9[oD9].Q[ 2].r=Y9[iY9].D9[oD9].Q[ 0].r;
                     Y9[iY9].D9[oD9].Q[ 3].r=Y9[iY9].D9[oD9].Q[ 1].r;
                     if( ( Ftot -Fm)<Fcut ){
                        Fcut=( Ftot -Fm);
                     }
//
//
// maintain order
//
                     for(int jD9=oD9;jD9> 0;jD9--){
                        if( Y9[iY9].D9[jD9   ].e.Ftot>=
                            Y9[iY9].D9[jD9- 1].e.Ftot )break;
                        Y9[iY9].D9[jD9   ].swap(
                        Y9[iY9].D9[jD9- 1]);
                     }
                  }
               }
            }
         }
      }
      Y9[iY9].oD9=(oD9+ 1);
////  out.FILE3<<"________"<< std::endl;
      out.FILE3<<"SEARCH ON SPARSE GRID\n";
      out.FILE3<<Y9[iY9];
//
//
// intermediate search over lattice
//
      int o=Y9[iY9].oD9;
      tY9 xY9=Y9[iY9];
      oD9=(o-1);
      for(int iD9=0;iD9<o;iD9++){
         int iJ=xY9.D9[iD9].Z9[ 0].B;
         int pF=(iJ/5242880);
         iJ-=(pF*5242880);
         int pTmin(-1),pTmax(-1);
         {
            int pT=(iJ/81920);
            iJ-=(pT*81920);
            pTmin=(pT- 4);
            pTmax=(pT+11);
         }
         int lF=(iJ/4096);
         iJ-=(lF*4096);
         int lTmin(-1),lTmax(-1);
         {
            int lT=(iJ/64);
            iJ-=(lT*64);
            lTmin=(lT- 4);
            lTmax=(lT+11);
         }
         int iJmin=iJ;
         int iJmax(iJ+4);
         for(int pT=pTmin;pT<pTmax;pT+=4){
            Coordinates TRANS1=( G9[pG9].FT(pF,pT).x -G9[pG9].x);
            int pFs=G9[pG9].FT(pF,pT).kF;
            int pTs=G9[pG9].FT(pF,pT).kT;
            Coordinates& n=FT(pFs,pTs).n;
            Rotation_Matrix& ROT1=FT(pFs,pTs).ROT;
            for(int iC=0;iC<3;iC++){
               Cq1[iC].populate( 7,G9[pG9].FT(pF,pT).C(iC).q);
            }
            for(int iB=0;iB<6;iB++){
               for(int iX=0;iX<4;iX++){
                  for(int iN=0;iN<8;iN++){
                     BXNs(iB,iX,iN)=G9[pG9].FT(pF,pT).B(iB).XNs(iX,iN);
                  }
               }
               Bu(iB)= G9[pG9].FT(pF,pT).B( 1).U
                      /G9[pG9].FT(pF,pT).B(iB).U;
            }
            for(int iC9= 0;iC9<pC9;iC9++){
               Coordinates b=G9[pG9].C9[iC9].b;
               b-=TRANS1;
               double r= b.r();
               double C= dot(b,n)/r;
               double the= std::acos( C);
               G9[pG9].C9[iC9].f= std::exp( alp*the*the);
               G9[pG9].C9[iC9].PASS=( the>(( .50)*PI) );
            }
            Z9[ 0].c=ROT1;
            Z9[ 0].t=ROT1*((-1.00)*TRANS1);
            for(int lT=lTmin;lT<lTmax;lT+=4){
               Coordinates TRANS2=( G9[lG9].FT(lF,lT).x -G9[lG9].x);
               int lFs=G9[lG9].FT(lF,lT).kF;
               int lTs=G9[lG9].FT(lF,lT).kT;
               for(iJ=iJmin;iJ<iJmax;iJ+=2){
                  if( (pT==(pTmin+4))&&
                      (lT==(lTmin+4))&&
                      (iJ==iJmin) )continue;
                  Rotation_Matrix& ROT2=FT(lFs,lTs).JROT[iJ];
                  for(int iC=0;iC<3;iC++){
                     Cq2[iC].populate( 7,G9[lG9].FT(lF,lT).C(iC).Jq(iJ));
                  }
                  Rotation_Matrix ROT=transpose(ROT1)*ROT2;
                  R=( G9[lG9].FT(lF,lT).rs +G9[pG9].FT(pF,pT).rs);
                  x=( TRANS1 +R*n -ROT*TRANS2);
                  for(int iB=0;iB<6;iB++){
                     for(int iX=0;iX<4;iX++){
                        BXs(iB,iX)=G9[lG9].FT(lF,lT).B(iB).JXs(iJ,iX);
                     }
                  }
                  for(int iC9= 0;iC9<lC9;iC9++){
                     Coordinates b=G9[lG9].C9[iC9].b;
                     G9[lG9].C9[iC9].x.generate(x,ROT,b);
                     b-=TRANS2;
                     double r= b.r();
                     double C= dot(b,FT(lFs,lTs).n)/r;
                     double the= std::acos( C);
                     G9[lG9].C9[iC9].f= std::exp( alp*the*the);
                     G9[lG9].C9[iC9].PASS=( the>(( .50)*PI) );
                  }
//
//
// lattice energy of reduced model
//
                  ePack e2;
                  bool OVERLAP=PCK_F(physics_consts,array_consts,out,
                                     pG9,lG9,pF,pT,lF,lT,ROT,
                                     oZ9,e2);
                  if( OVERLAP )continue;
                  Z9[ 1].c=ROT2;
                  Z9[ 1].t=ROT2*((-1.00)*TRANS2);
                  Z9[ 1].t(2)+=( G9[pG9].FT(pF,pT).zs
                                +G9[lG9].FT(lF,lT).zs
                                +doc.x*G9[pG9].FT(pF,pT).B( 1).U);
                  Ftot=( Fe +Fm +Fs +Fh +Fp +Fi +Fd);
                  Fb=( pF*5242880 +pT*81920 +lF*4096 +lT*64 +iJ);
//
//
// measure of distance from native conf
//
                  double d=( (1.60)*dot(n,TRANSn)
                            +( .80)*dot(ROT,ROTn));
//                if( Ftot<( xY9.D9[ 0].e.Ftot +( 4.00)) ){
//                   out.FILE3<<std::setprecision(2);
//                   out.FILE3<<" pF pT lF lT iJ  dexp "
//                              "  tot     e      m   "
//                              "   s      h      p      i      d   \n";
//                   out.FILE3<<std::setw( 3)<<pF
//                            <<std::setw( 3)<<pT
//                            <<std::setw( 3)<<lF
//                            <<std::setw( 3)<<lT
//                            <<std::setw( 3)<<iJ
//                            <<std::setw( 7)<<d
//                            <<std::setw( 7)<<Ftot
//                            <<std::setw( 7)<<Fe
//                            <<std::setw( 7)<<Fm
//                            <<std::setw( 7)<<Fs
//                            <<std::setw( 7)<<Fh
//                            <<std::setw( 7)<<Fp
//                            <<std::setw( 7)<<Fi
//                            <<std::setw( 7)<<Fd
//                            <<'\n';
//                }
//
//
// characterization of docked config
//
                  if( oD9<8191 ){
                     Y9[iY9].D9.push_back( tY9::tY9D9());
                     oD9++;
                     Y9[iY9].D9[oD9].Z9.resize( 2);
                  }else{
                     if( Ftot>=Y9[iY9].D9[oD9].e.Ftot )continue;
                  }
                  Y9[iY9].D9[oD9].e=ePack(Fe,Fm,Fs,Fh,Fp,Fi,Fd);
                  Y9[iY9].D9[oD9].dexp= d;
                  Y9[iY9].D9[oD9].Z9[ 0].X=0;
                  Y9[iY9].D9[oD9].Z9[ 1].X=1;
                  Y9[iY9].D9[oD9].Z9[ 0].e= ( .50)*Y9[iY9].D9[oD9].e;
                  Y9[iY9].D9[oD9].Z9[ 1].e= ( .50)*Y9[iY9].D9[oD9].e;
                  Y9[iY9].D9[oD9].Z9[ 0].A=-1;
                  Y9[iY9].D9[oD9].Z9[ 1].A=Fb;
                  Y9[iY9].D9[oD9].Z9[ 0].B=Fb;
                  Y9[iY9].D9[oD9].Z9[ 1].B=-1;
                  for(int iZ9=0;iZ9<2;iZ9++){
                     Y9[iY9].D9[oD9].Z9[iZ9].c=Z9[iZ9].c;
                     Y9[iY9].D9[oD9].Z9[iZ9].t=Z9[iZ9].t;
                  }
                  Y9[iY9].D9[oD9].Q[ 0].t=Z9[ 0].t;
                  Y9[iY9].D9[oD9].Q[ 1].t=Z9[ 1].t;
                  Y9[iY9].D9[oD9].Q[ 0].r.identity();
                  Y9[iY9].D9[oD9].Q[ 1].r=J;
                  Y9[iY9].D9[oD9].Q[ 2].t=Y9[iY9].D9[oD9].Q[ 0].t;
                  Y9[iY9].D9[oD9].Q[ 3].t=Y9[iY9].D9[oD9].Q[ 1].t;
                  Y9[iY9].D9[oD9].Q[ 2].r=Y9[iY9].D9[oD9].Q[ 0].r;
                  Y9[iY9].D9[oD9].Q[ 3].r=Y9[iY9].D9[oD9].Q[ 1].r;
                  if( ( Ftot -Fm)<Fcut ){
                     Fcut=( Ftot -Fm);
                  }
//
//
// maintain order
//
                  for(int jD9=oD9;jD9> 0;jD9--){
                     if( Y9[iY9].D9[jD9   ].e.Ftot>=
                         Y9[iY9].D9[jD9- 1].e.Ftot )break;
                     Y9[iY9].D9[jD9   ].swap(
                     Y9[iY9].D9[jD9- 1]);
                  }
               }
            }
         }
      }
      oD9++;
      Y9[iY9].oD9=oD9;
////  out.FILE3<<"________"<< std::endl;
      out.FILE3<<"SEARCH ON INTERMEDIATE GRID\n";
      out.FILE3<<Y9[iY9];
//
//
// diversity centered on representative confs
//
      for(int iD9=0;iD9<oD9;iD9++){
         int iJ=Y9[iY9].D9[iD9].Z9[ 0].B;
         int pF=(iJ/5242880);
         iJ-=(pF*5242880);
         int pTmin(-1),pTmax(-1);
         {
            int pT=(iJ/81920);
            iJ-=(pT*81920);
            pTmin=(pT- 1);
            pTmax=(pT+ 3);
         }
         int lF=(iJ/4096);
         iJ-=(lF*4096);
         int lTmin(-1),lTmax(-1);
         {
            int lT=(iJ/64);
            iJ-=(lT*64);
            lTmin=(lT- 1);
            lTmax=(lT+ 3);
         }
         int iJmin=iJ;
         int iJmax(iJ+2);
         for(int pT=pTmin;pT<pTmax;pT++){
            Coordinates TRANS1=( G9[pG9].FT(pF,pT).x -G9[pG9].x);
            int pFs=G9[pG9].FT(pF,pT).kF;
            int pTs=G9[pG9].FT(pF,pT).kT;
            Coordinates& n=FT(pFs,pTs).n;
            Rotation_Matrix& ROT1=FT(pFs,pTs).ROT;
            for(int iC=0;iC<3;iC++){
               Cq1[iC].populate( 7,G9[pG9].FT(pF,pT).C(iC).q);
            }
            for(int iB=0;iB<6;iB++){
               for(int iX=0;iX<4;iX++){
                  for(int iN=0;iN<8;iN++){
                     BXNs(iB,iX,iN)=G9[pG9].FT(pF,pT).B(iB).XNs(iX,iN);
                  }
               }
               Bu(iB)= G9[pG9].FT(pF,pT).B( 1).U
                      /G9[pG9].FT(pF,pT).B(iB).U;
            }
            for(int iC9= 0;iC9<pC9;iC9++){
               Coordinates b=G9[pG9].C9[iC9].b;
               b-=TRANS1;
               double r= b.r();
               double C= dot(b,n)/r;
               double the= std::acos( C);
               G9[pG9].C9[iC9].f= std::exp( alp*the*the);
               G9[pG9].C9[iC9].PASS=( the>(( .50)*PI) );
            }
            Z9[ 0].c=ROT1;
            Z9[ 0].t=ROT1*((-1.00)*TRANS1);
            for(int lT=lTmin;lT<lTmax;lT++){
               Coordinates TRANS2=( G9[lG9].FT(lF,lT).x -G9[lG9].x);
               int lFs=G9[lG9].FT(lF,lT).kF;
               int lTs=G9[lG9].FT(lF,lT).kT;
               for(iJ=iJmin;iJ<iJmax;iJ++){
                  if( (pT==(pTmin+1))&&
                      (lT==(lTmin+1))&&
                      (iJ==iJmin) )continue;
                  Rotation_Matrix& ROT2=FT(lFs,lTs).JROT[iJ];
                  for(int iC=0;iC<3;iC++){
                     Cq2[iC].populate( 7,G9[lG9].FT(lF,lT).C(iC).Jq(iJ));
                  }
                  Rotation_Matrix ROT=transpose(ROT1)*ROT2;
                  R=( G9[lG9].FT(lF,lT).rs +G9[pG9].FT(pF,pT).rs);
                  x=( TRANS1 +R*n -ROT*TRANS2);
                  for(int iB=0;iB<6;iB++){
                     for(int iX=0;iX<4;iX++){
                        BXs(iB,iX)=G9[lG9].FT(lF,lT).B(iB).JXs(iJ,iX);
                     }
                  }
                  for(int iC9= 0;iC9<lC9;iC9++){
                     Coordinates b=G9[lG9].C9[iC9].b;
                     G9[lG9].C9[iC9].x.generate(x,ROT,b);
                     b-=TRANS2;
                     double r= b.r();
                     double C= dot(b,FT(lFs,lTs).n)/r;
                     double the= std::acos( C);
                     G9[lG9].C9[iC9].f= std::exp( alp*the*the);
                     G9[lG9].C9[iC9].PASS=( the>(( .50)*PI) );
                  }
//
//
// lattice energy of reduced model
//
                  ePack e2;
                  bool OVERLAP=PCK_F(physics_consts,array_consts,out,
                                     pG9,lG9,pF,pT,lF,lT,ROT,
                                     oZ9,e2);
                  if( OVERLAP )continue;
                  Z9[ 1].c=ROT2;
                  Z9[ 1].t=ROT2*((-1.00)*TRANS2);
                  Z9[ 1].t(2)+=( G9[pG9].FT(pF,pT).zs
                                +G9[lG9].FT(lF,lT).zs
                                +doc.x*G9[pG9].FT(pF,pT).B( 1).U);
                  Ftot=( Fe +Fm +Fs +Fh +Fp +Fi +Fd);
                  Fb=( pF*5242880 +pT*81920 +lF*4096 +lT*64 +iJ);
//
//
// measure of distance from native conf
//
                  double d=( (1.60)*dot(n,TRANSn)
                            +( .80)*dot(ROT,ROTn));
//                if( Ftot<( Y9[iY9].D9[ 0].e.Ftot +( 4.00)) ){
//                   out.FILE3<<std::setprecision(2);
//                   out.FILE3<<" pF pT lF lT iJ  dexp "
//                              "  tot     e      m   "
//                              "   s      h      p      i      d   \n";
//                   out.FILE3<<std::setw( 3)<<pF
//                            <<std::setw( 3)<<pT
//                            <<std::setw( 3)<<lF
//                            <<std::setw( 3)<<lT
//                            <<std::setw( 3)<<iJ
//                            <<std::setw( 7)<<d
//                            <<std::setw( 7)<<Ftot
//                            <<std::setw( 7)<<Fe
//                            <<std::setw( 7)<<Fm
//                            <<std::setw( 7)<<Fs
//                            <<std::setw( 7)<<Fh
//                            <<std::setw( 7)<<Fp
//                            <<std::setw( 7)<<Fi
//                            <<std::setw( 7)<<Fd
//                            <<'\n';
//                }
//
//
// characterization of docked config
//
                  if( Ftot>=Y9[iY9].D9[iD9].e.Ftot )continue;
                  Y9[iY9].D9[iD9].e=ePack(Fe,Fm,Fs,Fh,Fp,Fi,Fd);
                  Y9[iY9].D9[iD9].dexp= d;
                  Y9[iY9].D9[iD9].Z9[ 0].X=0;
                  Y9[iY9].D9[iD9].Z9[ 1].X=1;
                  Y9[iY9].D9[iD9].Z9[ 0].e= ( .50)*Y9[iY9].D9[iD9].e;
                  Y9[iY9].D9[iD9].Z9[ 1].e= ( .50)*Y9[iY9].D9[iD9].e;
                  Y9[iY9].D9[iD9].Z9[ 0].A=-1;
                  Y9[iY9].D9[iD9].Z9[ 1].A=Fb;
                  Y9[iY9].D9[iD9].Z9[ 0].B=Fb;
                  Y9[iY9].D9[iD9].Z9[ 1].B=-1;
                  for(int iZ9=0;iZ9<2;iZ9++){
                     Y9[iY9].D9[iD9].Z9[iZ9].c=Z9[iZ9].c;
                     Y9[iY9].D9[iD9].Z9[iZ9].t=Z9[iZ9].t;
                  }
                  Y9[iY9].D9[iD9].Q[ 0].t=Z9[ 0].t;
                  Y9[iY9].D9[iD9].Q[ 1].t=Z9[ 1].t;
                  Y9[iY9].D9[iD9].Q[ 0].r.identity();
                  Y9[iY9].D9[iD9].Q[ 1].r=J;
                  Y9[iY9].D9[iD9].Q[ 2].t=Y9[iY9].D9[iD9].Q[ 0].t;
                  Y9[iY9].D9[iD9].Q[ 3].t=Y9[iY9].D9[iD9].Q[ 1].t;
                  Y9[iY9].D9[iD9].Q[ 2].r=Y9[iY9].D9[iD9].Q[ 0].r;
                  Y9[iY9].D9[iD9].Q[ 3].r=Y9[iY9].D9[iD9].Q[ 1].r;
                  if( ( Ftot -Fm)<Fcut ){
                     Fcut=( Ftot -Fm);
                  }
               }
            }
         }
//
//
// maintain order
//
         for(int jD9=iD9;jD9> 0;jD9--){
            if( Y9[iY9].D9[jD9   ].e.Ftot>=
                Y9[iY9].D9[jD9- 1].e.Ftot )break;
            Y9[iY9].D9[jD9   ].swap(
            Y9[iY9].D9[jD9- 1]);
         }
      }
//
//
// diagnostic output
//
////  out.FILE3<<"________"<< std::endl;
      out.FILE3<<"SEARCH ON FULL GRID\n";
      out.FILE3<<Y9[iY9];
//
//
// cluster
//
      Y9[iY9].CLUSTER(physics_consts,out);
////  out.FILE3<<"________"<< std::endl;
      out.FILE3<<"COLLECTION OF DOCKED CONFORMATIONS\n";
      out.FILE3<<Y9[iY9];
//
//
// composite structure
//
      for(int iD9= 0;iD9<oD9;iD9++){
         Structure str;
         G9[pG9].bac.generate((ANG*Y9[iY9].D9[iD9].Z9[ 0].t),
                              Y9[iY9].D9[iD9].Z9[ 0].c,
                              G9[pG9].str);
         G9[pG9].bac.TOR(physics_consts,residue_mappings);
         str=G9[pG9].bac;
         G9[lG9].bac.generate((ANG*Y9[iY9].D9[iD9].Z9[ 1].t),
                              Y9[iY9].D9[iD9].Z9[ 1].c,
                              G9[lG9].str);
         G9[lG9].bac.TOR(physics_consts,residue_mappings);
         str+=G9[lG9].bac;
         str.mol=G9[pG9].str.mol+'_'
                +G9[lG9].str.mol;
         {
            std::string cnf="____";
            int ii=iD9;
            for(int i=0;i<4;i++){
               cnf[3-i]=char('0'+(ii%10));
               ii/=10;
            }
            str.cnf="e"+cnf;
         }
         str.TOR(physics_consts,residue_mappings);
         str.CAR2FIL();
/**/     if( iD9==63 )break;
      }
   }
   std::cout<<"2-BODY ENERGIES COMPLETED"<< std::endl;
//
//
// partial config backup
//
   bool EMPTY=true;
   for(int iY9= 0;iY9<oY9;iY9++){
      if( Y9[iY9].oD9>0 ){
         U9[ 2].Y9[iY9]=Y9[iY9].D9[ 0];
         EMPTY=false;
      }else{
      }
   }
   return EMPTY;
}
