#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../pck/Packing_Search.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <vector>
#include <iomanip>

class MEM_pck {
private:
   std::vector<int> o_Z9Y9;     //group of n (n-1)-bod subsystems
   std::vector<int> o_Z9G9;     //map of position in subsystem to bod
   std::vector<bool> o_G9sub;   //subset of bods
public:
   MEM_pck(int g):
      o_Z9Y9(g),
      o_Z9G9(g),
      o_G9sub(g, false)
   {
   }
   int& Z9Y9(int i){
      return o_Z9Y9.at( i);  }
   int& Z9G9(int i){
      return o_Z9G9.at( i);  }
   void G9sub(int i,bool a){
      o_G9sub[ i]=a;  }
   bool G9sub(int i){
      return o_G9sub[ i];  }
};

void Packing_Search::PCK(
         const DAT_PHYSICS_CONSTS& physics_consts,
         const DAT_ARRAY_CONSTS& array_consts,
         const DAT_DISULFIDE_LINKS& disulfide_links,
         const DAT_ENERGY_PARAMS& energy_params,
         const DAT_REGION_MAPS& region_maps,
         const DAT_RESIDUE_MAPPINGS& residue_mappings,
         Thread_Options& opt,
         Output_Streams& out){
   double ANG= physics_consts.ANG;
   double RAD= physics_consts.RAD;
//
//
// sample points on a sphere
//
   PCK_SPHERE(physics_consts,array_consts,
              out);
//
//
// calc x, q, r, and s for bods
//
   PCK_ICO(physics_consts,array_consts,disulfide_links,energy_params,
           region_maps,residue_mappings,
           opt,out);
   for(int iG9= 0;iG9<oG9;iG9++){
      x=(ANG*G9[iG9].x);
      Structure& str=G9[iG9].str;
      for(int iZ0= 0;iZ0<str.nZ0;iZ0++){
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int mP1=str.R0[iR0].P1a;
            int nP1=(mP1-1+str.R0[iR0].cP1);
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( str.P1[iP1].sub==0 )continue;
               str.P1[iP1].x-=x;
            }
         }
      }
   }
//
//
// diagnostic output
//
// out.FILE3<< std::fixed;
// for(int iG9= 0;iG9<oG9;iG9++){
//    out.FILE3<<"BOD MEAN POSITION (angstrom)\n";
//    out.FILE3<<(ANG*G9[iG9].x)
//             <<'\n';
//    out.FILE3<<" jF jT   alp    bet    rs    zs    m [   Bzs]\n";
//    for(int jF= 0;jF<20;jF++){
//       for(int jT= 0;jT<64;jT++){
//          out.FILE3<< std::setw( 3)<<jF
//                   << std::setw( 3)<<jT
//                   << std::setprecision(2)
//                   << std::setw( 7)<<(FT(jF,jT).alp/RAD)
//                   << std::setw( 7)<<(FT(jF,jT).bet/RAD)
//                   << std::setw( 6)<<(G9[iG9].FT(jF,jT).rs*ANG)
//                   << std::setw( 6)<<(G9[iG9].FT(jF,jT).zs*ANG)
//                   << std::setw( 6)<<G9[iG9].FT(jF,jT).ms<<'[';
//          for(int iB=0;iB<6;iB++){
//             out.FILE3<< std::setw( 6)<<(G9[iG9].FT(jF,jT).B(iB).zs*ANG);
//          }
//          out.FILE3<<"]\n";
//       }
//    }
//    out.FILE3<<"MULTIPOLES AT ORIGIN\n";
//    for(int jF= 0;jF<20;jF++){
//       for(int jT= 0;jT<64;jT++){
//          for(int jC=0;jC<3;jC++){
//             out.FILE3<< std::setw( 3)<<jF
//                      << std::setw( 3)<<jT
//                      << std::setw( 3)<<jC
//                      <<'\n';
//             out.FILE3<<G9[iG9].FT(jF,jT).C(jC).q;
//          }
//       }
//    }
// }
//
//
// pairs of bods
//
   oU9=(oG9+ 1);
   U9.clear();
   U9.resize(oU9);
   pU9=2;
   oY9=oG9*(oG9- 1)/2;
   U9[pU9].Y9.resize(oY9);
   int iY9=0;
   for(int iG9= 0;iG9<(oG9- 1);iG9++){
      for(int jG9=(iG9+ 1);jG9<oG9;jG9++){
         U9[pU9].Y9[iY9].Z9.resize( 2);
         U9[pU9].Y9[iY9].Z9[ 0].G9=iG9;
         U9[pU9].Y9[iY9].Z9[ 1].G9=jG9;
         U9[pU9].Y9[iY9].STABLE=false;
         U9[pU9].Y9[iY9].FACTOR=false;
         iY9++;
      }
   }
   U9[pU9].oY9=iY9;
//
//
// 2-bod docking energies
//
   Z9.clear();
   Z9.resize( 2);
   bool EMPTY=PCK_2BOD(physics_consts,array_consts,disulfide_links,
                       energy_params,region_maps,residue_mappings,
                       opt,out);
   if( EMPTY ){
      Ftot= (0.00);
      Fe= (0.00);
      Fm= (0.00);
      Fs= (0.00);
      Fh= (0.00);
      Fp= (0.00);
      Fi= (0.00);
      Fd= (0.00);
      oU9=0;
      oT9=0;
      return;
   }
//
//
// recursive growth of subsystems from (pU-1)-bod to pU-bod
//
   MEM_pck vv(oG9);
   for(int iU9= 3;iU9<oU9;iU9++){
      pU9=iU9;
      int qU9=(pU9- 1);
      int jI9=0;
      int iZ9=0;
      vv.Z9Y9(iZ9)=-1;
      while( true ){
         vv.Z9Y9(iZ9)++;
         if( vv.Z9Y9(iZ9)>(U9[qU9].oY9-pU9+iZ9) ){
            if( iZ9== 0 ){
               break;
            }else{
               iZ9--;
               continue;
            }
//
         }else{
            if      ( iZ9== 1 ){
               int n=0;
               for(int aZ9= 0;aZ9<qU9;aZ9++){
                  for(int bZ9= 0;bZ9<qU9;bZ9++){
                     if( U9[qU9].Y9[vv.Z9Y9( 1)].Z9[bZ9].G9==
                         U9[qU9].Y9[vv.Z9Y9( 0)].Z9[aZ9].G9 )n++;
                  }
               }
               if( n<(qU9- 1) )continue;
               int pZ9=-1;
               for(int aZ9= 0;aZ9<qU9;aZ9++){
                  bool MATCH=false;
                  for(int bZ9= 0;bZ9<qU9&&(!MATCH);bZ9++){
                     if( U9[qU9].Y9[vv.Z9Y9( 1)].Z9[bZ9].G9==
                         U9[qU9].Y9[vv.Z9Y9( 0)].Z9[aZ9].G9 )MATCH=true;
                  }
                  if( !MATCH ){
                     pZ9=aZ9;
                     break;
                  }
               }
               if( pZ9<(qU9- 1) )continue;
               U9[pU9].Y9.push_back( tU9::tU9Y9());
               for(int aZ9= 0;aZ9<qU9;aZ9++){
                  vv.Z9G9(aZ9)=U9[qU9].Y9[vv.Z9Y9( 0)].Z9[aZ9].G9;
               }
               vv.Z9G9(qU9)=U9[qU9].Y9[vv.Z9Y9( 1)].Z9[qU9- 1].G9;
//             {
//                out.FILE3<<"SUBSET OF BODS=("
//                for(int jZ9= 0;jZ9<pU9;jZ9++){
//                   out.FILE3<<std::setw( 2)<<vv.Z9G9(jZ9)
//                            <<(( jZ9<qU9 )? ',': ')');
//                }
//                out.FILE3<<'\n';
//             }
            }else if( iZ9> 1 ){
               bool INGROUP=true;
               for(int aZ9= 0;aZ9<qU9&&( INGROUP);aZ9++){
                  bool MATCH=false;
                  for(int jZ9= 0;jZ9<pU9&&(!MATCH);jZ9++){
                     if( vv.Z9G9(jZ9)==
                         U9[qU9].Y9[vv.Z9Y9(iZ9)].Z9[aZ9].G9 )MATCH=true;
                  }
                  if( !MATCH )INGROUP=false;
               }
               if( !INGROUP )continue;
            }
            if( iZ9==(pU9- 1) ){
//             {
//                out.FILE3<<"SEQUENCE OF "
//                         <<std::setw( 2)<<qU9
//                         <<"-BOD SUBSYSTEMS=(";
//                for(int jZ9= 0;jZ9<pU9;jZ9++){
//                   out.FILE3<<std::setw( 4)<<vv.Z9Y9(jZ9)
//                            <<(( jZ9<qU9 )? ',': ')');
//                }
//                out.FILE3<<'\n';
//             }
               U9[pU9].Y9[jI9].Z9.resize(pU9);
               for(int jZ9= 0;jZ9<pU9;jZ9++){
                  U9[pU9].Y9[jI9].Z9[jZ9].G9=vv.Z9G9(jZ9);
                  U9[pU9].Y9[jI9].Z9[jZ9].Y9=vv.Z9Y9(jZ9);
               }
               U9[pU9].Y9[jI9].STABLE=false;
               U9[pU9].Y9[jI9].FACTOR=false;
               jI9++;
            }else{
               iZ9++;
               vv.Z9Y9(iZ9)=vv.Z9Y9(iZ9- 1);
            }
//
         }
      }
      U9[pU9].oY9=jI9;
//
//
// pU-bod packing energies
//
      Z9.clear();
      Z9.resize(pU9);
      EMPTY=PCK_NBOD(physics_consts,array_consts,
                     out);
//
//
// condition for continued recursion
//
      if( EMPTY ){
         pU9--;
         break;
      }
   }
//
//
// a full config is optimal
//
   oY9=U9[pU9].oY9;
   for(int iY9= 0;iY9<oY9;iY9++){
      if( U9[pU9].Y9[iY9].STABLE ){
         U9[pU9].Y9[iY9].FACTOR=true;
      }
   }
//
//
// remove non-factor sub configs
//
   for(int iU9= 2;iU9<=pU9;iU9++){
      oY9=U9[iU9].oY9;
      for(int iY9= 0;iY9<oY9;iY9++){
         if( !U9[iU9].Y9[iY9].FACTOR ){
            U9[iU9].Y9[iY9].STABLE=false;
         }
      }
   }
//
//
// order factor sub configs
//
   T9.clear();
   oT9=0;
   for(int iU9=pU9;iU9>=2;iU9--){
      oY9=U9[iU9].oY9;
      for(int iY9= 0;iY9<oY9;iY9++){
         if( !U9[iU9].Y9[iY9].STABLE )continue;
         T9.push_back( tT9());
         T9[oT9].e=U9[iU9].Y9[iY9].e;
         T9[oT9].U9=iU9;
         T9[oT9].Y9=iY9;
         oT9++;
      }
   }
   for(int jT9max=(oT9-1);jT9max> 0;jT9max--){
      bool ORDERED=true;
      double e1= T9[ 0].e.Ftot;
      for(int jT9= 1;jT9<=jT9max;jT9++){
         double e2= T9[jT9].e.Ftot;
         if( e2<e1 ){
            T9[jT9  ].swap(
            T9[jT9-1]);
            ORDERED=false;
         }else{
            e1=e2;
         }
      }
      if( ORDERED )break;
   }
//
//
// optimize partition
//
   ePack e;
   e.zero();
   double z= ( 0.00);
   for(int iT9= 0;iT9<oT9;iT9++){
      int iU9=T9[iT9].U9;
      int iY9=T9[iT9].Y9;
      bool DISJOINT=true;
      for(int iZ9= 0;iZ9<iU9&&( DISJOINT);iZ9++){
         int iG9=U9[iU9].Y9[iY9].Z9[iZ9].G9;
         if( vv.G9sub(iG9) )DISJOINT=false;
      }
      if( DISJOINT ){
         for(int iZ9= 0;iZ9<iU9;iZ9++){
            int iG9=U9[iU9].Y9[iY9].Z9[iZ9].G9;
            vv.G9sub(iG9,true);
         }
         e+=U9[iU9].Y9[iY9].e;
         T9[iT9].sub=true;
         z+=( 1.00);
      }else{
         T9[iT9].sub=false;
      }
   }
   e/=z;
//
//
// func value
//
   if( oT9> 0 ){
      Ftot= e.Ftot;
      Fe= e.Fe;
      Fm= e.Fm;
      Fs= e.Fs;
      Fh= e.Fh;
      Fp= e.Fp;
      Fi= e.Fi;
      Fd= e.Fd;
   }else{
      Ftot= (0.00);
      Fe= (0.00);
      Fm= (0.00);
      Fs= (0.00);
      Fh= (0.00);
      Fp= (0.00);
      Fi= (0.00);
      Fd= (0.00);
   }
//
//
// diagnostic output
//
   if( false ){
      out.FILE3<<"oG9\n";
      out.FILE3<<std::setw( 3)<<oG9<<'\n';
      out.FILE3<<U9;
      out.FILE3<<T9;
      out.FILE3<<"ENERGY OF PACKED BODS\n";
      out.FILE3<<std::setprecision( 3);
      out.FILE3<<"  tot     e      m      s      h      p      i      d   \n";
      out.FILE3<<std::setw( 7)<<e.Ftot
               <<std::setw( 7)<<e.Fe
               <<std::setw( 7)<<e.Fm
               <<std::setw( 7)<<e.Fs
               <<std::setw( 7)<<e.Fh
               <<std::setw( 7)<<e.Fp
               <<std::setw( 7)<<e.Fi
               <<std::setw( 7)<<e.Fd
               <<'\n';
   }
   return;
}
