#ifndef DEF_PACKING_SEARCH
#define DEF_PACKING_SEARCH

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../phi/Scratch_Multipoles.hh"
#include "../phi/Spherical_Harmonics.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cmath>
//
class Packing_Search {
public:
//
//________________________________________________________________
   class tG9 { //bod in pack
   public:
      class tC9 { //full charges
      public:
         Coordinates b;                 //position pre trans+rot (bohr)
         Gaussian_Volume ef[4];         //elec field density sqrt(hart/bohr**3)
         int R0;                        //
         std::string aa;                //
         std::string atm;               //
         double q;                      //charge
         Coordinates x;                 //position (bohr) relative to center
         double f;                      //scale factor
         double PASS;                   //negligible contribution
         tC9(){}
      };
      class tV9 { //nonoplar side chain clusters
      public:
         Coordinates b;                 //position pre trans+rot (bohr)
         Gaussian_Volume vf;            //volume density
         std::vector<int> XR0;          //side chains of cluster
         int oX;                        //number
         Coordinates x;                 //position (bohr) relative to center
         tV9(){}
      };
      class uFT { //points on unit sphere
      public:
         class uB { //shell of patch
         public:
            double U;                       //unit of dist (bohr) for patch
            double zs;                      //mean z component (bohr) of shell
            std::vector<Multipoles> o_XNs;  //X={s,h,p,i} N={translate coeffs}
            std::vector<Multipoles> o_JXs;  //Xs in system JROT
            uB():
               o_XNs( 4* 8, Multipoles(7)),
               o_JXs(64* 4, Multipoles(7))
            {
            }
            Multipoles& XNs(int i,int j){
               return o_XNs.at( i*8 +j);  }
            Multipoles& JXs(int i,int j){
               return o_JXs.at( i*4 +j);  }
         };
         class uC { //spherical volume within bod
         public:
            Multipoles q;                   //Fe mpoles, ROT(alp,bet, 0)
            std::vector<Multipoles> o_Jq;   //mpoles, ROT( alp+pi, pi-bet, Jgam)
            uC():
               o_Jq(64, Multipoles(7))
            {
            }
            Multipoles& Jq(int i){
               return o_Jq.at( i);  }
         };
         class uD { /*dot of patch st angle DOT wrt n is low*/
         public:
            double rst;               //angle of DOT wrt n (radians)
            int DOT;                  //index of DOT
            double ghp;               //fraction hydrophob of surf area
            uD(){}
         };
      private:
         std::vector<uB> o_B;           //partition of patch into shells
         std::vector<uC> o_C;           //decomp of bod volume into spheres
      public:
         double dncut;                  //dist to bounding plane (bohr)
         std::vector<uD> o_D;           //dots of patch
         int oD;                        //number of dots
         double omg;                    //angle (degree) ns wrt n
         int kF;                        //nearest grid indexes for ns
         int kT;                        //
         Coordinates ns;                //normal to patch surf
         Coordinates x;                 //alt origin (bohr) of bod
         double rs;                     //dist to bounding plane (bohr)
         double as;                     //surf area (bohr**2) of surf patch
         double zs;                     //mean z component (bohr)
         double ah;                     //hydrophob surf area (bohr**2)
         double ec;                     //energy for cleft of surf patch
         int nc;                        //n of cleft dots on patch
         double ms;                     //concave-convex measure of surf patch
         uFT():
            o_B( 6),
            o_C( 3)
         {
         }
         uB& B(int i){
            return o_B.at( i);  }
         uC& C(int i){
            return o_C.at( i);  }
         uD& D(int i){
            return o_D.at( i);  }
      };
   private:
      std::vector<uFT> o_FT;            //points on unit sphere
   public:
      std::string bod;                  //bod name
      Structure str;                    //
      Coordinates x;                    //mean position (bohr)
      Dielec_Continu med;               //dot surface
      std::vector<tC9> C9;              //full charges
      int oC9;                          //number of full charges
      std::vector<tV9> V9;              //nonpolar sites
      int oV9;                          //number of nonpolar sites
      Structure bac;                    //
      tG9():
         o_FT(20*64),
         med( 0, 0, 0, 0)
      {
      }
      uFT& FT(int i,int j){
         return o_FT.at( i*64 +j);
      }
   };
//
//________________________________________________________________
   class tFT { //points on unit sphere
   public:
      Coordinates n;                        //position
      double alp;                           //euler angles (radian)
      double bet;                           //
      Spherical_Harmonics H;                //
      Rotation_Matrix ROT;                  //ROT(alp,bet, 0) maps n to z-axis
      std::vector<Rotation_Matrix> JROT;    //ROT(alp+PI,PI-bet,gam)
      tFT(){}
   };
//
//________________________________________________________________
   class tAB { //grid points of [-180,180)x[  0,180]
   public:
      int pF;                   //indices of nearest sphere point
      int pT;                   //
      tAB(){}
   };
//
//________________________________________________________________
   class tF2 { //atoms in atom-contracted chain [backward order]
   public:
      Coordinates x;            //atom position (bohr)
      Multipoles q;             //atom multipoles
      tF2(){}
   };
//
//________________________________________________________________
   class tQ2 { /*torsions [forward order]*/
   public:
      Rotation_Matrix c;        //unit vector along rotatable bond
      tQ2(){}
   };
//
//________________________________________________________________
   class tA5 { //physical atoms in system of molecules
   public:
      int Z0;                   //index of chain
      int R0;                   //index of residue
      double exsa;              //exposed surface area (angstrom**2)
      tA5(){}
   };
//
//________________________________________________________________
   class ePack { /*lattice energy of reduced model*/
   public:
      float Fe;                 //electrostatic mpole expansion
      float Fm;                 //gaussian approx of dielec medium
      float Fs;                 //full surface match
      float Fh;                 //hydrophobic
      float Fp;                 //polar
      float Fi;                 //boundary chg
      float Fd;                 //depth wrt plane +cleft
      float Ftot;               //sum of components
      ePack():
         Fe( 0.00),
         Fm( 0.00),
         Fs( 0.00),
         Fh( 0.00),
         Fp( 0.00),
         Fi( 0.00),
         Fd( 0.00),
         Ftot( 0.00){}
      ePack(double e,double m,double s,double h,double p,double i,double d):
         Fe(e),
         Fm(m),
         Fs(s),
         Fh(h),
         Fp(p),
         Fi(i),
         Fd(d),
         Ftot( e +m +s +h +p +i +d){}
      void zero();
      void operator=(const ePack& a);
      void operator+=(const ePack& a);
      void operator-=(const ePack& a);
      void operator*=(const double a);
      void operator/=(const double a);
   };
//
//________________________________________________________________
   class eFull { /*energy decomposition of restbchpw*/
   public:
      double F;                 //total
      double Fr;                //repulsion+dispersion
      double Fe;                //electrostatic
      double Fs;                //disulfide bond
      double Ft;                //intrinsic torsional
      double Fc;                //distance constraint
      double Fb;                //ring closure
      double Fh;                //hydrophobic
      double Fw;                //excluded vol model of hydration
      double Fp;                //polarization
      double Fp_a;              // H-bonds
      double Fp_b;              // bifurcated H-bonds
      double Fp_c;              // chains of peptide alignment
      double Fp_d;              // mod of pept H-bond by elem type
      double Fp_e;              // nonpolar in the electric field
      eFull(){}
      void operator=(const eFull& a);
   };
//
//________________________________________________________________
   class tZ9 { /*bod*/
   public:
      Rotation_Matrix c;        //local axes of bod in pack config
      Coordinates t;            //pos of local axes of bod
      tZ9(){}
   };
//
//________________________________________________________________
   class tY9 { /*oU-bod subsystem*/
   public:
      class tY9D9 { /*low ENERGY config*/
      public:
         class tY9D9Z9 { /*bod*/
         public:
            char X;                     //pos in subsystem
            ePack e;                    //energy of alignment left and right
            int A;                      //left bod (pF,pT,lF,lT,iJ) dock
            int B;                      //right bod
            Rotation_Matrix c;          //local axes of bod in pack config
            Coordinates t;              //pos of local axes of bod
            tY9D9Z9(){}
         };
         class tY9D9Q { /*local axes of potential shared bods in pack config*/
         public:
            Rotation_Matrix r;          //orientation of local axes
            Coordinates t;              //pos of origin
            tY9D9Q(){}
         };
      public:
         std::vector<tY9D9Z9> Z9;       //bods
         std::vector<tY9D9Q> Q;         //4 local coord systems
         ePack e;                       //lattice energy [tot,e,m,s,h,p,i]
         eFull f;                       //decomp of full energy
         double dexp;                   //measure of distance no expt
         tY9D9():Q( 4){}
         void swap(tY9::tY9D9& a);
         void operator=(const tY9D9& a);
      };
   public:
      int oD9;                          //number
      std::vector<tY9D9> D9;            //set of configs
      int oZ9;                          //number of bods
      tY9(){}
      void operator=(const tY9& a);
      void CLUSTER(const DAT_PHYSICS_CONSTS& physics_consts,
                   Output_Streams& out);
   };
//
//________________________________________________________________
   class tU9 { /*all subsystems containing oU bods*/
   public:
      class tU9Y9 { /*oU-bod subsystem*/
      public:
         class tU9Y9Z9 { /*bod of subsystem*/
         public:
            int G9;                     //index of bod
            int Y9;                     //index of (oU-1)-bod subsystem
            char X;                     //pos in subsystem
            ePack e;                    //energy of alignment left and right
            int A;                      //alignment wrt left bod
            int B;                      //alignment wrt right bod
            Rotation_Matrix c;          //local axes of bod in pack config
            Coordinates t;              //pos of local axes of bod
            tU9Y9Z9(){}
         };
         class tU9Y9Q { /*local axes of potential shared bods in pack config*/
         public:
            Rotation_Matrix r;          //orientation of local axes
            Coordinates t;              //pos of origin
            tU9Y9Q(){}
         };
      public:
         std::vector<tU9Y9Z9> Z9;       //bods of subsystem
         bool STABLE;                   //exists stable config
         bool FACTOR;                   //subsys +complement stable wrt union
         ePack e;                       //energy of config [F,Fp,Fh,Fm]
         double dexp;                   //measure of distance no expt
         std::vector<tU9Y9Q> Q;         //4 local coord systems
         tU9Y9():Q( 4){}
         void operator=(const tY9::tY9D9& a);
      };
   public:
      int oY9;                          //number
      std::vector<tU9Y9> Y9;            //oU-bod subsystems
      tU9():oY9( 0){}
   };
//
//________________________________________________________________
   class tT9 { /*factor subconfigs*/
   public:
      int U9;                   //number of bods
      int Y9;                   //optimal config
      bool sub;                 //in optimal union of subconfigs
      ePack e;                   //SCORE of subconfig [F,Fp,Fh,Fm]
      tT9(){}
      void swap(tT9& a);
   };
//
private:
   std::vector<tFT> o_FT;       //points on unit sphere
   std::vector<tAB> o_AB;       //grid points of [-180,180)x[  0,180]

   void PCK_SPHERE(const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_ARRAY_CONSTS& array_consts,
                   Output_Streams& out);
   void PCK_ICO(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                const DAT_DISULFIDE_LINKS& disulfide_links,
                const DAT_ENERGY_PARAMS& energy_params,
                const DAT_REGION_MAPS& region_maps,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Thread_Options& opt,
                Output_Streams& out);
   void PCK_MOL(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ENERGY_PARAMS& energy_params,
                Dielec_Continu& med,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                const Conf_Dependent_System& dep);
   void PCK_SURF(const DAT_PHYSICS_CONSTS& physics_consts,
                 const Structure& str,
                 Output_Streams& out,
                 Dielec_Continu& med);
   void PCK_EHP(const DAT_PHYSICS_CONSTS& physics_consts,
                const Structure& str,
                Output_Streams& out,
                const Dielec_Continu& med);
   bool PCK_2BOD(const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ARRAY_CONSTS& array_consts,
                 const DAT_DISULFIDE_LINKS& disulfide_links,
                 const DAT_ENERGY_PARAMS& energy_params,
                 const DAT_REGION_MAPS& region_maps,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const Thread_Options& opt,
                 Output_Streams& out);
   bool PCK_NBOD(const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ARRAY_CONSTS& array_consts,
                 Output_Streams& out);
   bool PCK_NDOC(Output_Streams& out,
                 int iY9,
                 int aY9,int aD9,int bY9,int bD9,
                 int pZ9,int lZ9,
                 int aX,int bX,
                 std::vector<int>& o_XZ9,
                 Coordinates& t,Coordinates& u,
                 Rotation_Matrix& r);
   bool PCK_F(const DAT_PHYSICS_CONSTS& physics_consts,
              const DAT_ARRAY_CONSTS& array_consts,
              Output_Streams& out,
              int pG9,int lG9,
              int pF,int pT,int lF,int lT,
              const Rotation_Matrix& ROT,
              int oZ9,
              Packing_Search::ePack e);
   void PCK_VIS(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                const DAT_DISULFIDE_LINKS& disulfide_links,
                const DAT_ENERGY_PARAMS& energy_params,
                const DAT_REGION_MAPS& region_maps,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Thread_Options& opt,
                Output_Streams& out,
                std::string& CNF,
                double ztrans);

public:
   std::vector<tG9> G9;                 //full set of bods in pack
   int oG9;                             //number
   std::vector<tF2> F2;                 //backward atoms
   std::vector<tQ2> Q2;                 //forward torsions
   std::vector<tA5> A5;                 //set of physical atoms
   std::vector<Multipoles> o_BXs;       //X={s,h,p,i} exposed surface
   std::vector<Multipoles> o_BXNs;      //N={j: trans coeff of (1/r)**(j+1)}
   std::vector<double> o_Bu;            //scale factor for unit of distance
   Coordinates x;                       //relative position of atom pair
   double R;                            //distance
   double ZZ;                           //(1/R)
   double Lr[ 9];                       //(1/R**L)
   double CT;                           //cos(theta)
   double ST;                           //sin(theta)
   double CP;                           //cos(phi)
   double SP;                           //sin(phi)
   Scratch_Multipoles Cq1[3];           //
   Scratch_Multipoles Cq2[3];           //
   Scratch_Multipoles QQ;               //
   Spherical_Harmonics H;               //
   double Ftot;                         //total
   double Fe;                           //electrostatic mpole expansion
   double Fm;                           //gaussian approx of dielec medium
   double Fs;                           //full surface match
   double Fh;                           //hydrophobic
   double Fp;                           //polar
   double Fi;                           //boundary chg
   double Fd;                           //depth wrt plane +cleft
   double Fcut;                         //low partial e=(Fe+Fs+Fh+Fp+Fi+Fd)
   int Fb;                              //config (pF,pT,lF,lT,iJ)
   Surf_Match doc;                      //
   int oU9;                             //number
   std::vector<tU9> U9;                 //n of bods in subsystem
   int pU9;                             //index
   int oY9;                             //number
   std::vector<tY9> Y9;                 //oU-bod subsystems
   std::vector<tZ9> Z9;                 //strands of sheet
   int oI9;                             //number
   std::vector<tY9> I9;                 //oU-bod subsystems
   int oT9;                             //number
   std::vector<tT9> T9;                 //factor subconfigs

   tFT& FT(int i,int j){
      return o_FT.at( i*64 +j);
   }
   tAB& AB(double a,double b){
      int i=int( std::floor( a));
      int j=int( std::floor( b));
      i+=180;
      if( i<  0 )i=  0;
      if( i>359 )i=359;
      if( j<  0 )j=  0;
      if( j>179 )j=179;
      return o_AB.at( i*180 +j);
   }
   Multipoles& BXs(int i,int j){
      return o_BXs.at( i*4 +j);
   }
   Multipoles& BXNs(int i,int j,int k){
      return o_BXNs.at( i*32 +j*8 +k);
   }
   double& Bu(int i){
      return o_Bu.at( i);
   }

   void PCK(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ARRAY_CONSTS& array_consts,
            const DAT_DISULFIDE_LINKS& disulfide_links,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_REGION_MAPS& region_maps,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            Thread_Options& opt,
            Output_Streams& out);

   Packing_Search():
      o_FT(20*64),
      o_AB(360*180),
      o_BXs(6*4, Multipoles(7)),
      o_BXNs(6*4*8, Multipoles(7)),
      o_Bu(6)
   {
   }
};
//
//
// global operators
//
Packing_Search::ePack operator*(
             double a,
             const Packing_Search::ePack& b);
std::ostream& operator<<(
             std::ostream& os,
             const Packing_Search::tY9& a);
std::ostream& operator<<(
             std::ostream& os,
             const std::vector<Packing_Search::tU9>& a);
std::ostream& operator<<(
             std::ostream& os,
             const std::vector<Packing_Search::tT9>& a);

#endif
