#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../pck/Packing_Search.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>

//
// ePack zero, =, +=, -=, *=, /=
//
void Packing_Search::ePack::zero(){
   Fe= (0.00);
   Fm= (0.00);
   Fs= (0.00);
   Fh= (0.00);
   Fp= (0.00);
   Fi= (0.00);
   Fd= (0.00);
   Ftot= (0.00);
   return;
}
void Packing_Search::ePack::operator=(const Packing_Search::ePack& a){
   Fe= a.Fe;
   Fm= a.Fm;
   Fs= a.Fs;
   Fh= a.Fh;
   Fp= a.Fp;
   Fi= a.Fi;
   Fd= a.Fd;
   Ftot= a.Ftot;
   return;
}
void Packing_Search::ePack::operator+=(const Packing_Search::ePack& a){
   Fe+=a.Fe;
   Fm+=a.Fm;
   Fs+=a.Fs;
   Fh+=a.Fh;
   Fp+=a.Fp;
   Fi+=a.Fi;
   Fd+=a.Fd;
   Ftot+=a.Ftot;
   return;
}
void Packing_Search::ePack::operator-=(const Packing_Search::ePack& a){
   Fe-=a.Fe;
   Fm-=a.Fm;
   Fs-=a.Fs;
   Fh-=a.Fh;
   Fp-=a.Fp;
   Fi-=a.Fi;
   Fd-=a.Fd;
   Ftot-=a.Ftot;
   return;
}
void Packing_Search::ePack::operator*=(const double a){
   Fe*=a;
   Fm*=a;
   Fs*=a;
   Fh*=a;
   Fp*=a;
   Fi*=a;
   Fd*=a;
   Ftot*=a;
   return;
}
void Packing_Search::ePack::operator/=(const double a){
   Fe/=a;
   Fm/=a;
   Fs/=a;
   Fh/=a;
   Fp/=a;
   Fi/=a;
   Fd/=a;
   Ftot/=a;
   return;
}
//
// eFull=
//
void Packing_Search::eFull::operator=(const Packing_Search::eFull& a){
   F= a.F;
   Fr= a.Fr;
   Fe= a.Fe;
   Fs= a.Fs;
   Ft= a.Ft;
   Fc= a.Fc;
   Fb= a.Fb;
   Fh= a.Fh;
   Fw= a.Fw;
   Fp= a.Fp;
   Fp_a= a.Fp_a;
   Fp_b= a.Fp_b;
   Fp_c= a.Fp_c;
   Fp_d= a.Fp_d;
   Fp_e= a.Fp_e;
   return;
}
//
// Y9D9 swap
//
void Packing_Search::tY9::tY9D9::swap(Packing_Search::tY9::tY9D9& a){
   {
      Packing_Search::ePack z=a.e;
      a.e=e;
      e=z;
   }
   {
      Packing_Search::eFull z=a.f;
      a.f=f;
      f=z;
   }
   {
      double z=a.dexp;
      a.dexp=dexp;
      dexp=z;
   }
   int oZ9=a.Z9.size();
   for(int iZ9= 0;iZ9<oZ9;iZ9++){
      char j=a.Z9[iZ9].X;
      a.Z9[iZ9].X=Z9[iZ9].X;
      Z9[iZ9].X=j;
      Packing_Search::ePack z=a.Z9[iZ9].e;
      a.Z9[iZ9].e=Z9[iZ9].e;
      Z9[iZ9].e=z;
      int k=a.Z9[iZ9].A;
      a.Z9[iZ9].A=Z9[iZ9].A;
      Z9[iZ9].A=k;
      k=a.Z9[iZ9].B;
      a.Z9[iZ9].B=Z9[iZ9].B;
      Z9[iZ9].B=k;
      Rotation_Matrix r=a.Z9[iZ9].c;
      a.Z9[iZ9].c=Z9[iZ9].c;
      Z9[iZ9].c=r;
      Coordinates x=a.Z9[iZ9].t;
      a.Z9[iZ9].t=Z9[iZ9].t;
      Z9[iZ9].t=x;
   }
   for(int iQ=0;iQ<4;iQ++){
      Rotation_Matrix r=a.Q[iQ].r;
      a.Q[iQ].r=Q[iQ].r;
      Q[iQ].r=r;
      Coordinates x=a.Q[iQ].t;
      a.Q[iQ].t=Q[iQ].t;
      Q[iQ].t=x;
   }
   return;
}
//
// Y9D9=
//
void Packing_Search::tY9::tY9D9::operator=(
                const Packing_Search::tY9::tY9D9& a){
   e=a.e;
   f=a.f;
   dexp= a.dexp;
   int oZ9=a.Z9.size();
   for(int iZ9= 0;iZ9<oZ9;iZ9++){
      Z9[iZ9].X=a.Z9[iZ9].X;
      Z9[iZ9].e=a.Z9[iZ9].e;
      Z9[iZ9].A=a.Z9[iZ9].A;
      Z9[iZ9].B=a.Z9[iZ9].B;
      Z9[iZ9].c=a.Z9[iZ9].c;
      Z9[iZ9].t=a.Z9[iZ9].t;
   }
   for(int iQ=0;iQ<4;iQ++){
      Q[iQ].r=a.Q[iQ].r;
      Q[iQ].t=a.Q[iQ].t;
   }
   return;
}
//
// local memory
//
class MEM_cluster {
private:
   std::vector<int> o_XZ9;              //inverse map of Z9X
   std::vector<Rotation_Matrix> o_XROT; //rot of (iX+1) wrt i
   std::vector<Coordinates> o_Xn;       //normal of (iX+1) wrt i
   std::vector<int> o_D9I3a;            //start index of confs within threshold
   std::vector<int> o_D9cI3;            //number of confs within threshold
   std::vector<int> o_D9I3b;            //start index of higher neighbor confs
   std::vector<int> o_D9dI3;            //number of lower neighbor confs
   std::vector<bool> o_D9sub;           //
public:
   std::vector<int> o_I3D9;             //mapping to index of neighbor conf
   MEM_cluster(int z,int o):
      o_XZ9(z),
      o_XROT(z),
      o_Xn(z),
      o_D9I3a(o),
      o_D9cI3(o, 0),
      o_D9I3b(o),
      o_D9dI3(o, 0),
      o_D9sub(o, true)
   {
   }
   int& XZ9(int i){
      return o_XZ9.at( i);  }
   Rotation_Matrix& XROT(int i){
      return o_XROT.at( i);  }
   Coordinates& Xn(int i){
      return o_Xn.at( i);  }
   int& D9I3a(int i){
      return o_D9I3a.at( i);  }
   int& D9cI3(int i){
      return o_D9cI3.at( i);  }
   int& D9I3b(int i){
      return o_D9I3b.at( i);  }
   int& D9dI3(int i){
      return o_D9dI3.at( i);  }
   bool D9sub(int i){
      return o_D9sub[ i];  }
   void D9sub(int i,bool a){
      o_D9sub[ i]=a;  }
   int& I3D9(int i){
      return o_I3D9.at( i);  }
};
//
// Y9 cluster
//
void Packing_Search::tY9::CLUSTER(
                const DAT_PHYSICS_CONSTS& physics_consts,
                Output_Streams& out){
   double ANG= physics_consts.ANG;
   int o=oD9;
   MEM_cluster vv(oZ9,o);

   int jI3=0;
   for(int iD9=0;iD9<o;iD9++){
      for(int iZ9= 0;iZ9<oZ9;iZ9++){
         vv.XZ9(D9[iD9].Z9[iZ9].X)=iZ9;
      }
      for(int iX= 0;iX<(oZ9- 1);iX++){
         int iZ9=vv.XZ9(iX   );
         int jZ9=vv.XZ9(iX+ 1);
         vv.XROT(iX)=transpose(D9[iD9].Z9[iZ9].c)
                              *D9[iD9].Z9[jZ9].c;
         vv.Xn(iX)=(transpose(D9[iD9].Z9[iZ9].c)
                             *D9[iD9].Z9[jZ9].t).normalize();
      }
      vv.D9I3a(iD9)=jI3;
      int n=vv.D9cI3(iD9);
      for(int i=0;i<n;i++){
         vv.o_I3D9.push_back(-1);
         jI3++;
      }
      vv.D9I3b(iD9)=jI3;
      for(int jD9=(iD9+1);jD9<o;jD9++){
         double d= (0.00);
         for(int jX= 0;jX<(oZ9- 1);jX++){
            int iZ9=vv.XZ9(jX   );
            int jZ9=vv.XZ9(jX+ 1);
            Rotation_Matrix ROT=transpose(D9[jD9].Z9[iZ9].c)
                                         *D9[jD9].Z9[jZ9].c;
            Coordinates n=(transpose(D9[jD9].Z9[iZ9].c)
                                    *D9[jD9].Z9[jZ9].t).normalize();
            d+=( dot(n,vv.Xn(jX))
                +dot(ROT,vv.XROT(jX)));
         }
         d/=double( oZ9- 1);
         if( d>( 3.25) ){
            vv.o_I3D9.push_back(jD9);
            jI3++;
            vv.D9cI3(iD9)++;
            vv.D9cI3(jD9)++;
         }
      }
   }
   for(int iD9= 0;iD9<(o-1);iD9++){
      int iI3min=vv.D9I3b(iD9);
      int iI3max=(vv.D9I3a(iD9)-1+vv.D9cI3(iD9));
      for(int iI3=iI3min;iI3<=iI3max;iI3++){
         int jD9=vv.I3D9(iI3);
         vv.I3D9(vv.D9I3a(jD9)+vv.D9dI3(jD9))=iD9;
         vv.D9dI3(jD9)++;
      }
   }
   oD9= 0;
   for(int iD9=0;iD9<o;iD9++){
      if( vv.D9sub(iD9) ){
         if( oD9<iD9 ){
            D9[oD9]=D9[iD9];
         }
         oD9++;
         vv.D9sub(iD9,false);
         int iI3min=vv.D9I3b(iD9);
         int iI3max=(vv.D9I3a(iD9)-1+vv.D9cI3(iD9));
         for(int iI3=iI3min;iI3<=iI3max;iI3++){
            int jD9=vv.I3D9(iI3);
            vv.D9sub(jD9,false);
         }
      }
   }
   if( oD9>2048 )oD9=2048;
   for(int iD9=oD9;iD9<o;iD9++){
      D9.pop_back();
   }
   out.FILE3<<"CLUSTER"<<'\n';
// out.FILE3<<"  oD9  nD9    oI3  nI3"<<'\n';
// out.FILE3<< std::setw( 5)<<o
//          << std::setw( 5)<<oD9
//          << std::setw( 7)<<jI3
//          << std::setw( 5)<<(jI3/o)<<'\n';
   return;
}
//
// Y9=
//
void Packing_Search::tY9::operator=(const Packing_Search::tY9& a){
   oZ9=a.oZ9;
   oD9=a.oD9;
   if( int(D9.size())!=oD9 ){
      D9.clear();
      D9.resize(oD9);
   }
   for(int iD9= 0;iD9<oD9;iD9++){
      D9[iD9].e=a.D9[iD9].e;
      D9[iD9].f=a.D9[iD9].f;
      D9[iD9].dexp=a.D9[iD9].dexp;
      if( int(D9[iD9].Z9.size())!=oZ9 ){
         D9[iD9].Z9.clear();
         D9[iD9].Z9.resize(oZ9);
      }
      for(int iZ9= 0;iZ9<oZ9;iZ9++){
         D9[iD9].Z9[iZ9].X=a.D9[iD9].Z9[iZ9].X;
         D9[iD9].Z9[iZ9].e=a.D9[iD9].Z9[iZ9].e;
         D9[iD9].Z9[iZ9].A=a.D9[iD9].Z9[iZ9].A;
         D9[iD9].Z9[iZ9].B=a.D9[iD9].Z9[iZ9].B;
         D9[iD9].Z9[iZ9].c=a.D9[iD9].Z9[iZ9].c;
         D9[iD9].Z9[iZ9].t=a.D9[iD9].Z9[iZ9].t;
      }
      for(int iQ=0;iQ<4;iQ++){
         D9[iD9].Q[iQ].r=a.D9[iD9].Q[iQ].r;
         D9[iD9].Q[iQ].t=a.D9[iD9].Q[iQ].t;
      }
   }
   return;
}
//
// U9Y9=Y9D9
//
void Packing_Search::tU9::tU9Y9::operator=(const Packing_Search::tY9::tY9D9& a){
   e=a.e;
   dexp=a.dexp;
   int oZ9=a.Z9.size();
   for(int iZ9= 0;iZ9<oZ9;iZ9++){
      Z9[iZ9].X=a.Z9[iZ9].X;
      Z9[iZ9].e=a.Z9[iZ9].e;
      Z9[iZ9].A=a.Z9[iZ9].A;
      Z9[iZ9].B=a.Z9[iZ9].B;
      Z9[iZ9].c=a.Z9[iZ9].c;
      Z9[iZ9].t=a.Z9[iZ9].t;
   }
   for(int iQ=0;iQ<4;iQ++){
      Q[iQ].r=a.Q[iQ].r;
      Q[iQ].t=a.Q[iQ].t;
   }
   STABLE=true;
   return;
}
//
// T9 swap
//
void Packing_Search::tT9::swap(tT9& a){
   int j=a.U9;
   a.U9=U9;
   U9=j;
   j=a.Y9;
   a.Y9=Y9;
   Y9=j;
   ePack z=a.e;
   a.e=e;
   e=z;
   return;
}
//
// ePack binary * global
//
Packing_Search::ePack operator*(
                double a,
                const Packing_Search::ePack& b){
   Packing_Search::ePack t=b;
   t*=a;
   return t;
}
//
//
// write
//
std::ostream& operator<<(
                std::ostream& os,
                const Packing_Search::tY9& a){
   int oZ9=a.oZ9;
   int oD9=a.oD9;
   os<<" oD9 oZ9\n";
   os<<std::setw( 4)<<oD9
     <<std::setw( 4)<<oZ9<<'\n';
   os<<"  D9  tot     e      m      s      h      p      i      d     dexp "
       " pF pT lF lT iJ\n";
   os<< std::setprecision(3);
   for(int iD9= 0;iD9<oD9;iD9++){
      int pF(-1),pT(-1),lF(-1),lT(-1),iJ(-1);
      iJ=a.D9[iD9].Z9[ 0].B;
      pF=(iJ/5242880);
      iJ-=(pF*5242880);
      pT=(iJ/81920);
      iJ-=(pT*81920);
      lF=(iJ/4096);
      iJ-=(lF*4096);
      lT=(iJ/64);
      iJ-=(lT*64);
      os<<std::setw( 4)<<iD9;
      os<<std::setw( 7)<<a.D9[iD9].e.Ftot
        <<std::setw( 7)<<a.D9[iD9].e.Fe
        <<std::setw( 7)<<a.D9[iD9].e.Fm
        <<std::setw( 7)<<a.D9[iD9].e.Fs
        <<std::setw( 7)<<a.D9[iD9].e.Fh
        <<std::setw( 7)<<a.D9[iD9].e.Fp
        <<std::setw( 7)<<a.D9[iD9].e.Fi
        <<std::setw( 7)<<a.D9[iD9].e.Fd
        << std::setprecision(2)
        <<std::setw( 7)<<a.D9[iD9].dexp
        << std::setprecision(3)
        <<std::setw( 3)<<pF
        <<std::setw( 3)<<pT
        <<std::setw( 3)<<lF
        <<std::setw( 3)<<lT
        <<std::setw( 3)<<iJ
        <<'\n';
   }
// os<<"  D9 Z9  X pF pT lF lT iJ"
//     "  tot     e      m      s      h      p      i      d   \n";
// for(int iD9= 0;iD9<oD9;iD9++){
//    for(int iZ9= 0;iZ9<oZ9;iZ9++){
//       int iX=a.D9[iD9].Z9[iZ9].X;
//       int pF(-1),pT(-1),lF(-1),lT(-1),iJ(-1);
//       if( iX<(oZ9- 1) ){
//          iJ=a.D9[iD9].Z9[iZ9].B;
//          pF=(iJ/5242880);
//          iJ-=(pF*5242880);
//          pT=(iJ/81920);
//          iJ-=(pT*81920);
//          lF=(iJ/4096);
//          iJ-=(lF*4096);
//          lT=(iJ/64);
//          iJ-=(lT*64);
//       }
//       os<<std::setprecision(2);
//       os<<std::setw( 4)<<iD9
//         <<std::setw( 3)<<iZ9
//         <<std::setw( 3)<<iX
//         <<std::setw( 3)<<pF
//         <<std::setw( 3)<<pT
//         <<std::setw( 3)<<lF
//         <<std::setw( 3)<<lT
//         <<std::setw( 3)<<iJ
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Ftot
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Fe
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Fm
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Fs
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Fh
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Fp
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Fi
//         <<std::setw( 7)<<a.D9[iD9].Z9[iZ9].e.Fd
//         <<'\n';
//    }
// }
   return os;
}
std::ostream& operator<<(
                std::ostream& os,
                const std::vector<Packing_Search::tU9>& a){
   os<<"PACK COMPONENTS\n";
   os<< std::fixed;
   int oU9=a.size();
   int pU9=-1;
   bool STABLE=false;
   for(int iU9=(oU9- 1);iU9>=2&&(!STABLE);iU9--){
      int oY9=a[iU9].oY9;
      for(int iY9= 0;iY9<oY9&&(!STABLE);iY9++){
         if( a[iU9].Y9[iY9].STABLE ){
            pU9=iU9;
            STABLE=true;
         }
      }
   }
   os<<" oU9 pU9\n";
   os<<std::setw( 4)<<oU9
     <<std::setw( 4)<<pU9<<'\n';
   for(int iU9= 2;iU9<=pU9;iU9++){
      int oZ9=iU9;
      int oY9=a[iU9].oY9;
      os<<" U9 oY9\n";
      os<<std::setw( 3)<<iU9
        <<std::setw( 4)<<oY9<<'\n';
      os<<" U9  Y9  tot     e      m      s      h      p      i      d   "
          "  dexp STABLE FACTOR(  Z9G9)\n";
      os<< std::setprecision(3);
      for(int iY9= 0;iY9<oY9;iY9++){
         os<<std::setw( 3)<<iU9
           <<std::setw( 4)<<iY9;
         os<<std::setw( 7)<<a[iU9].Y9[iY9].e.Ftot
           <<std::setw( 7)<<a[iU9].Y9[iY9].e.Fe
           <<std::setw( 7)<<a[iU9].Y9[iY9].e.Fm
           <<std::setw( 7)<<a[iU9].Y9[iY9].e.Fs
           <<std::setw( 7)<<a[iU9].Y9[iY9].e.Fh
           <<std::setw( 7)<<a[iU9].Y9[iY9].e.Fp
           <<std::setw( 7)<<a[iU9].Y9[iY9].e.Fi
           <<std::setw( 7)<<a[iU9].Y9[iY9].e.Fd
           << std::setprecision(2)
           <<std::setw( 7)<<a[iU9].Y9[iY9].dexp
           << std::setprecision(3);
         os<<((a[iU9].Y9[iY9].STABLE)? "  T": "  F")
           <<((a[iU9].Y9[iY9].FACTOR)? "  T": "  F")<<'(';
         for(int iZ9= 0;iZ9<oZ9;iZ9++){
            os<<std::setw( 3)<<a[iU9].Y9[iY9].Z9[iZ9].G9;
         }
         os<<")\n";
      }
      os<<" U9  Y9 Z9  X G9 pF pT lF lT iJ"
          "  tot     e      m      s      h      p      i      d   \n";
      for(int iY9= 0;iY9<oY9;iY9++){
         if( !a[iU9].Y9[iY9].STABLE )continue;
         for(int iZ9= 0;iZ9<oZ9;iZ9++){
            int iX=a[iU9].Y9[iY9].Z9[iZ9].X;
            int pF(-1),pT(-1),lF(-1),lT(-1),iJ(-1);
            if( iX<(oZ9- 1) ){
               iJ=a[iU9].Y9[iY9].Z9[iZ9].B;
               pF=(iJ/5242880);
               iJ-=(pF*5242880);
               pT=(iJ/81920);
               iJ-=(pT*81920);
               lF=(iJ/4096);
               iJ-=(lF*4096);
               lT=(iJ/64);
               iJ-=(lT*64);
            }
            os<<std::setprecision(3);
            os<<std::setw( 3)<<iU9
              <<std::setw( 4)<<iY9
              <<std::setw( 3)<<iZ9
              <<std::setw( 3)<<iX
              <<std::setw( 3)<<a[iU9].Y9[iY9].Z9[iZ9].G9
              <<std::setw( 3)<<pF
              <<std::setw( 3)<<pT
              <<std::setw( 3)<<lF
              <<std::setw( 3)<<lT
              <<std::setw( 3)<<iJ
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Ftot
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Fe
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Fm
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Fs
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Fh
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Fp
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Fi
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e.Fd
              <<'\n';
         }
      }
   }
   return os;
}
std::ostream& operator<<(
                std::ostream& os,
                const std::vector<Packing_Search::tT9>& a){
   os<<"PACK OPTIMAL PARTITION\n";
   os<< std::fixed<< std::setprecision(3);
   int oT9=a.size();
   os<<"oT9\n";
   os<<std::setw( 3)<<oT9<<'\n';
   os<<" T9 U9  Y9  tot     e      m      s      h      p      i      d   "
       "sub\n";
   for(int iT9= 0;iT9<oT9;iT9++){
      os<<std::setw( 3)<<iT9
        <<std::setw( 3)<<a[iT9].U9
        <<std::setw( 4)<<a[iT9].Y9
        <<std::setw( 7)<<a[iT9].e.Ftot
        <<std::setw( 7)<<a[iT9].e.Fe
        <<std::setw( 7)<<a[iT9].e.Fm
        <<std::setw( 7)<<a[iT9].e.Fs
        <<std::setw( 7)<<a[iT9].e.Fh
        <<std::setw( 7)<<a[iT9].e.Fp
        <<std::setw( 7)<<a[iT9].e.Fi
        <<std::setw( 7)<<a[iT9].e.Fd
        <<((a[iT9].sub)? " T\n": " F\n");
   }
   return os;
}
