#include "../mov/Local_Minimization.hh"
#include "../phi/Energy_Surface.hh"
#include "../reg/Regularization_Target.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Local_Minimization5::WRT(Output_Streams& out,
                              const Energy_Surface5& ene,
                              const Regularization_Target& reg){
   if( out.VERBOSE&&false ){
      out.FILE3<<" nM2"
               <<" iM2"
               <<" ENDSTATE\n";
      out.FILE3<< std::setw( 4)<<nM2
               << std::setw( 4)<<iM2
               << std::setw( 4)<<ENDSTATE<<'\n';
   }
   int n=iM2;
   double zF1= (1.00)/std::sqrt( ene.nU2);

// if( n>0 ){
//    out.FILE3<<"  i"
//             <<"    "<<" k1"
//             <<" k2"
//             <<" k3"
//             <<"    "<<" k4"
//             <<" k5\n";
//    for(int i=0;i<n;i++){
//       int m=M2[i].k2;
//       out.FILE3<< std::setw( 3)<<i<<"    "
//                << std::setw( 3)<<M2[i].k1
//                << std::setw( 3)<<M2[i].k2
//                << std::setw( 3)<<M2[i].k3<<"  ";
//       for(int j=0;j<m;j++){
//          out.FILE3<<"  "
//                   << std::setw( 3)<<M2[i].k4[j]
//                   << std::setw( 3)<<M2[i].k5[j];
//       }
//       out.FILE3<<'\n';
//    }
// }

   if( n>0 ){
      for(int i=0;i<n;i++){
         M2[i].z= zF1*std::sqrt( M2[i].z);
         M2[i].bet= zF1*M2[i].bet;
         M2[i].s0= zF1*std::sqrt( M2[i].s0);
         int m=M2[i].k2;
         for(int j=0;j<m;j++){
            M2[i].s1[j]= zF1*std::sqrt( M2[i].s1[j]);
         }
         M2[i].s2= zF1*std::sqrt( M2[i].s2);
      }
   }
   M2[n].z= zF1*std::sqrt( M2[n].z);

   if( out.VERBOSE&&false ){
      if( n>0 ){
         out.FILE3<<"  i"
                  <<"        F   "
                  <<"       z   "
                  <<"       b   "
                  <<"    lam2   "
                  <<"      s2   "
                  <<"    delF   \n";
         out.FILE3<< std::scientific;
         for(int i=0;i<n;i++){
            out.FILE3<< std::setw( 3)<<i
                     << std::setprecision(5)<< std::setw(12)<<M2[i].tot
                     << std::setprecision(4)<< std::setw(11)<<M2[i].z
                     << std::setw(11)<<M2[i].bet
                     << std::setw(11)<<M2[i].lam2
                     << std::setw(11)<<M2[i].s2
                     << std::setw(11)<<M2[i].delF<<'\n';
         }
      }
      out.FILE3<< std::setw( 3)<<n
               << std::setprecision(5)<< std::setw(12)<<M2[n].tot
               << std::setprecision(4)<< std::setw(11)<<M2[n].z<<'\n';

//    if( n>0 ){
//       out.FILE3<< std::scientific<< std::setprecision(4);
//       out.FILE3<<"  i"
//                <<"    lam0   "
//                <<"      s0   \n";
//       for(int i=0;i<n;i++){
//          out.FILE3<< std::setw( 3)<<i
//                   << std::setw(11)<<M2[i].lam0
//                   << std::setw(11)<<M2[i].s0<<'\n';
//       }
//    }

//    if( n>0 ){
//       out.FILE3<< std::scientific<< std::setprecision(4);
//       out.FILE3<<"  i"
//                <<"    lam1   "
//                <<"      s1   "<<'\n';
//       for(int i=0;i<n;i++){
//          out.FILE3<< std::setw( 3)<<i;
//          int m=M2[i].k2;
//          for(int j=0;j<m;j++){
//             out.FILE3<< std::setw(11)<<M2[i].lam1[j]
//                      << std::setw(11)<<M2[i].s1[j];
//          }
//          out.FILE3<<'\n';
//       }
//    }

      out.FILE3<< std::scientific<< std::setprecision(5);
      out.FILE3<<"       F    \n";
      out.FILE3<< std::setw(12)<<ene.TOT<<'\n';
      out.FILE3<<"      Fa    "
               <<"      Fb    "
               <<"      Fc    "
               <<"      Fd    \n";
      out.FILE3<< std::setw(12)<<ene.Fa
               << std::setw(12)<<ene.Fb
               << std::setw(12)<<ene.Fc
               << std::setw(12)<<ene.Fd<<'\n';
   }
//
//
// update initial target step length for subset of degrees of freedom
//
   if( n>0 ){
      K1BETA(reg.iK1)=M2[n-1].bet;
   }
   return;
}
