#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

void Local_Minimization2::WRT(const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_RESIDUE_MAPPINGS& residue_mappings,
                              const Thread_Options& opt,
                              Output_Streams& out,
                              Structure& str,
                              const Mechanical_System& mol,
                              const Subset_Contracted_System::tM3& con,
                              Conf_Dependent_System& dep,
                              Energy_Surface2& ene){
//
//
// update conformation
//
   int iU2=0;
   for(int iZ0= 0;iZ0<str.nZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         dep.Z0[iZ0].trans(0)= ene.U2chi(iU2  );
         dep.Z0[iZ0].trans(1)= ene.U2chi(iU2+1);
         dep.Z0[iZ0].trans(2)= ene.U2chi(iU2+2);
         dep.Z0[iZ0].rot(0)= ene.U2chi(iU2+3);
         dep.Z0[iZ0].rot(1)= ene.U2chi(iU2+4);
         dep.Z0[iZ0].rot(2)= ene.U2chi(iU2+5);
         iU2+=6;
         if( opt.MODE=="loc" ){
            str.Z0[iZ0].trans=dep.Z0[iZ0].trans;
            str.Z0[iZ0].rot=dep.Z0[iZ0].rot;
         }
      }
   }
   for(int iZ0= 0;iZ0<str.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
         if( (opt.MODE=="bb ")&&(con.Q2[iQ2].br>0) ){
         }else{
            dep.Q2[iQ2].chi= ene.U2chi(iU2);
         }
         iU2++;
      }
   }
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int iQ2=mQ2;
      for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
         if( con.Q1[iQ1].sub ){
            dep.Q1[iQ1].chi= dep.Q2[++iQ2].chi;
         }
      }
   }
   if( opt.MODE=="loc" ){
      for(int iZ0= 0;iZ0<str.nZ0;iZ0++){
         int mQ1=mol.Z0[iZ0].Q1a;
         int iQ1bb=(mQ1+1);
         int iQ1sc=(mQ1+mol.Z0[iZ0].cQ1bb);
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iL0=str.R0[iR0].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
            if( nQ0>=mQ0 ){
               for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                  int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
                  std::string tor=mol.Q1[iQ1].tor;
                  int jR0=( tor=="OMG" )? iR0-1 : iR0;
                  int mT1=str.R0[jR0].T1a;
                  int nT1=(mT1-1+str.R0[jR0].cT1);
                  for(int iT1=mT1;iT1<=nT1;iT1++){
                     if( str.T1[iT1].tor==tor ){
                        str.T1[iT1].chi= (dep.Q1[iQ1].chi/physics_consts.RAD);
                        tor="xxx";
                     }
                  }
                  if( tor!="xxx" ){
                     std::cerr<<"ERROR: Unmatched torsion angle name."
                              <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                              <<" iR0="<< std::setw( 4)<<(iR0-(mR0-1))
                              <<" aa="<<str.R0[iR0].aa
                              <<" tor="<<tor<<".\n";
                     std::exit( 2);
                  }
               }
            }
         }
      }
   }
//
//
// output minimization trajectory
//
   double zF= (1.00)/std::sqrt( ene.nU2);
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<" steps remaining="<< std::setw( 3)<<nM2
               <<" steps taken="<< std::setw( 3)<<iM2
               <<" endstate="<< std::setw( 1)<<ENDSTATE<<'\n';
   }
   int n=iM2;

// if( n>0 ){
//    out.FILE3<<"  i"
//             <<"    "<<" k1"
//             <<" k2"
//             <<" k3"
//             <<"    "<<" k4"
//             <<" k5\n";
//    for(int i=0;i<n;i++){
//       int m=M2[i].k2;
//       out.FILE3<< std::setw( 3)<<i<<"    "
//                << std::setw( 3)<<M2[i].k1
//                << std::setw( 3)<<M2[i].k2
//                << std::setw( 3)<<M2[i].k3<<"  ";
//       for(int j=0;j<m;j++){
//          out.FILE3<<"  "
//                   << std::setw( 3)<<M2[i].k4[j]
//                   << std::setw( 3)<<M2[i].k5[j];
//       }
//       out.FILE3<<'\n';
//    }
// }

   if( n>0 ){
      for(int i=0;i<n;i++){
         M2[i].z= zF*std::sqrt( M2[i].z);
         M2[i].bet= zF*M2[i].bet;
         M2[i].s0= zF*std::sqrt( M2[i].s0);
         int m=M2[i].k2;
         for(int j=0;j<m;j++){
            M2[i].s1[j]= zF*std::sqrt( M2[i].s1[j]);
         }
         M2[i].s2= zF*std::sqrt( M2[i].s2);
         M2[i].d2= zF*std::sqrt( M2[i].d2);
      }
   }
   M2[n].z= zF*std::sqrt( M2[n].z);

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"  i"
               <<"        F   "
               <<"       z   "
               <<"       b   "
               <<"    lam2   "
               <<"      s2   "
               <<"      d2   "
               <<"    delF   \n";
      out.FILE3<< std::scientific;
      if( n>0 ){
         int j=0;
         for(int i=0;i<n;i++){
            if( M2[i].type.substr(0,5)=="MACRO" )j=i;
            out.FILE3<< std::setw( 3)<<i
                     << std::setprecision(5)
                     << std::setw(12)<<M2[i].tot
                     << std::setprecision(4)
                     << std::setw(11)<<M2[i].z
                     << std::setw(11)<<M2[i].bet
                     << std::setw(11)<<M2[i].lam2
                     << std::setw(11)<<M2[i].s2
                     << std::setw(11)<<M2[i].d2
                     << std::setprecision(5)
                     << std::setw(12)<<( M2[j].tot +M2[i].delF)
//                   <<' '<<M2[i].type
                     <<'\n';
         }
      }
      out.FILE3<< std::setw( 3)<<n
               << std::setprecision(5)
               << std::setw(12)<<M2[n].tot
               << std::setprecision(4)
               << std::setw(11)<<M2[n].z<<'\n';
   }

// if( n>0 ){
//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam0   "
//             <<"      s0   \n";
//    for(int i=0;i<n;i++){
//       out.FILE3<< std::setw( 3)<<i
//                << std::setw(11)<<M2[i].lam0
//                << std::setw(11)<<M2[i].s0<<'\n';
//    }
// }

// if( n>0 ){
//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam1   "
//             <<"      s1   \n";
//    for(int i=0;i<n;i++){
//       out.FILE3<< std::setw( 3)<<i;
//       int m=M2[i].k2;
//       for(int j=0;j<m;j++){
//          out.FILE3<< std::setw(11)<<M2[i].lam1[j]
//                   << std::setw(11)<<M2[i].s1[j];
//       }
//       out.FILE3<<'\n';
//    }
// }

// if( out.VERBOSE ){
//    out.FILE3<< std::fixed<< std::setprecision(2);
//    out.FILE3<<"  i"<<"  ethresh"<<"          "<<"  Lprof\n";
//    for(int i=0;i<=n;i++){
//       out.FILE3<< std::setw( 3)<<i
//                << std::setw( 9)<<M2[i].ethresh;
//       for(int L=0;L<8;L++){
//          out.FILE3<< std::setw(10)<<M2[i].Lprof[L];
//       }
//       out.FILE3<<'\n';
//    }
// }

   ene.Fr*=physics_consts.CAL;
   ene.Fe*=physics_consts.CAL;
   ene.Fs*=physics_consts.CAL;
   ene.Ft*=physics_consts.CAL;
   ene.Fb*=physics_consts.CAL;
   ene.Fc*=physics_consts.CAL;
   ene.Fh*=physics_consts.CAL;
   ene.Fw*=physics_consts.CAL;
   ene.Fp*=physics_consts.CAL;
   ene.Fp_a*=physics_consts.CAL;
   ene.Fp_b*=physics_consts.CAL;
   ene.Fp_c*=physics_consts.CAL;
   ene.Fp_d*=physics_consts.CAL;
   ene.Fp_e*=physics_consts.CAL;
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<< std::fixed<< std::setprecision(2);
      out.FILE3<<"      F  \n";
      out.FILE3<< std::setw( 9)<<ene.TOT<<'\n';
      out.FILE3<<"     Fr  "
               <<"     Fe  "
               <<"     Fs  "
               <<"     Ft  "
               <<"     Fb  "
               <<"     Fc  "
               <<"     Fh  "
               <<"     Fw  "
               <<"     Fg  "
               <<"     Fp  \n";
      out.FILE3<< std::setw( 9)<<ene.Fr
               << std::setw( 9)<<ene.Fe
               << std::setw( 9)<<ene.Fs
               << std::setw( 9)<<ene.Ft
               << std::setw( 9)<<ene.Fb
               << std::setw( 9)<<ene.Fc
               << std::setw( 9)<<ene.Fh
               << std::setw( 9)<<ene.Fw
               << std::setw( 9)<<( 0.00)
               << std::setw( 9)<<ene.Fp<<'\n';
//    out.FILE3<<"     Fp_a"
//             <<"     Fp_b"
//             <<"     Fp_c"
//             <<"     Fp_d"
//             <<"     Fp_e\n";
//    out.FILE3<< std::setw( 9)<<ene.Fp_a
//             << std::setw( 9)<<ene.Fp_b
//             << std::setw( 9)<<ene.Fp_c
//             << std::setw( 9)<<ene.Fp_d
//             << std::setw( 9)<<ene.Fp_e<<'\n';
   }
//
//
// store step length for subset of degs of free
//
   if( opt.MODE=="loc" ){
      if( n>0 ){
         M3BETA(iM3)=M2[n-1].bet;
      }
   }
   return;
}
