#include "../con/Subset_Contracted_System.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <iomanip>
#include <cmath>

void Local_Minimization4::WRT1(const Thread_Options& opt,
                               Output_Streams& out,
                               const Mechanical_System& mol,
                               const Subset_Contracted_System::tM3& con,
                               Conf_Dependent_System& dep,
                               Energy_Surface4& ene){

   int iU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         dep.Z0[iZ0].trans(0)= ene.U2chi(iU2  );
         dep.Z0[iZ0].trans(1)= ene.U2chi(iU2+1);
         dep.Z0[iZ0].trans(2)= ene.U2chi(iU2+2);
         dep.Z0[iZ0].rot(0)= ene.U2chi(iU2+3);
         dep.Z0[iZ0].rot(1)= ene.U2chi(iU2+4);
         dep.Z0[iZ0].rot(2)= ene.U2chi(iU2+5);
         iU2+=6;
      }
   }
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
         if( (opt.MODE=="bb ")&&(con.Q2[iQ2].br>0) ){
         }else{
            dep.Q2[iQ2].chi= ene.U2chi(iU2);
         }
         iU2++;
      }
   }

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int iQ2=mQ2;
      for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
         if( con.Q1[iQ1].sub ){
            dep.Q1[iQ1].chi= dep.Q2[++iQ2].chi;
         }
      }
   }

   double zF= (1.00)/std::sqrt( ene.nU2);

   if( iM4>0 ){
      for(int i=0;i<iM4;i++){
         M4[i].step= zF*std::sqrt( M4[i].step);
         if( M4[i].dtot<(-1.00e-8) ){
            M4[i].frac=( M4[i+1].Ftot -M4[i].Ftot)/M4[i].dtot;
         }else{
            M4[i].frac= (0.00);
         }
      }
   }

   if( out.VERBOSE ){
//    out.FILE3<<"  i"
//             <<" M2pt"
//             <<" nE3 "
//             <<"       F   "
//             <<"   step  "
//             <<"   dtot  "
//             <<"   frac"<<'\n';
      out.FILE3<< std::scientific;

//    if( iM4>0 ){
//       for(int i=0;i<iM4;i++){
//          out.FILE3<< std::setw( 3)<<i
//                   << std::setw( 5)<<(M4[i].M2pt-1)
//                   << std::setw( 4)<<M4[i].nE3<<' '
//                   << std::setprecision(4)<< std::setw(11)<<M4[i].Ftot
//                   << std::setprecision(2)<< std::setw( 9)<<M4[i].step
//                   << std::setw( 9)<<M4[i].dtot
//                   << std::setw( 9)<<M4[i].frac<<'\n';
//       }
//    }
//    out.FILE3<< std::setw( 3)<<iM4
//             <<"     "
//             << std::setw( 4)<<M4[iM4].nE3<<' '
//             << std::setprecision(4)<< std::setw(11)<<M4[iM4].Ftot<<'\n';

//    out.FILE3<<"  i"
//             <<"  nE2"
//             <<"   nO2 "
//             <<"     Fr   "
//             <<"     Fc   "
//             <<"     Fb   "
//             <<"     Ft   "
//             <<"ENDSTATE\n";
//    out.FILE3<< std::setprecision(3);
//    if( iM4>0 ){
//       for(int i=0;i<iM4;i++){
//           out.FILE3<< std::setw( 3)<<i
//                    << std::setw( 5)<<M4[i].nE2
//                    << std::setw( 6)<<M4[i].nO2<<' '
//                    << std::setw(10)<<M4[i].Fr
//                    << std::setw(10)<<M4[i].Fc
//                    << std::setw(10)<<M4[i].Fb
//                    << std::setw(10)<<M4[i].Ft
//                    << std::setw( 3)<<M4[i].end<<'\n';
//       }
//    }
//    out.FILE3<< std::setw( 3)<<iM4
//             << std::setw( 5)<<M4[iM4].nE2
//             << std::setw( 6)<<M4[iM4].nO2<<' '
//             << std::setw(10)<<M4[iM4].Fr
//             << std::setw(10)<<M4[iM4].Fc
//             << std::setw(10)<<M4[iM4].Fb
//             << std::setw(10)<<M4[iM4].Ft<<'\n';

//    out.FILE3<<"  i"
//             <<"    "<<" k1"
//             <<" k2"
//             <<" k3"
//             <<"    "<<" k4"
//             <<" k5\n";
//    int jMIN=0;
//    for(int i=0;i<iM4;i++){
//       int jMAX=(M4[i].M2pt-2);
//       for(int j=jMIN;j<=jMAX;j++){
//          int m=M2[j].k2;
//          out.FILE3<< std::setw( 3)<<j<<"    "
//                   << std::setw( 3)<<M2[j].k1
//                   << std::setw( 3)<<M2[j].k2
//                   << std::setw( 3)<<M2[j].k3<<"  ";
//          for(int k=0;k<m;k++){
//             out.FILE3<<"  "
//                      << std::setw( 3)<<M2[j].k4[k]
//                      << std::setw( 3)<<M2[j].k5[k];
//          }
//          out.FILE3<<'\n';
//       }
//       jMIN=jMAX+2;
//    }

//    int jMIN=0;
//    for(int i=0;i<iM4;i++){
//       int jMAX=(M4[i].M2pt-2);
//       for(int j=jMIN;j<=jMAX;j++){
//          M2[j].z= zF*std::sqrt( M2[j].z);
//          M2[j].bet= zF*M2[j].bet;
//          M2[j].s0= zF*std::sqrt( M2[j].s0);
//          int m=M2[j].k2;
//          for(int k=0;k<m;k++){
//             M2[j].s1[k]= zF*std::sqrt( M2[j].s1[k]);
//          }
//          M2[j].s2= zF*std::sqrt( M2[j].s2);
//       }
//       M2[jMAX+1].z= zF*std::sqrt( M2[jMAX+1].z);
//       jMIN=jMAX+2;
//    }

//    out.FILE3<<"  i"
//             <<"        F   "
//             <<"       z   "
//             <<"       b   "
//             <<"    lam2   "
//             <<"      s2   "
//             <<"    delF   \n";
//    out.FILE3<< std::scientific;
//    jMIN=0;
//    for(int i=0;i<iM4;i++){
//       int jMAX=(M4[i].M2pt-2);
//       for(int j=jMIN;j<=jMAX;j++){
//          out.FILE3<< std::setw( 3)<<j
//                   << std::setprecision(5)<< std::setw(12)<<M2[j].tot
//                   << std::setprecision(4)<< std::setw(11)<<M2[j].z
//                   << std::setw(11)<<M2[j].bet
//                   << std::setw(11)<<M2[j].lam2
//                   << std::setw(11)<<M2[j].s2
//                   << std::setw(11)<<M2[j].delF<<'\n';
//       }
//       out.FILE3<< std::setw( 3)<<(jMAX+1)
//                << std::setprecision(5)<< std::setw(12)<<M2[jMAX+1].tot
//                << std::setprecision(4)<< std::setw(11)<<M2[jMAX+1].z<<'\n';
//       jMIN=jMAX+2;
//    }

//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam0   "
//             <<"      s0   \n";
//    jMIN=0;
//    for(int i=0;i<iM4;i++){
//       int jMAX=(M4[i].M2pt-2);
//       for(int j=jMIN;j<=jMAX;j++){
//          out.FILE3<< std::setw( 3)<<j
//                   << std::setw(11)<<M2[j].lam0
//                   << std::setw(11)<<M2[j].s0<<'\n';
//       }
//       jMIN=jMAX+2;
//    }

//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam1   "
//             <<"      s1   "<<'\n';
//    jMIN=0;
//    for(int i=0;i<iM4;i++){
//       int jMAX=(M4[i].M2pt-2);
//       for(int j=jMIN;j<=jMAX;j++){
//          out.FILE3<< std::setw( 3)<<j;
//          int m=M2[j].k2;
//          for(int k=0;k<m;k++){
//             out.FILE3<< std::setw(11)<<M2[j].lam1[k]
//                      << std::setw(11)<<M2[j].s1[k];
//          }
//          out.FILE3<<'\n';
//       }
//       jMIN=jMAX+2;
//    }
   }

// if( out.VERBOSE ){
//    out.FILE3<< std::fixed<< std::setprecision(3);
//    out.FILE3<<" iM4="<< std::setw( 4)<<iM4
//             <<" nE3="<< std::setw( 4)<<M4[iM4].nE3
//             <<"  tot="<< std::setw(10)<<M4[iM4].Ftot
//             <<"   Fr="<< std::setw(10)<<M4[iM4].Fr
//             <<" Fc="<< std::setw(10)<<M4[iM4].Fc
//             <<" Fb="<< std::setw(10)<<M4[iM4].Fb
//             <<" Ft="<< std::setw(10)<<M4[iM4].Ft<<'\n';
// }
   return;
}
