#include "../mov/Lagrange_Multiplier.hh"
#include "../mov/Local_Minimization.hh"

void Local_Minimization::initial_lamda(Lagrange_Multiplier& lag,
                                       int ck1,
                                       double beta1){
   if      ( ck1==6 ){
      if( M2[iM2-1].k2>0 ){
         lag.lamda= M2[iM2-1].lam1[M2[iM2-1].k2-1];
         double xx= M2[iM2-1].s1[M2[iM2-1].k2-1];
         double dxx= M2[iM2-1].ds1[M2[iM2-1].k2-1];
         lag.lamdastep((2.00)*beta1,xx,dxx);
      }else{
         lag.lamda= M2[iM2-1].lam0;
         double xx= M2[iM2-1].s0;
         double dxx= M2[iM2-1].ds0;
         lag.lamdastep((2.00)*beta1,xx,dxx);
      }
   }else if( ck1==5 ){
      lag.lamda= M2[iM2-1].lam2;
      double xx= M2[iM2-1].s2;
      double dxx= M2[iM2-1].ds2;
      lag.lamdastep(beta1,xx,dxx);
   }else if( ck1==4 ){
      if( lag.lamda<(1.00e-2) )lag.lamda=(1.00e-2);
      lag.lamda*=( 8.00);
   }else if( ck1==3 ){
      if( iM2==0 ){
         lag.lamda= (2.00e+1);
      }else{
         lag.lamda*=(16.00);
      }
   }else if( ck1==2 ){
      lag.lamda*=(32.00);
      double h0=( (4.00)*lag.hsigma -lag.hmean);
      if( lag.lamda<h0 )lag.lamda= h0;
   }else if( ck1==1 ){
      lag.lamda=-lag.hbound;
   }
   return;
}
