#include "../mov/Lagrange_Multiplier.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Energy_Surface.hh"

void Local_Minimization5::backup(Lagrange_Multiplier& lag,
                                 Energy_Surface5& ene){
   if( iM2==0 ){
      lag.accept(ene);
   }else{
      if( ( ene.TOT -M2[iM2-1].tot)<=((1.00e-8)*M2[iM2-1].tot) ){
         lag.accept(ene);
      }else{
         M2[iM2-1].bet/=(2.00);
         lag.reject(ene);
      }
   }
   return;
}
