#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Energy_Surface.hh"
#include "../reg/Regularization_Target.hh"
#include "../str/Output_Streams.hh"

int Local_Minimization5::MOV(const DAT_PHYSICS_CONSTS& physics_consts,
                             Output_Streams& out,
                             Energy_Surface5& ene,
                             const Regularization_Target& reg){

   int ck1,ck2,ck3,ck4,ck5;             //loop counters
   Lagrange_Multiplier lag(ene.nU2);
   lag.aU2= 0;
   lag.bU2=(ene.nU2-1);

   for(iM2=0;;iM2++){
      ene.PHI(physics_consts,out,reg);
      backup(lag,ene);
      M2[iM2].tot= lag.TOT;
      double zz= lag.gradient();
      M2[iM2].z= zz;
      if( (nM2==0)||( zz<EPS1 ) )return ENDSTATE=0;
      double beta1= target_beta();
      M2[iM2].bet= beta1;

      for(ck1=(iM2>0)? 6: 3;ck1>0;ck1--){
         initial_lamda(lag,ck1,beta1);
         M2[iM2].lam0= lag.lamda;
         lag.diagonal();
         bool pd=lag.lower();
         if( pd )break;
      }
      if( ck1==0 )return ENDSTATE=1;

      M2[iM2].k1=(iM2>0)? (6-ck1): (3-ck1);
      lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
      lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
      double dxx;
      double xx=lag.length(dxx);
      M2[iM2].s0= xx;
      M2[iM2].ds0= dxx;

      int k2=0;
      for(ck2=4;ck2>0;ck2--){
         if( xx>(beta1*beta1*( (1.00) -EPS2)) )break;
         if( lag.lamda<=(0.00) )break;

         M2[iM2].k4[k2]=100;
         for(ck4=10;ck4>0;ck4--){
            for(int ii=0;ii<10;ii++){
               lag.step(lag.o_U2x,lag.lamda,lag.o_U2x);
            }
            lag.normalize();
         }

         double dlamda= lag.lamdastep(beta1);
         M2[iM2].lam1[k2]= lag.lamda;

         for(ck5=30;ck5>0;ck5--){
            lag.diagonal();
            bool pd=lag.lower();
            if( pd )break;
            lag.lamda+=dlamda;
            M2[iM2].lam1[k2]= lag.lamda;
            dlamda*=(2.00);
         }
         if( ck5==0 )return ENDSTATE=2;

         M2[iM2].k5[k2]=(30-ck5);
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
         M2[iM2].s1[k2]= xx;
         M2[iM2].ds1[k2]= dxx;
         k2++;
      }

      M2[iM2].k2=(4-ck2);
      for(ck3=32;ck3>0;ck3--){
         if( xx<=(beta1*beta1*( (1.00) +EPS2)) )break;
         lag.lamdastep(beta1,xx,dxx);
         lag.diagonal();
         bool pd=lag.lower();
         if( !pd )return ENDSTATE=3;
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
      }

      M2[iM2].k3=(32-ck3);
      update(lag,ene);
      M2[iM2].lam2= lag.lamda;
      M2[iM2].s2= xx;
      M2[iM2].ds2= dxx;
      M2[iM2].delF= lag.deltaf();

      nM2--;
   }
}
